/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import java.io.InputStream;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.security.AbstractSpringSecurityTest;
import org.apache.cxf.systest.jaxrs.security.BookServerSecuritySpringClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSSpringSecurityClassTest
extends AbstractSpringSecurityTest {
    public static final int PORT = BookServerSecuritySpringClass.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSSpringSecurityClassTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSSpringSecurityClassTest.launchServer(BookServerSecuritySpringClass.class, (boolean)true));
    }

    @Test
    public void testFailedAuthentication() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "ba", 401);
    }

    @Test
    public void testBookFromForm() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstorestorage/bookforms"), (String)"foo", (String)"bar", null);
        Response r = wc.form(new Form().set("name", (Object)"CXF Rocks").set("id", (Object)"123"));
        Book b = this.readBook((InputStream)r.getEntity());
        JAXRSSpringSecurityClassTest.assertEquals((Object)"CXF Rocks", (Object)b.getName());
        JAXRSSpringSecurityClassTest.assertEquals((long)123L, (long)b.getId());
    }

    @Test
    @Ignore(value="Spring Security 3+ does not preserve POSTed form parameters as HTTPServletRequest parameters")
    public void testBookFromHttpRequestParameters() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstorestorage/bookforms2"), (String)"foo", (String)"bar", null);
        Response r = wc.form(new Form().set("name", (Object)"CXF Rocks").set("id", (Object)"123"));
        Book b = this.readBook((InputStream)r.getEntity());
        JAXRSSpringSecurityClassTest.assertEquals((Object)"CXF Rocks", (Object)b.getName());
        JAXRSSpringSecurityClassTest.assertEquals((long)123L, (long)b.getId());
    }

    @Test
    public void testGetBookUserAdmin() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "bar", 200);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }

    @Test
    public void testGetBookUser() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstorestorage/thosebooks/123/123";
        this.getBook(endpointAddress, "foo", "bar", 200);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }

    @Test
    public void testGetBookAdmin() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstorestorage/thosebooks";
        this.getBook(endpointAddress, "foo", "bar", 200);
        this.getBook(endpointAddress, "bob", "bobspassword", 403);
    }

    private Book readBook(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        return (Book)u.unmarshal(is);
    }

    @Test
    @Ignore(value="Spring Security 3+ does not preserve POSTed form parameters as HTTPServletRequest parameters")
    public void testGetBookSubresourceAdmin() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstorestorage/securebook/self";
        this.getBook(endpointAddress, "foo", "bar", 200);
        this.getBook(endpointAddress, "bob", "bobspassword", 403);
    }
}

