/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.cxf.systest.jaxrs.Chapter;

@XmlRootElement(name="Book")
public class BookBean {
    private String name;
    private long id;
    private Map<Long, Chapter> chapters = new HashMap<Long, Chapter>();
    private Map<Long, String> comments = new HashMap<Long, String>();

    public BookBean() {
        this.init();
    }

    public BookBean(String name, long id) {
        this.name = name;
        this.id = id;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setId(long i) {
        this.id = i;
    }

    public long getId() {
        return this.id;
    }

    @PUT
    public void cloneState(BookBean book) {
        this.id = book.getId();
        this.name = book.getName();
    }

    @GET
    public BookBean retrieveState() {
        return this;
    }

    @GET
    @Path(value="chapters/{chapterid}/")
    @Produces(value={"application/xml;charset=ISO-8859-1"})
    public Chapter getChapter(@PathParam(value="chapterid") int chapterid) {
        return this.chapters.get(new Long(chapterid));
    }

    @GET
    @Path(value="chapters/acceptencoding/{chapterid}/")
    @Produces(value={"application/xml"})
    public Chapter getChapterAcceptEncoding(@PathParam(value="chapterid") int chapterid) {
        return this.chapters.get(new Long(chapterid));
    }

    @GET
    @Path(value="chapters/badencoding/{chapterid}/")
    @Produces(value={"application/xml;charset=UTF-48"})
    public Chapter getChapterBadEncoding(@PathParam(value="chapterid") int chapterid) {
        return this.chapters.get(new Long(chapterid));
    }

    @Path(value="chapters/sub/{chapterid}/")
    public Chapter getSubChapter(@PathParam(value="chapterid") int chapterid) {
        return this.chapters.get(new Long(chapterid));
    }

    @Path(value="chaptersobject/sub/{chapterid}/")
    public Object getSubChapterObject(@PathParam(value="chapterid") int chapterid) {
        return this.getSubChapter(chapterid);
    }

    final void init() {
        Chapter c1 = new Chapter();
        c1.setId(1L);
        c1.setTitle("chapter 1");
        this.chapters.put(c1.getId(), c1);
        Chapter c2 = new Chapter();
        c2.setId(2L);
        c2.setTitle("chapter 2");
        this.chapters.put(c2.getId(), c2);
    }

    public Map<Long, Chapter> getChapters() {
        return this.chapters;
    }

    public void setChapters(Map<Long, Chapter> chapters) {
        this.chapters = chapters;
    }

    public Map<Long, String> getComments() {
        return this.comments;
    }

    public void setComments(Map<Long, String> comments) {
        this.comments = comments;
    }
}

