/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.ext.search.QueryContextProvider;
import org.apache.cxf.jaxrs.ext.search.SearchContextProvider;
import org.apache.cxf.jaxrs.ext.search.sql.SQLPrinterVisitor;
import org.apache.cxf.jaxrs.interceptor.JAXRSOutExceptionMapperInterceptor;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.StreamingResponseProvider;
import org.apache.cxf.systest.jaxrs.BookNoXmlRootElement;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.BookStorePerRequest;
import org.apache.cxf.systest.jaxrs.BusMapperException;
import org.apache.cxf.systest.jaxrs.ContentTypeModifyingMBW;
import org.apache.cxf.systest.jaxrs.CustomInFaultyInterceptor;
import org.apache.cxf.systest.jaxrs.CustomOutFaultInterceptor;
import org.apache.cxf.systest.jaxrs.CustomOutInterceptor;
import org.apache.cxf.systest.jaxrs.FaultyRequestHandler;
import org.apache.cxf.systest.jaxrs.FaultyResponseHandler;
import org.apache.cxf.systest.jaxrs.FormatResponseHandler;
import org.apache.cxf.systest.jaxrs.GenericHandlerWriter;
import org.apache.cxf.systest.jaxrs.SimpleBookStore;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;

public class BookServer
extends AbstractBusTestServerBase {
    public static final String PORT = BookServer.allocatePort(BookServer.class);
    Server server;

    protected void run() {
        Bus bus = BusFactory.getDefaultBus();
        bus.setProperty(ExceptionMapper.class.getName(), (Object)new BusMapperExceptionMapper());
        this.setBus(bus);
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setBus(bus);
        sf.setResourceClasses(new Class[]{BookStore.class, SimpleBookStore.class, BookStorePerRequest.class});
        sf.getInInterceptors().add(new LoggingInInterceptor());
        ArrayList<Object> providers = new ArrayList<Object>();
        BinaryDataProvider p = new BinaryDataProvider();
        p.setProduceMediaTypes(Collections.singletonList("application/bar"));
        p.setEnableBuffering(true);
        p.setReportByteArraySize(true);
        providers.add(p);
        providers.add(new BookStore.PrimitiveIntArrayReaderWriter());
        providers.add(new BookStore.PrimitiveDoubleArrayReaderWriter());
        providers.add(new BookStore.StringArrayBodyReaderWriter());
        providers.add(new BookStore.StringListBodyReaderWriter());
        providers.add(new StreamingResponseProvider());
        providers.add(new ContentTypeModifyingMBW());
        JAXBElementProvider jaxbProvider = new JAXBElementProvider();
        HashMap<String, String> jaxbElementClassMap = new HashMap<String, String>();
        jaxbElementClassMap.put(BookNoXmlRootElement.class.getName(), "BookNoXmlRootElement");
        jaxbProvider.setJaxbElementClassMap(jaxbElementClassMap);
        providers.add(jaxbProvider);
        providers.add(new FormatResponseHandler());
        providers.add(new GenericHandlerWriter());
        providers.add(new FaultyRequestHandler());
        providers.add(new FaultyResponseHandler());
        providers.add(new SearchContextProvider());
        providers.add(new QueryContextProvider());
        sf.setProviders(providers);
        ArrayList<CustomInFaultyInterceptor> inInts = new ArrayList<CustomInFaultyInterceptor>();
        inInts.add(new CustomInFaultyInterceptor());
        sf.setInInterceptors(inInts);
        ArrayList<CustomOutInterceptor> outInts = new ArrayList<CustomOutInterceptor>();
        outInts.add(new CustomOutInterceptor());
        outInts.add((CustomOutInterceptor)new JAXRSOutExceptionMapperInterceptor());
        sf.setOutInterceptors(outInts);
        ArrayList<CustomOutFaultInterceptor> outFaultInts = new ArrayList<CustomOutFaultInterceptor>();
        outFaultInts.add(new CustomOutFaultInterceptor());
        sf.setOutFaultInterceptors(outFaultInts);
        sf.setResourceProvider(BookStore.class, (ResourceProvider)new SingletonResourceProvider((Object)new BookStore(), true));
        sf.setAddress("http://localhost:" + PORT + "/");
        sf.getProperties(true).put("org.apache.cxf.jaxrs.mediaTypeCheck.strict", true);
        sf.getProperties().put("search.visitor", new SQLPrinterVisitor("books", new String[0]));
        sf.getProperties().put("org.apache.cxf.http.header.split", true);
        sf.getProperties().put("default.content.type", "*/*");
        this.server = sf.create();
        BusFactory.setDefaultBus(null);
        BusFactory.setThreadDefaultBus(null);
    }

    public void tearDown() throws Exception {
        this.server.stop();
        this.server.destroy();
        this.server = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            BookServer s = new BookServer();
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }

    private static class BusMapperExceptionMapper
    implements ExceptionMapper<BusMapperException> {
        private BusMapperExceptionMapper() {
        }

        public Response toResponse(BusMapperException exception) {
            return Response.serverError().type("text/plain;charset=utf-8").header("BusMapper", (Object)"the-mapper").entity((Object)"BusMapperException").build();
        }
    }
}

