/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.systest.jaxrs.AbstractSpringServer;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSSimpleRequestDispatcherTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = JAXRSSimpleRequestDispatcherTest.allocatePort(JAXRSSimpleRequestDispatcherTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        AbstractResourceInfo.clearAllMaps();
        JAXRSSimpleRequestDispatcherTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSSimpleRequestDispatcherTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testGetTextWelcomeFile() throws Exception {
        String address = "http://localhost:" + PORT + "/dispatch/welcome.txt";
        WebClient client = WebClient.create((String)address);
        client.accept(new String[]{"text/plain"});
        String welcome = (String)client.get(String.class);
        JAXRSSimpleRequestDispatcherTest.assertEquals((Object)"Welcome", (Object)welcome);
    }

    @Test
    public void testGetRedirectedBook() throws Exception {
        String address = "http://localhost:" + PORT + "/dispatch/bookstore2/books/redirectStart";
        WebClient client = WebClient.create((String)address);
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(10000000L);
        client.accept(new String[]{"application/json"});
        Book book = (Book)client.get(Book.class);
        JAXRSSimpleRequestDispatcherTest.assertEquals((Object)"Redirect complete: /dispatch/bookstore/books/redirectComplete", (Object)book.getName());
    }

    @Test
    public void testGetRedirectedBook2() throws Exception {
        String address = "http://localhost:" + PORT + "/dispatch/redirect/bookstore3/books/redirectStart";
        WebClient client = WebClient.create((String)address);
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setReceiveTimeout(10000000L);
        client.accept(new String[]{"application/json"});
        Book book = (Book)client.get(Book.class);
        JAXRSSimpleRequestDispatcherTest.assertEquals((Object)"Redirect complete: /dispatch/redirect/bookstore/books/redirectComplete", (Object)book.getName());
    }

    @Ignore
    public static class Server
    extends AbstractSpringServer {
        public Server() {
            super("/jaxrs_dispatch_simple", "/dispatch", Integer.parseInt(PORT));
        }
    }
}

