/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.security.AbstractSpringSecurityTest;
import org.apache.cxf.systest.jaxrs.security.BookServerJaasSecurity;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSJaasConfigurationSecurityTest
extends AbstractSpringSecurityTest {
    public static final int PORT = BookServerJaasSecurity.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSJaasConfigurationSecurityTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSJaasConfigurationSecurityTest.launchServer(BookServerJaasSecurity.class, (boolean)true));
    }

    @Test
    public void testJaasInterceptorAuthenticationFailure() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaasConfig/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "bar1", 401);
    }

    @Test
    public void testGetBookUserAdminJaasInterceptor() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaasConfig/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "bar", 403);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }

    @Test
    public void testJaasFilterAuthenticationFailure() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaasConfigFilter/bookstorestorage/thosebooks/123";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"text/xml"});
        wc.header("Authorization", new Object[]{"Basic " + this.base64Encode("foo:bar1")});
        Response r = wc.get();
        JAXRSJaasConfigurationSecurityTest.assertEquals((long)401L, (long)r.getStatus());
        Object wwwAuthHeader = r.getMetadata().getFirst((Object)"WWW-Authenticate");
        JAXRSJaasConfigurationSecurityTest.assertNotNull((Object)wwwAuthHeader);
        JAXRSJaasConfigurationSecurityTest.assertEquals((Object)"Basic", (Object)wwwAuthHeader.toString());
    }

    @Test
    public void testGetBookUserAdminJaasFilter() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaasConfigFilter/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "bar", 403);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }
}

