/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.Book2;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.BookStoreSpring;
import org.apache.cxf.systest.jaxrs.CustomInFaultyInterceptor;
import org.apache.cxf.systest.jaxrs.CustomOutInterceptor;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.local.LocalConduit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JAXRSLocalTransportTest
extends AbstractBusClientServerTestBase {
    private Server localServer;

    @Before
    public void setUp() {
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setResourceClasses(new Class[]{BookStore.class, BookStoreSpring.class});
        sf.setResourceProvider(BookStore.class, (ResourceProvider)new SingletonResourceProvider((Object)new BookStore(), true));
        sf.setResourceProvider(BookStoreSpring.class, (ResourceProvider)new SingletonResourceProvider((Object)new BookStoreSpring(), true));
        ArrayList<CustomOutInterceptor> outInts = new ArrayList<CustomOutInterceptor>();
        outInts.add(new CustomOutInterceptor());
        sf.setOutInterceptors(outInts);
        ArrayList<CustomInFaultyInterceptor> inInts = new ArrayList<CustomInFaultyInterceptor>();
        inInts.add(new CustomInFaultyInterceptor());
        sf.setInInterceptors(inInts);
        sf.setTransportId("http://cxf.apache.org/transports/local");
        sf.setAddress("local://books");
        this.localServer = sf.create();
    }

    @After
    public void tearDown() {
        if (this.localServer != null) {
            this.localServer.stop();
        }
    }

    @Test
    public void testProxyPipedDispatchGet() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        Book book = localProxy.getBook("123");
        JAXRSLocalTransportTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testProxyServerInFaultMapped() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        Response r = localProxy.infault();
        JAXRSLocalTransportTest.assertEquals((long)401L, (long)r.getStatus());
    }

    @Test
    public void testProxyServerInFaultEscaped() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        Response r = localProxy.infault2();
        JAXRSLocalTransportTest.assertEquals((long)500L, (long)r.getStatus());
    }

    @Test
    public void testProxyServerInFaultDirectDispatch() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        WebClient.getConfig((Object)localProxy).getRequestContext().put(LocalConduit.DIRECT_DISPATCH, "true");
        WebClient.getConfig((Object)localProxy).getInFaultInterceptors().add(new TestFaultInInterceptor());
        Response r = localProxy.infault2();
        JAXRSLocalTransportTest.assertEquals((long)500L, (long)r.getStatus());
    }

    @Test
    public void testProxyEmtpyResponse() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        JAXRSLocalTransportTest.assertNull((Object)localProxy.getEmptyBook());
        JAXRSLocalTransportTest.assertEquals((long)204L, (long)WebClient.client((Object)localProxy).getResponse().getStatus());
    }

    @Test
    public void testProxyEmptyResponseDirectDispatch() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        WebClient.getConfig((Object)localProxy).getRequestContext().put(LocalConduit.DIRECT_DISPATCH, "true");
        JAXRSLocalTransportTest.assertNull((Object)localProxy.getEmptyBook());
        JAXRSLocalTransportTest.assertEquals((long)204L, (long)WebClient.client((Object)localProxy).getResponse().getStatus());
    }

    @Test
    public void testProxyServerOutFault() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        Response r = localProxy.outfault();
        JAXRSLocalTransportTest.assertEquals((long)500L, (long)r.getStatus());
    }

    @Test
    public void testProxyServerOutFaultDirectDispacth() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        WebClient.getConfig((Object)localProxy).getRequestContext().put(LocalConduit.DIRECT_DISPATCH, "true");
        Response r = localProxy.outfault();
        JAXRSLocalTransportTest.assertEquals((long)500L, (long)r.getStatus());
    }

    @Test
    public void testSubresourceProxyDirectDispatchGet() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        WebClient.getConfig((Object)localProxy).getRequestContext().put(LocalConduit.DIRECT_DISPATCH, "true");
        Book bookSubProxy = localProxy.getBookSubResource("123");
        Book book = bookSubProxy.retrieveState();
        JAXRSLocalTransportTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testProxyDirectDispatchPostWithGzip() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        WebClient.getConfig((Object)localProxy).getRequestContext().put(LocalConduit.DIRECT_DISPATCH, Boolean.TRUE);
        Response response = localProxy.addBook(new Book("New", 124L));
        JAXRSLocalTransportTest.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testProxyDirectDispatchPost() throws Exception {
        BookStoreSpring localProxy = (BookStoreSpring)JAXRSClientFactory.create((String)"local://books", BookStoreSpring.class);
        WebClient.getConfig((Object)localProxy).getRequestContext().put(LocalConduit.DIRECT_DISPATCH, Boolean.TRUE);
        Book response = localProxy.convertBook(new Book2("New", 124L));
        JAXRSLocalTransportTest.assertEquals((long)124L, (long)response.getId());
    }

    @Test
    public void testProxyPipedDispatchPost() throws Exception {
        BookStoreSpring localProxy = (BookStoreSpring)JAXRSClientFactory.create((String)"local://books", BookStoreSpring.class);
        Book response = localProxy.convertBook(new Book2("New", 124L));
        JAXRSLocalTransportTest.assertEquals((long)124L, (long)response.getId());
    }

    @Test
    public void testWebClientDirectDispatch() throws Exception {
        WebClient localClient = WebClient.create((String)"local://books");
        WebClient.getConfig((Object)localClient).getRequestContext().put(LocalConduit.DIRECT_DISPATCH, Boolean.TRUE);
        localClient.path((Object)"bookstore/books/123");
        Book book = (Book)localClient.get(Book.class);
        JAXRSLocalTransportTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testWebClientPipedDispatch() throws Exception {
        WebClient localClient = WebClient.create((String)"local://books");
        localClient.accept(new String[]{"text/xml"});
        localClient.path((Object)"bookstore/books");
        Book book = (Book)localClient.post((Object)new Book("New", 124L), Book.class);
        JAXRSLocalTransportTest.assertEquals((long)124L, (long)book.getId());
    }

    @Test
    public void testProxyWithQuery() throws Exception {
        BookStore localProxy = (BookStore)JAXRSClientFactory.create((String)"local://books", BookStore.class);
        WebClient.getConfig((Object)localProxy).getRequestContext().put(LocalConduit.DIRECT_DISPATCH, Boolean.TRUE);
        Book book = localProxy.getBookByURLQuery(new String[]{"1", "2", "3"});
        JAXRSLocalTransportTest.assertEquals((long)123L, (long)book.getId());
    }

    private static class TestFaultInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public TestFaultInInterceptor() {
            this("pre-stream");
        }

        public TestFaultInInterceptor(String s) {
            super("pre-stream");
        }

        public void handleMessage(Message message) throws Fault {
            message.getExchange().put((Object)Message.RESPONSE_CODE, (Object)500);
        }
    }
}

