/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import java.util.Collections;
import javax.ws.rs.core.Response;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.security.AbstractSpringSecurityTest;
import org.apache.cxf.systest.jaxrs.security.BookServerJaasSecurity;
import org.apache.cxf.systest.jaxrs.security.SecureBookStoreNoAnnotations;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSJaasSecurityTest
extends AbstractSpringSecurityTest {
    public static final int PORT = BookServerJaasSecurity.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        String jaasConfig = JAXRSJaasSecurityTest.class.getResource("/org/apache/cxf/systest/jaxrs/security/jaas.cfg").toURI().getPath();
        JAXRSJaasSecurityTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSJaasSecurityTest.launchServer(BookServerJaasSecurity.class, Collections.singletonMap("java.security.auth.login.config", jaasConfig), (String[])new String[0], (boolean)false));
    }

    @Test
    public void testJaasInterceptorAuthenticationFailure() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaas/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "bar1", 401);
    }

    @Test
    public void testGetBookUserAdminJaasInterceptor() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaas/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "bar", 403);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }

    @Test
    public void testJaasFilterAuthenticationFailure() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaas2/bookstorestorage/thosebooks/123";
        WebClient wc = WebClient.create((String)endpointAddress);
        AuthorizationPolicy pol = new AuthorizationPolicy();
        pol.setUserName("foo");
        pol.setPassword("bar1");
        WebClient.getConfig((Object)wc).getHttpConduit().setAuthorization(pol);
        wc.accept(new String[]{"application/xml"});
        Response r = wc.get();
        JAXRSJaasSecurityTest.assertEquals((long)401L, (long)r.getStatus());
        Object wwwAuthHeader = r.getMetadata().getFirst((Object)"WWW-Authenticate");
        JAXRSJaasSecurityTest.assertNotNull((Object)wwwAuthHeader);
        JAXRSJaasSecurityTest.assertEquals((Object)"Basic", (Object)wwwAuthHeader.toString());
    }

    @Test
    public void testJaasFilterWebClientAuthorizationPolicy() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaas2/bookstorestorage/thosebooks/123";
        WebClient wc = WebClient.create((String)endpointAddress);
        AuthorizationPolicy pol = new AuthorizationPolicy();
        pol.setUserName("bob");
        pol.setPassword("bobspassword");
        WebClient.getConfig((Object)wc).getHttpConduit().setAuthorization(pol);
        wc.accept(new String[]{"application/xml"});
        Book book = (Book)wc.get(Book.class);
        JAXRSJaasSecurityTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testJaasFilterWebClientAuthorizationPolicy2() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaas2/bookstorestorage/thosebooks/123";
        WebClient wc = WebClient.create((String)endpointAddress, (String)"bob", (String)"bobspassword", null);
        wc.accept(new String[]{"application/xml"});
        Book book = (Book)wc.get(Book.class);
        JAXRSJaasSecurityTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testJaasFilterProxyAuthorizationPolicy() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaas2";
        SecureBookStoreNoAnnotations proxy = (SecureBookStoreNoAnnotations)JAXRSClientFactory.create((String)endpointAddress, SecureBookStoreNoAnnotations.class, (String)"bob", (String)"bobspassword", null);
        Book book = proxy.getThatBook(123L);
        JAXRSJaasSecurityTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testJaasFilterAuthenticationFailureWithRedirection() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaas2/bookstorestorage/thosebooks/123";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"text/xml,text/html"});
        wc.header("Authorization", new Object[]{"Basic " + this.base64Encode("foo:bar1")});
        Response r = wc.get();
        JAXRSJaasSecurityTest.assertEquals((long)307L, (long)r.getStatus());
        Object locationHeader = r.getMetadata().getFirst((Object)"Location");
        JAXRSJaasSecurityTest.assertNotNull((Object)locationHeader);
        JAXRSJaasSecurityTest.assertEquals((Object)("http://localhost:" + PORT + "/login.jsp"), (Object)locationHeader.toString());
    }

    @Test
    public void testGetBookUserAdminJaasFilter() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/service/jaas2/bookstorestorage/thosebooks/123";
        this.getBook(endpointAddress, "foo", "bar", 403);
        this.getBook(endpointAddress, "bob", "bobspassword", 200);
    }
}

