/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.Chapter;
import org.apache.cxf.systest.jaxrs.ChapterNoAnnotations;

public class BookStoreNoAnnotations {
    private Map<Long, Book> books = new HashMap<Long, Book>();

    public BookStoreNoAnnotations() {
        Book b = new Book();
        b.setId(123L);
        b.setName("CXF in Action");
        this.books.put(b.getId(), b);
    }

    public Book getBook(Long id) throws BookNotFoundFault {
        return this.books.get(id);
    }

    public ChapterNoAnnotations getBookChapter(Long id) throws BookNotFoundFault {
        Book b = this.books.get(id);
        Chapter ch = b.getChapter(1);
        ChapterNoAnnotations ch2 = new ChapterNoAnnotations();
        ch2.setId(ch.getId());
        ch2.setTitle(ch.getTitle());
        return ch2;
    }

    public Book getBookWithAuthorization(Long id, String authorizationHeader) throws BookNotFoundFault {
        if (authorizationHeader == null || !authorizationHeader.startsWith("Basic")) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return this.books.get(id);
    }
}

