/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.provider.atom.AbstractEntryBuilder;
import org.apache.cxf.jaxrs.provider.atom.AbstractFeedBuilder;
import org.apache.cxf.jaxrs.provider.atom.AtomEntryProvider;
import org.apache.cxf.jaxrs.provider.atom.AtomFeedProvider;
import org.apache.cxf.management.web.logging.LogRecord;
import org.apache.cxf.management.web.logging.atom.AtomPushHandler;
import org.apache.cxf.management.web.logging.atom.converter.Converter;
import org.apache.cxf.management.web.logging.atom.converter.StandardConverter;
import org.apache.cxf.management.web.logging.atom.deliverer.Deliverer;
import org.apache.cxf.management.web.logging.atom.deliverer.WebClientDeliverer;
import org.apache.cxf.testutil.common.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSLoggingAtomPushTest
extends Assert {
    public static final String PORT = TestUtil.getPortNumber(JAXRSLoggingAtomPushTest.class);
    public static final Logger LOG = LogUtils.getL7dLogger(JAXRSLoggingAtomPushTest.class);
    private static Server server;

    @BeforeClass
    public static void beforeClass() throws Exception {
        JAXRSLoggingAtomPushTest.configureLogging("resources/logging_atompush_disabled.properties");
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setResourceClasses(new Class[]{Resource.class});
        sf.setAddress("http://localhost:" + PORT + "/");
        sf.setProviders(Arrays.asList(new AtomFeedProvider(), new AtomEntryProvider()));
        server = sf.create();
        server.start();
    }

    private static void configureLogging(String propFile) throws Exception {
        LogManager lm = LogManager.getLogManager();
        InputStream ins = JAXRSLoggingAtomPushTest.class.getResourceAsStream(propFile);
        String s = IOUtils.readStringFromStream((InputStream)ins);
        ins.close();
        s = s.replaceAll("9080", PORT);
        lm.readConfiguration(new ByteArrayInputStream(s.getBytes("UTF-8")));
        for (Handler h : LOG.getHandlers()) {
            LOG.removeHandler(h);
            h.close();
        }
        if (lm.getProperty(JAXRSLoggingAtomPushTest.class.getName() + ".handlers") != null) {
            LOG.addHandler((Handler)new AtomPushHandler());
        }
        LOG.setUseParentHandlers(false);
    }

    private static void logSixEvents(Logger log) {
        log.severe("severe message");
        log.warning("warning message");
        log.info("info message");
        java.util.logging.LogRecord r = new java.util.logging.LogRecord(Level.FINE, "fine message");
        r.setThrown(new IllegalArgumentException("tadaam"));
        log.log(r);
        r = new java.util.logging.LogRecord(Level.FINER, "finer message with {0} and {1}");
        r.setParameters(new Object[]{"param1", "param2"});
        r.setLoggerName("faky-logger");
        log.log(r);
        log.finest("finest message");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        LogManager lm = LogManager.getLogManager();
        try {
            lm.reset();
            lm.readConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (server != null) {
            server.destroy();
        }
    }

    @Before
    public void before() throws Exception {
        Resource.clear();
    }

    private void waitForFeeds(Collection<?> c, int count) throws Exception {
        int iter = 0;
        while (c.size() < count) {
            Thread.sleep(100L);
            if (++iter <= 30) continue;
            return;
        }
    }

    @Test
    public void testPrivateLogger() throws Exception {
        JAXRSLoggingAtomPushTest.configureLogging("resources/logging_atompush_disabled.properties");
        Logger log = LogUtils.getL7dLogger(JAXRSLoggingAtomPushTest.class, null, (String)"private-log");
        StandardConverter c = new StandardConverter(StandardConverter.Output.FEED, StandardConverter.Multiplicity.ONE, StandardConverter.Format.CONTENT);
        WebClientDeliverer d = new WebClientDeliverer("http://localhost:" + PORT);
        AtomPushHandler h = new AtomPushHandler(2, (Converter)c, (Deliverer)d);
        log.addHandler((Handler)h);
        log.setLevel(Level.ALL);
        JAXRSLoggingAtomPushTest.logSixEvents(log);
        this.waitForFeeds(Resource.feeds, 3);
        JAXRSLoggingAtomPushTest.assertEquals((String)"Different logged events count;", (long)3L, (long)Resource.feeds.size());
    }

    @Test
    public void testPrivateLoggerCustomBuilders() throws Exception {
        JAXRSLoggingAtomPushTest.configureLogging("resources/logging_atompush_disabled.properties");
        Logger log = LogUtils.getL7dLogger(JAXRSLoggingAtomPushTest.class, null, (String)"private-log");
        AbstractFeedBuilder<List<LogRecord>> fb = this.createCustomFeedBuilder();
        AbstractEntryBuilder<List<LogRecord>> eb = this.createCustomEntryBuilder();
        StandardConverter c = new StandardConverter(StandardConverter.Output.FEED, StandardConverter.Multiplicity.ONE, StandardConverter.Format.CONTENT, fb, eb);
        WebClientDeliverer d = new WebClientDeliverer("http://localhost:" + PORT);
        AtomPushHandler h = new AtomPushHandler(2, (Converter)c, (Deliverer)d);
        log.addHandler((Handler)h);
        log.setLevel(Level.ALL);
        JAXRSLoggingAtomPushTest.logSixEvents(log);
        this.waitForFeeds(Resource.feeds, 3);
        JAXRSLoggingAtomPushTest.assertEquals((String)"Different logged events count;", (long)3L, (long)Resource.feeds.size());
    }

    @Test
    public void testOneElementBatch() throws Exception {
        JAXRSLoggingAtomPushTest.configureLogging("resources/logging_atompush.properties");
        JAXRSLoggingAtomPushTest.logSixEvents(LogUtils.getL7dLogger(JAXRSLoggingAtomPushTest.class));
        this.waitForFeeds(Resource.feeds, 6);
        JAXRSLoggingAtomPushTest.assertEquals((String)"Different logged events count;", (long)6L, (long)Resource.feeds.size());
    }

    @Test
    public void testMultiElementBatch() throws Exception {
        JAXRSLoggingAtomPushTest.configureLogging("resources/logging_atompush_batch.properties");
        JAXRSLoggingAtomPushTest.logSixEvents(LogUtils.getL7dLogger(JAXRSLoggingAtomPushTest.class));
        this.waitForFeeds(Resource.feeds, 2);
        JAXRSLoggingAtomPushTest.assertEquals((String)"Different logged events count;", (long)2L, (long)Resource.feeds.size());
    }

    @Ignore
    private AbstractFeedBuilder<List<LogRecord>> createCustomFeedBuilder() {
        AbstractFeedBuilder<List<LogRecord>> fb = new AbstractFeedBuilder<List<LogRecord>>(){

            public String getAuthor(List<LogRecord> pojo) {
                return "custom author";
            }
        };
        return fb;
    }

    @Ignore
    private AbstractEntryBuilder<List<LogRecord>> createCustomEntryBuilder() {
        AbstractEntryBuilder<List<LogRecord>> eb = new AbstractEntryBuilder<List<LogRecord>>(){

            public String getSummary(List<LogRecord> pojo) {
                return "custom summary";
            }
        };
        return eb;
    }

    @Test
    public void testAtomPubEntries() throws Exception {
        JAXRSLoggingAtomPushTest.configureLogging("resources/logging_atompush_atompub.properties");
        JAXRSLoggingAtomPushTest.logSixEvents(LogUtils.getL7dLogger(JAXRSLoggingAtomPushTest.class));
        this.waitForFeeds(Resource.entries, 6);
        JAXRSLoggingAtomPushTest.assertEquals((String)"Different logged events count;", (long)6L, (long)Resource.entries.size());
    }

    @Ignore
    @Path(value="/")
    public static class Resource {
        private static Queue<Feed> feeds = new ConcurrentLinkedQueue<Feed>();
        private static Queue<Entry> entries = new ConcurrentLinkedQueue<Entry>();

        @POST
        public void consume(Feed feed) {
            feeds.add(feed);
        }

        @POST
        @Path(value="/atomPub")
        public void consume(Entry entry) {
            entries.add(entry);
        }

        public static void clear() {
            feeds.clear();
            entries.clear();
        }
    }
}

