/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.ws.Holder;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookServerAsyncClient;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSAsyncClientTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServerAsyncClient.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        AbstractResourceInfo.clearAllMaps();
        JAXRSAsyncClientTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSAsyncClientTest.launchServer(BookServerAsyncClient.class, (boolean)true));
        JAXRSAsyncClientTest.createStaticBus();
    }

    @Test
    public void testRetrieveBookCustomMethodAsyncSync() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/retrieve";
        WebClient wc = WebClient.create((String)address);
        wc.type("application/xml").accept(new String[]{"application/xml"});
        WebClient.getConfig((Object)wc).getRequestContext().put("use.async.http.conduit", true);
        Book book = (Book)wc.invoke("RETRIEVE", (Object)new Book("Retrieve", 123L), Book.class);
        JAXRSAsyncClientTest.assertEquals((Object)"Retrieve", (Object)book.getName());
    }

    @Test
    public void testPatchBookInputStream() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/patch";
        WebClient wc = WebClient.create((String)address);
        wc.type("application/xml");
        WebClient.getConfig((Object)wc).getRequestContext().put("use.async.http.conduit", true);
        Book book = (Book)wc.invoke("PATCH", (Object)new ByteArrayInputStream("<Book><name>Patch</name><id>123</id></Book>".getBytes()), Book.class);
        JAXRSAsyncClientTest.assertEquals((Object)"Patch", (Object)book.getName());
        wc.close();
    }

    @Test
    public void testDeleteWithBody() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/deletebody";
        WebClient wc = WebClient.create((String)address);
        wc.type("application/xml").accept(new String[]{"application/xml"});
        WebClient.getConfig((Object)wc).getRequestContext().put("use.async.http.conduit", true);
        Book book = (Book)wc.invoke("DELETE", (Object)new Book("Delete", 123L), Book.class);
        JAXRSAsyncClientTest.assertEquals((Object)"Delete", (Object)book.getName());
    }

    @Test
    public void testRetrieveBookCustomMethodAsync() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/retrieve";
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"application/xml"});
        Future book = wc.async().method("RETRIEVE", Entity.xml((Object)new Book("Retrieve", 123L)), Book.class);
        JAXRSAsyncClientTest.assertEquals((Object)"Retrieve", (Object)((Book)book.get()).getName());
    }

    @Test
    public void testGetBookAsyncResponse404() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/404";
        WebClient wc = this.createWebClient(address);
        Future future = wc.async().get(Response.class);
        JAXRSAsyncClientTest.assertEquals((long)404L, (long)((Response)future.get()).getStatus());
    }

    @Test
    public void testGetBookAsync404() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/404";
        WebClient wc = this.createWebClient(address);
        Future future = wc.async().get(Book.class);
        try {
            future.get();
            JAXRSAsyncClientTest.fail((String)"Exception expected");
        }
        catch (ExecutionException ex) {
            JAXRSAsyncClientTest.assertTrue((boolean)(ex.getCause() instanceof NotFoundException));
        }
    }

    @Test
    public void testPostBookProcessingException() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/";
        ArrayList<FaultyBookWriter> providers = new ArrayList<FaultyBookWriter>();
        providers.add(new FaultyBookWriter());
        WebClient wc = WebClient.create((String)address, providers);
        Future future = wc.async().post(Entity.xml((Object)new Book()), Book.class);
        try {
            future.get();
            JAXRSAsyncClientTest.fail((String)"Exception expected");
        }
        catch (ExecutionException ex) {
            JAXRSAsyncClientTest.assertTrue((boolean)(ex.getCause() instanceof ClientException));
        }
    }

    @Test
    public void testGetBookResponseProcessingException() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/123";
        ArrayList<FaultyBookReader> providers = new ArrayList<FaultyBookReader>();
        providers.add(new FaultyBookReader());
        WebClient wc = WebClient.create((String)address, providers);
        Future future = wc.async().get(Book.class);
        try {
            future.get();
            JAXRSAsyncClientTest.fail((String)"Exception expected");
        }
        catch (ExecutionException ex) {
            JAXRSAsyncClientTest.assertTrue((boolean)(ex.getCause() instanceof ClientException));
        }
    }

    @Test
    public void testGetBookAsync404Callback() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/404";
        WebClient wc = this.createWebClient(address);
        Holder holder = new Holder();
        InvocationCallback<Object> callback = this.createCallback((Holder<Object>)holder);
        try {
            wc.async().get(callback).get();
            JAXRSAsyncClientTest.fail((String)"Exception expected");
        }
        catch (ExecutionException ex) {
            JAXRSAsyncClientTest.assertTrue((boolean)(ex.getCause() instanceof NotFoundException));
            JAXRSAsyncClientTest.assertTrue((ex.getCause() == ((ClientException)((Object)holder.value)).getCause() ? 1 : 0) != 0);
        }
    }

    private WebClient createWebClient(String address) {
        ArrayList providers = new ArrayList();
        return WebClient.create((String)address, providers);
    }

    private InvocationCallback<Object> createCallback(final Holder<Object> holder) {
        return new InvocationCallback<Object>(){

            public void completed(Object response) {
                holder.value = response;
            }

            public void failed(ClientException error) {
                holder.value = error;
            }
        };
    }

    private static class FaultyBookReader
    implements MessageBodyReader<Book> {
        private FaultyBookReader() {
        }

        public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
            return true;
        }

        public Book readFrom(Class<Book> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> arg4, InputStream arg5) throws IOException, WebApplicationException {
            throw new RuntimeException();
        }
    }

    private static class FaultyBookWriter
    implements MessageBodyWriter<Book> {
        private FaultyBookWriter() {
        }

        public long getSize(Book arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
            return 0L;
        }

        public boolean isWriteable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
            return true;
        }

        public void writeTo(Book arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4, MultivaluedMap<String, Object> arg5, OutputStream arg6) throws IOException, WebApplicationException {
            throw new RuntimeException();
        }
    }
}

