/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.XSLTJaxbProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.Book2;
import org.apache.cxf.systest.jaxrs.BookNoXmlRootElement;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.BookServer;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.Books;
import org.apache.cxf.systest.jaxrs.CD;
import org.apache.cxf.systest.jaxrs.CDs;
import org.apache.cxf.systest.jaxrs.Chapter;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSClientServerBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServer.PORT;
    public static final String PORT2 = JAXRSClientServerBookTest.allocatePort(JAXRSClientServerBookTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        AbstractResourceInfo.clearAllMaps();
        JAXRSClientServerBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerBookTest.launchServer(BookServer.class, (boolean)true));
        JAXRSClientServerBookTest.createStaticBus();
    }

    @Test
    public void testExceptionFromFaultyResponseHandler() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/faultyResponseHandler";
        WebClient wc = WebClient.create((String)address);
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setAutoRedirect(true);
        Response r = wc.get();
        JAXRSClientServerBookTest.assertEquals((long)500L, (long)r.getStatus());
    }

    @Test
    public void testGetBookRoot() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/;JSESSIONID=xxx";
        WebClient wc = WebClient.create((String)address);
        Book book = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"root", (Object)book.getName());
    }

    @Test
    public void testGetBookUntypedStreamingResponse() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/streamingresponse";
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"text/xml"});
        Book book = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"stream", (Object)book.getName());
    }

    @Test
    public void testGetBookQueryGZIP() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/";
        WebClient wc = WebClient.create((String)address);
        wc.acceptEncoding(new String[]{"gzip,deflate"});
        wc.encoding("gzip");
        InputStream r = (InputStream)wc.get(InputStream.class);
        JAXRSClientServerBookTest.assertNotNull((Object)r);
        GZIPInputStream in = new GZIPInputStream(r);
        String s = IOUtils.toString((InputStream)in);
        in.close();
        JAXRSClientServerBookTest.assertTrue((String)s, (boolean)s.contains("id>124"));
    }

    @Test
    public void testGetBookQueryDefault() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/query/default";
        WebClient wc = WebClient.create((String)address);
        Response r = wc.get();
        Book book = (Book)r.readEntity(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testGetBookSameUriAutoRedirect() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/redirect?sameuri=true";
        WebClient wc = WebClient.create((String)address);
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setAutoRedirect(true);
        WebClient.getConfig((Object)wc).getRequestContext().put(Message.MAINTAIN_SESSION, Boolean.TRUE);
        Response r = wc.get();
        Book book = (Book)r.readEntity(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
        String requestUri = (String)r.getStringHeaders().getFirst((Object)"RequestURI");
        JAXRSClientServerBookTest.assertEquals((Object)("http://localhost:" + PORT + "/bookstore/redirect?redirect=true"), (Object)requestUri);
        String theCookie = (String)r.getStringHeaders().getFirst((Object)"TheCookie");
        JAXRSClientServerBookTest.assertEquals((Object)"b", (Object)theCookie);
    }

    @Test
    public void testGetBookDiffUriAutoRedirect() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/redirect?sameuri=false";
        WebClient wc = WebClient.create((String)address);
        WebClient.getConfig((Object)wc).getRequestContext().put("http.redirect.same.host.only", "true");
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setAutoRedirect(true);
        try {
            wc.get();
            JAXRSClientServerBookTest.fail((String)"Redirect to different host is not allowed");
        }
        catch (ClientException ex) {
            Throwable cause = ex.getCause();
            JAXRSClientServerBookTest.assertTrue((boolean)cause.getMessage().contains("Different HTTP Scheme or Host Redirect detected on"));
        }
    }

    @Test
    public void testGetBookRelativeUriAutoRedirect() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/redirect/relative?loop=false";
        WebClient wc = WebClient.create((String)address);
        WebClient.getConfig((Object)wc).getRequestContext().put("http.redirect.relative.uri", "true");
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setAutoRedirect(true);
        Response r = wc.get();
        Book book = (Book)r.readEntity(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)book.getId());
    }

    @Test
    public void testGetBookRelativeUriAutoRedirectLoop() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/redirect/relative?loop=true";
        WebClient wc = WebClient.create((String)address);
        WebClient.getConfig((Object)wc).getRequestContext().put("http.redirect.relative.uri", "true");
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setAutoRedirect(true);
        try {
            wc.get();
            JAXRSClientServerBookTest.fail((String)"Redirect loop must be detected");
        }
        catch (ClientException ex) {
            Throwable cause = ex.getCause();
            JAXRSClientServerBookTest.assertTrue((boolean)cause.getMessage().contains("Redirect loop detected on"));
        }
    }

    @Test
    public void testGetBookRelativeUriAutoRedirectNotAllowed() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/redirect/relative?loop=true";
        WebClient wc = WebClient.create((String)address);
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setAutoRedirect(true);
        try {
            wc.get();
            JAXRSClientServerBookTest.fail((String)"relative Redirect is not allowed");
        }
        catch (ClientException ex) {
            Throwable cause = ex.getCause().getCause();
            JAXRSClientServerBookTest.assertTrue((boolean)cause.getMessage().startsWith("Relative Redirect detected on"));
        }
    }

    @Test
    public void testPostEmptyForm() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/emptyform";
        WebClient wc = WebClient.create((String)address);
        Response r = wc.form(new Form());
        JAXRSClientServerBookTest.assertEquals((Object)"empty form", (Object)r.readEntity(String.class));
    }

    @Test
    public void testPostEmptyFormAsInStream() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/emptyform";
        WebClient wc = WebClient.create((String)address);
        WebClient.getConfig((Object)wc).getRequestContext().put("org.apache.cxf.empty.request", true);
        wc.type("application/x-www-form-urlencoded");
        Response r = wc.post((Object)new ByteArrayInputStream("".getBytes()));
        JAXRSClientServerBookTest.assertEquals((Object)"empty form", (Object)r.readEntity(String.class));
    }

    @Test
    public void testGetBookDescriptionHttpResponse() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/httpresponse";
        WebClient wc = WebClient.create((String)address);
        WebClient.getConfig((Object)wc).getInInterceptors().add(new LoggingInInterceptor());
        Response r = wc.get();
        JAXRSClientServerBookTest.assertEquals((Object)"text/plain", (Object)r.getMediaType().toString());
        JAXRSClientServerBookTest.assertEquals((Object)"Good Book", (Object)r.readEntity(String.class));
    }

    @Test
    public void testGetCustomBookResponse() {
        String address = "http://localhost:" + PORT + "/bookstore/customresponse";
        WebClient wc = WebClient.create((String)address);
        Response r = (Response)wc.accept(new String[]{"application/xml"}).get(Response.class);
        Book book = (Book)r.readEntity(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)222L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"OK", (Object)r.getHeaderString("customresponse"));
    }

    @Test
    public void testGetCustomBookBufferedResponse() {
        String address = "http://localhost:" + PORT + "/bookstore/customresponse";
        WebClient wc = WebClient.create((String)address);
        Response r = (Response)wc.accept(new String[]{"application/xml"}).get(Response.class);
        r.bufferEntity();
        String bookStr = (String)r.readEntity(String.class);
        JAXRSClientServerBookTest.assertTrue((boolean)bookStr.endsWith("</Book>"));
        Book book = (Book)r.readEntity(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)222L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"OK", (Object)r.getHeaderString("customresponse"));
    }

    @Test
    public void testGetCustomBookText() {
        String address = "http://localhost:" + PORT + "/bookstore/customtext";
        WebClient wc = WebClient.create((String)address);
        Response r = wc.accept(new String[]{"text/custom"}).get();
        String name = (String)r.readEntity(String.class);
        JAXRSClientServerBookTest.assertEquals((Object)"Good book", (Object)name);
        JAXRSClientServerBookTest.assertEquals((Object)"text/custom;charset=us-ascii", (Object)r.getMediaType().toString());
    }

    @Test
    public void testGetBookNameAsByteArray() {
        String address = "http://localhost:" + PORT + "/bookstore/booknames/123";
        WebClient wc = WebClient.create((String)address);
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(1000000L);
        Response r = wc.accept(new String[]{"application/bar"}).get();
        String name = (String)r.readEntity(String.class);
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)name);
        String lengthStr = r.getHeaderString("Content-Length");
        JAXRSClientServerBookTest.assertNotNull((Object)lengthStr);
        long length = Long.valueOf(lengthStr);
        JAXRSClientServerBookTest.assertEquals((long)name.length(), (long)length);
    }

    @Test
    public void testGetChapterFromSelectedBook() {
        String address = "http://localhost:" + PORT + "/bookstore/books/id=le=123/chapter/1";
        this.doTestGetChapterFromSelectedBook(address);
    }

    @Test
    public void testUseMapperOnBus() {
        String address = "http://localhost:" + PORT + "/bookstore/mapperonbus";
        WebClient wc = WebClient.create((String)address);
        Response r = wc.post(null);
        JAXRSClientServerBookTest.assertEquals((long)500L, (long)r.getStatus());
        MediaType mt = r.getMediaType();
        JAXRSClientServerBookTest.assertEquals((Object)"text/plain;charset=utf-8", (Object)mt.toString().toLowerCase());
        JAXRSClientServerBookTest.assertEquals((Object)"the-mapper", (Object)r.getHeaderString("BusMapper"));
        JAXRSClientServerBookTest.assertEquals((Object)"BusMapperException", (Object)r.readEntity(String.class));
    }

    @Test
    public void testUseParamBeanWebClient() {
        String address = "http://localhost:" + PORT + "/bookstore/beanparam";
        this.doTestUseParamBeanWebClient(address);
    }

    @Test
    public void testUseParamBeanWebClient2() {
        String address = "http://localhost:" + PORT + "/bookstore/beanparam2";
        this.doTestUseParamBeanWebClient(address);
    }

    private void doTestUseParamBeanWebClient(String address) {
        WebClient wc = WebClient.create((String)address);
        wc.path((Object)"100");
        wc.query("id_2", new Object[]{"20"});
        wc.query("id3", new Object[]{"3"});
        Book book = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testGetIntroChapterFromSelectedBook() {
        String address = "http://localhost:" + PORT + "/bookstore/books(id=le=123)/chapter";
        this.doTestGetChapterFromSelectedBook(address);
    }

    @Test
    public void testGetIntroChapterFromSelectedBook2() {
        String address = "http://localhost:" + PORT + "/bookstore/";
        WebClient wc = WebClient.create((String)address);
        wc.path((Object)"books[id=le=123]");
        wc.path((Object)"chapter");
        wc.accept(new String[]{"application/xml"});
        Chapter chapter = (Chapter)wc.get(Chapter.class);
        JAXRSClientServerBookTest.assertEquals((Object)"chapter 1", (Object)chapter.getTitle());
    }

    private void doTestGetChapterFromSelectedBook(String address) {
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"application/xml"});
        Chapter chapter = (Chapter)wc.get(Chapter.class);
        JAXRSClientServerBookTest.assertEquals((Object)"chapter 1", (Object)chapter.getTitle());
    }

    @Test
    public void testWithComplexPath() {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/allCharsButA-B/:@!$&'()*+,;=-._~"));
        wc.accept(new String[]{"application/xml"});
        Book book = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((Object)"Encoded Path", (Object)book.getName());
    }

    @Test
    public void testMalformedAcceptType() {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/123"));
        wc.accept(new String[]{"application"});
        Response r = wc.get();
        JAXRSClientServerBookTest.assertEquals((long)406L, (long)r.getStatus());
    }

    @Test
    public void testProxyWrongAddress() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT2 + "/wrongaddress"), BookStore.class);
        try {
            store.getBook("123");
            JAXRSClientServerBookTest.fail((String)"ClientException expected");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    @Test
    public void testProxyBeanParam() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        BookStore.BookBean bean = new BookStore.BookBean();
        bean.setId(100L);
        bean.setId2(23L);
        Book book = store.getBeanParamBook(bean);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testProxyBeanParam2() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        WebClient.getConfig((Object)store).getHttpConduit().getClient().setReceiveTimeout(10000000L);
        BookStore.BookBean2 bean = new BookStore.BookBean2();
        bean.setId(100L);
        bean.setId2(23L);
        BookStore.BookBeanNested nested = new BookStore.BookBeanNested();
        nested.setId4(123L);
        Book book = store.getTwoBeanParamsBook(bean, nested);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testGetBookWithCustomHeader() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books/123";
        WebClient wc = WebClient.create((String)endpointAddress);
        Book b = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b.getId());
        MultivaluedMap headers = wc.getResponse().getMetadata();
        JAXRSClientServerBookTest.assertEquals((Object)"123", (Object)headers.getFirst((Object)"BookId"));
        JAXRSClientServerBookTest.assertEquals((Object)MultivaluedMap.class.getName(), (Object)headers.getFirst((Object)"MAP-NAME"));
        JAXRSClientServerBookTest.assertNotNull((Object)headers.getFirst((Object)"Date"));
        wc.header("PLAIN-MAP", new Object[]{"true"});
        b = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b.getId());
        headers = wc.getResponse().getMetadata();
        JAXRSClientServerBookTest.assertEquals((Object)"321", (Object)headers.getFirst((Object)"BookId"));
        JAXRSClientServerBookTest.assertEquals((Object)Map.class.getName(), (Object)headers.getFirst((Object)"MAP-NAME"));
        JAXRSClientServerBookTest.assertNotNull((Object)headers.getFirst((Object)"Date"));
    }

    @Test
    public void testGetBookWithNameInQuery() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/name-in-query";
        WebClient wc = WebClient.create((String)endpointAddress);
        String name = "Many        spaces";
        wc.query("name", new Object[]{name});
        Book b = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((Object)name, (Object)b.getName());
    }

    @Test
    public void testGetBookAsObject() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/object";
        WebClient wc = WebClient.create((String)endpointAddress);
        Book b = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((Object)"Book as Object", (Object)b.getName());
    }

    @Test
    public void testProcessingInstruction() throws Exception {
        String base = "http://localhost:" + PORT;
        String endpointAddress = base + "/bookstore/name-in-query";
        WebClient wc = WebClient.create((String)endpointAddress);
        String name = "Many        spaces";
        wc.query("name", new Object[]{name});
        String content = (String)wc.get(String.class);
        JAXRSClientServerBookTest.assertTrue((boolean)content.contains("<!DOCTYPE Something SYSTEM 'my.dtd'>"));
        JAXRSClientServerBookTest.assertTrue((boolean)content.contains("<?xmlstylesheet href='" + base + "/common.css'?>"));
        JAXRSClientServerBookTest.assertTrue((boolean)content.contains("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\""));
        JAXRSClientServerBookTest.assertTrue((boolean)content.contains("xsi:schemaLocation=\"" + base + "/book.xsd\""));
    }

    @Test
    public void testGetBookWithColonMarks() throws Exception {
        String endpointAddressUrlEncoded = "http://localhost:" + PORT + "/bookstore/books/colon/" + URLEncoder.encode("1:2:3", "UTF-8");
        Response r = WebClient.create((String)endpointAddressUrlEncoded).get();
        JAXRSClientServerBookTest.assertEquals((long)404L, (long)r.getStatus());
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books/colon/1:2:3";
        WebClient wc = WebClient.create((String)endpointAddress);
        Book b = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b.getId());
    }

    @Test
    public void testPostAnd401WithText() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/post401";
        WebClient wc = WebClient.create((String)endpointAddress);
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setAllowChunking(false);
        Response r = wc.post(null);
        JAXRSClientServerBookTest.assertEquals((long)401L, (long)r.getStatus());
        JAXRSClientServerBookTest.assertEquals((Object)"This is 401", (Object)this.getStringFromInputStream((InputStream)r.getEntity()));
    }

    @Test
    public void testCapturedServerInFault() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/infault";
        WebClient wc = WebClient.create((String)endpointAddress);
        Response r = wc.get();
        JAXRSClientServerBookTest.assertEquals((long)401L, (long)r.getStatus());
    }

    @Test
    public void testCapturedServerOutFault() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/outfault";
        WebClient wc = WebClient.create((String)endpointAddress);
        Response r = wc.get();
        JAXRSClientServerBookTest.assertEquals((long)403L, (long)r.getStatus());
    }

    @Test
    public void testGetCollectionOfBooks() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/collections";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"});
        Collection collection = wc.getCollection(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)collection.size());
        Book book = (Book)collection.iterator().next();
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testPostCollectionGetBooksWebClient() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/collections3";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).type("application/xml");
        Book b1 = new Book("CXF in Action", 123L);
        Book b2 = new Book("CXF Rocks", 124L);
        ArrayList<Book> books = new ArrayList<Book>();
        books.add(b1);
        books.add(b2);
        Book book = (Book)wc.postCollection(books, Book.class, Book.class);
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)wc.getResponse().getStatus());
        JAXRSClientServerBookTest.assertNotSame((Object)b1, (Object)book);
        JAXRSClientServerBookTest.assertEquals((Object)b1.getName(), (Object)book.getName());
    }

    @Test
    public void testPostCollectionGenericEntityWebClient() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/collections3";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).type("application/xml");
        Book b1 = new Book("CXF in Action", 123L);
        Book b2 = new Book("CXF Rocks", 124L);
        ArrayList<Book> books = new ArrayList<Book>();
        books.add(b1);
        books.add(b2);
        GenericEntity<List<Book>> genericCollectionEntity = new GenericEntity<List<Book>>(books){};
        Book book = (Book)wc.post((Object)genericCollectionEntity, Book.class);
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)wc.getResponse().getStatus());
        JAXRSClientServerBookTest.assertNotSame((Object)b1, (Object)book);
        JAXRSClientServerBookTest.assertEquals((Object)b1.getName(), (Object)book.getName());
    }

    @Test
    public void testPostGetCollectionGenericEntityAndType() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/collections";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).type("application/xml");
        Book b1 = new Book("CXF in Action", 123L);
        Book b2 = new Book("CXF Rocks", 124L);
        ArrayList<Book> books = new ArrayList<Book>();
        books.add(b1);
        books.add(b2);
        GenericEntity<List<Book>> genericCollectionEntity = new GenericEntity<List<Book>>(books){};
        GenericType<List<Book>> genericResponseType = new GenericType<List<Book>>(){};
        List books2 = (List)wc.post((Object)genericCollectionEntity, (GenericType)genericResponseType);
        JAXRSClientServerBookTest.assertNotNull((Object)books2);
        JAXRSClientServerBookTest.assertNotSame(books, (Object)books2);
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)books2.size());
        Book b11 = (Book)books.get(0);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b11.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)b11.getName());
        Book b22 = (Book)books.get(1);
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)b22.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF Rocks", (Object)b22.getName());
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)wc.getResponse().getStatus());
    }

    @Test
    public void testPostCollectionOfBooksWebClient() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/collections";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).type("application/xml");
        Book b1 = new Book("CXF in Action", 123L);
        Book b2 = new Book("CXF Rocks", 124L);
        ArrayList<Book> books = new ArrayList<Book>();
        books.add(b1);
        books.add(b2);
        ArrayList books2 = new ArrayList(wc.postAndGetCollection(books, Book.class, Book.class));
        JAXRSClientServerBookTest.assertNotNull(books2);
        JAXRSClientServerBookTest.assertNotSame(books, books2);
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)books2.size());
        Book b11 = (Book)books.get(0);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b11.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)b11.getName());
        Book b22 = (Book)books.get(1);
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)b22.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF Rocks", (Object)b22.getName());
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)wc.getResponse().getStatus());
    }

    @Test
    public void testPostNullGetEmptyCollectionProxy() throws Exception {
        String endpointAddress = "http://localhost:" + PORT;
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)endpointAddress, BookStore.class);
        List<Book> books = bs.postBookGetCollection(null);
        JAXRSClientServerBookTest.assertNotNull(books);
        JAXRSClientServerBookTest.assertEquals((long)0L, (long)books.size());
    }

    @Test
    public void testPostObjectGetCollection() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/collectionBook";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).type("application/xml");
        Book b1 = new Book("Book", 666L);
        ArrayList books = new ArrayList(wc.postObjectGetCollection((Object)b1, Book.class));
        JAXRSClientServerBookTest.assertNotNull(books);
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)books.size());
        Book b = (Book)books.get(0);
        JAXRSClientServerBookTest.assertEquals((long)666L, (long)b.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"Book", (Object)b.getName());
    }

    @Test
    public void testGetBookResponseAndETag() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books/response/123";
        WebClient wc = WebClient.create((String)endpointAddress);
        Book book = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)wc.getResponse().getStatus());
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
        MultivaluedMap headers = wc.getResponse().getMetadata();
        JAXRSClientServerBookTest.assertTrue((headers.size() > 0 ? 1 : 0) != 0);
        Object etag = headers.getFirst((Object)"ETag");
        JAXRSClientServerBookTest.assertNotNull((Object)etag);
        JAXRSClientServerBookTest.assertTrue((boolean)etag.toString().startsWith("\""));
        JAXRSClientServerBookTest.assertTrue((boolean)etag.toString().endsWith("\""));
    }

    @Test
    public void testOnewayWebClient() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/oneway"));
        Response r = client.header("OnewayRequest", new Object[]{"true"}).post(null);
        JAXRSClientServerBookTest.assertEquals((long)202L, (long)r.getStatus());
        JAXRSClientServerBookTest.assertFalse((boolean)r.getHeaders().isEmpty());
    }

    @Test
    public void testBookWithSpace() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/")).path((Object)"the books/123");
        Book book = (Book)client.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testBookWithSpaceProxy() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Book book = store.getBookWithSpace("123");
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)book.getName());
    }

    @Test
    public void testBookWithSpaceProxyPathUrlEncoded() throws Exception {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setServiceClass(BookStore.class);
        bean.setAddress("http://localhost:" + PORT);
        bean.setProperties(Collections.singletonMap("url.encode.client.parameters", Boolean.TRUE));
        BookStore store = (BookStore)bean.create(BookStore.class, new Object[0]);
        Book book = store.getBookWithSemicolon("123;:", "custom;:header");
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action%3B%3A", (Object)book.getName());
    }

    @Test
    public void testBookWithSpaceProxyPathUrlEncodedSemicolonOnly() throws Exception {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setServiceClass(BookStore.class);
        bean.setAddress("http://localhost:" + PORT);
        bean.getProperties(true).put("url.encode.client.parameters", "true");
        bean.getProperties(true).put("url.encode.client.parameters.list", ";");
        BookStore store = (BookStore)bean.create(BookStore.class, new Object[0]);
        Book book = store.getBookWithSemicolon("123;:", "custom;:header");
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action%3B:", (Object)book.getName());
    }

    @Test
    public void testBookWithSpaceProxyNonEncodedSemicolon() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Book book = store.getBookWithSemicolon("123;", "custom;:header");
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action;", (Object)book.getName());
    }

    @Test
    public void testBookWithMultipleExceptions() throws Exception {
        LinkedList<Object> providers = new LinkedList<Object>();
        providers.add(new NotReturnedExceptionMapper());
        providers.add(new NotFoundExceptionMapper());
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class, providers);
        try {
            store.getBookWithExceptions(true);
            JAXRSClientServerBookTest.fail();
        }
        catch (BookStore.BookNotReturnedException ex) {
            JAXRSClientServerBookTest.assertEquals((Object)"notReturned", (Object)ex.getMessage());
        }
        try {
            store.getBookWithExceptions(false);
            JAXRSClientServerBookTest.fail();
        }
        catch (BookNotFoundFault ex) {
            JAXRSClientServerBookTest.assertEquals((Object)"notFound", (Object)ex.getMessage());
        }
    }

    @Test
    public void testBookWithExceptionsNoMapper() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        try {
            store.getBookWithExceptions(true);
            JAXRSClientServerBookTest.fail();
        }
        catch (WebApplicationException ex) {
            JAXRSClientServerBookTest.assertEquals((Object)"notReturned", (Object)ex.getResponse().getHeaderString("Status"));
        }
    }

    @Test
    public void testBookWithMultipleExceptions2() throws Exception {
        LinkedList<Object> providers = new LinkedList<Object>();
        providers.add(new NotReturnedExceptionMapper());
        providers.add(new NotFoundExceptionMapper());
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class, providers);
        try {
            store.getBookWithExceptions2(true);
            JAXRSClientServerBookTest.fail();
        }
        catch (BookStore.BookNotReturnedException ex) {
            JAXRSClientServerBookTest.assertEquals((Object)"notReturned", (Object)ex.getMessage());
        }
        try {
            store.getBookWithExceptions2(false);
            JAXRSClientServerBookTest.fail();
        }
        catch (BookNotFoundFault ex) {
            JAXRSClientServerBookTest.assertEquals((Object)"notFound", (Object)ex.getMessage());
        }
    }

    @Test
    public void testTempRedirectWebClient() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/tempredirect"));
        Response r = client.type("*/*").get();
        JAXRSClientServerBookTest.assertEquals((long)307L, (long)r.getStatus());
        MultivaluedMap map = r.getMetadata();
        JAXRSClientServerBookTest.assertEquals((Object)("http://localhost:" + PORT + "/whatever/redirection?css1=http%3A//bar"), (Object)map.getFirst((Object)"Location").toString());
        List cookies = (List)r.getMetadata().get((Object)"Set-Cookie");
        JAXRSClientServerBookTest.assertNotNull((Object)cookies);
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)cookies.size());
    }

    @Test
    public void testSetCookieWebClient() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/setcookies"));
        Response r = client.type("*/*").get();
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)r.getStatus());
        List cookies = (List)r.getMetadata().get((Object)"Set-Cookie");
        JAXRSClientServerBookTest.assertNotNull((Object)cookies);
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)cookies.size());
    }

    @Test
    public void testSetManyCookiesWebClient() throws Exception {
        WebClient client = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/setmanycookies"));
        Response r = client.type("*/*").get();
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)r.getStatus());
        List cookies = (List)r.getMetadata().get((Object)"Set-Cookie");
        JAXRSClientServerBookTest.assertNotNull((Object)cookies);
        JAXRSClientServerBookTest.assertEquals((long)3L, (long)cookies.size());
    }

    @Test
    public void testOnewayProxy() throws Exception {
        BookStore proxy = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        proxy.onewayRequest();
        JAXRSClientServerBookTest.assertEquals((long)202L, (long)WebClient.client((Object)proxy).getResponse().getStatus());
    }

    @Test
    public void testProxyWithCollectionMatrixParams() throws Exception {
        BookStore proxy = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        ArrayList<String> params = new ArrayList<String>();
        params.add("12");
        params.add("3");
        Book book = proxy.getBookByMatrixListParams(params);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testPropogateException() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/propagate-exception", "Error: 500", "application/xml", 500);
    }

    @Test
    public void testPropogateException2() throws Exception {
        String data = "<ns1:XMLFault xmlns:ns1=\"http://cxf.apache.org/bindings/xformat\"><ns1:faultstring xmlns:ns1=\"http://cxf.apache.org/bindings/xformat\">org.apache.cxf.systest.jaxrs.BookNotFoundFault: Book Exception</ns1:faultstring></ns1:XMLFault>";
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/propagate-exception2", data, "application/xml", 500);
    }

    @Test
    public void testPropogateException3() throws Exception {
        String data = "<nobook/>";
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/propagate-exception3", data, "application/xml", 500);
    }

    @Test
    public void testPropogateException4() throws Exception {
        String data = "<nobook/>";
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/propogateExceptionVar/1", data, "application/xml", 500);
    }

    @Test
    public void testServerWebApplicationException() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/webappexception"));
        wc.accept(new String[]{"application/xml"});
        try {
            wc.get(Book.class);
            JAXRSClientServerBookTest.fail((String)"Exception expected");
        }
        catch (ServerErrorException ex) {
            JAXRSClientServerBookTest.assertEquals((long)500L, (long)ex.getResponse().getStatus());
            JAXRSClientServerBookTest.assertEquals((Object)"This is a WebApplicationException", (Object)ex.getResponse().readEntity(String.class));
        }
    }

    @Test
    public void testServerWebApplicationExceptionResponse() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/webappexception"));
        wc.accept(new String[]{"application/xml"});
        try {
            Response r = (Response)wc.get(Response.class);
            JAXRSClientServerBookTest.assertEquals((long)500L, (long)r.getStatus());
        }
        catch (WebApplicationException ex) {
            JAXRSClientServerBookTest.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void testServerWebApplicationExceptionXML() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/webappexceptionXML"));
        wc.accept(new String[]{"application/xml"});
        try {
            wc.get(Book.class);
            JAXRSClientServerBookTest.fail((String)"Exception expected");
        }
        catch (NotAcceptableException ex) {
            JAXRSClientServerBookTest.assertEquals((long)406L, (long)ex.getResponse().getStatus());
            Book exBook = (Book)ex.getResponse().readEntity(Book.class);
            JAXRSClientServerBookTest.assertEquals((Object)"Exception", (Object)exBook.getName());
            JAXRSClientServerBookTest.assertEquals((long)999L, (long)exBook.getId());
        }
    }

    @Test
    public void testServerWebApplicationExceptionXMLWithProxy() throws Exception {
        BookStore proxy = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        try {
            proxy.throwExceptionXML();
            JAXRSClientServerBookTest.fail((String)"Exception expected");
        }
        catch (NotAcceptableException ex) {
            JAXRSClientServerBookTest.assertEquals((long)406L, (long)ex.getResponse().getStatus());
            Book exBook = (Book)ex.getResponse().readEntity(Book.class);
            JAXRSClientServerBookTest.assertEquals((Object)"Exception", (Object)exBook.getName());
            JAXRSClientServerBookTest.assertEquals((long)999L, (long)exBook.getId());
        }
    }

    @Test
    public void testServerWebApplicationExceptionWithProxy() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        try {
            store.throwException();
            JAXRSClientServerBookTest.fail((String)"Exception expected");
        }
        catch (ServerErrorException ex) {
            JAXRSClientServerBookTest.assertEquals((long)500L, (long)ex.getResponse().getStatus());
            JAXRSClientServerBookTest.assertEquals((Object)"This is a WebApplicationException", (Object)ex.getResponse().readEntity(String.class));
        }
    }

    @Test
    public void testServerWebApplicationExceptionWithProxy2() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        try {
            store.throwException();
            JAXRSClientServerBookTest.fail((String)"Exception expected");
        }
        catch (WebApplicationException ex) {
            JAXRSClientServerBookTest.assertEquals((long)500L, (long)ex.getResponse().getStatus());
            JAXRSClientServerBookTest.assertEquals((Object)"This is a WebApplicationException", (Object)ex.getResponse().readEntity(String.class));
        }
    }

    @Test
    public void testWebApplicationException() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/webappexception", "This is a WebApplicationException", "application/xml", 500);
    }

    @Test
    public void testAddBookProxyResponse() {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Book b = new Book("CXF rocks", 123L);
        Response r = store.addBook(b);
        JAXRSClientServerBookTest.assertNotNull((Object)r);
        InputStream is = (InputStream)r.getEntity();
        JAXRSClientServerBookTest.assertNotNull((Object)is);
        XMLSource source = new XMLSource(is);
        source.setBuffering();
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)Long.parseLong(source.getValue("Book/id")));
        JAXRSClientServerBookTest.assertEquals((Object)"CXF rocks", (Object)source.getValue("Book/name"));
    }

    @Test
    public void testGetBookCollection() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Book b1 = new Book("CXF in Action", 123L);
        Book b2 = new Book("CXF Rocks", 124L);
        ArrayList<Book> books = new ArrayList<Book>();
        books.add(b1);
        books.add(b2);
        List<Book> books2 = store.getBookCollection(books);
        JAXRSClientServerBookTest.assertNotNull(books2);
        JAXRSClientServerBookTest.assertNotSame(books, books2);
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)books2.size());
        Book b11 = (Book)books.get(0);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b11.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)b11.getName());
        Book b22 = (Book)books.get(1);
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)b22.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF Rocks", (Object)b22.getName());
    }

    @Test
    public void testGetBookCollection2() throws Exception {
        JAXBElementProvider provider = new JAXBElementProvider();
        provider.setMarshallAsJaxbElement(true);
        provider.setUnmarshallAsJaxbElement(true);
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class, Collections.singletonList(provider));
        BookNoXmlRootElement b1 = new BookNoXmlRootElement("CXF in Action", 123L);
        BookNoXmlRootElement b2 = new BookNoXmlRootElement("CXF Rocks", 124L);
        ArrayList<BookNoXmlRootElement> books = new ArrayList<BookNoXmlRootElement>();
        books.add(b1);
        books.add(b2);
        WebClient.getConfig((Object)store).getHttpConduit().getClient().setReceiveTimeout(10000000L);
        List<BookNoXmlRootElement> books2 = store.getBookCollection2(books);
        JAXRSClientServerBookTest.assertNotNull(books2);
        JAXRSClientServerBookTest.assertNotSame(books, books2);
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)books2.size());
        BookNoXmlRootElement b11 = (BookNoXmlRootElement)books.get(0);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b11.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)b11.getName());
        BookNoXmlRootElement b22 = (BookNoXmlRootElement)books.get(1);
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)b22.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF Rocks", (Object)b22.getName());
    }

    @Test
    public void testGetBookArray() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Book b1 = new Book("CXF in Action", 123L);
        Book b2 = new Book("CXF Rocks", 124L);
        Book[] books = new Book[]{b1, b2};
        Book[] books2 = store.getBookArray(books);
        JAXRSClientServerBookTest.assertNotNull((Object)books2);
        JAXRSClientServerBookTest.assertNotSame((Object)books, (Object)books2);
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)books2.length);
        Book b11 = books2[0];
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b11.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)b11.getName());
        Book b22 = books2[1];
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)b22.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF Rocks", (Object)b22.getName());
    }

    @Test
    public void testGetBookByURL() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/bookurl/http%3A%2F%2Ftest.com%2Frss%2F123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testHeadBookByURL() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/bookurl/http%3A%2F%2Ftest.com%2Frss%2F123"));
        Response response = wc.head();
        JAXRSClientServerBookTest.assertTrue((response.getMetadata().size() != 0 ? 1 : 0) != 0);
        JAXRSClientServerBookTest.assertEquals((long)0L, (long)((InputStream)response.getEntity()).available());
    }

    @Test
    public void testWebClientUnwrapBookWithXslt() throws Exception {
        XSLTJaxbProvider provider = new XSLTJaxbProvider();
        provider.setInTemplate("classpath:/org/apache/cxf/systest/jaxrs/resources/unwrapbook.xsl");
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/wrapper"), Collections.singletonList(provider));
        wc.path("{id}", new Object[]{123});
        Book book = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertNotNull((Object)book);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    @Ignore
    public void testProxyUnwrapBookWithXslt() throws Exception {
        XSLTJaxbProvider provider = new XSLTJaxbProvider();
        provider.setInTemplate("classpath:/org/apache/cxf/systest/jaxrs/resources/unwrapbook2.xsl");
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class, Collections.singletonList(provider));
        Book book = bs.getWrappedBook2(123L);
        JAXRSClientServerBookTest.assertNotNull((Object)book);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testOptions() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/bookurl/http%3A%2F%2Ftest.com%2Frss%2F123"));
        WebClient.getConfig((Object)wc).getRequestContext().put("org.apache.cxf.http.header.split", true);
        Response response = wc.options();
        List values = (List)response.getMetadata().get((Object)"Allow");
        JAXRSClientServerBookTest.assertNotNull((Object)values);
        JAXRSClientServerBookTest.assertTrue((values.contains("POST") && values.contains("GET") && values.contains("DELETE") && values.contains("PUT") ? 1 : 0) != 0);
        JAXRSClientServerBookTest.assertEquals((long)0L, (long)((InputStream)response.getEntity()).available());
        List date = (List)response.getMetadata().get((Object)"Date");
        JAXRSClientServerBookTest.assertNotNull((Object)date);
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)date.size());
    }

    @Test
    public void testExplicitOptions() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/options"));
        WebClient.getConfig((Object)wc).getRequestContext().put("org.apache.cxf.http.header.split", true);
        Response response = wc.options();
        List values = (List)response.getMetadata().get((Object)"Allow");
        JAXRSClientServerBookTest.assertNotNull((Object)values);
        JAXRSClientServerBookTest.assertTrue((values.contains("POST") && values.contains("GET") && values.contains("DELETE") && values.contains("PUT") ? 1 : 0) != 0);
        JAXRSClientServerBookTest.assertEquals((long)0L, (long)((InputStream)response.getEntity()).available());
        List date = (List)response.getMetadata().get((Object)"Date");
        JAXRSClientServerBookTest.assertNotNull((Object)date);
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)date.size());
    }

    public void testExplicitOptionsNoSplitByDefault() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/options"));
        Response response = wc.options();
        List<String> values = Arrays.asList(response.getHeaderString("Allow").split(","));
        JAXRSClientServerBookTest.assertNotNull(values);
        JAXRSClientServerBookTest.assertTrue((values.contains("POST") && values.contains("GET") && values.contains("DELETE") && values.contains("PUT") ? 1 : 0) != 0);
        JAXRSClientServerBookTest.assertEquals((long)0L, (long)((InputStream)response.getEntity()).available());
        List date = (List)response.getMetadata().get((Object)"Date");
        JAXRSClientServerBookTest.assertNotNull((Object)date);
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)date.size());
    }

    @Test
    public void testOptionsOnSubresource() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/booksubresource/123"));
        WebClient.getConfig((Object)wc).getRequestContext().put("org.apache.cxf.http.header.split", true);
        Response response = wc.options();
        List values = (List)response.getMetadata().get((Object)"Allow");
        JAXRSClientServerBookTest.assertNotNull((Object)values);
        JAXRSClientServerBookTest.assertTrue((!values.contains("POST") && values.contains("GET") && !values.contains("DELETE") && values.contains("PUT") ? 1 : 0) != 0);
        JAXRSClientServerBookTest.assertEquals((long)0L, (long)((InputStream)response.getEntity()).available());
        List date = (List)response.getMetadata().get((Object)"Date");
        JAXRSClientServerBookTest.assertNotNull((Object)date);
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)date.size());
    }

    @Test
    public void testEmptyPost() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/emptypost"));
        Response response = wc.post(null);
        JAXRSClientServerBookTest.assertEquals((long)204L, (long)response.getStatus());
        JAXRSClientServerBookTest.assertNull((Object)response.getMetadata().getFirst((Object)"Content-Type"));
    }

    @Test
    public void testEmptyPostBytes() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/emptypost"));
        Response response = wc.post((Object)new byte[0]);
        JAXRSClientServerBookTest.assertEquals((long)204L, (long)response.getStatus());
        JAXRSClientServerBookTest.assertNull((Object)response.getMetadata().getFirst((Object)"Content-Type"));
    }

    @Test
    public void testEmptyPut() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/emptyput"));
        Response response = wc.put(null);
        JAXRSClientServerBookTest.assertEquals((long)204L, (long)response.getStatus());
        JAXRSClientServerBookTest.assertNull((Object)response.getMetadata().getFirst((Object)"Content-Type"));
        response = wc.put((Object)"");
        JAXRSClientServerBookTest.assertEquals((long)204L, (long)response.getStatus());
        JAXRSClientServerBookTest.assertNull((Object)response.getMetadata().getFirst((Object)"Content-Type"));
    }

    @Test
    public void testEmptyPostProxy() throws Exception {
        String address = "http://localhost:" + PORT;
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(address);
        bean.setResourceClass(BookStore.class);
        BookStore store = (BookStore)bean.create(BookStore.class, new Object[0]);
        store.emptypost();
        JAXRSClientServerBookTest.assertEquals((long)204L, (long)WebClient.client((Object)store).getResponse().getStatus());
    }

    @Test
    public void testGetStringArray() throws Exception {
        String address = "http://localhost:" + PORT;
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setProvider((Object)new BookStore.StringArrayBodyReaderWriter());
        bean.setAddress(address);
        bean.setResourceClass(BookStore.class);
        BookStore store = (BookStore)bean.create(BookStore.class, new Object[0]);
        String[] str = store.getBookStringArray();
        JAXRSClientServerBookTest.assertEquals((Object)"Good book", (Object)str[0]);
    }

    @Test
    public void testGetPrimitiveIntArray() throws Exception {
        String address = "http://localhost:" + PORT;
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setProvider((Object)new BookStore.PrimitiveIntArrayReaderWriter());
        bean.setAddress(address);
        bean.setResourceClass(BookStore.class);
        BookStore store = (BookStore)bean.create(BookStore.class, new Object[0]);
        int[] arr = store.getBookIndexAsIntArray();
        JAXRSClientServerBookTest.assertEquals((long)3L, (long)arr.length);
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)arr[0]);
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)arr[1]);
        JAXRSClientServerBookTest.assertEquals((long)3L, (long)arr[2]);
    }

    @Test
    public void testGetPrimitiveDoubleArray() throws Exception {
        String address = "http://localhost:" + PORT;
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setProvider((Object)new BookStore.PrimitiveDoubleArrayReaderWriter());
        bean.setAddress(address);
        bean.setResourceClass(BookStore.class);
        BookStore store = (BookStore)bean.create(BookStore.class, new Object[0]);
        WebClient.getConfig((Object)store).getHttpConduit().getClient().setReceiveTimeout(1000000L);
        double[] arr = store.getBookIndexAsDoubleArray();
        JAXRSClientServerBookTest.assertEquals((long)3L, (long)arr.length);
        JAXRSClientServerBookTest.assertEquals((double)1.0, (double)arr[0], (double)0.0);
        JAXRSClientServerBookTest.assertEquals((double)2.0, (double)arr[1], (double)0.0);
        JAXRSClientServerBookTest.assertEquals((double)3.0, (double)arr[2], (double)0.0);
    }

    @Test
    public void testGetStringList() throws Exception {
        String address = "http://localhost:" + PORT;
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setProvider((Object)new BookStore.StringListBodyReaderWriter());
        bean.setAddress(address);
        bean.setResourceClass(BookStore.class);
        BookStore store = (BookStore)bean.create(BookStore.class, new Object[0]);
        List<String> str = store.getBookListArray();
        JAXRSClientServerBookTest.assertEquals((Object)"Good book", (Object)str.get(0));
    }

    @Test
    public void testEmptyPostProxy2() throws Exception {
        String address = "http://localhost:" + PORT;
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(address);
        bean.setResourceClass(BookStore.class);
        BookStore store = (BookStore)bean.create(BookStore.class, new Object[0]);
        store.emptypostNoPath();
        JAXRSClientServerBookTest.assertEquals((long)204L, (long)WebClient.client((Object)store).getResponse().getStatus());
    }

    @Test
    public void testGetBookByEncodedQuery() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/bookquery?" + "urlid=http%3A%2F%2Ftest.com%2Frss%2F123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetGenericBook() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/genericbooks/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetGenericResponseBook() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/genericresponse/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookByArrayQuery() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/bookidarray?" + "id=1&id=2&id=3", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testNoRootResourceException() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/nobookstore/webappexception", "", "application/xml", 404);
    }

    @Test
    public void testNoPathMatch() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/bookqueries", "", "application/xml", 404);
    }

    @Test
    public void testStatusAngHeadersFromStream() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/statusFromStream";
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"text/xml"});
        Response r = wc.get();
        JAXRSClientServerBookTest.assertEquals((long)503L, (long)r.getStatus());
        JAXRSClientServerBookTest.assertEquals((Object)"text/plain", (Object)r.getMediaType().toString());
        JAXRSClientServerBookTest.assertEquals((Object)"CustomValue", (Object)r.getHeaderString("CustomHeader"));
        JAXRSClientServerBookTest.assertEquals((Object)"Response is not available", (Object)r.readEntity(String.class));
    }

    @Test
    public void testWriteAndFailEarly() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/books/fail-early", "This is supposed to go on the wire", "application/bar, text/plain", 410);
    }

    @Test
    public void testWriteAndFailLate() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/books/fail-late", "", "application/bar", 410);
    }

    @Test
    public void testAcceptTypeMismatch() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/booknames/123", "", "foo/bar", 406);
    }

    @Test
    public void testWrongHttpMethod() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/unsupportedcontenttype", "", "foo/bar", 405);
    }

    @Test
    public void testWrongQueryParameterType() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/wrongparametertype?p=1", "Parameter Class java.util.Map has no constructor with single String parameter, static valueOf(String) or fromString(String) methods", "*/*", 500);
    }

    @Test
    public void testWrongContentType() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/unsupportedcontenttype";
        URL url = new URL(endpointAddress);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setReadTimeout(30000);
        urlConnection.setConnectTimeout(30000);
        urlConnection.addRequestProperty("Content-Type", "MissingSeparator");
        urlConnection.setRequestMethod("POST");
        JAXRSClientServerBookTest.assertEquals((long)415L, (long)urlConnection.getResponseCode());
    }

    @Test
    public void testExceptionDuringConstruction() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/exceptionconstruction?p=1", "", "foo/bar", 404);
    }

    @Test
    public void testSubresourceMethodNotFound() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/interface/thesubresource", "", "foo/bar", 404);
    }

    @Test
    public void testNoMessageWriterFound() throws Exception {
        String msg1 = "No message body writer has been found for response class GregorianCalendar.";
        String msg2 = "No message body writer has been found for response class Calendar.";
        this.getAndCompareStrings("http://localhost:" + PORT + "/bookstore/timetable", new String[]{msg1, msg2}, "*/*", 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoMessageReaderFound() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/binarybooks";
        PostMethod post = new PostMethod(endpointAddress);
        post.setRequestHeader("Content-Type", "application/octet-stream");
        post.setRequestHeader("Accept", "text/xml");
        post.setRequestBody("Bar");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)415L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumeTypeMismatch() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/unsupportedcontenttype";
        PostMethod post = new PostMethod(endpointAddress);
        post.setRequestHeader("Content-Type", "application/bar");
        post.setRequestHeader("Accept", "text/xml");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)415L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Test
    public void testBookExists() throws Exception {
        this.checkBook("http://localhost:" + PORT + "/bookstore/books/check/123", true);
        this.checkBook("http://localhost:" + PORT + "/bookstore/books/check/125", false);
    }

    @Test
    public void testBookExistsWebClientPrimitiveBoolean() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/check/123"));
        wc.accept(new String[]{"text/plain"});
        JAXRSClientServerBookTest.assertTrue((boolean)((Boolean)wc.get(Boolean.TYPE)));
    }

    @Test
    public void testBookExistsProxyPrimitiveBoolean() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        JAXRSClientServerBookTest.assertTrue((boolean)store.checkBook(123L));
    }

    @Test
    public void testBookExistsWebClientBooleanObject() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/check/123"));
        wc.accept(new String[]{"text/plain"});
        JAXRSClientServerBookTest.assertTrue((boolean)((Boolean)wc.get(Boolean.class)));
    }

    @Test
    public void testBookExistsMalformedMt() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/check/malformedmt/123"));
        wc.accept(new String[]{"text/plain"});
        WebClient.getConfig((Object)wc).getInInterceptors().add(new ReplaceContentTypeInterceptor());
        JAXRSClientServerBookTest.assertTrue((boolean)((Boolean)wc.get(Boolean.class)));
    }

    @Test
    public void testBookExists2() throws Exception {
        BookStore proxy = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        JAXRSClientServerBookTest.assertTrue((boolean)proxy.checkBook2(123L));
        JAXRSClientServerBookTest.assertFalse((boolean)proxy.checkBook2(125L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBook(String address, boolean expected) throws Exception {
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", "text/plain");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)get);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            if (expected) {
                JAXRSClientServerBookTest.assertEquals((String)"Book must be available", (Object)"true", (Object)get.getResponseBodyAsString());
            } else {
                JAXRSClientServerBookTest.assertEquals((String)"Book must not be available", (Object)"false", (Object)get.getResponseBodyAsString());
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    @Test
    public void testGetBookCustomExpression() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/custom/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetHeadBook123WebClient() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/getheadbook/";
        WebClient client = WebClient.create((String)address);
        Response r = client.head();
        JAXRSClientServerBookTest.assertEquals((Object)"HEAD_HEADER_VALUE", (Object)r.getMetadata().getFirst((Object)"HEAD_HEADER"));
    }

    @Test
    public void testGetHeadBook123WebClient2() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/getheadbook/";
        WebClient client = WebClient.create((String)address);
        Book b = (Book)client.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testGetBook123WithProxy() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Book b = bs.getBook("123");
        JAXRSClientServerBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testDeleteWithProxy() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Response r = bs.deleteBook("123");
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)r.getStatus());
    }

    @Test
    public void testCreatePutWithProxy() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Response r = bs.createBook(777L);
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)r.getStatus());
    }

    @Test
    public void testGetBookFromResponseWithProxyAndReader() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Response r = bs.getGenericResponseBook("123");
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)r.getStatus());
        Book book = (Book)r.readEntity(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testGetBookFromResponseWithProxy() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Response r = bs.getGenericResponseBook("123");
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)r.getStatus());
        Book book = (Book)r.readEntity(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testGetBookFromResponseWithWebClientAndReader() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/genericresponse/123";
        WebClient wc = WebClient.create((String)address);
        Response r = wc.accept(new String[]{"application/xml"}).get();
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)r.getStatus());
        Book book = (Book)r.readEntity(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testGetBookFromResponseWithWebClient() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/genericresponse/123";
        WebClient wc = WebClient.create((String)address);
        Response r = wc.accept(new String[]{"application/xml"}).get();
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)r.getStatus());
        Book book = (Book)r.readEntity(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testUpdateWithProxy() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        Book book = new Book();
        book.setId(888L);
        bs.updateBook(book);
        JAXRSClientServerBookTest.assertEquals((long)304L, (long)WebClient.client((Object)bs).getResponse().getStatus());
    }

    @Test
    public void testGetBookTypeAndWildcard() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml;q=0.8,*/*", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/123", "resources/expected_get_book123.txt", "application/*", "application/xml", 200);
    }

    @Test
    public void testSearchBook123() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/search" + "?_s=name==CXF*;id=ge=123;id=lt=124", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testSearchBook123WithWebClient() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/search";
        WebClient client = WebClient.create((String)address);
        Book b = (Book)client.query("_s", new Object[]{"name==CXF*;id=ge=123;id=lt=124"}).get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testGetSearchBookSQL() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/querycontext/id=ge=123";
        WebClient client = WebClient.create((String)address);
        client.accept(new String[]{"text/plain"});
        String sql = (String)client.get(String.class);
        JAXRSClientServerBookTest.assertEquals((Object)"SELECT * FROM books WHERE id >= '123'", (Object)sql);
    }

    @Test
    public void testGetBook123CGLIB() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/123/cglib", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookSimple222() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/simplebooks/222"));
        Book book = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)222L, (long)book.getId());
    }

    @Test
    public void testGetBookLowCaseHeader() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/booksecho3"));
        wc.type("text/plain").accept(new String[]{"text/plain"}).header("CustomHeader", new Object[]{"custom"});
        String name = (String)wc.post((Object)"book", String.class);
        JAXRSClientServerBookTest.assertEquals((Object)"book", (Object)name);
        JAXRSClientServerBookTest.assertEquals((Object)"custom", (Object)wc.getResponse().getHeaderString("CustomHeader"));
    }

    @Test
    public void testEchoBookName202() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/booksecho202"));
        wc.type("text/plain").accept(new String[]{"text/plain"});
        Response r = wc.post((Object)"book");
        JAXRSClientServerBookTest.assertEquals((long)202L, (long)r.getStatus());
        JAXRSClientServerBookTest.assertEquals((Object)"book", (Object)r.readEntity(String.class));
    }

    @Test
    public void testGetBookSimple() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/simplebooks/simple"));
        Book book = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)444L, (long)book.getId());
    }

    @Test(expected=ClientException.class)
    public void testEmptyJSON() {
        this.doTestEmptyResponse("application/json");
    }

    @Test(expected=ClientException.class)
    public void testEmptyJAXB() {
        this.doTestEmptyResponse("application/xml");
    }

    private void doTestEmptyResponse(String mt) {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/emptybook"));
        WebClient.getConfig((Object)wc).getInInterceptors().add(new ReplaceStatusInterceptor());
        wc.accept(new String[]{mt});
        wc.get(Book.class);
    }

    @Test(expected=ClientException.class)
    public void testEmptyResponseProxy() {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        WebClient.getConfig((Object)store).getInInterceptors().add(new ReplaceStatusInterceptor());
        store.getEmptyBook();
    }

    @Test
    public void testEmptyResponseProxyNullable() {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        WebClient.getConfig((Object)store).getInInterceptors().add(new ReplaceStatusInterceptor());
        JAXRSClientServerBookTest.assertNull((Object)store.getEmptyBookNullable());
    }

    @Test
    public void testDropJSONRootDynamically() {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/dropjsonroot"));
        wc.accept(new String[]{"application/json"});
        String response = (String)wc.get(String.class);
        JAXRSClientServerBookTest.assertEquals((Object)"{\"id\":123,\"name\":\"CXF in Action\"}", (Object)response);
    }

    @Test
    public void testFormattedJSON() {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/123"));
        wc.accept(new String[]{"application/json"});
        String response = (String)wc.get(String.class);
        JAXRSClientServerBookTest.assertTrue((boolean)response.startsWith("{"));
        JAXRSClientServerBookTest.assertTrue((boolean)response.endsWith("}"));
        JAXRSClientServerBookTest.assertTrue((boolean)response.contains("\"Book\":{"));
        JAXRSClientServerBookTest.assertTrue((response.indexOf("\"Book\":{") == 1 ? 1 : 0) != 0);
        wc.query("_format", new Object[]{""});
        response = (String)wc.get(String.class);
        JAXRSClientServerBookTest.assertTrue((boolean)response.startsWith("{"));
        JAXRSClientServerBookTest.assertTrue((boolean)response.endsWith("}"));
        JAXRSClientServerBookTest.assertTrue((boolean)response.contains("\"Book\":{"));
        JAXRSClientServerBookTest.assertFalse((response.indexOf("\"Book\":{") == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetBook123() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/query?bookId=123", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/defaultquery", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/missingquery", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/123", "resources/expected_get_book123json.txt", "application/json, application/xml;q=0.9", "application/json", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml, application/json", "application/xml", 200);
    }

    @Test
    public void testGetBookXmlWildcard() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/123", "resources/expected_get_book123.txt", "*/*", "application/xml", 200);
    }

    @Test
    public void testGetBookBuffer() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/buffer", "resources/expected_get_book123.txt", "application/bar", 200);
    }

    @Test
    public void testGetBookBySegment() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/segment/matrix2;first=12;second=3", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore;bar/segment;foo/" + "matrix2;first=12;second=3;third", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookByListOfSegments() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/segment/list/1/2/3", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookByMatrixParameters() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/segment/matrix;first=12;second=3", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore;bar;first=12/segment;foo;" + "second=3/matrix;third", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookByMatrixParametersInTheMiddle() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/segment;first=12;second=3/matrix-middle", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookByHeader() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/bookheaders", "resources/expected_get_book123.txt", "application/xml;q=0.5,text/xml", "text/xml", 200);
    }

    @Test
    public void testGetBookByHeaderPerRequest() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore2/bookheaders", "resources/expected_get_book123.txt", "application/xml;q=0.5,text/xml", "text/xml", 200);
    }

    @Test
    public void testGetBookByHeaderPerRequestInjected() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore2/bookheaders/injected";
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"application/xml"});
        wc.header("BOOK", new Object[]{"1", "2", "3"});
        Book b = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b.getId());
    }

    @Test
    public void testGetBookByHeaderPerRequestInjectedFault() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore2/bookheaders/injected";
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"application/xml"});
        wc.header("BOOK", new Object[]{"2", "3"});
        Response r = wc.get();
        JAXRSClientServerBookTest.assertEquals((long)400L, (long)r.getStatus());
        JAXRSClientServerBookTest.assertEquals((Object)"Param setter: 3 header values are required", (Object)r.readEntity(String.class));
    }

    @Test
    public void testGetBookByHeaderPerRequestConstructorFault() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore2/bookheaders";
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"application/xml"});
        wc.header("BOOK", new Object[]{"1", "2", "4"});
        Response r = wc.get();
        JAXRSClientServerBookTest.assertEquals((long)400L, (long)r.getStatus());
        JAXRSClientServerBookTest.assertEquals((Object)"Constructor: Header value 3 is required", (Object)r.readEntity(String.class));
    }

    @Test
    public void testGetBookByHeaderPerRequestContextFault() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore2/bookheaders";
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"application/xml"});
        wc.header("BOOK", new Object[]{"1", "3", "4"});
        Response r = wc.get();
        JAXRSClientServerBookTest.assertEquals((long)400L, (long)r.getStatus());
        JAXRSClientServerBookTest.assertEquals((Object)"Context setter: unexpected header value", (Object)r.readEntity(String.class));
    }

    @Test
    public void testGetBookByHeaderDefault() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/bookheaders2", "resources/expected_get_book123.txt", "application/xml;q=0.5,text/xml", "text/xml", 200);
    }

    @Test
    public void testGetBookElement() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/element", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testEchoBookElement() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        JAXBElement<Book> element = store.echoBookElement((JAXBElement<Book>)new JAXBElement(new QName("", "Book"), Book.class, (Object)new Book("CXF", 123L)));
        Book book = (Book)element.getValue();
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF", (Object)book.getName());
    }

    @Test
    public void testEchoBookElementWildcard() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        JAXBElement<? super Book> element = store.echoBookElementWildcard((JAXBElement<? extends Book>)new JAXBElement(new QName("", "Book"), Book.class, (Object)new Book("CXF", 123L)));
        Book book = (Book)element.getValue();
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF", (Object)book.getName());
    }

    @Test
    public void testGetBookAdapter() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/adapter", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testPostGetBookAdapterList() throws Exception {
        JAXBElementProvider provider = new JAXBElementProvider();
        HashMap<String, String> outMap = new HashMap<String, String>();
        outMap.put("Books", "CollectionWrapper");
        outMap.put("books", "Book");
        provider.setOutTransformElements(outMap);
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/adapter-list"), Collections.singletonList(provider));
        Collection books = wc.type("application/xml").accept(new String[]{"application/xml"}).postAndGetCollection((Object)new Books(new Book("CXF", 123L)), Book.class);
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)books.size());
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)((Book)books.iterator().next()).getId());
    }

    @Test
    public void testPostGetBookAdapterListJSON() throws Exception {
        JAXBElementProvider provider = new JAXBElementProvider();
        HashMap<String, String> outMap = new HashMap<String, String>();
        outMap.put("Books", "CollectionWrapper");
        outMap.put("books", "Book");
        provider.setOutTransformElements(outMap);
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/adapter-list"), Collections.singletonList(provider));
        Response r = wc.type("application/xml").accept(new String[]{"application/json"}).post((Object)new Books(new Book("CXF", 123L)));
        JAXRSClientServerBookTest.assertEquals((Object)"{\"Book\":[{\"id\":123,\"name\":\"CXF\"}]}", (Object)IOUtils.readStringFromStream((InputStream)((InputStream)r.getEntity())));
    }

    @Test
    public void testGetBookAdapterInterface() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/interface/adapter", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookAdapterInterfaceList() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        List<? extends BookStore.BookInfoInterface> list = store.getBookAdapterInterfaceList();
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)list.size());
        BookStore.BookInfoInterface info = list.get(0);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)info.getId());
    }

    @Test
    public void testGetBookAdapterInterfaceProxy() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        BookStore.BookInfoInterface info = store.getBookAdapterInterface();
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)info.getId());
    }

    @Test
    public void testGetBookAdapterInfoList() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        List<? extends BookStore.BookInfo> list = store.getBookAdapterList();
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)list.size());
        BookStore.BookInfo info = list.get(0);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)info.getId());
    }

    @Test
    public void testGetBookAdapterInfoProxy() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        BookStore.BookInfo info = store.getBookAdapter();
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)info.getId());
    }

    @Test
    public void testGetBook123FromSub() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/interface/subresource", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/books/123", "resources/expected_get_book123json.txt", "application/xml;q=0.1,application/json", "application/json", 200);
    }

    @Test
    public void testGetBook123FromSubObject() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/booksubresourceobject/123/chaptersobject/sub/1", "resources/expected_get_chapter1.txt", "application/xml", "application/xml;charset=ISO-8859-1", 200);
    }

    @Test
    public void testGetChapter() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/booksubresource/123/chapters/1", "resources/expected_get_chapter1.txt", "application/xml", "application/xml;charset=ISO-8859-1", 200);
    }

    @Test
    public void testGetBookWithResourceContext() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/booksubresource/context/rc";
        this.doTestGetBookWithResourceContext(address);
    }

    @Test
    public void testGetBookWithResourceContextBeanParam() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/booksubresource/context/rc/bean";
        this.doTestGetBookWithResourceContext(address);
    }

    @Test
    public void testGetBookWithResourceContextBeanParam2() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/booksubresource/context/rc/bean2";
        this.doTestGetBookWithResourceContext(address);
    }

    @Test
    public void testGetBookWithResourceContextInstance() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/booksubresource/instance/context/rc";
        this.doTestGetBookWithResourceContext(address);
    }

    private void doTestGetBookWithResourceContext(String address) throws Exception {
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"application/xml"});
        wc.query("bookid", new Object[]{"12345"});
        wc.query("bookname", new Object[]{"bookcontext"});
        Book2 book = (Book2)wc.get(Book2.class);
        JAXRSClientServerBookTest.assertEquals((long)12345L, (long)book.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"bookcontext", (Object)book.getName());
    }

    @Test
    public void testGetChapterEncodingDefault() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/booksubresource/123/chapters/badencoding/1", "resources/expected_get_chapter1_utf.txt", "application/xml", "application/xml;charset=UTF-8", 200);
    }

    @Test
    public void testGetChapterAcceptEncoding() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/booksubresource/123/chapters/acceptencoding/1", "resources/expected_get_chapter1.txt", "application/xml;charset=ISO-8859-1", "application/xml;charset=ISO-8859-1", 200);
    }

    @Test
    public void testGetChapterChapter() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/booksubresource/123/chapters/sub/1/recurse", "resources/expected_get_chapter1_utf.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/booksubresource/123/chapters/sub/1/recurse2", "resources/expected_get_chapter1.txt", "application/xml", "application/xml;charset=ISO-8859-1", 200);
    }

    @Test
    public void testGetChapterWithParentIds() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/booksubresource/123/chapters/sub/1/recurse2/ids", "resources/expected_get_chapter1.txt", "application/xml", "application/xml;charset=ISO-8859-1", 200);
    }

    @Test
    public void testGetBook123ReturnString() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/booknames/123", "resources/expected_get_book123_returnstring.txt", "text/plain", 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddBookNoBody() throws Exception {
        PostMethod post = new PostMethod("http://localhost:" + PORT + "/bookstore/books");
        post.setRequestHeader("Content-Type", "application/xml");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)400L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Test
    public void testAddBookEmptyContent() throws Exception {
        Response r = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books")).type("*/*").post(null);
        JAXRSClientServerBookTest.assertEquals((long)400L, (long)r.getStatus());
    }

    @Test
    public void testAddBookEmptyContentWithNullable() throws Exception {
        Book defaultBook = (Book)WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/null")).type("*/*").post(null, Book.class);
        JAXRSClientServerBookTest.assertEquals((Object)"Default Book", (Object)defaultBook.getName());
    }

    @Test
    public void testAddBook() throws Exception {
        this.doAddBook("http://localhost:" + PORT + "/bookstore/books");
    }

    @Test
    public void testAddBookXmlAdapter() throws Exception {
        this.doAddBook("http://localhost:" + PORT + "/bookstore/booksinfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddBook(String address) throws Exception {
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/add_book.txt").toURI());
        PostMethod post = new PostMethod(address);
        post.setRequestHeader("Content-Type", "application/xml");
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_add_book.txt");
            JAXRSClientServerBookTest.assertEquals((Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(expected)), (Object)this.stripXmlInstructionIfNeeded(post.getResponseBodyAsString()));
        }
        finally {
            post.releaseConnection();
        }
    }

    @Test
    public void testAddBookCustomFailureStatus() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books/customstatus";
        WebClient client = WebClient.create((String)endpointAddress);
        Book book = (Book)client.type("text/xml").accept(new String[]{"application/xml"}).post((Object)new Book(), Book.class);
        JAXRSClientServerBookTest.assertEquals((long)888L, (long)book.getId());
        Response r = client.getResponse();
        JAXRSClientServerBookTest.assertEquals((Object)"CustomValue", (Object)r.getMetadata().getFirst((Object)"CustomHeader"));
        JAXRSClientServerBookTest.assertEquals((long)233L, (long)r.getStatus());
        JAXRSClientServerBookTest.assertEquals((Object)"application/xml", (Object)r.getMetadata().getFirst((Object)"Content-Type"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateBook() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/update_book.txt").toURI());
        PutMethod put = new PutMethod(endpointAddress);
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        put.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)put);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_update_book.txt");
            JAXRSClientServerBookTest.assertEquals((Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(expected)), (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(put.getResponseBodyAsStream())));
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateBookWithDom() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/bookswithdom";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/update_book.txt").toURI());
        PutMethod put = new PutMethod(endpointAddress);
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        put.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)put);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            String resp = put.getResponseBodyAsString();
            InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/update_book.txt");
            String s = this.getStringFromInputStream(expected);
            JAXRSClientServerBookTest.assertTrue((resp.indexOf(s) >= 0 ? 1 : 0) != 0);
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateBookWithJSON() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/bookswithjson";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/update_book_json.txt").toURI());
        PutMethod put = new PutMethod(endpointAddress);
        FileRequestEntity entity = new FileRequestEntity(input, "application/json; charset=ISO-8859-1");
        put.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)put);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_update_book.txt");
            JAXRSClientServerBookTest.assertEquals((Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(expected)), (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(put.getResponseBodyAsStream())));
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateBookFailed() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/update_book_not_exist.txt").toURI());
        PutMethod post = new PutMethod(endpointAddress);
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)304L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Test
    public void testGetCDs() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/cds"));
        CDs cds = (CDs)wc.get(CDs.class);
        Collection<CD> collection = cds.getCD();
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)collection.size());
        JAXRSClientServerBookTest.assertTrue((boolean)collection.contains(new CD("BICYCLE RACE", 124L)));
        JAXRSClientServerBookTest.assertTrue((boolean)collection.contains(new CD("BOHEMIAN RHAPSODY", 123L)));
    }

    @Test
    public void testGetCDJSON() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/cd/123", "resources/expected_get_cdjson.txt", "application/json", 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPlainLong() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/booksplain";
        PostMethod post = new PostMethod(endpointAddress);
        post.addRequestHeader("Content-Type", "text/plain");
        post.addRequestHeader("Accept", "text/plain");
        post.setRequestBody("12345");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            JAXRSClientServerBookTest.assertEquals((Object)post.getResponseBodyAsString(), (Object)"12345");
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteBook() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books/123";
        DeleteMethod post = new DeleteMethod(endpointAddress);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteBookByQuery() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books/id?value=123";
        DeleteMethod post = new DeleteMethod(endpointAddress);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCDsJSON() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/cds";
        GetMethod get = new GetMethod(endpointAddress);
        get.addRequestHeader("Accept", "application/json");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)get);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            InputStream expected123 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_cdsjson123.txt");
            InputStream expected124 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_cdsjson124.txt");
            JAXRSClientServerBookTest.assertTrue((get.getResponseBodyAsString().indexOf(this.getStringFromInputStream(expected123)) >= 0 ? 1 : 0) != 0);
            JAXRSClientServerBookTest.assertTrue((get.getResponseBodyAsString().indexOf(this.getStringFromInputStream(expected124)) >= 0 ? 1 : 0) != 0);
        }
        finally {
            get.releaseConnection();
        }
    }

    @Test
    public void testGetCDXML() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/cd/123", "resources/expected_get_cd.txt", "application/xml", 200);
    }

    @Test
    public void testGetCDWithMultiContentTypesXML() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/cdwithmultitypes/123", "resources/expected_get_cd.txt", "application/json;q=0.8,application/xml,*/*", "application/xml", 200);
    }

    @Test
    public void testGetCDWithMultiContentTypesCustomXML() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/cdwithmultitypes/123", "resources/expected_get_cd.txt", "application/bar+xml", "application/bar+xml", 200);
    }

    @Test
    public void testGetCDWithMultiContentTypesJSON() throws Exception {
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/cdwithmultitypes/123", "resources/expected_get_cdjson.txt", "application/json", 200);
        this.getAndCompareAsStrings("http://localhost:" + PORT + "/bookstore/cdwithmultitypes/123", "resources/expected_get_cdjson.txt", "*/*,application/xml;q=0.9,application/json", "application/json", 200);
    }

    @Test
    public void testUriInfoMatchedResources() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/" + "booksubresource/123/chapters/sub/1/matched-resources", "[class org.apache.cxf.systest.jaxrs.Chapter, class org.apache.cxf.systest.jaxrs.Book, class org.apache.cxf.systest.jaxrs.BookStore]", "text/plain", "text/plain", 200);
    }

    @Test
    public void testUriInfoMatchedResourcesWithObject() throws Exception {
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/" + "booksubresource/123/chaptersobject/sub/1/matched-resources", "[class org.apache.cxf.systest.jaxrs.Chapter, class org.apache.cxf.systest.jaxrs.Book, class org.apache.cxf.systest.jaxrs.BookStore]", "text/plain", "text/plain", 200);
    }

    @Test
    public void testUriInfoMatchedUrisDecode() throws Exception {
        String expected = "[/bookstore/booksubresource/123/chapters/sub/1/matched!uris, /bookstore/booksubresource/123/chapters/sub/1/, /bookstore/booksubresource/123/]";
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/" + "booksubresource/123/chapters/sub/1/matched%21uris?decode=true", expected, "text/plain", "text/plain", 200);
    }

    @Test
    public void testUriInfoMatchedUrisNoDecode() throws Exception {
        String expected = "[/bookstore/booksubresource/123/chapters/sub/1/matched%21uris, /bookstore/booksubresource/123/chapters/sub/1/, /bookstore/booksubresource/123/]";
        this.getAndCompare("http://localhost:" + PORT + "/bookstore/" + "booksubresource/123/chapters/sub/1/matched%21uris?decode=false", expected, "text/plain", "text/plain", 200);
    }

    @Test
    public void testQuotedHeaders() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/quotedheaders";
        WebClient wc = WebClient.create((String)endpointAddress);
        WebClient.getConfig((Object)wc).getRequestContext().put("org.apache.cxf.http.header.split", true);
        Response r = wc.get();
        List header1 = (List)r.getMetadata().get((Object)"SomeHeader1");
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)header1.size());
        JAXRSClientServerBookTest.assertEquals((Object)"\"some text, some more text\"", header1.get(0));
        List header2 = (List)r.getMetadata().get((Object)"SomeHeader2");
        JAXRSClientServerBookTest.assertEquals((long)3L, (long)header2.size());
        JAXRSClientServerBookTest.assertEquals((Object)"\"some text\"", header2.get(0));
        JAXRSClientServerBookTest.assertEquals((Object)"\"quoted,text\"", header2.get(1));
        JAXRSClientServerBookTest.assertEquals((Object)"\"even more text\"", header2.get(2));
        List header3 = (List)r.getMetadata().get((Object)"SomeHeader3");
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)header3.size());
        JAXRSClientServerBookTest.assertEquals((Object)"\"some text, some more text with inlined \"\"", header3.get(0));
        List header4 = (List)r.getMetadata().get((Object)"SomeHeader4");
        JAXRSClientServerBookTest.assertEquals((long)1L, (long)header4.size());
        JAXRSClientServerBookTest.assertEquals((Object)"\"\"", header4.get(0));
    }

    @Test
    public void testBadlyQuotedHeaders() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/badlyquotedheaders";
        String[] responses = new String[]{"\"some text", "\"some text, some more text with inlined \"", "\"some te\\"};
        for (int i = 0; i < 3; ++i) {
            WebClient wc = WebClient.create((String)endpointAddress);
            WebClient.getConfig((Object)wc).getRequestContext().put("org.apache.cxf.http.header.split", true);
            Response r = wc.query("type", new Object[]{Integer.toString(i)}).get();
            JAXRSClientServerBookTest.assertEquals((Object)responses[i], ((List)r.getMetadata().get((Object)("SomeHeader" + i))).get(0));
        }
        WebClient wc = WebClient.create((String)endpointAddress);
        WebClient.getConfig((Object)wc).getRequestContext().put("org.apache.cxf.http.header.split", true);
        Response r3 = wc.query("type", new Object[]{"3"}).get();
        List r3values = (List)r3.getMetadata().get((Object)"SomeHeader3");
        JAXRSClientServerBookTest.assertEquals((long)4L, (long)r3values.size());
        JAXRSClientServerBookTest.assertEquals((Object)"some text", r3values.get(0));
        JAXRSClientServerBookTest.assertEquals((Object)"\"other quoted\"", r3values.get(1));
        JAXRSClientServerBookTest.assertEquals((Object)"text", r3values.get(2));
        JAXRSClientServerBookTest.assertEquals((Object)"blah", r3values.get(3));
    }

    private void getAndCompareAsStrings(String address, String resourcePath, String acceptType, int status) throws Exception {
        String expected = this.getStringFromInputStream(((Object)((Object)this)).getClass().getResourceAsStream(resourcePath));
        this.getAndCompare(address, expected, acceptType, acceptType, status);
    }

    private void getAndCompareAsStrings(String address, String resourcePath, String acceptType, String expectedContentType, int status) throws Exception {
        String expected = this.getStringFromInputStream(((Object)((Object)this)).getClass().getResourceAsStream(resourcePath));
        this.getAndCompare(address, expected, acceptType, expectedContentType, status);
    }

    private void getAndCompare(String address, String expectedValue, String acceptType, int expectedStatus) throws Exception {
        this.getAndCompare(address, expectedValue, acceptType, null, expectedStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndCompare(String address, String expectedValue, String acceptType, String expectedContentType, int expectedStatus) throws Exception {
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", acceptType);
        get.addRequestHeader("Cookie", "a=b;c=d");
        get.addRequestHeader("Cookie", "e=f");
        get.setRequestHeader("Accept-Language", "da;q=0.8,en");
        get.setRequestHeader("Book", "1,2,3");
        HttpClient httpClient = new HttpClient();
        try {
            int result = httpClient.executeMethod((HttpMethod)get);
            JAXRSClientServerBookTest.assertEquals((long)expectedStatus, (long)result);
            String content = this.getStringFromInputStream(get.getResponseBodyAsStream());
            JAXRSClientServerBookTest.assertEquals((String)"Expected value is wrong", (Object)this.stripXmlInstructionIfNeeded(expectedValue), (Object)this.stripXmlInstructionIfNeeded(content));
            if (expectedStatus == 200) {
                JAXRSClientServerBookTest.assertEquals((Object)"123", (Object)get.getResponseHeader("BookId").getValue());
                JAXRSClientServerBookTest.assertNotNull((Object)get.getResponseHeader("Date"));
            }
            if (expectedStatus == 405) {
                JAXRSClientServerBookTest.assertNotNull((Object)get.getResponseHeader("Allow"));
            }
            if (expectedContentType != null) {
                Header ct = get.getResponseHeader("Content-Type");
                JAXRSClientServerBookTest.assertEquals((String)"Wrong type of response", (Object)expectedContentType, (Object)ct.getValue());
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    private String stripXmlInstructionIfNeeded(String str) {
        if (str != null && str.startsWith("<?xml")) {
            int index = str.indexOf("?>");
            str = str.substring(index + 2);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndCompareStrings(String address, String[] expectedValue, String acceptType, int expectedStatus) throws Exception {
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)expectedValue.length);
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", acceptType);
        HttpClient httpClient = new HttpClient();
        try {
            int result = httpClient.executeMethod((HttpMethod)get);
            JAXRSClientServerBookTest.assertEquals((long)expectedStatus, (long)result);
            String jsonContent = this.getStringFromInputStream(get.getResponseBodyAsStream());
            JAXRSClientServerBookTest.assertTrue((String)"Expected value is wrong", (expectedValue[0].equals(jsonContent) || expectedValue[1].equals(jsonContent) ? 1 : 0) != 0);
        }
        finally {
            get.releaseConnection();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        String str = new String(bos.getBytes());
        in.close();
        bos.close();
        return str;
    }

    public static class NotFoundExceptionMapper
    implements ResponseExceptionMapper<BookNotFoundFault> {
        public BookNotFoundFault fromResponse(Response r) {
            String status = r.getHeaderString("Status");
            if ("notFound".equals(status)) {
                return new BookNotFoundFault(status);
            }
            return null;
        }
    }

    public static class NotReturnedExceptionMapper
    implements ResponseExceptionMapper<BookStore.BookNotReturnedException> {
        public BookStore.BookNotReturnedException fromResponse(Response r) {
            String status = r.getHeaderString("Status");
            if ("notReturned".equals(status)) {
                return new BookStore.BookNotReturnedException(status);
            }
            return null;
        }
    }

    public static class ReplaceStatusInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public ReplaceStatusInterceptor() {
            super("read");
        }

        public void handleMessage(Message message) throws Fault {
            message.getExchange().put((Object)Message.RESPONSE_CODE, (Object)200);
        }
    }

    public static class ReplaceContentTypeInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public ReplaceContentTypeInterceptor() {
            super("read");
        }

        public void handleMessage(Message message) throws Fault {
            Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
            headers.put("Content-Type", Collections.singletonList("text/plain"));
        }
    }
}

