/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.systest.jaxrs.BookServerResourceCreatedSpringProviders;
import org.apache.cxf.systest.jaxrs.PetStore;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JAXRSClientServerResourceCreatedSpringProviderTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServerResourceCreatedSpringProviders.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        AbstractResourceInfo.clearAllMaps();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerResourceCreatedSpringProviderTest.launchServer(BookServerResourceCreatedSpringProviders.class, (boolean)true));
        JAXRSClientServerResourceCreatedSpringProviderTest.createStaticBus();
    }

    @Test
    public void testBasePetStoreWithoutTrailingSlash() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/pets";
        WebClient client = WebClient.create((String)endpointAddress);
        HTTPConduit conduit = WebClient.getConfig((Object)client).getHttpConduit();
        conduit.getClient().setReceiveTimeout(1000000L);
        conduit.getClient().setConnectionTimeout(1000000L);
        String value = (String)client.accept(new String[]{"text/plain"}).get(String.class);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"The Pet Store is closed", (Object)value);
    }

    @Test
    public void testBasePetStore() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/pets/";
        WebClient client = WebClient.create((String)endpointAddress);
        HTTPConduit conduit = WebClient.getConfig((Object)client).getHttpConduit();
        conduit.getClient().setReceiveTimeout(1000000L);
        conduit.getClient().setConnectionTimeout(1000000L);
        String value = (String)client.accept(new String[]{"text/plain"}).get(String.class);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"The Pet Store is closed", (Object)value);
    }

    @Test
    public void testMultipleRootsWadl() throws Exception {
        List<Element> resourceEls = this.getWadlResourcesInfo("http://localhost:" + PORT + "/webapp/resources", "http://localhost:" + PORT + "/webapp/resources", 2);
        String path1 = resourceEls.get(0).getAttribute("path");
        int bookStoreInd = path1.contains("/bookstore") ? 0 : 1;
        int petStoreInd = bookStoreInd == 0 ? 1 : 0;
        this.checkBookStoreInfo(resourceEls.get(bookStoreInd));
        this.checkServletInfo(resourceEls.get(petStoreInd));
    }

    @Test
    public void testBookStoreWadl() throws Exception {
        List<Element> resourceEls = this.getWadlResourcesInfo("http://localhost:" + PORT + "/webapp/resources", "http://localhost:" + PORT + "/webapp/resources/bookstore", 1);
        this.checkBookStoreInfo(resourceEls.get(0));
    }

    @Test
    public void testPetStoreWadl() throws Exception {
        List<Element> resourceEls = this.getWadlResourcesInfo("http://localhost:" + PORT + "/webapp/pets", "http://localhost:" + PORT + "/webapp/pets/", 1);
        this.checkPetStoreInfo(resourceEls.get(0));
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Element)((Element)resourceEls.get(0).getParentNode().getParentNode()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StaxUtils.copy((XMLStreamReader)reader, (OutputStream)bos);
        String s = bos.toString();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)s.contains("<xs:element name=\"elstatus\" type=\"petStoreStatusElement\"/>"));
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)s.contains("<xs:element name=\"status\" type=\"status\"/>"));
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)s.contains("<xs:element name=\"statusType\" type=\"statusType\"/>"));
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)s.contains("<xs:element name=\"statusImpl1\" substitutionGroup=\"statusType\" type=\"petStoreStatusImpl1\"/>"));
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)s.contains("<xs:element name=\"statusImpl2\" substitutionGroup=\"statusType\" type=\"petStoreStatusImpl2\"/>"));
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)s.contains("<xs:element name=\"statuses\""));
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)s.contains("element=\"prefix1:status\""));
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)s.contains("element=\"prefix1:elstatus\""));
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)s.contains("element=\"prefix1:statuses\""));
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((boolean)s.contains("element=\"prefix1:statusType\""));
    }

    @Test
    public void testWadlPublishedEndpointUrl() throws Exception {
        String requestURI = "http://localhost:" + PORT + "/webapp/resources2";
        WebClient client = WebClient.create((String)(requestURI + "?_wadl&_type=xml"));
        Document doc = StaxUtils.read((Reader)new InputStreamReader((InputStream)client.get(InputStream.class), "UTF-8"));
        Element root = doc.getDocumentElement();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"http://wadl.dev.java.net/2009/02", (Object)root.getNamespaceURI());
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"application", (Object)root.getLocalName());
        List resourcesEls = DOMUtils.getChildrenWithName((Element)root, (String)"http://wadl.dev.java.net/2009/02", (String)"resources");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)1L, (long)resourcesEls.size());
        Element resourcesEl = (Element)resourcesEls.get(0);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"http://proxy", (Object)resourcesEl.getAttribute("base"));
    }

    private void checkBookStoreInfo(Element resource) {
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"/bookstore", (Object)resource.getAttribute("path"));
    }

    private void checkServletInfo(Element resource) {
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"/servlet", (Object)resource.getAttribute("path"));
    }

    private void checkPetStoreInfo(Element resource) {
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"/", (Object)resource.getAttribute("path"));
    }

    private List<Element> getWadlResourcesInfo(String baseURI, String requestURI, int size) throws Exception {
        WebClient client = WebClient.create((String)(requestURI + "?_wadl&_type=xml"));
        Document doc = StaxUtils.read((Reader)new InputStreamReader((InputStream)client.get(InputStream.class), "UTF-8"));
        Element root = doc.getDocumentElement();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"http://wadl.dev.java.net/2009/02", (Object)root.getNamespaceURI());
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"application", (Object)root.getLocalName());
        List resourcesEls = DOMUtils.getChildrenWithName((Element)root, (String)"http://wadl.dev.java.net/2009/02", (String)"resources");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)1L, (long)resourcesEls.size());
        Element resourcesEl = (Element)resourcesEls.get(0);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)baseURI, (Object)resourcesEl.getAttribute("base"));
        List resourceEls = DOMUtils.getChildrenWithName((Element)resourcesEl, (String)"http://wadl.dev.java.net/2009/02", (String)"resource");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)size, (long)resourceEls.size());
        return resourceEls;
    }

    @Test
    public void testServletConfigInitParam() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/resources/servlet/config/a";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"text/plain"});
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"avalue", (Object)wc.get(String.class));
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/resources/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        connect.addRequestProperty("Content-Language", "badgerFishLanguage");
        InputStream in = connect.getInputStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123badgerfish.txt");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"BadgerFish output not correct", (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(expected).trim()), (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(in).trim()));
    }

    private String stripXmlInstructionIfNeeded(String str) {
        if (str != null && str.startsWith("<?xml")) {
            int index = str.indexOf("?>");
            str = str.substring(index + 2);
        }
        return str;
    }

    @Test
    public void testGetBookNotFound() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/resources/bookstore/books/12345";
        URL url = new URL(endpointAddress);
        HttpURLConnection connect = (HttpURLConnection)url.openConnection();
        connect.addRequestProperty("Accept", "text/plain,application/xml");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)500L, (long)connect.getResponseCode());
        InputStream in = connect.getErrorStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book_notfound_mapped.txt");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Exception is not mapped correctly", (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(expected).trim()), (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(in).trim()));
    }

    @Test
    public void testGetBookNotExistent() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/resources/bookstore/nonexistent";
        URL url = new URL(endpointAddress);
        HttpURLConnection connect = (HttpURLConnection)url.openConnection();
        connect.addRequestProperty("Accept", "application/xml");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)405L, (long)connect.getResponseCode());
        InputStream in = connect.getErrorStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Exception is not mapped correctly", (Object)"StringTextWriter - Nonexistent method", (Object)this.getStringFromInputStream(in).trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostPetStatus() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/pets/petstore/pets";
        URL url = new URL(endpointAddress);
        HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
        httpUrlConnection.setUseCaches(false);
        httpUrlConnection.setDefaultUseCaches(false);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Accept", "text/xml");
        httpUrlConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        httpUrlConnection.setRequestProperty("Connection", "close");
        OutputStream outputstream = httpUrlConnection.getOutputStream();
        File inputFile = new File(((Object)((Object)this)).getClass().getResource("resources/singleValPostBody.txt").toURI());
        byte[] tmp = new byte[4096];
        int i = 0;
        FileInputStream is = new FileInputStream(inputFile);
        try {
            while ((i = ((InputStream)is).read(tmp)) >= 0) {
                outputstream.write(tmp, 0, i);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        outputstream.flush();
        int responseCode = httpUrlConnection.getResponseCode();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)200L, (long)responseCode);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Wrong status returned", (Object)"open", (Object)this.getStringFromInputStream(httpUrlConnection.getInputStream()));
        httpUrlConnection.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostPetStatus2() throws Exception {
        Socket s = new Socket("localhost", Integer.parseInt(PORT));
        IOUtils.copyAndCloseInput((InputStream)((Object)((Object)this)).getClass().getResource("resources/formRequest.txt").openStream(), (OutputStream)s.getOutputStream());
        s.getOutputStream().flush();
        try {
            JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((String)"Wrong status returned", (boolean)this.getStringFromInputStream(s.getInputStream()).contains("open"));
        }
        finally {
            s.close();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        return IOUtils.toString((InputStream)in);
    }

    @Test
    public void testPostPetStatusType() throws Exception {
        JAXBElementProvider p = new JAXBElementProvider();
        p.setUnmarshallAsJaxbElement(true);
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/webapp/pets/petstore/jaxb/statusType/"), Collections.singletonList(p));
        WebClient.getConfig((Object)wc).getInInterceptors().add(new LoggingInInterceptor());
        wc.accept(new String[]{"text/xml"});
        PetStore.PetStoreStatusType type = (PetStore.PetStoreStatusType)wc.get(PetStore.PetStoreStatusType.class);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"The Pet Store is closed", (Object)type.getStatus());
    }
}

