/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors.charset;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.processors.charset.BitsCharset;
import org.apache.daffodil.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.processors.charset.BitsCharsetEncoder;
import org.apache.daffodil.processors.charset.BitsCharsetNonByteSize;
import org.apache.daffodil.processors.charset.DecoderInfo;
import org.apache.daffodil.processors.charset.EncoderInfo;
import org.apache.daffodil.util.MaybeInt;
import org.apache.daffodil.util.MaybeInt$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i4qa\u0003\u0007\u0011\u0002\u0007\u0005q\u0003C\u0003%\u0001\u0011\u0005Q\u0005\u0003\u0005*\u0001!\u0015\r\u0011\"\u0003+\u0011!Q\u0004\u0001#b\u0001\n\u0013Y\u0004\"\u0002!\u0001\t\u0013\t\u0005\"\u0002(\u0001\t\u0003y\u0005\"\u0002+\u0001\t\u0003)\u0006\"B,\u0001\t\u0003A\u0006\"B/\u0001\t\u0003q\u0006\"\u00021\u0001\t\u000b\t\u0007\"\u0002;\u0001\t\u000b)(aE#oG>$WM\u001d#fG>$WM]'jq&t'BA\u0007\u000f\u0003\u001d\u0019\u0007.\u0019:tKRT!a\u0004\t\u0002\u0015A\u0014xnY3tg>\u00148O\u0003\u0002\u0012%\u0005AA-\u00194g_\u0012LGN\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 E5\t\u0001E\u0003\u0002\"!\u0005\u0011\u0011n\\\u0005\u0003G\u0001\u0012\u0001\u0003T8dC2\u0014UO\u001a4fe6K\u00070\u001b8\u0002\r\u0011Jg.\u001b;%)\u00051\u0003CA\r(\u0013\tA#D\u0001\u0003V]&$\u0018\u0001\u00043fG>$WM]\"bG\",W#A\u0016\u0011\t1\n4gN\u0007\u0002[)\u0011afL\u0001\u0005kRLGNC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#a\u0002%bg\"l\u0015\r\u001d\t\u0003iUj\u0011\u0001D\u0005\u0003m1\u00111BQ5ug\u000eC\u0017M]:fiB\u0011A\u0007O\u0005\u0003s1\u00111\u0002R3d_\u0012,'/\u00138g_\u0006aQM\\2pI\u0016\u00148)Y2iKV\tA\b\u0005\u0003-cMj\u0004C\u0001\u001b?\u0013\tyDBA\u0006F]\u000e|G-\u001a:J]\u001a|\u0017a\u00033fe&4\u0018\r^5p]N$\"AQ'\u0011\te\u0019U\tS\u0005\u0003\tj\u0011a\u0001V;qY\u0016\u0014\u0004CA\rG\u0013\t9%DA\u0002J]R\u0004\"!S&\u000e\u0003)S!A\f\t\n\u00051S%\u0001C'bs\n,\u0017J\u001c;\t\u000b5!\u0001\u0019A\u001a\u0002\u0015\u001d,G\u000fR3d_\u0012,'\u000f\u0006\u0002Q'B\u0011A'U\u0005\u0003%2\u0011!CQ5ug\u000eC\u0017M]:fi\u0012+7m\u001c3fe\")Q\"\u0002a\u0001g\u0005qq-\u001a;EK\u000e|G-\u001a:J]\u001a|GCA\u001cW\u0011\u0015ia\u00011\u00014\u0003)9W\r^#oG>$WM\u001d\u000b\u00033r\u0003\"\u0001\u000e.\n\u0005mc!A\u0005\"jiN\u001c\u0005.\u0019:tKR,enY8eKJDQ!D\u0004A\u0002M\nabZ3u\u000b:\u001cw\u000eZ3s\u0013:4w\u000e\u0006\u0002>?\")Q\u0002\u0003a\u0001g\u0005aA.\u001a8hi\"LeNQ5ugR\u0019!-\u001a:\u0011\u0005e\u0019\u0017B\u00013\u001b\u0005\u0011auN\\4\t\u000b\u0019L\u0001\u0019A4\u0002\u0007M$(\u000f\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003Uji\u0011a\u001b\u0006\u0003YZ\ta\u0001\u0010:p_Rt\u0014B\u00018\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059T\u0002\"B:\n\u0001\u0004\u0019\u0014a\u00032jiN\u001c\u0005.\u0019:tKR\fa\u0002\u001e:v]\u000e\fG/\u001a+p\u0005&$8\u000f\u0006\u0003hm^D\b\"\u00024\u000b\u0001\u00049\u0007\"B:\u000b\u0001\u0004\u0019\u0004\"B=\u000b\u0001\u0004\u0011\u0017!\u00028CSR\u001c\b")
public interface EncoderDecoderMixin
extends LocalBufferMixin {
    public static /* synthetic */ HashMap org$apache$daffodil$processors$charset$EncoderDecoderMixin$$decoderCache$(EncoderDecoderMixin $this) {
        return $this.org$apache$daffodil$processors$charset$EncoderDecoderMixin$$decoderCache();
    }

    default public HashMap<BitsCharset, DecoderInfo> org$apache$daffodil$processors$charset$EncoderDecoderMixin$$decoderCache() {
        return new HashMap<BitsCharset, DecoderInfo>();
    }

    public static /* synthetic */ HashMap org$apache$daffodil$processors$charset$EncoderDecoderMixin$$encoderCache$(EncoderDecoderMixin $this) {
        return $this.org$apache$daffodil$processors$charset$EncoderDecoderMixin$$encoderCache();
    }

    default public HashMap<BitsCharset, EncoderInfo> org$apache$daffodil$processors$charset$EncoderDecoderMixin$$encoderCache() {
        return new HashMap<BitsCharset, EncoderInfo>();
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, MaybeInt> derivations(BitsCharset charset) {
        void var3_12;
        Tuple2 tuple2;
        BitsCharset bitsCharset = charset;
        if (bitsCharset instanceof BitsCharsetNonByteSize) {
            BitsCharsetNonByteSize bitsCharsetNonByteSize = (BitsCharsetNonByteSize)bitsCharset;
            int encodingMandatoryAlignmentInBits = 1;
            long maybeCharWidthInBits = MaybeInt$.MODULE$.apply(bitsCharsetNonByteSize.bitWidthOfACodeUnit());
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
        } else {
            Tuple2 tuple22;
            int encodingMandatoryAlignmentInBits = 8;
            BitsCharsetEncoder encoder = charset.newEncoder();
            float maxBytes = encoder.maxBytesPerChar();
            if (maxBytes == encoder.averageBytesPerChar()) {
                long maybeCharWidthInBits = MaybeInt$.MODULE$.apply((int)(maxBytes * (float)8));
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            } else {
                long maybeCharWidthInBits = MaybeInt$.MODULE$.Nope();
                tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            }
            tuple2 = tuple22;
        }
        Tuple2 tuple = tuple2;
        return var3_12;
    }

    public static /* synthetic */ BitsCharsetDecoder getDecoder$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getDecoder(charset);
    }

    default public BitsCharsetDecoder getDecoder(BitsCharset charset) {
        return this.getDecoderInfo(charset).coder();
    }

    public static /* synthetic */ DecoderInfo getDecoderInfo$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getDecoderInfo(charset);
    }

    /*
     * WARNING - void declaration
     */
    default public DecoderInfo getDecoderInfo(BitsCharset charset) {
        void var3_2;
        Object object;
        DecoderInfo entry = this.org$apache$daffodil$processors$charset$EncoderDecoderMixin$$decoderCache().get(charset);
        if (entry == null) {
            BitsCharsetDecoder coder = charset.newDecoder();
            Tuple2<Object, MaybeInt> tuple2 = this.derivations(charset);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int encodingMandatoryAlignmentInBits = tuple2._1$mcI$sp();
            long maybeCharWidthInBits = ((MaybeInt)tuple2._2()).__v();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            Tuple2 tuple23 = tuple22;
            int encodingMandatoryAlignmentInBits2 = tuple23._1$mcI$sp();
            long maybeCharWidthInBits2 = ((MaybeInt)tuple23._2()).__v();
            entry = new DecoderInfo(coder, encodingMandatoryAlignmentInBits2, maybeCharWidthInBits2);
            object = this.org$apache$daffodil$processors$charset$EncoderDecoderMixin$$decoderCache().put(charset, entry);
        } else {
            object = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    public static /* synthetic */ BitsCharsetEncoder getEncoder$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getEncoder(charset);
    }

    default public BitsCharsetEncoder getEncoder(BitsCharset charset) {
        return this.getEncoderInfo(charset).coder();
    }

    public static /* synthetic */ EncoderInfo getEncoderInfo$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getEncoderInfo(charset);
    }

    /*
     * WARNING - void declaration
     */
    default public EncoderInfo getEncoderInfo(BitsCharset charset) {
        void var3_2;
        Object object;
        EncoderInfo entry = this.org$apache$daffodil$processors$charset$EncoderDecoderMixin$$encoderCache().get(charset);
        if (entry == null) {
            BitsCharsetEncoder coder = charset.newEncoder();
            BitsCharsetEncoder replacingCoder = charset.newEncoder();
            BitsCharsetEncoder reportingCoder = charset.newEncoder();
            replacingCoder.onMalformedInput(CodingErrorAction.REPLACE);
            replacingCoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            reportingCoder.onMalformedInput(CodingErrorAction.REPORT);
            reportingCoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            Tuple2<Object, MaybeInt> tuple2 = this.derivations(charset);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int encodingMandatoryAlignmentInBits = tuple2._1$mcI$sp();
            long maybeCharWidthInBits = ((MaybeInt)tuple2._2()).__v();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            Tuple2 tuple23 = tuple22;
            int encodingMandatoryAlignmentInBits2 = tuple23._1$mcI$sp();
            long maybeCharWidthInBits2 = ((MaybeInt)tuple23._2()).__v();
            entry = new EncoderInfo(coder, replacingCoder, reportingCoder, encodingMandatoryAlignmentInBits2, maybeCharWidthInBits2);
            object = this.org$apache$daffodil$processors$charset$EncoderDecoderMixin$$encoderCache().put(charset, entry);
        } else {
            object = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    public static /* synthetic */ long lengthInBits$(EncoderDecoderMixin $this, String str, BitsCharset bitsCharset) {
        return $this.lengthInBits(str, bitsCharset);
    }

    default public long lengthInBits(String str, BitsCharset bitsCharset) {
        long l;
        if (str.length() == 0) {
            return 0L;
        }
        long mew = bitsCharset.maybeFixedWidth();
        if (MaybeInt$.MODULE$.isDefined$extension(mew)) {
            int w = MaybeInt$.MODULE$.get$extension(mew);
            l = w * str.length();
        } else {
            l = BoxesRunTime.unboxToLong((Object)this.withLocalByteBuffer().apply((Function1 & Serializable & scala.Serializable)lbb -> BoxesRunTime.boxToLong((long)EncoderDecoderMixin.$anonfun$lengthInBits$1(this, str, bitsCharset, lbb))));
        }
        return l;
    }

    public static /* synthetic */ String truncateToBits$(EncoderDecoderMixin $this, String str, BitsCharset bitsCharset, long nBits) {
        return $this.truncateToBits(str, bitsCharset, nBits);
    }

    default public String truncateToBits(String str, BitsCharset bitsCharset, long nBits) {
        int w;
        long nChars;
        if (nBits < 0L) {
            throw Assert$.MODULE$.abort("Usage error: nBits.>=(0)");
        }
        if (str.length() == 0) {
            return str;
        }
        if (nBits == 0L) {
            return "";
        }
        long mew = bitsCharset.maybeFixedWidth();
        return MaybeInt$.MODULE$.isDefined$extension(mew) ? ((nChars = nBits / (long)(w = MaybeInt$.MODULE$.get$extension(mew))) > (long)str.length() ? str : str.substring(0, (int)nChars)) : (String)this.withLocalByteBuffer().apply((Function1 & Serializable & scala.Serializable)lbb -> {
            long nBytes = nBits / 8L;
            ByteBuffer bb = (ByteBuffer)lbb.getBuf(nBytes);
            return (String)this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)cbb -> {
                String string;
                CoderResult cr;
                CharBuffer cb = (CharBuffer)cbb.getBuf(str.length());
                cb.append(str);
                cb.flip();
                BitsCharsetEncoder encoder = this.getEncoder(bitsCharset);
                encoder.reset();
                CoderResult coderResult = cr = encoder.encode(cb, bb, true);
                CoderResult coderResult2 = CoderResult.UNDERFLOW;
                CoderResult coderResult3 = coderResult;
                if (!(coderResult2 != null ? !coderResult2.equals(coderResult3) : coderResult3 != null)) {
                    string = str;
                } else {
                    CoderResult coderResult4 = CoderResult.OVERFLOW;
                    CoderResult coderResult5 = coderResult;
                    if (!(coderResult4 != null ? !coderResult4.equals(coderResult5) : coderResult5 != null)) {
                        String truncString;
                        cb.flip();
                        string = truncString = cb.toString();
                    } else if (cr.isMalformed()) {
                        cr.throwException();
                        string = "";
                    } else if (cr.isUnmappable()) {
                        cr.throwException();
                        string = "";
                    } else {
                        throw new MatchError((Object)coderResult);
                    }
                }
                String truncString = string;
                return truncString;
            });
        });
    }

    public static /* synthetic */ long $anonfun$lengthInBits$2(EncoderDecoderMixin $this, String str$1, BitsCharset bitsCharset$1, LocalBufferMixin.LocalByteBuffer lbb$1, LocalBufferMixin.LocalCharBuffer cbb) {
        CoderResult cr;
        CharBuffer cb = (CharBuffer)cbb.getBuf(str$1.length());
        cb.append(str$1);
        cb.flip();
        BitsCharsetEncoder encoder = $this.getEncoder(bitsCharset$1);
        encoder.reset();
        long nBytes = (long)package$.MODULE$.ceil((double)((float)str$1.length() * encoder.maxBytesPerChar()));
        ByteBuffer bb = (ByteBuffer)lbb$1.getBuf(nBytes);
        CoderResult coderResult = cr = encoder.encode(cb, bb, true);
        CoderResult coderResult2 = CoderResult.UNDERFLOW;
        CoderResult coderResult3 = coderResult;
        if (!(coderResult2 != null ? !coderResult2.equals(coderResult3) : coderResult3 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            CoderResult coderResult4 = CoderResult.OVERFLOW;
            CoderResult coderResult5 = coderResult;
            if (!(coderResult4 != null ? !coderResult4.equals(coderResult5) : coderResult5 != null)) {
                throw Assert$.MODULE$.invariantFailed("byte buffer wasn't big enough to accomodate the string");
            }
            if (cr.isMalformed()) {
                cr.throwException();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (cr.isUnmappable()) {
                cr.throwException();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)coderResult);
            }
        }
        bb.flip();
        int lengthInBytes = bb.remaining();
        return lengthInBytes * 8;
    }

    public static /* synthetic */ long $anonfun$lengthInBits$1(EncoderDecoderMixin $this, String str$1, BitsCharset bitsCharset$1, LocalBufferMixin.LocalByteBuffer lbb) {
        return BoxesRunTime.unboxToLong((Object)$this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)cbb -> BoxesRunTime.boxToLong((long)EncoderDecoderMixin.$anonfun$lengthInBits$2($this, str$1, bitsCharset$1, lbb, cbb))));
    }

    public static void $init$(EncoderDecoderMixin $this) {
    }
}

