/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.io.RegexLimitingStream;

public final class BoundaryMarkLimitingStream$ {
    public static BoundaryMarkLimitingStream$ MODULE$;

    static {
        new BoundaryMarkLimitingStream$();
    }

    public RegexLimitingStream apply(InputStream inputStream, String boundaryMark, Charset charset, int targetChunkSize) {
        if (targetChunkSize < 1) {
            throw Assert$.MODULE$.abort("Usage error: targetChunkSize.>=(1)");
        }
        if (boundaryMark.length() < 1) {
            throw Assert$.MODULE$.abort("Usage error: boundaryMark.length().>=(1)");
        }
        String boundaryMarkIn8859 = new String(boundaryMark.getBytes(charset), StandardCharsets.ISO_8859_1);
        String quotedBoundaryMark = Pattern.quote(boundaryMarkIn8859);
        RegexLimitingStream result = new RegexLimitingStream(inputStream, quotedBoundaryMark, boundaryMarkIn8859, charset, targetChunkSize);
        return result;
    }

    public int apply$default$4() {
        return 32768;
    }

    private BoundaryMarkLimitingStream$() {
        MODULE$ = this;
    }
}

