/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.regex.Matcher;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.io.DataInputStream;
import org.apache.daffodil.io.DataInputStreamImplMixin;
import org.apache.daffodil.io.DataStreamCommonImplMixin;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSource;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.io.InputSourceDataInputStreamCharIterator;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.io.MarkPool;
import org.apache.daffodil.io.MarkState;
import org.apache.daffodil.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.schema.annotation.props.gen.ByteOrder;
import org.apache.daffodil.util.Bits$;
import org.apache.daffodil.util.LocalStack;
import org.apache.daffodil.util.LogLevel;
import org.apache.daffodil.util.LogWriter;
import org.apache.daffodil.util.Logging;
import org.apache.daffodil.util.MStackOf;
import org.apache.daffodil.util.Maybe;
import org.apache.daffodil.util.Maybe$;
import org.apache.daffodil.util.MaybeULong$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5x!B\u001d;\u0011\u0003\u0019e!B#;\u0011\u00031\u0005\"B'\u0002\t\u0003q\u0005\"B(\u0002\t\u0003\u0001\u0006BB(\u0002\t\u0003\u00119\u000e\u0003\u0004P\u0003\u0011\u0005!Q\u001c\u0004\u0005\u000bj\u0012!\u000b\u0003\u0005W\r\t\u0015\r\u0011\"\u0001X\u0011!YfA!A!\u0002\u0013A\u0006\"B'\u0007\t\u0013a\u0006\"\u00020\u0007\t\u0003z\u0006b\u00025\u0007\u0005\u0004%)%\u001b\u0005\u0007[\u001a\u0001\u000bQ\u00026\t\u000f94!\u0019!C\u0001_\"1aO\u0002Q\u0001\nADqa\u001e\u0004C\u0002\u0013\u0005\u0001\u0010\u0003\u0004}\r\u0001\u0006I!\u001f\u0005\u0006{\u001a!)E \u0005\b\u0003\u001b1AQIA\b\u0011\u001d\tIB\u0002C\u0001\u00037Aq!a\t\u0007\t\u000b\t)\u0003C\u0004\u00028\u0019!\t!!\u000f\t\u000f\u0005\u0015c\u0001\"\u0011\u0002H!9\u0011Q\n\u0004\u0005\u0002\u0005=\u0003bBA+\r\u0011\u0005\u0011q\u000b\u0005\b\u0003+2A\u0011AA=\u0011\u001d\t\u0019I\u0002C\u0005\u0003\u000bCq!!$\u0007\t\u0003\ty\tC\u0004\u0002\u001a\u001a!\t!a'\t\u000f\u0005\u0015f\u0001\"\u0001\u0002(\"I\u0011q\u0016\u0004C\u0002\u0013%\u0011\u0011\u0017\u0005\t\u0003g3\u0001\u0015!\u0003\u0002Z!9\u0011Q\u0017\u0004\u0005\u0002\u0005]\u0006bBAg\r\u0011%\u0011q\u001a\u0005\b\u000334A\u0011AAn\u0011\u001d\tiO\u0002C\u0001\u0003_Dq!!>\u0007\t\u000b\t9\u0010C\u0004\u0002~\u001a!)!!\n\t\u000f\u0005}h\u0001\"\u0001\u0003\u0002!9!q\u0001\u0004\u0005\u0002\t%\u0001b\u0002B\u0019\r\u0011%!1\u0007\u0005\b\u0005o1A\u0011\u0001B\u001d\u0011\u001d\u0011iD\u0002C\u0001\u0005\u007fAqAa\u0011\u0007\t\u0003\u0012)\u0005C\u0004\u0003N\u0019!\tEa\u0014\t\u000f\tUc\u0001\"\u0001\u0003X!9!\u0011\f\u0004\u0005\u0006\tm\u0003b\u0002B5\r\u0011\u0015!1\u000e\u0005\u000b\u0005c2\u0001R1A\u0005\u0002\tM\u0004b\u0002BA\r\u0011\u0005!1\u0011\u0005\b\u0005\u00133A\u0011\u0001BF\u0011%\u0011\tK\u0002b\u0001\n\u0013\u0011\u0019\u000b\u0003\u0005\u0003,\u001a\u0001\u000b\u0011\u0002BS\u0011\u001d\u0011iK\u0002C\u0001\u0005_CqAa.\u0007\t\u0003\u0012I\fC\u0004\u0003@\u001a!\tA!1\t\u000f\t5g\u0001\"\u0001\u0003P\u0006Q\u0012J\u001c9viN{WO]2f\t\u0006$\u0018-\u00138qkR\u001cFO]3b[*\u00111\bP\u0001\u0003S>T!!\u0010 \u0002\u0011\u0011\fgMZ8eS2T!a\u0010!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0015aA8sO\u000e\u0001\u0001C\u0001#\u0002\u001b\u0005Q$AG%oaV$8k\\;sG\u0016$\u0015\r^1J]B,Ho\u0015;sK\u0006l7CA\u0001H!\tA5*D\u0001J\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aQ\u0001\u0006CB\u0004H.\u001f\u000b\u0004#\nM\u0007C\u0001#\u0007'\r1qi\u0015\t\u0003\tRK!!\u0016\u001e\u00031\u0011\u000bG/Y%oaV$8\u000b\u001e:fC6LU\u000e\u001d7NSbLg.A\u0006j]B,HoU8ve\u000e,W#\u0001-\u0011\u0005\u0011K\u0016B\u0001.;\u0005-Ie\u000e];u'>,(oY3\u0002\u0019%t\u0007/\u001e;T_V\u00148-\u001a\u0011\u0015\u0005Ek\u0006\"\u0002,\n\u0001\u0004A\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0001\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\t1\fgn\u001a\u0006\u0002K\u0006!!.\u0019<b\u0013\t9'M\u0001\u0004TiJLgnZ\u0001\u0004GN$X#\u00016\u0011\u0005\u0011[\u0017B\u00017;\u0005%i\u0015M]6Ti\u0006$X-\u0001\u0003dgR\u0004\u0013!C7be.\u001cF/Y2l+\u0005\u0001\bcA9uU6\t!O\u0003\u0002ty\u0005!Q\u000f^5m\u0013\t)(O\u0001\u0005N'R\f7m[(g\u0003)i\u0017M]6Ti\u0006\u001c7\u000eI\u0001\t[\u0006\u00148\u000eU8pYV\t\u0011\u0010\u0005\u0002Eu&\u00111P\u000f\u0002\t\u001b\u0006\u00148\u000eU8pY\u0006IQ.\u0019:l!>|G\u000eI\u0001\tE&$\bk\\:1EV\tq\u0010E\u0002I\u0003\u0003I1!a\u0001J\u0005\u0011auN\\4)\u0007E\t9\u0001E\u0002I\u0003\u0013I1!a\u0003J\u0005\u0019Ig\u000e\\5oK\u0006Q!-\u001b;MS6LG\u000f\r2\u0016\u0005\u0005E\u0001cA9\u0002\u0014%\u0019\u0011Q\u0003:\u0003\u00155\u000b\u0017PY3V\u0019>tw\rK\u0002\u0013\u0003\u000f\t1\u0003[1t%\u0016\f7\r[3e\u000b:$wJ\u001a#bi\u0006,\"!!\b\u0011\u0007!\u000by\"C\u0002\u0002\"%\u0013qAQ8pY\u0016\fg.A\u0004jg\u0006#XI\u001c3\u0015\u0005\u0005u\u0001f\u0002\u000b\u0002*\u0005=\u00121\u0007\t\u0004\u0011\u0006-\u0012bAA\u0017\u0013\nQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005E\u0012!U+tK\u0002\u0012\u0017\u000e\u001e)pgB\u0012\u0007e\u001c:!E&$\bk\\:2E\u0002\"x\u000eI2p[B\f'/\u001a\u0011xSRD\u0007%\u001a=qK\u000e$X\r\u001a\u0011q_NLG/[8oA!\u0002xn]:jE2L\bEY5u\u0019&l\u0017\u000e\u001e\u0019cS9\n#!!\u000e\u0002\u000bMr\u0013G\f\u0019\u0002\u0017M,GOQ5u!>\u001c\bG\u0019\u000b\u0005\u0003w\t\t\u0005E\u0002I\u0003{I1!a\u0010J\u0005\u0011)f.\u001b;\t\r\u0005\rS\u00031\u0001\u0000\u0003-qWm\u001e\"jiB{7\u000f\r2\u0002\u001bM,GOQ5u\u0019&l\u0017\u000e\u001e\u0019c)\u0011\ti\"!\u0013\t\u000f\u0005-c\u00031\u0001\u0002\u0012\u0005ia.Z<CSRd\u0015.\\5ua\t\fqB]3tKR\u0014\u0015\u000e\u001e'j[&$\bG\u0019\u000b\u0005\u0003w\t\t\u0006C\u0004\u0002T]\u0001\r!!\u0005\u0002\u001fM\fg/\u001a3CSRd\u0015.\\5ua\t\fAbZ3u\u0005f$X-\u0011:sCf$b!!\u0017\u0002f\u0005=\u0004#\u0002%\u0002\\\u0005}\u0013bAA/\u0013\n)\u0011I\u001d:bsB\u0019\u0001*!\u0019\n\u0007\u0005\r\u0014J\u0001\u0003CsR,\u0007bBA41\u0001\u0007\u0011\u0011N\u0001\u000fE&$H*\u001a8hi\"4%o\\72!\rA\u00151N\u0005\u0004\u0003[J%aA%oi\"9\u0011\u0011\u000f\rA\u0002\u0005M\u0014!\u00024j]\u001a|\u0007c\u0001#\u0002v%\u0019\u0011q\u000f\u001e\u0003\u0015\u0019{'/\\1u\u0013:4w\u000e\u0006\u0005\u0002<\u0005m\u0014QPA@\u0011\u001d\t9'\u0007a\u0001\u0003SBq!!\u001d\u001a\u0001\u0004\t\u0019\bC\u0004\u0002\u0002f\u0001\r!!\u0017\u0002\u000b\u0005\u0014(/Y=\u0002\u001b\u0019LG\u000e\u001c\"zi\u0016\f%O]1z)!\tY$a\"\u0002\n\u0006-\u0005bBAA5\u0001\u0007\u0011\u0011\f\u0005\b\u0003OR\u0002\u0019AA5\u0011\u001d\t\tH\u0007a\u0001\u0003g\nqbZ3u\u0005&t\u0017M]=E_V\u0014G.\u001a\u000b\u0005\u0003#\u000b9\nE\u0002I\u0003'K1!!&J\u0005\u0019!u.\u001e2mK\"9\u0011\u0011O\u000eA\u0002\u0005M\u0014AD4fi\nKg.\u0019:z\r2|\u0017\r\u001e\u000b\u0005\u0003;\u000b\u0019\u000bE\u0002I\u0003?K1!!)J\u0005\u00151En\\1u\u0011\u001d\t\t\b\ba\u0001\u0003g\nQbZ3u'&<g.\u001a3M_:<G#B@\u0002*\u00065\u0006bBAV;\u0001\u0007\u0011\u0011N\u0001\u0013E&$H*\u001a8hi\"4%o\\72)>4D\u0007C\u0004\u0002ru\u0001\r!a\u001d\u0002\u00131|gnZ!se\u0006LXCAA-\u0003)awN\\4BeJ\f\u0017\u0010I\u0001\u0010O\u0016$XK\\:jO:,G\rT8oOR1\u0011\u0011XAe\u0003\u0017\u0004B!a/\u0002F6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-\u0001\u0005v]NLwM\\3e\u0015\t\t\u0019-A\u0004qCN\u001cXM]1\n\t\u0005\u001d\u0017Q\u0018\u0002\u0006+2{gn\u001a\u0005\b\u0003W\u0003\u0003\u0019AA5\u0011\u001d\t\t\b\ta\u0001\u0003g\n\u0011%\u00193kkN$()[4J]R\f%O]1z/&$\bN\u0012:bO6,g\u000e\u001e\"zi\u0016$\u0002\"a\u000f\u0002R\u0006M\u0017q\u001b\u0005\b\u0003\u0003\u000b\u0003\u0019AA-\u0011\u001d\t).\ta\u0001\u0003S\naB\u001a:bO6,g\u000e\u001e'f]\u001e$\b\u000eC\u0004\u0002r\u0005\u0002\r!a\u001d\u0002\u001f\u001d,GoU5h]\u0016$')[4J]R$b!!8\u0002j\u0006-\b\u0003BAp\u0003Kl!!!9\u000b\u0007\u0005\rH-\u0001\u0003nCRD\u0017\u0002BAt\u0003C\u0014!BQ5h\u0013:$XmZ3s\u0011\u001d\t9G\ta\u0001\u0003SBq!!\u001d#\u0001\u0004\t\u0019(A\thKR,fn]5h]\u0016$')[4J]R$b!!8\u0002r\u0006M\bbBA4G\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003c\u001a\u0003\u0019AA:\u0003II7\u000fR3gS:,GMR8s\u0019\u0016tw\r\u001e5\u0015\t\u0005u\u0011\u0011 \u0005\u0007\u0003w$\u0003\u0019A@\u0002\u000b9\u0014\u0015\u000e^:\u0002\u000f!\f7\u000fR1uC\u0006!1o[5q)\u0019\tiBa\u0001\u0003\u0006!1\u00111 \u0014A\u0002}Dq!!\u001d'\u0001\u0004\t\u0019(\u0001\u0003nCJ\\G\u0003\u0002B\u0006\u00053\u0001BA!\u0004\u0003\u00149\u0019AIa\u0004\n\u0007\tE!(A\bECR\f\u0017J\u001c9viN#(/Z1n\u0013\u0011\u0011)Ba\u0006\u0003\t5\u000b'o\u001b\u0006\u0004\u0005#Q\u0004b\u0002B\u000eO\u0001\u0007!QD\u0001\fe\u0016\fX/Z:u_JLE\t\u0005\u0003\u0003 \t5b\u0002\u0002B\u0011\u0005S\u00012Aa\tJ\u001b\t\u0011)CC\u0002\u0003(\t\u000ba\u0001\u0010:p_Rt\u0014b\u0001B\u0016\u0013\u00061\u0001K]3eK\u001aL1a\u001aB\u0018\u0015\r\u0011Y#S\u0001\u0011e\u0016dW-Y:f+:$\u0018\u000e\\'be.$2A\u001bB\u001b\u0011\u001d\u00119\u0001\u000ba\u0001\u0005\u0017\tQA]3tKR$B!a\u000f\u0003<!9!qA\u0015A\u0002\t-\u0011a\u00023jg\u000e\f'\u000f\u001a\u000b\u0005\u0003w\u0011\t\u0005C\u0004\u0003\b)\u0002\rAa\u0003\u0002\u000f5\f'o\u001b)pgV\u0011!q\t\t\u0005\u0005\u001b\u0011I%\u0003\u0003\u0003L\t]!aB'be.\u0004vn]\u0001\te\u0016\u001cX\r\u001e)pgR!\u00111\bB)\u0011\u001d\u0011\u0019\u0006\fa\u0001\u0005\u000f\n\u0011!\\\u0001\u0019m\u0006d\u0017\u000eZ1uK\u001aKg.\u00197TiJ,\u0017-\\*uCR,WCAA\u001e\u0003%9W\r^*ue&tw\r\u0006\u0004\u0003^\t\r$q\r\t\u0006c\n}#QD\u0005\u0004\u0005C\u0012(!B'bs\n,\u0007B\u0002B3]\u0001\u0007q0\u0001\u0004o\u0007\"\f'o\u001d\u0005\b\u0003cr\u0003\u0019AA:\u000359W\r^*p[\u0016\u001cFO]5oOR1!Q\fB7\u0005_BaA!\u001a0\u0001\u0004y\bbBA9_\u0001\u0007\u00111O\u0001\u000fg.L\u0007o\u00115be\n+hMZ3s+\t\u0011)\b\u0005\u0003\u0003x\tuTB\u0001B=\u0015\r\u0011Y\bZ\u0001\u0004]&|\u0017\u0002\u0002B@\u0005s\u0012!b\u00115be\n+hMZ3s\u0003%\u00198.\u001b9DQ\u0006\u00148\u000f\u0006\u0004\u0002\u001e\t\u0015%q\u0011\u0005\u0007\u0005K\n\u0004\u0019A@\t\u000f\u0005E\u0014\u00071\u0001\u0002t\u0005IAn\\8lS:<\u0017\t\u001e\u000b\u0007\u0003;\u0011iIa(\t\u000f\t=%\u00071\u0001\u0003\u0012\u00069Q.\u0019;dQ\u0016\u0014\b\u0003\u0002BJ\u00057k!A!&\u000b\t\t]%\u0011T\u0001\u0006e\u0016<W\r\u001f\u0006\u0003g\u0012LAA!(\u0003\u0016\n9Q*\u0019;dQ\u0016\u0014\bbBA9e\u0001\u0007\u00111O\u0001\rG\"\f'/\u0013;fe\u0006$xN]\u000b\u0003\u0005K\u00032\u0001\u0012BT\u0013\r\u0011IK\u000f\u0002'\u0013:\u0004X\u000f^*pkJ\u001cW\rR1uC&s\u0007/\u001e;TiJ,\u0017-\\\"iCJLE/\u001a:bi>\u0014\u0018!D2iCJLE/\u001a:bi>\u0014\b%\u0001\bbg&#XM]1u_J\u001c\u0005.\u0019:\u0016\u0005\tE\u0006\u0003\u0002B\u0007\u0005gKAA!.\u0003\u0018\ta1\t[1s\u0013R,'/\u0019;pe\u0006a1/\u001a;EK\n,xmZ5oOR!\u00111\bB^\u0011\u001d\u0011iL\u000ea\u0001\u0003;\tqa]3ui&tw-\u0001\u0005qCN$H)\u0019;b)\u0011\u0011\u0019M!3\u0011\t\t]$QY\u0005\u0005\u0005\u000f\u0014IH\u0001\u0006CsR,')\u001e4gKJDqAa38\u0001\u0004\tI'A\bo\u0005f$Xm\u001d*fcV,7\u000f^3e\u0003)1W\u000f^;sK\u0012\u000bG/\u0019\u000b\u0005\u0005\u0007\u0014\t\u000eC\u0004\u0003Lb\u0002\r!!\u001b\t\u000f\tU7\u00011\u0001\u0002Z\u0005I!-\u001f;f\u0003J\u0014\u0018-\u001f\u000b\u0004#\ne\u0007b\u0002Bn\t\u0001\u0007!1Y\u0001\u000bEf$XMQ;gM\u0016\u0014HcA)\u0003`\"9!\u0011]\u0003A\u0002\t\r\u0018AA5o!\u0011\u0011)O!;\u000e\u0005\t\u001d(BA\u001ee\u0013\u0011\u0011YOa:\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c")
public final class InputSourceDataInputStream
implements DataInputStreamImplMixin {
    private CharBuffer skipCharBuffer;
    private final InputSource inputSource;
    private final MarkState cst;
    private final MStackOf<MarkState> markStack;
    private final MarkPool markPool;
    private final byte[] longArray;
    private final InputSourceDataInputStreamCharIterator charIterator;
    private LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer;
    private LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer;
    private String logID;
    private Object logWriter;
    private Object logLevel;
    private volatile byte bitmap$0;

    public static InputSourceDataInputStream apply(InputStream inputStream) {
        return InputSourceDataInputStream$.MODULE$.apply(inputStream);
    }

    public static InputSourceDataInputStream apply(ByteBuffer byteBuffer) {
        return InputSourceDataInputStream$.MODULE$.apply(byteBuffer);
    }

    public static InputSourceDataInputStream apply(byte[] byArray) {
        return InputSourceDataInputStream$.MODULE$.apply(byArray);
    }

    @Override
    public final boolean isAligned(int bitAlignment1b) {
        return DataInputStreamImplMixin.isAligned$(this, bitAlignment1b);
    }

    @Override
    public final boolean align(int bitAlignment1b, FormatInfo finfo) {
        return DataInputStreamImplMixin.align$(this, bitAlignment1b, finfo);
    }

    @Override
    public final long remainingBits() {
        return DataInputStreamImplMixin.remainingBits$(this);
    }

    @Override
    public final boolean areDebugging() {
        return DataStreamCommonImplMixin.areDebugging$(this);
    }

    public void setLoggingLevel(LogLevel.Type level) {
        Logging.setLoggingLevel$((Logging)this, (LogLevel.Type)level);
    }

    public final LogLevel.Type getLoggingLevel() {
        return Logging.getLoggingLevel$((Logging)this);
    }

    public void setLogWriter(LogWriter lw) {
        Logging.setLogWriter$((Logging)this, (LogWriter)lw);
    }

    public LogWriter getLogWriter() {
        return Logging.getLogWriter$((Logging)this);
    }

    public final boolean areLogging(LogLevel.Type lvl) {
        return Logging.areLogging$((Logging)this, (LogLevel.Type)lvl);
    }

    public void doLogging(LogLevel.Type lvl, String msg, Seq<Object> args) {
        Logging.doLogging$((Logging)this, (LogLevel.Type)lvl, (String)msg, args);
    }

    public <S> LogLevel.Type withLoggingLevel$default$1() {
        return Logging.withLoggingLevel$default$1$((Logging)this);
    }

    @Override
    public final long bitPos1b() {
        return DataInputStream.bitPos1b$(this);
    }

    @Override
    public final long bytePos0b() {
        return DataInputStream.bytePos0b$(this);
    }

    @Override
    public final long bytePos1b() {
        return DataInputStream.bytePos1b$(this);
    }

    @Override
    public final long bitLimit1b() {
        return DataInputStream.bitLimit1b$(this);
    }

    @Override
    public final boolean setBitLimit1b(long bitLimit1b) {
        return DataInputStream.setBitLimit1b$(this, bitLimit1b);
    }

    private LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.withLocalCharBuffer = LocalBufferMixin.withLocalCharBuffer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.withLocalCharBuffer;
    }

    @Override
    public final LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.withLocalCharBuffer$lzycompute() : this.withLocalCharBuffer;
    }

    private LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.withLocalByteBuffer = LocalBufferMixin.withLocalByteBuffer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.withLocalByteBuffer;
    }

    @Override
    public final LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.withLocalByteBuffer$lzycompute() : this.withLocalByteBuffer;
    }

    private String logID$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logID = Logging.logID$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.logID;
    }

    public String logID() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logID$lzycompute() : this.logID;
    }

    public Object logWriter() {
        return this.logWriter;
    }

    public void logWriter_$eq(Object x$1) {
        this.logWriter = x$1;
    }

    public Object logLevel() {
        return this.logLevel;
    }

    public void logLevel_$eq(Object x$1) {
        this.logLevel = x$1;
    }

    public InputSource inputSource() {
        return this.inputSource;
    }

    public String toString() {
        long bp0b = this.bitPos0b();
        long bl0b = this.bitLimit0b();
        String bl0b1 = MaybeULong$.MODULE$.isDefined$extension(bl0b) ? Long.toString(MaybeULong$.MODULE$.get$extension(bl0b)) : "none";
        String str = new StringBuilder(35).append("DataInputStream(bitPos=").append(bp0b).append(", bitLimit=").append(bl0b1).append(")").toString();
        return str;
    }

    @Override
    public final MarkState cst() {
        return this.cst;
    }

    public MStackOf<MarkState> markStack() {
        return this.markStack;
    }

    public MarkPool markPool() {
        return this.markPool;
    }

    @Override
    public final long bitPos0b() {
        return this.cst().bitPos0b();
    }

    @Override
    public final long bitLimit0b() {
        return this.cst().bitLimit0b();
    }

    public boolean hasReachedEndOfData() {
        return this.inputSource().hasReachedEndOfData();
    }

    public final boolean isAtEnd() {
        return !this.hasData() && this.hasReachedEndOfData();
    }

    public void setBitPos0b(long newBitPos0b) {
        if (newBitPos0b < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitPos0b.>=(0)");
        }
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            throw Assert$.MODULE$.abort("Invariant broken: InputSourceDataInputStream.this.bitLimit0b.isEmpty.||(newBitPos0b.<=(InputSourceDataInputStream.this.bitLimit0b.get))");
        }
        this.inputSource().position(newBitPos0b >> 3);
        this.cst().bitPos0b_$eq(newBitPos0b);
    }

    @Override
    public boolean setBitLimit0b(long newBitLimit0b) {
        boolean bl;
        if (!MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) && MaybeULong$.MODULE$.get$extension(newBitLimit0b) < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitLimit0b.isEmpty.||(newBitLimit0b.get.>=(0))");
        }
        if (MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) || MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) || MaybeULong$.MODULE$.get$extension(newBitLimit0b) <= MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            this.cst().bitLimit0b_$eq(newBitLimit0b);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void resetBitLimit0b(long savedBitLimit0b) {
        this.cst().bitLimit0b_$eq(savedBitLimit0b);
    }

    @Override
    public byte[] getByteArray(int bitLengthFrom1, FormatInfo finfo) {
        if (!this.isDefinedForLength(bitLengthFrom1)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1);
        }
        int arraySize = (bitLengthFrom1 + 7) / 8;
        byte[] array = new byte[arraySize];
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
        return array;
    }

    @Override
    public void getByteArray(int bitLengthFrom1, FormatInfo finfo, byte[] array) {
        if (!this.isDefinedForLength(bitLengthFrom1)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1);
        }
        int bytesNeeded = (bitLengthFrom1 + 7) / 8;
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).size() < bytesNeeded) {
            throw Assert$.MODULE$.abort("Usage error: scala.Predef.byteArrayOps(array).size.>=(bytesNeeded)");
        }
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
    }

    private void fillByteArray(byte[] array, int bitLengthFrom1, FormatInfo finfo) {
        block4: {
            boolean isUnaligned = !this.isAligned(8);
            int fragmentBits = bitLengthFrom1 % 8;
            int bytesToFill = (bitLengthFrom1 + 7) / 8;
            this.inputSource().get(array, 0, bytesToFill);
            if (isUnaligned) {
                int index;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                boolean isMSBF = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null);
                int bitOffset0b = (int)(this.bitPos0b() % 8L);
                int bytesToRead = (bitLengthFrom1 + bitOffset0b + 7) / 8;
                int arrayOverflow = bytesToRead > bytesToFill ? Bits$.MODULE$.asUnsignedByte((long)this.inputSource().get()) : 0;
                int curBitMask = isMSBF ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(8 - bitOffset0b)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(8 - bitOffset0b));
                int nxtBitMask = ~curBitMask & 0xFF;
                int curShift = bitOffset0b;
                int nxtShift = 8 - bitOffset0b;
                int curByte = Bits$.MODULE$.asUnsignedByte(array[index]);
                int stopIndex = bytesToFill - 1;
                for (index = 0; index < stopIndex; ++index) {
                    int nxtByte = Bits$.MODULE$.asUnsignedByte(array[index + 1]);
                    array[index] = InputSourceDataInputStream.calcNewByte$1(curByte, nxtByte, curBitMask, nxtBitMask, isMSBF, curShift, nxtShift);
                    curByte = nxtByte;
                }
                array[index] = InputSourceDataInputStream.calcNewByte$1(curByte, arrayOverflow, curBitMask, nxtBitMask, isMSBF, curShift, nxtShift);
            }
            if (fragmentBits > 0) {
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                int mask = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null) ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(fragmentBits)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(fragmentBits));
                int lastIndex = bytesToFill - 1;
                int lastByte = Bits$.MODULE$.asUnsignedByte(array[lastIndex]);
                array[lastIndex] = Bits$.MODULE$.asSignedByte((long)(lastByte & mask));
            }
            if (bitLengthFrom1 <= 8) break block4;
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
                Bits$.MODULE$.reverseBytes(array, bytesToFill);
            }
        }
    }

    @Override
    public double getBinaryDouble(FormatInfo finfo) {
        long l = this.getSignedLong(64, finfo);
        double d = Double.longBitsToDouble(l);
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getBinaryFloat(FormatInfo finfo) {
        void var3_3;
        int i = (int)this.getSignedLong(32, finfo);
        float f = Float.intBitsToFloat(i);
        return (float)var3_3;
    }

    @Override
    public long getSignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.<=(64)");
        }
        long res = this.getUnsignedLong(bitLengthFrom1To64, finfo);
        return Bits$.MODULE$.signExtend(res, bitLengthFrom1To64);
    }

    private byte[] longArray() {
        return this.longArray;
    }

    @Override
    public long getUnsignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        long l;
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.<=(64)");
        }
        if (!this.isDefinedForLength(bitLengthFrom1To64)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1To64);
        }
        int numBytes = (bitLengthFrom1To64 + 7) / 8;
        this.fillByteArray(this.longArray(), bitLengthFrom1To64, finfo);
        int fragmentLength = bitLengthFrom1To64 % 8;
        if (fragmentLength == 0) {
            long l2;
            l = l2 = this.buildLongFromArray$1(numBytes);
        } else {
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
                long l3;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null)) {
                    int firstByte = Bits$.MODULE$.asUnsignedByte(this.longArray()[0]);
                    int shifted = firstByte >>> 8 - fragmentLength;
                    this.longArray()[0] = Bits$.MODULE$.asSignedByte((long)shifted);
                }
                l = l3 = this.buildLongFromArray$1(numBytes);
            } else {
                long l4;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.LeastSignificantBitFirst$ leastSignificantBitFirst$ = BitOrder.LeastSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(leastSignificantBitFirst$) : leastSignificantBitFirst$ != null)) {
                    int lastIndex = numBytes - 1;
                    byte lastByte = this.longArray()[lastIndex];
                    int shifted = lastByte << 8 - fragmentLength;
                    this.longArray()[lastIndex] = Bits$.MODULE$.asSignedByte((long)shifted);
                }
                long unShiftedLong = this.buildLongFromArray$1(numBytes);
                l = l4 = unShiftedLong >>> 8 - fragmentLength;
            }
        }
        long res = l;
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1To64);
        return res;
    }

    private void adjustBigIntArrayWithFragmentByte(byte[] array, int fragmentLength, FormatInfo finfo) {
        ByteOrder byteOrder = finfo.byteOrder();
        ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
        if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
            if (!(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null)) {
                int firstByte = Bits$.MODULE$.asUnsignedByte(array[0]);
                int shifted = firstByte >>> 8 - fragmentLength;
                array[0] = Bits$.MODULE$.asSignedByte((long)shifted);
            }
        } else {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.LeastSignificantBitFirst$ leastSignificantBitFirst$ = BitOrder.LeastSignificantBitFirst$.MODULE$;
            if (!(bitOrder != null ? !bitOrder.equals(leastSignificantBitFirst$) : leastSignificantBitFirst$ != null)) {
                int lastIndex = array.length - 1;
                byte lastByte = array[lastIndex];
                int shifted = lastByte << 8 - fragmentLength;
                array[lastIndex] = Bits$.MODULE$.asSignedByte((long)shifted);
            }
            ByteBuffer bb = ByteBuffer.wrap(array);
            Bits$.MODULE$.shiftRight(bb, 8 - fragmentLength);
        }
    }

    @Override
    public BigInteger getSignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        BigInteger bigInteger;
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1.>=(1)");
        }
        if (bitLengthFrom1 <= 64) {
            bigInteger = BigInteger.valueOf(this.getSignedLong(bitLengthFrom1, finfo));
        } else {
            byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
            int fragmentLength = bitLengthFrom1 % 8;
            if (fragmentLength > 0) {
                this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
                int shift = 8 - fragmentLength;
                bytes[0] = (byte)((byte)(bytes[0] << shift) >> shift);
            }
            bigInteger = new BigInteger(bytes);
        }
        return bigInteger;
    }

    @Override
    public BigInteger getUnsignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1.>=(1)");
        }
        byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
        int fragmentLength = bitLengthFrom1 % 8;
        if (fragmentLength > 0) {
            this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
        }
        return new BigInteger(1, bytes);
    }

    @Override
    public final boolean isDefinedForLength(long nBits) {
        boolean bl;
        long newBitPos0b = this.bitPos0b() + nBits;
        if (MaybeULong$.MODULE$.isDefined$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            bl = false;
        } else {
            long newEndingBytePos0b = Bits$.MODULE$.roundUpBitToBytePosition(newBitPos0b);
            long moreBytesNeeded = newEndingBytePos0b - this.inputSource().position();
            bl = this.inputSource().areBytesAvailable(moreBytesNeeded);
        }
        return bl;
    }

    @Override
    public final boolean hasData() {
        return this.isDefinedForLength(1L);
    }

    @Override
    public boolean skip(long nBits, FormatInfo finfo) {
        if (!this.isDefinedForLength(nBits)) {
            return false;
        }
        this.setBitPos0b(this.bitPos0b() + nBits);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataInputStream.Mark mark(String requestorID) {
        void var2_2;
        MarkState m = (MarkState)this.markPool().getFromPool(requestorID);
        m.assignFrom(this.cst());
        this.markStack().push((Object)m);
        this.inputSource().lockPosition(m.bytePos0b());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private MarkState releaseUntilMark(DataInputStream.Mark mark) {
        void var2_2;
        if (this.markStack().isEmpty()) {
            throw Assert$.MODULE$.abort("Usage error: InputSourceDataInputStream.this.markStack.isEmpty.unary_!");
        }
        if (mark == null) {
            throw Assert$.MODULE$.abort("Usage error: mark.!=(null)");
        }
        MarkState current = (MarkState)this.markStack().pop();
        while (!this.markStack().isEmpty() && current != mark) {
            this.inputSource().releasePosition(current.bytePos0b());
            this.markPool().returnToPool(current);
            current = (MarkState)this.markStack().pop();
        }
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        return var2_2;
    }

    @Override
    public void reset(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.cst().assignFrom(current);
        this.setBitPos0b(this.cst().bitPos0b());
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public void discard(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public long markPos() {
        return this.bitPos0b();
    }

    @Override
    public void resetPos(long m) {
        this.setBitPos0b(m);
    }

    @Override
    public void validateFinalStreamState() {
        this.markPool().finalCheck();
    }

    @Override
    public final Object getString(long nChars, FormatInfo finfo) {
        long startingBitPos = this.bitPos0b();
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        return !aligned ? Maybe$.MODULE$.Nope() : ((Maybe)this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)lcb -> new Maybe(InputSourceDataInputStream.$anonfun$getString$1(this, nChars, finfo, startingBitPos, lcb)))).v();
    }

    @Override
    public final Object getSomeString(long nChars, FormatInfo finfo) {
        long startingBitPos = this.bitPos0b();
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        return !aligned ? Maybe$.MODULE$.Nope() : ((Maybe)this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)lcb -> new Maybe(InputSourceDataInputStream.$anonfun$getSomeString$1(this, nChars, finfo, startingBitPos, lcb)))).v();
    }

    private CharBuffer skipCharBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.skipCharBuffer = CharBuffer.allocate(32);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.skipCharBuffer;
    }

    public CharBuffer skipCharBuffer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.skipCharBuffer$lzycompute() : this.skipCharBuffer;
    }

    @Override
    public boolean skipChars(long nChars, FormatInfo finfo) {
        boolean bl;
        long startingBitPos = this.bitPos0b();
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        if (!aligned) {
            bl = false;
        } else {
            boolean skippedAllNChars;
            long remainingCharsToSkip;
            int numDecoded;
            boolean keepGoing = true;
            for (remainingCharsToSkip = nChars; keepGoing && remainingCharsToSkip > 0L; remainingCharsToSkip -= (long)numDecoded) {
                long charsToSkip = Math.min(remainingCharsToSkip, (long)this.skipCharBuffer().capacity());
                this.skipCharBuffer().position(0);
                this.skipCharBuffer().limit((int)charsToSkip);
                BitsCharsetDecoder qual$1 = finfo.decoder();
                InputSourceDataInputStream x$1 = this;
                FormatInfo x$2 = finfo;
                CharBuffer x$3 = this.skipCharBuffer();
                LongBuffer x$4 = qual$1.decode$default$4();
                numDecoded = qual$1.decode(x$1, x$2, x$3, x$4);
                if (numDecoded != 0) continue;
                keepGoing = false;
            }
            boolean bl2 = skippedAllNChars = remainingCharsToSkip == 0L;
            if (!skippedAllNChars) {
                this.setBitPos0b(startingBitPos);
            }
            bl = skippedAllNChars;
        }
        return bl;
    }

    @Override
    public boolean lookingAt(Matcher matcher, FormatInfo finfo) {
        boolean bl;
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        if (!aligned) {
            bl = false;
        } else {
            int regexMatchBufferLimit = finfo.tunable().initialRegexMatchLimitInCharacters();
            CharBuffer regexMatchBuffer = finfo.regexMatchBuffer();
            LongBuffer regexMatchBitPositionBuffer = finfo.regexMatchBitPositionBuffer();
            regexMatchBuffer.position(0);
            regexMatchBuffer.limit(0);
            regexMatchBitPositionBuffer.position(0);
            regexMatchBitPositionBuffer.limit(0);
            long startingBitPos = this.bitPos0b();
            boolean keepMatching = true;
            boolean isMatch = false;
            while (keepMatching) {
                regexMatchBuffer.position(regexMatchBuffer.limit());
                regexMatchBuffer.limit(regexMatchBufferLimit);
                regexMatchBitPositionBuffer.position(regexMatchBitPositionBuffer.limit());
                regexMatchBitPositionBuffer.limit(regexMatchBufferLimit);
                int numDecoded = finfo.decoder().decode(this, finfo, regexMatchBuffer, regexMatchBitPositionBuffer);
                boolean potentiallyMoreData = regexMatchBuffer.position() == regexMatchBuffer.limit();
                regexMatchBuffer.flip();
                regexMatchBitPositionBuffer.flip();
                if (numDecoded > 0) {
                    matcher.reset(regexMatchBuffer);
                    isMatch = matcher.lookingAt();
                    boolean hitEnd = matcher.hitEnd();
                    boolean requireEnd = matcher.requireEnd();
                    if (potentiallyMoreData && (hitEnd || isMatch && requireEnd)) {
                        if (regexMatchBufferLimit == regexMatchBuffer.capacity()) {
                            keepMatching = false;
                            continue;
                        }
                        regexMatchBufferLimit = Math.min(regexMatchBufferLimit * 2, regexMatchBuffer.capacity());
                        continue;
                    }
                    keepMatching = false;
                    continue;
                }
                keepMatching = false;
            }
            if (isMatch && matcher.end() != 0) {
                long endingBitPos = regexMatchBitPositionBuffer.get(matcher.end() - 1);
                this.setBitPos0b(endingBitPos);
            } else {
                this.setBitPos0b(startingBitPos);
            }
            bl = isMatch;
        }
        return bl;
    }

    private InputSourceDataInputStreamCharIterator charIterator() {
        return this.charIterator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataInputStream.CharIterator asIteratorChar() {
        void var1_1;
        InputSourceDataInputStreamCharIterator ci = this.charIterator();
        ci.reset();
        return var1_1;
    }

    @Override
    public void setDebugging(boolean setting) {
        DataInputStreamImplMixin.setDebugging$(this, setting);
        this.inputSource().setDebugging(setting);
    }

    @Override
    public ByteBuffer pastData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.abort("Usage error: nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        int bytesToRead = (int)Math.min(savedBytePosition, (long)nBytesRequested);
        long newBytePosition = savedBytePosition - (long)bytesToRead;
        this.inputSource().position(newBytePosition);
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer futureData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.abort("Usage error: nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        boolean available = this.inputSource().areBytesAvailable(nBytesRequested);
        int bytesToRead = available ? nBytesRequested : (int)this.inputSource().bytesAvailable();
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    private static final byte calcNewByte$1(long curByte, long nxtByte, int curBitMask$1, int nxtBitMask$1, boolean isMSBF$1, int curShift$1, int nxtShift$1) {
        long curBits = curByte & (long)curBitMask$1;
        long nxtBits = nxtByte & (long)nxtBitMask$1;
        long newByte = isMSBF$1 ? curBits << curShift$1 | nxtBits >> nxtShift$1 : curBits >> curShift$1 | nxtBits << nxtShift$1;
        return Bits$.MODULE$.asSignedByte(newByte);
    }

    /*
     * WARNING - void declaration
     */
    private final long buildLongFromArray$1(int numBytes$1) {
        void var2_2;
        long l = Bits$.MODULE$.asUnsignedByte(this.longArray()[0]);
        for (int i = 1; i < numBytes$1; ++i) {
            l = l << 8 | (long)Bits$.MODULE$.asUnsignedByte(this.longArray()[i]);
        }
        return (long)var2_2;
    }

    public static final /* synthetic */ Object $anonfun$getString$1(InputSourceDataInputStream $this, long nChars$1, FormatInfo finfo$1, long startingBitPos$1, LocalBufferMixin.LocalCharBuffer lcb) {
        Object object;
        LongBuffer x$4;
        CharBuffer x$3;
        FormatInfo x$2;
        InputSourceDataInputStream x$1;
        CharBuffer cb = (CharBuffer)lcb.getBuf(nChars$1);
        BitsCharsetDecoder qual$1 = finfo$1.decoder();
        int numDecoded = qual$1.decode(x$1 = $this, x$2 = finfo$1, x$3 = cb, x$4 = qual$1.decode$default$4());
        if ((long)numDecoded == nChars$1) {
            object = Maybe$.MODULE$.apply((Object)cb.flip().toString());
        } else {
            $this.setBitPos0b(startingBitPos$1);
            object = Maybe$.MODULE$.Nope();
        }
        return object;
    }

    public static final /* synthetic */ Object $anonfun$getSomeString$1(InputSourceDataInputStream $this, long nChars$2, FormatInfo finfo$2, long startingBitPos$2, LocalBufferMixin.LocalCharBuffer lcb) {
        Object object;
        LongBuffer x$4;
        CharBuffer x$3;
        FormatInfo x$2;
        InputSourceDataInputStream x$1;
        CharBuffer cb = (CharBuffer)lcb.getBuf(nChars$2);
        BitsCharsetDecoder qual$1 = finfo$2.decoder();
        int numDecoded = qual$1.decode(x$1 = $this, x$2 = finfo$2, x$3 = cb, x$4 = qual$1.decode$default$4());
        if (numDecoded > 0) {
            object = Maybe$.MODULE$.apply((Object)cb.flip().toString());
        } else {
            $this.setBitPos0b(startingBitPos$2);
            object = Maybe$.MODULE$.Nope();
        }
        return object;
    }

    public InputSourceDataInputStream(InputSource inputSource) {
        this.inputSource = inputSource;
        DataInputStream.$init$(this);
        Logging.$init$((Logging)this);
        DataStreamCommonImplMixin.$init$(this);
        LocalBufferMixin.$init$(this);
        DataInputStreamImplMixin.$init$(this);
        this.cst = new MarkState();
        this.markStack = new MStackOf();
        this.markPool = new MarkPool();
        this.longArray = new byte[8];
        this.charIterator = new InputSourceDataInputStreamCharIterator(this);
    }
}

