/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import org.apache.daffodil.io.BacktrackingException;
import org.apache.daffodil.io.BucketingInputSource$;
import org.apache.daffodil.io.InputSource;
import org.apache.daffodil.io.InputStreamReadZeroError;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Array$;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u001b7\u0001}B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\r\u0019\u0002!\t\u0011!B\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001b\")A\u000b\u0001C\u0001+\u001a!1\f\u0001\u0003]\u0011\u0015!V\u0001\"\u0001a\u0011\u001d\u0019W\u00011A\u0005\u0002\u0011Dq!Z\u0003A\u0002\u0013\u0005a\r\u0003\u0004m\u000b\u0001\u0006K!\u0014\u0005\b[\u0016\u0011\r\u0011\"\u0001o\u0011\u0019)X\u0001)A\u0005_\")a\u000f\u0001C!o\"9\u0001\u0010\u0001b\u0001\n\u0013!\u0007BB=\u0001A\u0003%Q\nC\u0004{\u0001\t\u0007I\u0011B>\t\u000f\u0005%\u0001\u0001)A\u0005y\"A\u00111\u0002\u0001A\u0002\u0013%A\rC\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0003\u0002\u0010!9\u00111\u0003\u0001!B\u0013i\u0005\"CA\u000b\u0001\u0001\u0007I\u0011BA\f\u0011%\ty\u0002\u0001a\u0001\n\u0013\t\t\u0003\u0003\u0005\u0002&\u0001\u0001\u000b\u0015BA\r\u0011%\t9\u0003\u0001a\u0001\n\u0013\t9\u0002C\u0005\u0002*\u0001\u0001\r\u0011\"\u0003\u0002,!A\u0011q\u0006\u0001!B\u0013\tI\u0002\u0003\b\u00022\u0001!\t\u0011!B\u0001\u0002\u0004%I!a\u0006\t\u0017\u0005M\u0002A!AA\u0002\u0013%\u0011Q\u0007\u0005\f\u0003s\u0001!\u0011!A!B\u0013\tI\u0002\u0003\u0005\u0002<\u0001\u0001\r\u0011\"\u0003e\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty\u0004C\u0004\u0002D\u0001\u0001\u000b\u0015B'\t\u0013\u0005\u0015\u0003\u00011A\u0005\n\u0005\u001d\u0003\"CA(\u0001\u0001\u0007I\u0011BA)\u0011!\t)\u0006\u0001Q!\n\u0005%\u0003bBA,\u0001\u0011\u0005\u0013q\t\u0005\b\u00033\u0002A\u0011BA.\u0011\u001d\t)\u0007\u0001C\u0007\u0003OBq!a\u001f\u0001\t\u0003\ti\bC\u0004\u0002\u0004\u0002!\t!!\"\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"9\u0011q\u0011\u0001\u0005\u0002\u0005-\u0005bBAM\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u00033\u0003A\u0011AAN\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!!*\u0001\t\u0003\t9\u000b\u0003\u0004\u0002,\u0002!Ia\u001e\u0005\u0007\u0003[\u0003A\u0011A<\b\u0013\u0005=f'!A\t\u0002\u0005Ef\u0001C\u001b7\u0003\u0003E\t!a-\t\rQ\u000bD\u0011AA[\u0011%\t9,MI\u0001\n\u0003\tI\fC\u0005\u0002PF\n\n\u0011\"\u0001\u0002:\n!\")^2lKRLgnZ%oaV$8k\\;sG\u0016T!a\u000e\u001d\u0002\u0005%|'BA\u001d;\u0003!!\u0017M\u001a4pI&d'BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0001B\u0011\u0011IQ\u0007\u0002m%\u00111I\u000e\u0002\f\u0013:\u0004X\u000f^*pkJ\u001cW-A\u0006j]B,Ho\u0015;sK\u0006l\u0007C\u0001$K\u001b\u00059%BA\u001cI\u0015\u0005I\u0015\u0001\u00026bm\u0006L!aS$\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u00018_J<G%\u00199bG\",G\u0005Z1gM>$\u0017\u000e\u001c\u0013j_\u0012\u0012UoY6fi&tw-\u00138qkR\u001cv.\u001e:dK\u0012\"#-^2lKR\u001c\u0016N_3\u0011\u00059\u000bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\u0007%sG/A\nnCb\u001c\u0015m\u00195f'&TX-\u00138CsR,7/\u0001\u0004=S:LGO\u0010\u000b\u0005-^C&\f\u0005\u0002B\u0001!)A\t\u0002a\u0001\u000b\"9\u0011\f\u0002I\u0001\u0002\u0004i\u0015A\u00032vG.,GoU5{K\"91\u000b\u0002I\u0001\u0002\u0004i%A\u0002\"vG.,Go\u0005\u0002\u0006;B\u0011aJX\u0005\u0003?>\u0013a!\u00118z%\u00164G#A1\u0011\u0005\t,Q\"\u0001\u0001\u0002\u0011I,gmQ8v]R,\u0012!T\u0001\re\u001647i\\;oi~#S-\u001d\u000b\u0003O*\u0004\"A\u00145\n\u0005%|%\u0001B+oSRDqa\u001b\u0005\u0002\u0002\u0003\u0007Q*A\u0002yIE\n\u0011B]3g\u0007>,h\u000e\u001e\u0011\u0002\u000b\tLH/Z:\u0016\u0003=\u00042A\u00149s\u0013\t\txJA\u0003BeJ\f\u0017\u0010\u0005\u0002Og&\u0011Ao\u0014\u0002\u0005\u0005f$X-\u0001\u0004csR,7\u000fI\u0001\u0006G2|7/\u001a\u000b\u0002O\u0006IR.\u0019=Ok6\u0014WM](g\u001d>tg*\u001e7m\u0005V\u001c7.\u001a;t\u0003ii\u0017\r\u001f(v[\n,'o\u00144O_:tU\u000f\u001c7Ck\u000e\\W\r^:!\u0003\u001d\u0011WoY6fiN,\u0012\u0001 \t\u0005{\u0006\u0015\u0011-D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019aT\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0004}\nY\u0011I\u001d:bs\n+hMZ3s\u0003!\u0011WoY6fiN\u0004\u0013!E8mI\u0016\u001cHOQ;dW\u0016$\u0018J\u001c3fq\u0006)r\u000e\u001c3fgR\u0014UoY6fi&sG-\u001a=`I\u0015\fHcA4\u0002\u0012!91NEA\u0001\u0002\u0004i\u0015AE8mI\u0016\u001cHOQ;dW\u0016$\u0018J\u001c3fq\u0002\n\u0011cY;s\u0005f$X\rU8tSRLwN\u001c\u0019c+\t\tI\u0002E\u0002O\u00037I1!!\bP\u0005\u0011auN\\4\u0002+\r,(OQ=uKB{7/\u001b;j_:\u0004$m\u0018\u0013fcR\u0019q-a\t\t\u0011-,\u0012\u0011!a\u0001\u00033\t!cY;s\u0005f$X\rU8tSRLwN\u001c\u0019cA\u0005\u0011Bo\u001c;bY\nKH/Z:Ck\u000e\\W\r^3e\u0003Y!x\u000e^1m\u0005f$Xm\u001d\"vG.,G/\u001a3`I\u0015\fHcA4\u0002.!A1\u000eGA\u0001\u0002\u0004\tI\"A\nu_R\fGNQ=uKN\u0014UoY6fi\u0016$\u0007%A#pe\u001e$\u0013\r]1dQ\u0016$C-\u00194g_\u0012LG\u000eJ5pI\t+8m[3uS:<\u0017J\u001c9viN{WO]2fI\u0011BW-\u00193Ck\u000e\\W\r\u001e\"zi\u0016\u0004vn]5uS>t\u0007GY\u0001J_J<G%\u00199bG\",G\u0005Z1gM>$\u0017\u000e\u001c\u0013j_\u0012\u0012UoY6fi&tw-\u00138qkR\u001cv.\u001e:dK\u0012\"\u0003.Z1e\u0005V\u001c7.\u001a;CsR,\u0007k\\:ji&|g\u000e\r2`I\u0015\fHcA4\u00028!A1nGA\u0001\u0002\u0004\tI\"\u0001$pe\u001e$\u0013\r]1dQ\u0016$C-\u00194g_\u0012LG\u000eJ5pI\t+8m[3uS:<\u0017J\u001c9viN{WO]2fI\u0011BW-\u00193Ck\u000e\\W\r\u001e\"zi\u0016\u0004vn]5uS>t\u0007G\u0019\u0011\u0002/\tLH/Z:GS2dW\rZ%o\u0019\u0006\u001cHOQ;dW\u0016$\u0018a\u00072zi\u0016\u001ch)\u001b7mK\u0012Le\u000eT1ti\n+8m[3u?\u0012*\u0017\u000fF\u0002h\u0003\u0003Bqa\u001b\u0010\u0002\u0002\u0003\u0007Q*\u0001\rcsR,7OR5mY\u0016$\u0017J\u001c'bgR\u0014UoY6fi\u0002\n1\u0002[1t\u001b>\u0014X\rR1uCV\u0011\u0011\u0011\n\t\u0004\u001d\u0006-\u0013bAA'\u001f\n9!i\\8mK\u0006t\u0017a\u00045bg6{'/\u001a#bi\u0006|F%Z9\u0015\u0007\u001d\f\u0019\u0006\u0003\u0005lC\u0005\u0005\t\u0019AA%\u00031A\u0017m]'pe\u0016$\u0015\r^1!\u0003MA\u0017m\u001d*fC\u000eDW\rZ#oI>3G)\u0019;b\u0003I1\u0017\u000e\u001c7Ck\u000e\\W\r^:U_&sG-\u001a=\u0015\r\u0005%\u0013QLA1\u0011\u001d\ty\u0006\na\u0001\u00033\tqbZ8bY\n+8m[3u\u0013:$W\r\u001f\u0005\b\u0003G\"\u0003\u0019AA\r\u0003M\u0011\u0017\u0010^3t\u001d\u0016,G-\u001a3J]\n+8m[3u\u0003Y\u0011\u0017\u0010^3Q_NLG/[8o)>Le\u000eZ5dS\u0016\u001cH\u0003BA5\u0003_\u0002rATA6\u00033\tI\"C\u0002\u0002n=\u0013a\u0001V;qY\u0016\u0014\u0004bBA9K\u0001\u0007\u0011\u0011D\u0001\nEf$X\rU8ta\tD3!JA;!\rq\u0015qO\u0005\u0004\u0003sz%AB5oY&tW-A\tbe\u0016\u0014\u0015\u0010^3t\u0003Z\f\u0017\u000e\\1cY\u0016$B!!\u0013\u0002\u0000!9\u0011\u0011\u0011\u0014A\u0002\u0005e\u0011A\u00028CsR,7/A\nl]><hNQ=uKN\fe/Y5mC\ndW\r\u0006\u0002\u0002\u001a\u0005\u0019q-\u001a;\u0015\u00035#\u0002\"!\u0013\u0002\u000e\u0006E\u0015Q\u0013\u0005\u0007\u0003\u001fK\u0003\u0019A8\u0002\t\u0011,7\u000f\u001e\u0005\u0007\u0003'K\u0003\u0019A'\u0002\u0007=4g\r\u0003\u0004\u0002\u0018&\u0002\r!T\u0001\u0004Y\u0016t\u0017\u0001\u00039pg&$\u0018n\u001c8\u0015\u0007\u001d\fi\nC\u0004\u0002r-\u0002\r!!\u0007\u0002\u00191|7m\u001b)pg&$\u0018n\u001c8\u0015\u0007\u001d\f\u0019\u000bC\u0004\u0002r1\u0002\r!!\u0007\u0002\u001fI,G.Z1tKB{7/\u001b;j_:$2aZAU\u0011\u001d\t\t(\fa\u0001\u00033\taB]3mK\u0006\u001cXMQ;dW\u0016$8/A\u0004d_6\u0004\u0018m\u0019;\u0002)\t+8m[3uS:<\u0017J\u001c9viN{WO]2f!\t\t\u0015g\u0005\u00022;R\u0011\u0011\u0011W\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m&fA'\u0002>.\u0012\u0011q\u0018\t\u0005\u0003\u0003\fY-\u0004\u0002\u0002D*!\u0011QYAd\u0003%)hn\u00195fG.,GMC\u0002\u0002J>\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti-a1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r")
public class BucketingInputSource
extends InputSource {
    private final InputStream inputStream;
    public final int org$apache$daffodil$io$BucketingInputSource$$bucketSize;
    private final int maxCacheSizeInBytes;
    private final int maxNumberOfNonNullBuckets;
    private final ArrayBuffer<Bucket> buckets;
    private int oldestBucketIndex;
    private long curBytePosition0b;
    private long totalBytesBucketed;
    private long org$apache$daffodil$io$BucketingInputSource$$headBucketBytePosition0b;
    private int bytesFilledInLastBucket;
    private boolean hasMoreData;

    public static int $lessinit$greater$default$3() {
        return BucketingInputSource$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return BucketingInputSource$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void close() {
        this.inputStream.close();
    }

    private int maxNumberOfNonNullBuckets() {
        return this.maxNumberOfNonNullBuckets;
    }

    private ArrayBuffer<Bucket> buckets() {
        return this.buckets;
    }

    private int oldestBucketIndex() {
        return this.oldestBucketIndex;
    }

    private void oldestBucketIndex_$eq(int x$1) {
        this.oldestBucketIndex = x$1;
    }

    private long curBytePosition0b() {
        return this.curBytePosition0b;
    }

    private void curBytePosition0b_$eq(long x$1) {
        this.curBytePosition0b = x$1;
    }

    private long totalBytesBucketed() {
        return this.totalBytesBucketed;
    }

    private void totalBytesBucketed_$eq(long x$1) {
        this.totalBytesBucketed = x$1;
    }

    public long org$apache$daffodil$io$BucketingInputSource$$headBucketBytePosition0b() {
        return this.org$apache$daffodil$io$BucketingInputSource$$headBucketBytePosition0b;
    }

    private void org$apache$daffodil$io$BucketingInputSource$$headBucketBytePosition0b_$eq(long x$1) {
        this.org$apache$daffodil$io$BucketingInputSource$$headBucketBytePosition0b = x$1;
    }

    private int bytesFilledInLastBucket() {
        return this.bytesFilledInLastBucket;
    }

    private void bytesFilledInLastBucket_$eq(int x$1) {
        this.bytesFilledInLastBucket = x$1;
    }

    private boolean hasMoreData() {
        return this.hasMoreData;
    }

    private void hasMoreData_$eq(boolean x$1) {
        this.hasMoreData = x$1;
    }

    @Override
    public boolean hasReachedEndOfData() {
        return !this.hasMoreData();
    }

    private boolean fillBucketsToIndex(long goalBucketIndex, long bytesNeededInBucket) {
        boolean needsMoreData;
        int lastBucketIndex = this.buckets().length() - 1;
        boolean bl = needsMoreData = goalBucketIndex > (long)lastBucketIndex || goalBucketIndex == (long)lastBucketIndex && bytesNeededInBucket > (long)this.bytesFilledInLastBucket();
        while (needsMoreData && this.hasMoreData()) {
            int emptyBytesInLastBucket = this.org$apache$daffodil$io$BucketingInputSource$$bucketSize - this.bytesFilledInLastBucket();
            if (emptyBytesInLastBucket <= 0) {
                throw Assert$.MODULE$.abort("Invariant broken: emptyBytesInLastBucket.>(0)");
            }
            int bytesRead = this.inputStream.read(((Bucket)this.buckets().apply(lastBucketIndex)).bytes(), this.bytesFilledInLastBucket(), emptyBytesInLastBucket);
            if (bytesRead == 0) {
                throw new InputStreamReadZeroError(this.inputStream);
            }
            if (bytesRead == -1) {
                this.hasMoreData_$eq(false);
                continue;
            }
            this.totalBytesBucketed_$eq(this.totalBytesBucketed() + (long)bytesRead);
            this.bytesFilledInLastBucket_$eq(this.bytesFilledInLastBucket() + bytesRead);
            if (this.bytesFilledInLastBucket() == this.org$apache$daffodil$io$BucketingInputSource$$bucketSize) {
                this.buckets().$plus$eq((Object)new Bucket());
                this.bytesFilledInLastBucket_$eq(0);
                if (++lastBucketIndex - this.oldestBucketIndex() >= this.maxNumberOfNonNullBuckets()) {
                    this.buckets().update(this.oldestBucketIndex(), null);
                    this.oldestBucketIndex_$eq(this.oldestBucketIndex() + 1);
                }
            }
            if (((long)lastBucketIndex != goalBucketIndex || bytesNeededInBucket > (long)this.bytesFilledInLastBucket()) && (long)lastBucketIndex <= goalBucketIndex) continue;
            needsMoreData = false;
        }
        return !needsMoreData;
    }

    private final Tuple2<Object, Object> bytePositionToIndicies(long bytePos0b) {
        long offsetBytePosition0b = bytePos0b - this.org$apache$daffodil$io$BucketingInputSource$$headBucketBytePosition0b();
        long bucketIndex = offsetBytePosition0b / (long)this.org$apache$daffodil$io$BucketingInputSource$$bucketSize;
        long byteIndex = offsetBytePosition0b % (long)this.org$apache$daffodil$io$BucketingInputSource$$bucketSize;
        return new Tuple2.mcJJ.sp(bucketIndex, byteIndex);
    }

    @Override
    public boolean areBytesAvailable(long nBytes) {
        long finalBytePosition0b = this.curBytePosition0b() + nBytes;
        if (finalBytePosition0b <= this.totalBytesBucketed()) {
            return true;
        }
        Tuple2<Object, Object> tuple2 = this.bytePositionToIndicies(finalBytePosition0b);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long bucketIndex = tuple2._1$mcJ$sp();
        long byteIndex = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(bucketIndex, byteIndex);
        long bucketIndex2 = sp2._1$mcJ$sp();
        long byteIndex2 = sp2._2$mcJ$sp();
        if (bucketIndex2 < (long)this.oldestBucketIndex()) {
            throw Assert$.MODULE$.abort("Invariant broken: bucketIndex.>=(BucketingInputSource.this.oldestBucketIndex)");
        }
        boolean filled = this.fillBucketsToIndex(bucketIndex2, byteIndex2);
        return filled;
    }

    @Override
    public long knownBytesAvailable() {
        long available = 0L;
        Tuple2<Object, Object> tuple2 = this.bytePositionToIndicies(this.curBytePosition0b());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long curBucketIndex = tuple2._1$mcJ$sp();
        long curByteIndex = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(curBucketIndex, curByteIndex);
        long curBucketIndex2 = sp2._1$mcJ$sp();
        long curByteIndex2 = sp2._2$mcJ$sp();
        for (long i = curBucketIndex2; i < (long)this.buckets().length(); ++i) {
            long startByteIndex = i == curBucketIndex2 ? curByteIndex2 : 0L;
            int endByteIndex = i == (long)(this.buckets().length() - 1) ? this.bytesFilledInLastBucket() : this.org$apache$daffodil$io$BucketingInputSource$$bucketSize;
            long bytesAvailableInBucket = (long)endByteIndex - startByteIndex;
            available += bytesAvailableInBucket;
        }
        return available;
    }

    @Override
    public int get() {
        boolean hasByte = this.areBytesAvailable(1L);
        if (!hasByte) {
            return -1;
        }
        Tuple2<Object, Object> tuple2 = this.bytePositionToIndicies(this.curBytePosition0b());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long bucketIndex = tuple2._1$mcJ$sp();
        long byteIndex = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(bucketIndex, byteIndex);
        long bucketIndex2 = sp2._1$mcJ$sp();
        long byteIndex2 = sp2._2$mcJ$sp();
        if (bucketIndex2 < 0L || this.buckets().apply((int)bucketIndex2) == null) {
            throw new BacktrackingException(this.curBytePosition0b(), this.maxCacheSizeInBytes);
        }
        byte by = ((Bucket)this.buckets().apply((int)bucketIndex2)).bytes()[(int)byteIndex2];
        this.curBytePosition0b_$eq(this.curBytePosition0b() + 1L);
        return by & 0xFF;
    }

    @Override
    public boolean get(byte[] dest, int off, int len) {
        if (dest.length - off < len) {
            throw Assert$.MODULE$.abort("Invariant broken: dest.length.-(off).>=(len)");
        }
        boolean hasBytes = this.areBytesAvailable(len);
        if (!hasBytes) {
            return false;
        }
        Tuple2<Object, Object> tuple2 = this.bytePositionToIndicies(this.curBytePosition0b());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long bucketIndex = tuple2._1$mcJ$sp();
        long byteIndex = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(bucketIndex, byteIndex);
        long bucketIndex2 = sp2._1$mcJ$sp();
        long byteIndex2 = sp2._2$mcJ$sp();
        int bytesStillToGet = len;
        int destOffset = off;
        while (bytesStillToGet > 0) {
            int bytesToGetFromCurrentBucket = (int)Math.min((long)this.org$apache$daffodil$io$BucketingInputSource$$bucketSize - byteIndex2, (long)bytesStillToGet);
            if (bucketIndex2 < 0L || this.buckets().apply((int)bucketIndex2) == null) {
                throw new BacktrackingException(this.curBytePosition0b(), this.maxCacheSizeInBytes);
            }
            Array$.MODULE$.copy((Object)((Bucket)this.buckets().apply((int)bucketIndex2)).bytes(), (int)byteIndex2, (Object)dest, destOffset, bytesToGetFromCurrentBucket);
            destOffset += bytesToGetFromCurrentBucket;
            bytesStillToGet -= bytesToGetFromCurrentBucket;
            ++bucketIndex2;
            byteIndex2 = 0L;
        }
        this.curBytePosition0b_$eq(this.curBytePosition0b() + (long)len);
        return true;
    }

    @Override
    public long position() {
        return this.curBytePosition0b();
    }

    @Override
    public void position(long bytePos0b) {
        Tuple2<Object, Object> tuple2 = this.bytePositionToIndicies(bytePos0b);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long bucketIndex = tuple2._1$mcJ$sp();
        long bucketIndex2 = bucketIndex;
        if (bucketIndex2 >= (long)this.buckets().length()) {
            throw Assert$.MODULE$.abort("Invariant broken: bucketIndex.<(BucketingInputSource.this.buckets.length)");
        }
        this.curBytePosition0b_$eq(bytePos0b);
    }

    @Override
    public void lockPosition(long bytePos0b) {
        Tuple2<Object, Object> tuple2 = this.bytePositionToIndicies(bytePos0b);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long bucketIndex = tuple2._1$mcJ$sp();
        long bucketIndex2 = bucketIndex;
        if (bucketIndex2 >= (long)this.buckets().length()) {
            throw Assert$.MODULE$.abort("Invariant broken: bucketIndex.<(BucketingInputSource.this.buckets.length)");
        }
        if (this.buckets().apply((int)bucketIndex2) != null) {
            Bucket bucket = (Bucket)this.buckets().apply((int)bucketIndex2);
            bucket.refCount_$eq(bucket.refCount() + 1);
            return;
        }
    }

    @Override
    public void releasePosition(long bytePos0b) {
        Tuple2<Object, Object> tuple2 = this.bytePositionToIndicies(bytePos0b);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long bucketIndex = tuple2._1$mcJ$sp();
        long bucketIndex2 = bucketIndex;
        if (this.buckets().apply((int)bucketIndex2) != null) {
            if (bucketIndex2 < (long)this.oldestBucketIndex() || bucketIndex2 >= (long)this.buckets().length()) {
                throw Assert$.MODULE$.abort("Invariant broken: bucketIndex.>=(BucketingInputSource.this.oldestBucketIndex).&&(bucketIndex.<(BucketingInputSource.this.buckets.length))");
            }
            Bucket bucket = (Bucket)this.buckets().apply((int)bucketIndex2);
            bucket.refCount_$eq(bucket.refCount() - 1);
        }
        if (((Bucket)this.buckets().apply(this.oldestBucketIndex())).refCount() == 0) {
            this.releaseBuckets();
            return;
        }
    }

    private void releaseBuckets() {
        if (!this.areDebugging()) {
            Tuple2<Object, Object> tuple2 = this.bytePositionToIndicies(this.curBytePosition0b());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long curBucketIndex = tuple2._1$mcJ$sp();
            long curBucketIndex2 = curBucketIndex;
            while ((long)this.oldestBucketIndex() < curBucketIndex2 && ((Bucket)this.buckets().apply(this.oldestBucketIndex())).refCount() == 0) {
                this.buckets().update(this.oldestBucketIndex(), null);
                this.oldestBucketIndex_$eq(this.oldestBucketIndex() + 1);
            }
            return;
        }
    }

    @Override
    public void compact() {
        this.releaseBuckets();
        this.buckets().remove(0, this.oldestBucketIndex());
        int bytesRemoved = this.oldestBucketIndex() * this.org$apache$daffodil$io$BucketingInputSource$$bucketSize;
        this.org$apache$daffodil$io$BucketingInputSource$$headBucketBytePosition0b_$eq(this.org$apache$daffodil$io$BucketingInputSource$$headBucketBytePosition0b() + (long)bytesRemoved);
        this.oldestBucketIndex_$eq(0);
    }

    public BucketingInputSource(InputStream inputStream, int bucketSize, int maxCacheSizeInBytes) {
        this.inputStream = inputStream;
        this.org$apache$daffodil$io$BucketingInputSource$$bucketSize = bucketSize;
        this.maxCacheSizeInBytes = maxCacheSizeInBytes;
        this.maxNumberOfNonNullBuckets = Math.max(maxCacheSizeInBytes / bucketSize, 2);
        ArrayBuffer b = new ArrayBuffer();
        b.$plus$eq((Object)new Bucket());
        this.buckets = b;
        this.oldestBucketIndex = 0;
        this.curBytePosition0b = 0L;
        this.totalBytesBucketed = 0L;
        this.org$apache$daffodil$io$BucketingInputSource$$headBucketBytePosition0b = 0L;
        this.bytesFilledInLastBucket = 0;
        this.hasMoreData = true;
    }

    private class Bucket {
        private int refCount;
        private final byte[] bytes;

        public int refCount() {
            return this.refCount;
        }

        public void refCount_$eq(int x$1) {
            this.refCount = x$1;
        }

        public byte[] bytes() {
            return this.bytes;
        }

        public /* synthetic */ BucketingInputSource org$apache$daffodil$io$BucketingInputSource$Bucket$$$outer() {
            return BucketingInputSource.this;
        }

        public Bucket() {
            if (BucketingInputSource.this == null) {
                throw null;
            }
            this.refCount = 0;
            this.bytes = new byte[BucketingInputSource.this.org$apache$daffodil$io$BucketingInputSource$$bucketSize];
        }
    }
}

