/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.calendar.DFDLDate;
import org.apache.daffodil.calendar.DFDLDateConversion$;
import org.apache.daffodil.calendar.DFDLDateTime;
import org.apache.daffodil.calendar.DFDLDateTimeConversion$;
import org.apache.daffodil.calendar.DFDLTime;
import org.apache.daffodil.calendar.DFDLTimeConversion$;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.util.Maybe$;
import org.apache.daffodil.util.Misc$;
import org.apache.daffodil.xml.NS;
import org.apache.daffodil.xml.NS$;
import org.apache.daffodil.xml.PrettyPrinter;
import org.apache.daffodil.xml.XMLUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.xml.Atom;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.Elem$;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.PrefixedAttribute$;
import scala.xml.ProcInstr;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.Unparsed;

public final class XMLUtils$ {
    public static XMLUtils$ MODULE$;
    private final PrefixedAttribute xmlNilAttribute;
    private final String PositiveInfinityString;
    private final String NegativeInfinityString;
    private final String NaNString;
    private final NS XSD_NAMESPACE;
    private final NS XSI_NAMESPACE;
    private final NS XPATH_FUNCTION_NAMESPACE;
    private final NS XPATH_MATH_NAMESPACE;
    private final NS DFDL_NAMESPACE;
    private final NS DFDLX_NAMESPACE;
    private final NS TDML_NAMESPACE;
    private final NS EXAMPLE_NAMESPACE;
    private final NS XHTML_NAMESPACE;
    private final String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA;
    private final NS DAFFODIL_EXTENSION_NAMESPACE_NCSA;
    private final String EXT_PREFIX_NCSA;
    private final NS EXT_NS_NCSA;
    private final String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_APACHE;
    private final NS DAFFODIL_EXTENSION_NAMESPACE_APACHE;
    private final String EXT_PREFIX_APACHE;
    private final NS EXT_NS_APACHE;
    private final NS DAFFODIL_INTERNAL_NAMESPACE;
    private final String INT_PREFIX;
    private final NS INT_NS;
    private final String FILE_ATTRIBUTE_NAME;
    private final String LINE_ATTRIBUTE_NAME;
    private final String COLUMN_ATTRIBUTE_NAME;
    private final NS xsdURI;
    private final NS dfdlURI;
    private final NS dfdlxURI;
    private final NS dfdlAppinfoSource;
    private final NS targetNS;
    private final NS xsiURI;
    private final NS fnURI;
    private final NS mathURI;
    private final NS dafintURI;
    private final List<String> DFDL_SIMPLE_BUILT_IN_TYPES;
    private final Function1<Object, Object> escapeMapper;

    static {
        new XMLUtils$();
    }

    public PrefixedAttribute xmlNilAttribute() {
        return this.xmlNilAttribute;
    }

    public String PositiveInfinityString() {
        return this.PositiveInfinityString;
    }

    public String NegativeInfinityString() {
        return this.NegativeInfinityString;
    }

    public String NaNString() {
        return this.NaNString;
    }

    public char remapXMLIllegalCharToPUA(boolean checkForExistingPUA, boolean replaceCRWithLF, char c) {
        char c2;
        char cInt = c;
        char c3 = cInt;
        if ('\t' == c3) {
            c2 = c;
        } else if ('\n' == c3) {
            c2 = c;
        } else if ('\r' == c3) {
            c2 = replaceCRWithLF ? (char)10 : (char)57357;
        } else if (cInt < ' ') {
            c2 = (char)(cInt + 57344);
        } else if (cInt > '\ud7ff' && cInt < '\ue000') {
            c2 = (char)(cInt + 4096);
        } else if (cInt >= '\ue000' && cInt <= '\uf8ff') {
            if (checkForExistingPUA) {
                throw Assert$.MODULE$.usageError(new StringOps(Predef$.MODULE$.augmentString("Pre-existing Private Use Area (PUA) character found in data: '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)})));
            }
            c2 = c;
        } else if ('\ufffe' == c3) {
            c2 = (char)61694;
        } else if ('\uffff' == c3) {
            c2 = (char)61695;
        } else {
            if (cInt > '\u10ffff') {
                throw Assert$.MODULE$.invariantFailed(new StringOps(Predef$.MODULE$.augmentString("Character code beyond U+10FFFF found in data. Codepoint: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)cInt)})));
            }
            c2 = c;
        }
        char res = c2;
        return res;
    }

    public boolean remapXMLIllegalCharToPUA$default$1() {
        return true;
    }

    public boolean remapXMLIllegalCharToPUA$default$2() {
        return true;
    }

    public boolean needsXMLToPUARemapping(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            if (!(v < ' ' && v != '\n' && v != '\t' || v > '\ud7ff' && v < '\ue000' || v >= '\ue000' && v <= '\uf8ff' || v == '\ufffe' || v == '\uffff') && v <= '\u10ffff') continue;
            return true;
        }
        return false;
    }

    public char remapPUAToXMLIllegalChar(boolean checkForExistingPUA, char c) {
        char c2;
        char cInt;
        char c3 = cInt = c;
        if (c >= '\ue000' && c < '\ue020') {
            c2 = (char)(c - 57344);
        } else if (c > '\ue7ff' && c < '\uf000') {
            c2 = (char)(c - 4096);
        } else if ('\uf0fe' == c3) {
            c2 = (char)65534;
        } else if ('\uf0ff' == c3) {
            c2 = (char)65535;
        } else {
            if (c > '\u10ffff') {
                throw Assert$.MODULE$.invariantFailed(new StringOps(Predef$.MODULE$.augmentString("Character code beyond U+10FFFF found in data. Codepoint: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
            }
            c2 = c;
        }
        char res = c2;
        return res;
    }

    public boolean remapPUAToXMLIllegalChar$default$1() {
        return true;
    }

    public boolean needsPUAToXMLRemapping(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            if (!(v == '\r' || v >= '\ue000' && v < '\ue020' || v > '\ue7ff' && v < '\uf000' || v == '\uf0fe' || v == '\uf0ff') && v <= '\u10ffff') continue;
            return true;
        }
        return false;
    }

    public boolean isLeadingSurrogate(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    public boolean isTrailingSurrogate(char c) {
        return c >= '\udc00' && c <= '\udfff';
    }

    /*
     * WARNING - void declaration
     */
    public int uncodeLength(String s) {
        void var2_2;
        int res = s.getBytes("UTF-32BE").length / 4;
        return (int)var2_2;
    }

    public <T> Seq<T> walkUnicodeString(String str, Function3<Object, Object, Object, T> bodyFunc) {
        int len = str.length();
        if (len == 0) {
            return Nil$.MODULE$;
        }
        ListBuffer list = new ListBuffer();
        char prev = (char)0;
        char curr = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), 0);
        char next = (char)0;
        for (int pos = 0; pos < len; ++pos) {
            next = pos + 1 < len ? StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), pos + 1) : (char)0;
            list.$plus$eq(bodyFunc.apply((Object)BoxesRunTime.boxToCharacter((char)prev), (Object)BoxesRunTime.boxToCharacter((char)curr), (Object)BoxesRunTime.boxToCharacter((char)next)));
            prev = curr;
            curr = next;
        }
        return list;
    }

    public String remapXMLCharacters(String dfdlString, Function1<Object, Object> remapFunc) {
        int len = dfdlString.length();
        if (len == 0) {
            return dfdlString;
        }
        StringBuilder sb = new StringBuilder();
        char prev = (char)0;
        char curr = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dfdlString), 0);
        char next = (char)0;
        for (int pos = 0; pos < len; ++pos) {
            char c = next = pos + 1 < len ? StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dfdlString), pos + 1) : (char)0;
            Object object = curr == '\r' ? (next != '\n' ? sb.append((char)10) : BoxedUnit.UNIT) : sb.append(this.remapOneChar$1(prev, curr, next, remapFunc));
            prev = curr;
            curr = next;
        }
        return sb.toString();
    }

    public String remapXMLIllegalCharactersToPUA(String dfdlString) {
        String string;
        if (this.needsXMLToPUARemapping(dfdlString)) {
            boolean bl = this.remapXMLIllegalCharToPUA$default$2();
            string = this.remapXMLCharacters(dfdlString, (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)XMLUtils$.MODULE$.remapXMLIllegalCharToPUA(false, bl, BoxesRunTime.unboxToChar((Object)c))));
        } else {
            string = dfdlString;
        }
        return string;
    }

    public String remapPUAToXMLIllegalCharacters(String dfdlString) {
        return this.needsPUAToXMLRemapping(dfdlString) ? this.remapXMLCharacters(dfdlString, (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)XMLUtils$.MODULE$.remapPUAToXMLIllegalChar(false, BoxesRunTime.unboxToChar((Object)c)))) : dfdlString;
    }

    public Node coalesceAllAdjacentTextNodes(Node node) {
        Node node2;
        Node node3 = node;
        Option option = Elem$.MODULE$.unapplySeq(node3);
        if (!option.isEmpty()) {
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attribs = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq child = (Seq)((Tuple5)option.get())._5();
            Seq coalescedChildren = (Seq)child.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.coalesceAllAdjacentTextNodes((Node)x$1), Seq$.MODULE$.canBuildFrom());
            Seq<Node> newChildren = this.coalesceAdjacentTextNodes((Seq<Node>)coalescedChildren);
            node2 = Elem$.MODULE$.apply(prefix, label, attribs, scope, true, newChildren);
        } else {
            node2 = node3;
        }
        return node2;
    }

    public Seq<Node> coalesceAdjacentTextNodes(Seq<Node> seq) {
        if (seq.length() == 0) {
            return seq;
        }
        if (seq.length() == 1) {
            Node node = (Node)seq.apply(0);
            if (node instanceof Atom) {
                return seq;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ArrayBuilder ab = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Node.class));
        int i = 0;
        ObjectRef tn = ObjectRef.create(null);
        ObjectRef sb = ObjectRef.create(null);
        while (i < seq.length()) {
            Builder builder;
            Node current = (Node)seq.apply(i);
            ++i;
            if (current instanceof Text || current instanceof Unparsed) {
                if ((Node)tn.elem == null) {
                    if ((StringBuilder)sb.elem == null || ((StringBuilder)sb.elem).length() == 0) {
                        tn.elem = current;
                        builder = BoxedUnit.UNIT;
                        continue;
                    }
                    builder = ((StringBuilder)sb.elem).append(current.text());
                    continue;
                }
                if ((StringBuilder)sb.elem == null) {
                    sb.elem = new StringBuilder();
                }
                ((StringBuilder)sb.elem).append(((Node)tn.elem).text());
                ((StringBuilder)sb.elem).append(current.text());
                tn.elem = null;
                builder = BoxedUnit.UNIT;
                continue;
            }
            XMLUtils$.processText$1(tn, sb, ab);
            builder = ab.$plus$eq((Object)current);
        }
        XMLUtils$.processText$1(tn, sb, ab);
        return Predef$.MODULE$.wrapRefArray((Object[])ab.result());
    }

    public NS XSD_NAMESPACE() {
        return this.XSD_NAMESPACE;
    }

    public NS XSI_NAMESPACE() {
        return this.XSI_NAMESPACE;
    }

    public NS XPATH_FUNCTION_NAMESPACE() {
        return this.XPATH_FUNCTION_NAMESPACE;
    }

    public NS XPATH_MATH_NAMESPACE() {
        return this.XPATH_MATH_NAMESPACE;
    }

    public NS DFDL_NAMESPACE() {
        return this.DFDL_NAMESPACE;
    }

    public NS DFDLX_NAMESPACE() {
        return this.DFDLX_NAMESPACE;
    }

    public NS TDML_NAMESPACE() {
        return this.TDML_NAMESPACE;
    }

    public NS EXAMPLE_NAMESPACE() {
        return this.EXAMPLE_NAMESPACE;
    }

    public NS XHTML_NAMESPACE() {
        return this.XHTML_NAMESPACE;
    }

    public Elem getXSDElement(NamespaceBinding scope) {
        String string;
        boolean isXSDTheDefaultNS;
        String xsdPre = scope.getPrefix(this.XSD_NAMESPACE().toString());
        String string2 = this.XSD_NAMESPACE().toString();
        String string3 = scope.getURI(null);
        boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? true : (isXSDTheDefaultNS = false);
        if (xsdPre != null) {
            string = xsdPre;
        } else if (isXSDTheDefaultNS) {
            string = null;
        } else {
            throw Assert$.MODULE$.usageError("Scope argument must have a binding for the XSD namespace.");
        }
        String xsdPrefix = string;
        Elem res = Elem$.MODULE$.apply(xsdPrefix, "element", (MetaData)Null$.MODULE$, scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        return res;
    }

    private String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA() {
        return this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA;
    }

    private NS DAFFODIL_EXTENSION_NAMESPACE_NCSA() {
        return this.DAFFODIL_EXTENSION_NAMESPACE_NCSA;
    }

    public String EXT_PREFIX_NCSA() {
        return this.EXT_PREFIX_NCSA;
    }

    public NS EXT_NS_NCSA() {
        return this.EXT_NS_NCSA;
    }

    private String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_APACHE() {
        return this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_APACHE;
    }

    private NS DAFFODIL_EXTENSION_NAMESPACE_APACHE() {
        return this.DAFFODIL_EXTENSION_NAMESPACE_APACHE;
    }

    public String EXT_PREFIX_APACHE() {
        return this.EXT_PREFIX_APACHE;
    }

    public NS EXT_NS_APACHE() {
        return this.EXT_NS_APACHE;
    }

    private NS DAFFODIL_INTERNAL_NAMESPACE() {
        return this.DAFFODIL_INTERNAL_NAMESPACE;
    }

    public String INT_PREFIX() {
        return this.INT_PREFIX;
    }

    public NS INT_NS() {
        return this.INT_NS;
    }

    public String FILE_ATTRIBUTE_NAME() {
        return this.FILE_ATTRIBUTE_NAME;
    }

    public String LINE_ATTRIBUTE_NAME() {
        return this.LINE_ATTRIBUTE_NAME;
    }

    public String COLUMN_ATTRIBUTE_NAME() {
        return this.COLUMN_ATTRIBUTE_NAME;
    }

    public NS xsdURI() {
        return this.xsdURI;
    }

    public NS dfdlURI() {
        return this.dfdlURI;
    }

    public NS dfdlxURI() {
        return this.dfdlxURI;
    }

    public NS dfdlAppinfoSource() {
        return this.dfdlAppinfoSource;
    }

    public NS targetNS() {
        return this.targetNS;
    }

    public NS xsiURI() {
        return this.xsiURI;
    }

    public NS fnURI() {
        return this.fnURI;
    }

    public NS mathURI() {
        return this.mathURI;
    }

    public NS dafintURI() {
        return this.dafintURI;
    }

    public List<String> DFDL_SIMPLE_BUILT_IN_TYPES() {
        return this.DFDL_SIMPLE_BUILT_IN_TYPES;
    }

    public String slashify(String s) {
        String string = s;
        String string2 = "";
        return !(string == null ? string2 != null : !string.equals(string2)) || s.endsWith("/") ? s : new java.lang.StringBuilder(1).append(s).append("/").toString();
    }

    public Seq<NamespaceBinding> namespaceBindings(NamespaceBinding nsBinding) {
        Nil$ nil$;
        if (nsBinding == null) {
            nil$ = Nil$.MODULE$;
        } else {
            Nil$ thisOne = nsBinding.uri() != null ? new .colon.colon((Object)nsBinding, (List)Nil$.MODULE$) : Nil$.MODULE$;
            Seq<NamespaceBinding> others = this.namespaceBindings(nsBinding.parent());
            nil$ = (Seq)thisOne.$plus$plus(others, List$.MODULE$.canBuildFrom());
        }
        return nil$;
    }

    public MetaData dfdlAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dfdlAttributes$1(n, x$2)));
    }

    public MetaData dfdlxAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dfdlxAttributes$1(n, x$3)));
    }

    public MetaData dafAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dafAttributes$1(n, a)));
    }

    public NamespaceBinding combineScopes(NamespaceBinding local, NamespaceBinding outer) {
        NamespaceBinding namespaceBinding;
        block5: {
            String outerURI;
            NamespaceBinding moreBindings;
            String uri;
            String pre;
            while (true) {
                NamespaceBinding namespaceBinding2 = local;
                TopScope$ topScope$ = TopScope$.MODULE$;
                if (!(namespaceBinding2 != null ? !namespaceBinding2.equals(topScope$) : topScope$ != null)) {
                    namespaceBinding = outer;
                    break block5;
                }
                NamespaceBinding namespaceBinding3 = local;
                if (namespaceBinding3 == null) {
                    throw new MatchError((Object)namespaceBinding3);
                }
                String pre2 = namespaceBinding3.prefix();
                String uri2 = namespaceBinding3.uri();
                NamespaceBinding moreBindings2 = namespaceBinding3.parent();
                Tuple3 tuple3 = new Tuple3((Object)pre2, (Object)uri2, (Object)moreBindings2);
                Tuple3 tuple32 = tuple3;
                pre = (String)tuple32._1();
                uri = (String)tuple32._2();
                moreBindings = (NamespaceBinding)tuple32._3();
                String string = outerURI = outer.getURI(pre);
                String string2 = uri;
                if (string != null ? !string.equals(string2) : string2 != null) break;
                local = moreBindings;
            }
            if (outerURI == null) {
                namespaceBinding = new NamespaceBinding(pre, uri, this.combineScopes(moreBindings, outer));
            } else {
                NamespaceBinding outerWithoutDuplicate = this.removeBindings(new NamespaceBinding(pre, uri, (NamespaceBinding)TopScope$.MODULE$), outer);
                NamespaceBinding moreBindingsWithoutConflict = this.removeBindings(new NamespaceBinding(pre, uri, (NamespaceBinding)TopScope$.MODULE$), moreBindings);
                namespaceBinding = new NamespaceBinding(pre, uri, this.combineScopes(moreBindingsWithoutConflict, outerWithoutDuplicate));
            }
        }
        return namespaceBinding;
    }

    public NamespaceBinding removeBindings(NamespaceBinding nb, NamespaceBinding scope) {
        NamespaceBinding namespaceBinding;
        block4: {
            NamespaceBinding more;
            while (true) {
                NamespaceBinding namespaceBinding2 = nb;
                TopScope$ topScope$ = TopScope$.MODULE$;
                if (!(namespaceBinding2 != null ? !namespaceBinding2.equals(topScope$) : topScope$ != null)) {
                    namespaceBinding = scope;
                    break block4;
                }
                NamespaceBinding namespaceBinding3 = scope;
                TopScope$ topScope$2 = TopScope$.MODULE$;
                if (!(namespaceBinding3 != null ? !namespaceBinding3.equals(topScope$2) : topScope$2 != null)) {
                    namespaceBinding = scope;
                    break block4;
                }
                NamespaceBinding namespaceBinding4 = scope;
                if (namespaceBinding4 == null) {
                    throw new MatchError((Object)namespaceBinding4);
                }
                String pre = namespaceBinding4.prefix();
                NamespaceBinding more2 = namespaceBinding4.parent();
                Tuple2 tuple2 = new Tuple2((Object)pre, (Object)more2);
                Tuple2 tuple22 = tuple2;
                String pre2 = (String)tuple22._1();
                more = (NamespaceBinding)tuple22._2();
                if (nb.getURI(pre2) == null) break;
                scope = more;
            }
            NamespaceBinding x$1 = this.removeBindings(nb, more);
            String x$2 = scope.copy$default$1();
            String x$3 = scope.copy$default$2();
            namespaceBinding = scope.copy(x$2, x$3, x$1);
        }
        return namespaceBinding;
    }

    public NamespaceBinding combineScopes(String prefix, NS ns, NamespaceBinding outer) {
        NamespaceBinding namespaceBinding;
        if (Maybe$.MODULE$.isEmpty$extension(ns.optURI())) {
            namespaceBinding = outer;
        } else {
            String uri = ((URI)Maybe$.MODULE$.get$extension(ns.optURI())).toString();
            NamespaceBinding inner = new NamespaceBinding(prefix, uri, (NamespaceBinding)TopScope$.MODULE$);
            namespaceBinding = this.combineScopes(inner, outer);
        }
        return namespaceBinding;
    }

    public Node collapseScopes(Node x, NamespaceBinding outer) {
        Node node;
        Node node2 = x;
        Option option = Elem$.MODULE$.unapplySeq(node2);
        if (!option.isEmpty()) {
            String pre = (String)((Tuple5)option.get())._1();
            String lab = (String)((Tuple5)option.get())._2();
            MetaData md = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scp = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq child = (Seq)((Tuple5)option.get())._5();
            NamespaceBinding newScope = this.combineScopes(scp, outer);
            node = Elem$.MODULE$.apply(pre, lab, md, newScope, true, (Seq)child.flatMap((Function1 & Serializable & scala.Serializable)ch -> MODULE$.collapseScopes((Node)ch, newScope), Seq$.MODULE$.canBuildFrom()));
        } else {
            node = x;
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    public NamespaceBinding filterScope(NamespaceBinding nsb, Seq<NS> nss) {
        void var3_8;
        TopScope$ topScope$;
        NamespaceBinding namespaceBinding = nsb;
        TopScope$ topScope$2 = TopScope$.MODULE$;
        if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$2) : topScope$2 != null)) {
            topScope$ = TopScope$.MODULE$;
        } else {
            NamespaceBinding parentCopy = this.filterScope(nsb.parent(), nss);
            if (nss.contains((Object)NS$.MODULE$.apply(nsb.uri()))) {
                topScope$ = parentCopy;
            } else {
                NamespaceBinding x$1 = parentCopy;
                String x$2 = nsb.copy$default$1();
                String x$3 = nsb.copy$default$2();
                topScope$ = nsb.copy(x$2, x$3, x$1);
            }
        }
        TopScope$ newHead = topScope$;
        return var3_8;
    }

    /*
     * WARNING - void declaration
     */
    public boolean prefixInScope(String prefix, NamespaceBinding scope) {
        void var3_4;
        boolean bl;
        if (scope == null) {
            bl = false;
        } else {
            String string = prefix;
            String string2 = scope.prefix();
            bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : this.prefixInScope(prefix, scope.parent());
        }
        boolean ret = bl;
        return (boolean)var3_4;
    }

    public Node removeComments(Node e) {
        Node node;
        Node node2 = e;
        Option option = Elem$.MODULE$.unapplySeq(node2);
        if (!option.isEmpty()) {
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attribs = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq child = (Seq)((Tuple5)option.get())._5();
            Seq newChildren = (Seq)((TraversableLike)child.filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeComments$1(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.removeComments((Node)x$7), Seq$.MODULE$.canBuildFrom());
            node = Elem$.MODULE$.apply(prefix, label, attribs, scope, true, newChildren);
        } else {
            node = node2;
        }
        return node;
    }

    public Node removeAttributes(Node n, Seq<NS> ns, Option<NamespaceBinding> parentScope) {
        Node res1 = (Node)this.removeAttributes1(n, ns, parentScope);
        Node res2 = this.removeMixedWhitespace(res1);
        Node res = res2.apply(0);
        return res;
    }

    public Seq<NS> removeAttributes$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Option<NamespaceBinding> removeAttributes$default$3() {
        return None$.MODULE$;
    }

    private Node removeMixedWhitespace(Node ns2) {
        Elem elem;
        Seq noMixedChildren;
        if (!(ns2 instanceof Elem)) {
            return ns2;
        }
        Elem e = (Elem)ns2;
        Seq children = e.child();
        Seq seq = noMixedChildren = children.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$1(x$8))) ? (Seq)((TraversableLike)children.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$2(e, x0$1)))).map((Function1 & Serializable & scala.Serializable)ns -> MODULE$.removeMixedWhitespace((Node)ns), Seq$.MODULE$.canBuildFrom()) : (Seq)children.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$4(x0$2)));
        if (noMixedChildren == children) {
            elem = e;
        } else {
            Seq x$1 = noMixedChildren;
            String x$2 = e.copy$default$1();
            String x$3 = e.copy$default$2();
            MetaData x$4 = e.copy$default$3();
            NamespaceBinding x$5 = e.copy$default$4();
            boolean x$6 = e.copy$default$5();
            elem = e.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        }
        Elem res = elem;
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public Node convertPCDataToText(Node n) {
        void var3_13;
        Text text;
        Node node = n;
        if (node instanceof Text) {
            Text text2;
            text = text2 = (Text)node;
        } else if (node instanceof Atom) {
            Atom atom = (Atom)node;
            text = Text$.MODULE$.apply(atom.text());
        } else {
            Option option = Elem$.MODULE$.unapplySeq(node);
            if (!option.isEmpty()) {
                String prefix = (String)((Tuple5)option.get())._1();
                String label = (String)((Tuple5)option.get())._2();
                MetaData attributes = (MetaData)((Tuple5)option.get())._3();
                NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
                Seq children = (Seq)((Tuple5)option.get())._5();
                Seq newChildren = (Seq)children.map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.convertPCDataToText((Node)x$9), Seq$.MODULE$.canBuildFrom());
                text = Elem$.MODULE$.apply(prefix, label, attributes, scope, true, newChildren);
            } else {
                text = n;
            }
        }
        Text res = text;
        return var3_13;
    }

    private NodeSeq removeAttributes1(Node n, Seq<NS> ns, Option<NamespaceBinding> parentScope) {
        Object object;
        Node node = n;
        Option option = Elem$.MODULE$.unapplySeq(node);
        if (!option.isEmpty()) {
            TopScope$ topScope$;
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attributes = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq children = (Seq)((Tuple5)option.get())._5();
            TopScope$ filteredScope = ns.length() > 0 ? this.filterScope(scope, ns) : TopScope$.MODULE$;
            Option<NamespaceBinding> option2 = parentScope;
            if (option2 instanceof Some) {
                NamespaceBinding ps;
                Some some = (Some)option2;
                NamespaceBinding namespaceBinding = ps = (NamespaceBinding)some.value();
                TopScope$ topScope$2 = filteredScope;
                topScope$ = !(namespaceBinding != null ? !namespaceBinding.equals(topScope$2) : topScope$2 != null) ? ps : filteredScope;
            } else if (None$.MODULE$.equals(option2)) {
                topScope$ = filteredScope;
            } else {
                throw new MatchError(option2);
            }
            TopScope$ newScope = topScope$;
            NodeSeq newChildren = NodeSeq$.MODULE$.seqToNodeSeq((Seq)children.flatMap(arg_0 -> XMLUtils$.$anonfun$removeAttributes1$1(ns, (NamespaceBinding)newScope, arg_0), Seq$.MODULE$.canBuildFrom()));
            Seq<Node> textMergedChildren = this.coalesceAdjacentTextNodes((Seq<Node>)newChildren);
            String newPrefix = this.prefixInScope(prefix, (NamespaceBinding)newScope) ? prefix : null;
            MetaData newAttributes = attributes.filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeAttributes1$2(node, m)));
            object = Elem$.MODULE$.apply(newPrefix, label, newAttributes, (NamespaceBinding)newScope, true, textMergedChildren);
        } else {
            object = node instanceof Comment ? NodeSeq$.MODULE$.Empty() : node;
        }
        NodeSeq res = object;
        return res;
    }

    private Node prepareForDiffComparison(Node n) {
        Node noComments = this.removeComments(n);
        Node noPCData = this.convertPCDataToText(noComments);
        Node combinedText = this.coalesceAllAdjacentTextNodes(noPCData);
        Node noMixedWS = this.removeMixedWhitespace(combinedText);
        return noMixedWS;
    }

    public void compareAndReport(Node expected, Node actual, boolean ignoreProcInstr) {
        Node actualMinimized;
        Node expectedMinimized = this.prepareForDiffComparison(expected);
        Seq<Tuple3<String, String, String>> diffs = this.computeDiff(expectedMinimized, actualMinimized = this.prepareForDiffComparison(actual), ignoreProcInstr);
        if (diffs.length() > 0) {
            throw new XMLUtils.XMLDifferenceException(new StringOps(Predef$.MODULE$.augmentString("\nComparison failed.\nExpected (attributes stripped)\n          %s\nActual (attributes ignored for diff)\n          %s\nDifferences were (path, expected, actual):\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.removeAttributes(expected, this.removeAttributes$default$2(), this.removeAttributes$default$3()).toString(), actual, ((TraversableOnce)diffs.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), Seq$.MODULE$.canBuildFrom())).mkString("- ", "\n- ", "\n")})));
        }
    }

    public boolean compareAndReport$default$3() {
        return true;
    }

    public Seq<Tuple3<String, String, String>> computeDiff(Node a, Node b, boolean ignoreProcInstr) {
        return this.computeDiffOne(a, b, (Option<Object>)None$.MODULE$, (Seq<String>)Nil$.MODULE$, ignoreProcInstr, (Option<String>)None$.MODULE$);
    }

    public boolean computeDiff$default$3() {
        return true;
    }

    public scala.collection.immutable.Map<String, Object> childArrayCounters(Elem e) {
        Seq children;
        Elem elem = e;
        Option option = Elem$.MODULE$.unapplySeq((Node)elem);
        if (option.isEmpty()) {
            throw new MatchError((Object)elem);
        }
        Seq seq = children = (Seq)((Tuple5)option.get())._5();
        Seq children2 = seq;
        Seq labels = (Seq)children2.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.label(), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map groups = labels.groupBy((Function1 & Serializable & scala.Serializable)x -> x);
        scala.collection.immutable.Map counts = (scala.collection.immutable.Map)groups.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String label = (String)tuple2._1();
            Seq labelList = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)label, (Object)BoxesRunTime.boxToInteger((int)labelList.length()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map arrayCounts = (scala.collection.immutable.Map)counts.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$childArrayCounters$4(x0$2)));
        scala.collection.immutable.Map arrayCounters = (scala.collection.immutable.Map)arrayCounts.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String label = (String)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)label, (Object)BoxesRunTime.boxToLong((long)1));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return arrayCounters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Tuple3<String, String, String>> computeDiffOne(Node an, Node bn, Option<Object> maybeIndex, Seq<String> parentPathSteps, boolean ignoreProcInstr, Option<String> maybeType) {
        LazyRef zPath$lzy = new LazyRef();
        Tuple2 tuple2 = new Tuple2((Object)an, (Object)bn);
        if (tuple2 != null) {
            Node a = (Node)tuple2._1();
            Node b = (Node)tuple2._2();
            if (a instanceof Elem) {
                Elem elem = (Elem)a;
                if (b instanceof Elem) {
                    .colon.colon colon2;
                    Elem elem2 = (Elem)b;
                    Elem elem3 = elem;
                    Option option = Elem$.MODULE$.unapplySeq((Node)elem3);
                    if (option.isEmpty()) throw new MatchError((Object)elem3);
                    String labelA = (String)((Tuple5)option.get())._2();
                    MetaData attribsA = (MetaData)((Tuple5)option.get())._3();
                    Seq childrenA = (Seq)((Tuple5)option.get())._5();
                    Tuple3 tuple3 = new Tuple3((Object)labelA, (Object)attribsA, (Object)childrenA);
                    Tuple3 tuple32 = tuple3;
                    String labelA2 = (String)tuple32._1();
                    MetaData attribsA2 = (MetaData)tuple32._2();
                    Seq childrenA2 = (Seq)tuple32._3();
                    Elem elem4 = elem2;
                    Option option2 = Elem$.MODULE$.unapplySeq((Node)elem4);
                    if (option2.isEmpty()) throw new MatchError((Object)elem4);
                    String labelB = (String)((Tuple5)option2.get())._2();
                    MetaData attribsB = (MetaData)((Tuple5)option2.get())._3();
                    Seq childrenB = (Seq)((Tuple5)option2.get())._5();
                    Tuple3 tuple33 = new Tuple3((Object)labelB, (Object)attribsB, (Object)childrenB);
                    Tuple3 tuple34 = tuple33;
                    String labelB2 = (String)tuple34._1();
                    MetaData attribsB2 = (MetaData)tuple34._2();
                    Seq childrenB2 = (Seq)tuple34._3();
                    Option typeA = elem.attribute(this.XSI_NAMESPACE().toString(), "type").map((Function1 & Serializable & scala.Serializable)x$15 -> ((Node)x$15.head()).text());
                    Option typeB = elem2.attribute(this.XSI_NAMESPACE().toString(), "type").map((Function1 & Serializable & scala.Serializable)x$16 -> ((Node)x$16.head()).text());
                    Option maybeType2 = Option$.MODULE$.apply(typeA.getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)typeB.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)));
                    Option nilledA = elem.attribute(this.XSI_NAMESPACE().toString(), "nil");
                    Option nilledB = elem2.attribute(this.XSI_NAMESPACE().toString(), "nil");
                    String string = labelA2;
                    String string2 = labelB2;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        colon2 = new .colon.colon((Object)new Tuple3((Object)XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), (Object)labelA2, (Object)labelB2), (List)Nil$.MODULE$);
                        return colon2;
                    } else {
                        Option option3 = nilledA;
                        Option option4 = nilledB;
                        if (option3 == null ? option4 != null : !option3.equals(option4)) {
                            colon2 = new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(9).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("@xsi:nil").toString(), nilledA.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), nilledB.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)Nil$.MODULE$);
                            return colon2;
                        } else {
                            Option option5 = typeA;
                            Option option6 = typeB;
                            if ((option5 == null ? option6 != null : !option5.equals(option6)) && typeA.isDefined() && typeB.isDefined()) {
                                colon2 = new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(10).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("@xsi:type").toString(), typeA.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), typeA.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)Nil$.MODULE$);
                                return colon2;
                            } else {
                                Tuple2 tuple22;
                                String pathLabel;
                                String string3 = pathLabel = new java.lang.StringBuilder(0).append(labelA2).append(maybeIndex.map((Function1 & Serializable & scala.Serializable)x$21 -> XMLUtils$.$anonfun$computeDiffOne$13(BoxesRunTime.unboxToInt((Object)x$21))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
                                Seq thisPathStep = (Seq)parentPathSteps.$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom());
                                if (ignoreProcInstr) {
                                    Seq ca = (Seq)childrenA2.filterNot((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$15(x$23)));
                                    Seq cb = (Seq)childrenB2.filterNot((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$16(x$24)));
                                    tuple22 = new Tuple2((Object)ca, (Object)cb);
                                } else {
                                    tuple22 = new Tuple2((Object)childrenA2, (Object)childrenB2);
                                }
                                Tuple2 tuple23 = tuple22;
                                if (tuple23 == null) throw new MatchError((Object)tuple23);
                                Seq childrenACompare = (Seq)tuple23._1();
                                Seq childrenBCompare = (Seq)tuple23._2();
                                Tuple2 tuple24 = new Tuple2((Object)childrenACompare, (Object)childrenBCompare);
                                Tuple2 tuple25 = tuple24;
                                Seq childrenACompare2 = (Seq)tuple25._1();
                                Seq childrenBCompare2 = (Seq)tuple25._2();
                                Iterable repeatingChildrenLabels = ((MapLike)childrenA2.groupBy((Function1 & Serializable & scala.Serializable)x$26 -> x$26.label()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$18(x0$1)))).keys();
                                Iterable labelsWithZeroCount = (Iterable)repeatingChildrenLabels.map((Function1 & Serializable & scala.Serializable)x$27 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$27), (Object)BoxesRunTime.boxToInteger((int)0)), Iterable$.MODULE$.canBuildFrom());
                                Map countMap = (Map)Map$.MODULE$.apply(labelsWithZeroCount.toSeq());
                                Seq childrenDiffs = (Seq)((TraversableLike)childrenACompare2.zip((GenIterable)childrenBCompare2, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                    Tuple2 tuple2 = x0$2;
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    Node ca = (Node)tuple2._1();
                                    Node cb = (Node)tuple2._2();
                                    Option maybeChildCount = countMap.get((Object)ca.label());
                                    Option maybeChildIndex = maybeChildCount.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)count -> {
                                        String string = ca.label();
                                        countMap.update((Object)string, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)countMap.apply((Object)string)) + 1)));
                                        return count + 1;
                                    });
                                    Seq<Tuple3<String, String, String>> seq = MODULE$.computeDiffOne(ca, cb, (Option<Object>)maybeChildIndex, (Seq<String>)thisPathStep, ignoreProcInstr, (Option<String>)maybeType2);
                                    return seq;
                                }, Seq$.MODULE$.canBuildFrom());
                                Nil$ childrenLengthDiff = childrenA2.length() != childrenB2.length() ? new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(15).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("::child@count)").toString(), (Object)((Object)BoxesRunTime.boxToInteger((int)childrenA2.length())).toString(), (Object)((Object)BoxesRunTime.boxToInteger((int)childrenB2.length())).toString()), (List)Nil$.MODULE$) : Nil$.MODULE$;
                                colon2 = (Seq)childrenDiffs.$plus$plus((GenTraversableOnce)childrenLengthDiff, Seq$.MODULE$.canBuildFrom());
                            }
                        }
                    }
                    return colon2;
                }
            }
        }
        if (tuple2 != null) {
            Node tA = (Node)tuple2._1();
            Node tB = (Node)tuple2._2();
            if (tA instanceof Text) {
                Text text = (Text)tA;
                if (tB instanceof Text) {
                    Text text2 = (Text)tB;
                    Seq thisDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), text, text2, maybeType);
                    return thisDiff;
                }
            }
        }
        if (tuple2 == null) return new .colon.colon((Object)new Tuple3((Object)XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), (Object)an.toString(), (Object)bn.toString()), (List)Nil$.MODULE$);
        Node pA = (Node)tuple2._1();
        Node pB = (Node)tuple2._2();
        if (!(pA instanceof ProcInstr)) return new .colon.colon((Object)new Tuple3((Object)XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), (Object)an.toString(), (Object)bn.toString()), (List)Nil$.MODULE$);
        ProcInstr procInstr = (ProcInstr)pA;
        if (!(pB instanceof ProcInstr)) return new .colon.colon((Object)new Tuple3((Object)XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), (Object)an.toString(), (Object)bn.toString()), (List)Nil$.MODULE$);
        ProcInstr procInstr2 = (ProcInstr)pB;
        ProcInstr procInstr3 = procInstr;
        if (procInstr3 == null) throw new MatchError((Object)procInstr3);
        String tA1label = procInstr3.target();
        String tA1content = procInstr3.proctext();
        Tuple2 tuple26 = new Tuple2((Object)tA1label, (Object)tA1content);
        Tuple2 tuple27 = tuple26;
        String tA1label2 = (String)tuple27._1();
        String tA1content2 = (String)tuple27._2();
        ProcInstr procInstr4 = procInstr2;
        if (procInstr4 == null) throw new MatchError((Object)procInstr4);
        String tB1label = procInstr4.target();
        String tB1content = procInstr4.proctext();
        Tuple2 tuple28 = new Tuple2((Object)tB1label, (Object)tB1content);
        Tuple2 tuple29 = tuple28;
        String tB1label2 = (String)tuple29._1();
        String tB1content2 = (String)tuple29._2();
        Seq<Tuple3<String, String, String>> labelDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), tA1label2, tB1label2, (Option<String>)None$.MODULE$);
        Seq<Tuple3<String, String, String>> contentDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), tA1content2, tB1content2, maybeType);
        return (Seq)labelDiff.$plus$plus(contentDiff, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple3<String, String, String>> computeTextDiff(String zPath, Text tA, Text tB, Option<String> maybeType) {
        String dataA = tA.toString();
        String dataB = tB.toString();
        return this.computeTextDiff(zPath, dataA, dataB, maybeType);
    }

    public Seq<Tuple3<String, String, String>> computeBlobDiff(String zPath, String dataA, String dataB) {
        Seq seq;
        Option<URI> uriA = Misc$.MODULE$.searchResourceOption(dataA, (Option<URI>)None$.MODULE$);
        Option<URI> uriB = Misc$.MODULE$.searchResourceOption(dataB, (Option<URI>)None$.MODULE$);
        Option pathA = uriA.map((Function1 & Serializable & scala.Serializable)u -> Paths.get(u));
        Option pathB = uriB.map((Function1 & Serializable & scala.Serializable)u -> Paths.get(u));
        boolean canReadA = BoxesRunTime.unboxToBoolean((Object)pathA.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$3(p))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        boolean canReadB = BoxesRunTime.unboxToBoolean((Object)pathB.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$5(p))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        if (!canReadA || !canReadB) {
            String path = new java.lang.StringBuilder(8).append(zPath).append(".canRead").toString();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)path, (Object)((Object)BoxesRunTime.boxToBoolean((boolean)canReadA)).toString(), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)canReadB)).toString())}));
        } else {
            int CHUNK_SIZE = 1024;
            byte[] arrayA = new byte[CHUNK_SIZE];
            byte[] arrayB = new byte[CHUNK_SIZE];
            InputStream streamA = Files.newInputStream((Path)pathA.get(), StandardOpenOption.READ);
            InputStream streamB = Files.newInputStream((Path)pathB.get(), StandardOpenOption.READ);
            int lenA = 0;
            int lenB = 0;
            int numSameBytes = 0;
            boolean areSame = true;
            while ((areSame = (lenA = streamA.read(arrayA)) == (lenB = streamB.read(arrayB)) && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayA)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(arrayB))) && lenA != -1 && lenB != -1) {
                numSameBytes += lenA;
            }
            if (!areSame) {
                Tuple2[] zip = (Tuple2[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayA)).zip((GenIterable)Predef$.MODULE$.wrapByteArray(arrayB), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                int firstDiffIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])zip)).indexWhere((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$7(z)));
                int MAX_CONTEXT = 40;
                byte[] contextA = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayA)).take(lenA))).drop(firstDiffIndex))).take(MAX_CONTEXT);
                byte[] contextB = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayB)).take(lenB))).drop(firstDiffIndex))).take(MAX_CONTEXT);
                String hexA = Misc$.MODULE$.bytes2Hex(contextA);
                String hexB = Misc$.MODULE$.bytes2Hex(contextB);
                int absoluteIndex = numSameBytes + firstDiffIndex;
                String path = new java.lang.StringBuilder(10).append(zPath).append(".bytesAt(").append(absoluteIndex + 1).append(")").toString();
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)path, (Object)hexA, (Object)hexB)}));
            } else {
                seq = Nil$.MODULE$;
            }
        }
        return seq;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Seq<Tuple3<String, String, String>> computeTextDiff(String zPath, String dataA, String dataB, Option<String> maybeType) {
        int index;
        Seq seq;
        if (maybeType.isDefined()) {
            Object object = maybeType.get();
            String string = "xs:anyURI";
            if (!(object != null ? !object.equals(string) : string != null)) {
                seq = this.computeBlobDiff(zPath, dataA, dataB);
                return seq;
            }
        }
        if (this.textIsSame(dataA, dataB, maybeType)) {
            seq = Nil$.MODULE$;
            return seq;
        }
        int CHARS_TO_SHOW_AFTER_DIFF = 40;
        int lenA = dataA.length();
        int lenB = dataB.length();
        for (index = 0; index < lenA && index < lenB && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dataA), index) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dataB), index); ++index) {
        }
        String contextA = Misc$.MODULE$.remapControlsAndLineEndingsToVisibleGlyphs(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(dataA), index, index + CHARS_TO_SHOW_AFTER_DIFF));
        String contextB = Misc$.MODULE$.remapControlsAndLineEndingsToVisibleGlyphs(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(dataB), index, index + CHARS_TO_SHOW_AFTER_DIFF));
        String path = new java.lang.StringBuilder(9).append(zPath).append(".charAt(").append(index + 1).append(")").toString();
        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)path, (Object)contextA, (Object)contextB)}));
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean textIsSame(String dataA, String dataB, Option<String> maybeType) {
        String string;
        String string2;
        String string3;
        boolean bl = false;
        Some some = null;
        Option<String> option = maybeType;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string4 = (String)some.value();
            if ("xs:hexBinary".equals(string4)) {
                return dataA.equalsIgnoreCase(dataB);
            }
        }
        if (bl && "xs:date".equals(string3 = (String)some.value())) {
            DFDLDate a = DFDLDateConversion$.MODULE$.fromXMLString(dataA);
            DFDLDate b = DFDLDateConversion$.MODULE$.fromXMLString(dataB);
            DFDLDate dFDLDate = a;
            DFDLDate dFDLDate2 = b;
            if (dFDLDate != null) {
                if (!((Object)dFDLDate).equals(dFDLDate2)) return false;
                return true;
            }
            if (dFDLDate2 == null) return true;
            return false;
        }
        if (bl && "xs:time".equals(string2 = (String)some.value())) {
            DFDLTime a = DFDLTimeConversion$.MODULE$.fromXMLString(dataA);
            DFDLTime b = DFDLTimeConversion$.MODULE$.fromXMLString(dataB);
            DFDLTime dFDLTime = a;
            DFDLTime dFDLTime2 = b;
            if (dFDLTime != null) {
                if (!((Object)dFDLTime).equals(dFDLTime2)) return false;
                return true;
            }
            if (dFDLTime2 == null) return true;
            return false;
        }
        if (bl && "xs:dateTime".equals(string = (String)some.value())) {
            DFDLDateTime a = DFDLDateTimeConversion$.MODULE$.fromXMLString(dataA);
            DFDLDateTime b = DFDLDateTimeConversion$.MODULE$.fromXMLString(dataB);
            DFDLDateTime dFDLDateTime = a;
            DFDLDateTime dFDLDateTime2 = b;
            if (dFDLDateTime != null) {
                if (!((Object)dFDLDateTime).equals(dFDLDateTime2)) return false;
                return true;
            }
            if (dFDLDateTime2 == null) return true;
            return false;
        }
        String string5 = dataA;
        String string6 = dataB;
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    public File convertNodeToTempFile(Node xml, File tmpDir, String nameHint) {
        String string;
        int n = nameHint.length();
        switch (n) {
            case 0: {
                string = "daffodil_tmp_";
                break;
            }
            case 1: {
                string = new java.lang.StringBuilder(2).append(nameHint).append("__").toString();
                break;
            }
            case 2: {
                string = new java.lang.StringBuilder(1).append(nameHint).append("_").toString();
                break;
            }
            default: {
                string = nameHint;
                break;
            }
        }
        String prefix = string;
        File tmpSchemaFile = File.createTempFile(prefix, ".dfdl.xsd", tmpDir);
        tmpSchemaFile.deleteOnExit();
        PrettyPrinter pp = new PrettyPrinter(2);
        String xmlString = pp.format(xml);
        FileOutputStream fos = new FileOutputStream(tmpSchemaFile);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fos, "utf-8");
        fw.write(xmlString);
        fw.close();
        return tmpSchemaFile;
    }

    public String convertNodeToTempFile$default$3() {
        return "daffodil_tmp_";
    }

    public File convertInputStreamToTempFile(InputStream is, File tmpDir, String nameHint, String suffix) {
        String string;
        int n = nameHint.length();
        switch (n) {
            case 0: {
                string = "daffodil_tmp_";
                break;
            }
            case 1: {
                string = new java.lang.StringBuilder(2).append(nameHint).append("__").toString();
                break;
            }
            case 2: {
                string = new java.lang.StringBuilder(1).append(nameHint).append("_").toString();
                break;
            }
            default: {
                string = nameHint;
                break;
            }
        }
        String prefix = string;
        File tmpSchemaFile = File.createTempFile(prefix, suffix, tmpDir);
        tmpSchemaFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tmpSchemaFile);
        IOUtils.copy((InputStream)is, (OutputStream)fos);
        fos.close();
        return tmpSchemaFile;
    }

    public StringBuilder escape(String str, StringBuilder sb) {
        int i = 0;
        while (i < str.length()) {
            char x = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), i);
            char c = BoxesRunTime.unboxToChar((Object)this.escapeMapper().apply((Object)BoxesRunTime.boxToCharacter((char)x)));
            ++i;
            char c2 = c;
            switch (c2) {
                case '\'': {
                    StringBuilder stringBuilder = sb.append("&#x27;");
                    break;
                }
                case '\"': {
                    StringBuilder stringBuilder = sb.append("&quot;");
                    break;
                }
                case '&': {
                    StringBuilder stringBuilder = sb.append("&amp;");
                    break;
                }
                case '<': {
                    StringBuilder stringBuilder = sb.append("&lt;");
                    break;
                }
                case '>': {
                    StringBuilder stringBuilder = sb.append("&gt;");
                    break;
                }
                default: {
                    StringBuilder stringBuilder;
                    if (RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c))) {
                        stringBuilder = sb.append(c);
                        break;
                    }
                    if (RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c)) || RichChar$.MODULE$.isControl$extension(Predef$.MODULE$.charWrapper(c))) {
                        stringBuilder = this.toNumericCharacterEntity(c, sb);
                        break;
                    }
                    if (c == '\u00a0') {
                        stringBuilder = this.toNumericCharacterEntity(c, sb);
                        break;
                    }
                    if (c < '\u00ff') {
                        stringBuilder = sb.append(c);
                        break;
                    }
                    stringBuilder = this.toNumericCharacterEntity(c, sb);
                    break;
                }
            }
        }
        return sb;
    }

    public StringBuilder escape$default$2() {
        return new StringBuilder();
    }

    private Function1<Object, Object> escapeMapper() {
        return this.escapeMapper;
    }

    public StringBuilder toNumericCharacterEntity(char c, StringBuilder sb) {
        char i = c;
        if (i <= '\u0000') {
            throw Assert$.MODULE$.abort("Usage error: i.>(0)");
        }
        String s = Integer.toHexString(i).toUpperCase();
        sb.append("&#x");
        sb.append(s);
        return sb.append(";");
    }

    private final char remapOneChar$1(char previous, char current, char next, Function1 remapFunc$1) {
        if (this.isLeadingSurrogate(current) && this.isTrailingSurrogate(next)) {
            return current;
        }
        if (this.isTrailingSurrogate(current) && this.isLeadingSurrogate(previous)) {
            return current;
        }
        return BoxesRunTime.unboxToChar((Object)remapFunc$1.apply((Object)BoxesRunTime.boxToCharacter((char)current)));
    }

    private static final void processText$1(ObjectRef tn$1, ObjectRef sb$1, ArrayBuilder ab$1) {
        if ((Node)tn$1.elem == null) {
            if ((StringBuilder)sb$1.elem != null && ((StringBuilder)sb$1.elem).length() > 0) {
                ab$1.$plus$eq((Object)new Text(((StringBuilder)sb$1.elem).toString()));
                ((StringBuilder)sb$1.elem).clear();
            }
        } else {
            if ((StringBuilder)sb$1.elem != null && ((StringBuilder)sb$1.elem).length() != 0) {
                throw Assert$.MODULE$.abort("Invariant broken: sb.==(null).||(sb.length.==(0))");
            }
            ab$1.$plus$eq((Object)((Node)tn$1.elem));
            tn$1.elem = null;
        }
    }

    public static final /* synthetic */ boolean $anonfun$dfdlAttributes$1(Node n$1, MetaData x$2) {
        String string = x$2.getNamespace(n$1);
        String string2 = MODULE$.DFDL_NAMESPACE().toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$dfdlxAttributes$1(Node n$2, MetaData x$3) {
        String string = x$3.getNamespace(n$2);
        String string2 = MODULE$.DFDLX_NAMESPACE().toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$dafAttributes$1(Node n$3, MetaData a) {
        String string = a.getNamespace(n$3);
        String string2 = MODULE$.EXT_NS_NCSA().toString();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = a.getNamespace(n$3);
        String string4 = MODULE$.EXT_NS_APACHE().toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$removeComments$1(Node x$6) {
        return x$6 instanceof Comment;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$1(Node x$8) {
        return x$8 instanceof Elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$2(Elem e$1, Node x0$1) {
        boolean bl;
        String data;
        Node node = x0$1;
        Option option = Text$.MODULE$.unapply((Object)node);
        if (!option.isEmpty() && (data = (String)option.get()).matches("\\s*")) {
            bl = false;
        } else {
            Option option2 = Text$.MODULE$.unapply((Object)node);
            if (!option2.isEmpty()) {
                String data2 = (String)option2.get();
                throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Element %s contains mixed data: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e$1.label(), data2})));
            }
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$4(Node x0$2) {
        String string;
        Node node = x0$2;
        Option option = Text$.MODULE$.unapply((Object)node);
        boolean bl = option.isEmpty() || !"".equals(string = (String)option.get());
        return bl;
    }

    public static final /* synthetic */ NodeSeq $anonfun$removeAttributes1$1(Seq ns$1, NamespaceBinding newScope$2, Node x$10) {
        return MODULE$.removeAttributes1(x$10, (Seq<NS>)ns$1, (Option<NamespaceBinding>)new Some((Object)newScope$2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$removeAttributes1$2(Node x1$1, MetaData m) {
        String string;
        Some some;
        String pre;
        Some some2;
        Some some3;
        boolean bl = false;
        PrefixedAttribute prefixedAttribute = null;
        MetaData metaData = m;
        if (metaData instanceof PrefixedAttribute) {
            bl = true;
            prefixedAttribute = (PrefixedAttribute)metaData;
            Some some4 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute);
            if (!some4.isEmpty()) {
                String string2;
                Option option;
                String string3 = (String)((Tuple4)some4.get())._2();
                Seq seq = (Seq)((Tuple4)some4.get())._3();
                if ("nil".equals(string3) && !(option = Text$.MODULE$.unapply((Object)seq)).isEmpty() && "true".equals(string2 = (String)option.get())) {
                    NS nS = NS$.MODULE$.apply(prefixedAttribute.getNamespace(x1$1));
                    NS nS2 = MODULE$.XSI_NAMESPACE();
                    if (nS == null) {
                        if (nS2 == null) return true;
                    } else if (((Object)nS).equals(nS2)) {
                        return true;
                    }
                }
            }
        }
        if (bl && !(some3 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty()) {
            String string4;
            Option option;
            String string5 = (String)((Tuple4)some3.get())._1();
            String string6 = (String)((Tuple4)some3.get())._2();
            Seq seq = (Seq)((Tuple4)some3.get())._3();
            if ("xsi".equals(string5) && "nil".equals(string6) && !(option = Text$.MODULE$.unapply((Object)seq)).isEmpty() && "true".equals(string4 = (String)option.get()) && prefixedAttribute.getNamespace(x1$1) == null) {
                return true;
            }
        }
        if (bl && !(some2 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty() && (pre = (String)((Tuple4)some2.get())._1()) != null) {
            String string7 = prefixedAttribute.getNamespace(x1$1);
            String string8 = MODULE$.DAFFODIL_INTERNAL_NAMESPACE().toString();
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                String string9 = pre;
                String string10 = "";
                if (string9 != null) {
                    if (!string9.equals(string10)) return false;
                    throw Assert$.MODULE$.abort("Invariant broken: pre.!=(\"\")");
                }
                if (string10 == null) throw Assert$.MODULE$.abort("Invariant broken: pre.!=(\"\")");
                return false;
            }
        }
        if (bl && !(some = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty() && "type".equals(string = (String)((Tuple4)some.get())._2())) {
            NS nS = NS$.MODULE$.apply(prefixedAttribute.getNamespace(x1$1));
            NS nS3 = MODULE$.XSI_NAMESPACE();
            if (nS == null) {
                if (nS3 == null) return true;
            } else if (((Object)nS).equals(nS3)) {
                return true;
            }
        }
        if (!bl) return true;
        Some some5 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute);
        if (some5.isEmpty()) return true;
        String string11 = (String)((Tuple4)some5.get())._1();
        String string12 = (String)((Tuple4)some5.get())._2();
        if (!"xsi".equals(string11)) return true;
        if (!"type".equals(string12)) return true;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$childArrayCounters$4(Tuple2 x0$2) {
        int n;
        Tuple2 tuple2 = x0$2;
        boolean bl = tuple2 == null || 1 != (n = tuple2._2$mcI$sp());
        return bl;
    }

    private static final /* synthetic */ String zPath$lzycompute$1(LazyRef zPath$lzy$1, Seq parentPathSteps$1) {
        String string;
        LazyRef lazyRef = zPath$lzy$1;
        synchronized (lazyRef) {
            string = zPath$lzy$1.initialized() ? (String)zPath$lzy$1.value() : (String)zPath$lzy$1.initialize((Object)((TraversableOnce)parentPathSteps$1.reverse()).mkString("/"));
        }
        return string;
    }

    private static final String zPath$1(LazyRef zPath$lzy$1, Seq parentPathSteps$1) {
        return zPath$lzy$1.initialized() ? (String)zPath$lzy$1.value() : XMLUtils$.zPath$lzycompute$1(zPath$lzy$1, parentPathSteps$1);
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$13(int x$21) {
        return new java.lang.StringBuilder(2).append("[").append(x$21).append("]").toString();
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$15(Node x$23) {
        return x$23 instanceof ProcInstr;
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$16(Node x$24) {
        return x$24 instanceof ProcInstr;
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$18(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq v = (Seq)tuple2._2();
        boolean bl = v.length() > 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$3(Path p) {
        return Files.isReadable(p);
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$5(Path p) {
        return Files.isReadable(p);
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$7(Tuple2 z) {
        return BoxesRunTime.unboxToByte((Object)z._1()) != BoxesRunTime.unboxToByte((Object)z._2());
    }

    private XMLUtils$() {
        MODULE$ = this;
        this.xmlNilAttribute = new PrefixedAttribute("xsi", "nil", "true", (MetaData)Null$.MODULE$);
        this.PositiveInfinityString = "INF";
        this.NegativeInfinityString = "-INF";
        this.NaNString = "NaN";
        this.XSD_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2001/XMLSchema");
        this.XSI_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2001/XMLSchema-instance");
        this.XPATH_FUNCTION_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2005/xpath-functions");
        this.XPATH_MATH_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2005/xpath-functions/math");
        this.DFDL_NAMESPACE = NS$.MODULE$.apply("http://www.ogf.org/dfdl/dfdl-1.0/");
        this.DFDLX_NAMESPACE = NS$.MODULE$.apply("http://www.ogf.org/dfdl/dfdl-1.0/extensions");
        this.TDML_NAMESPACE = NS$.MODULE$.apply("http://www.ibm.com/xmlns/dfdl/testData");
        this.EXAMPLE_NAMESPACE = NS$.MODULE$.apply("http://example.com");
        this.XHTML_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/1999/xhtml");
        this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA = "urn:ogf:dfdl:2013:imp:opensource.ncsa.illinois.edu:2012";
        this.DAFFODIL_EXTENSION_NAMESPACE_NCSA = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA()).append(":ext").toString());
        this.EXT_PREFIX_NCSA = "daf";
        this.EXT_NS_NCSA = NS$.MODULE$.apply(this.DAFFODIL_EXTENSION_NAMESPACE_NCSA().uri());
        this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_APACHE = "urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018";
        this.DAFFODIL_EXTENSION_NAMESPACE_APACHE = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_APACHE()).append(":ext").toString());
        this.EXT_PREFIX_APACHE = "daf";
        this.EXT_NS_APACHE = NS$.MODULE$.apply(this.DAFFODIL_EXTENSION_NAMESPACE_APACHE().uri());
        this.DAFFODIL_INTERNAL_NAMESPACE = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_APACHE()).append(":int").toString());
        this.INT_PREFIX = "dafint";
        this.INT_NS = NS$.MODULE$.apply(this.DAFFODIL_INTERNAL_NAMESPACE().uri());
        this.FILE_ATTRIBUTE_NAME = "file";
        this.LINE_ATTRIBUTE_NAME = "line";
        this.COLUMN_ATTRIBUTE_NAME = "col";
        this.xsdURI = this.XSD_NAMESPACE();
        this.dfdlURI = this.DFDL_NAMESPACE();
        this.dfdlxURI = this.DFDLX_NAMESPACE();
        this.dfdlAppinfoSource = NS$.MODULE$.apply("http://www.ogf.org/dfdl/");
        this.targetNS = this.EXAMPLE_NAMESPACE();
        this.xsiURI = this.XSI_NAMESPACE();
        this.fnURI = this.XPATH_FUNCTION_NAMESPACE();
        this.mathURI = this.XPATH_MATH_NAMESPACE();
        this.dafintURI = this.DAFFODIL_INTERNAL_NAMESPACE();
        this.DFDL_SIMPLE_BUILT_IN_TYPES = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "float", "double", "decimal", "integer", "long", "int", "short", "byte", "unsignedLong", "unsignedInt", "nonNegativeInteger", "unsignedShort", "unsignedByte", "boolean", "date", "time", "dateTime", "hexBinary"}));
        this.escapeMapper = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)XMLUtils$.MODULE$.remapXMLIllegalCharToPUA(false, false, BoxesRunTime.unboxToChar((Object)c)));
    }
}

