/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.daffodil.lib.api

////////////////////////////////////////////////////////////////////////////////////////////
//
// Generated Code - Do not hand modify!
//
// This file is entirely generated code created from the
// XML Schema files that describe Daffodil configuration files.
//
// Don't edit this. Go fix the generator to create what you need instead.
//
////////////////////////////////////////////////////////////////////////////////////////////

import java.nio.file.Paths

import org.apache.daffodil.lib.exceptions.Assert
import org.apache.daffodil.lib.exceptions.ThrowsSDE
import org.apache.daffodil.lib.schema.annotation.props.EmptyElementParsePolicy
import org.apache.daffodil.lib.schema.annotation.props.Enum
import org.apache.daffodil.lib.util.Misc
import org.apache.daffodil.lib.xml.DaffodilXMLLoader
import org.apache.daffodil.lib.xml.XMLUtils

object DaffodilTunables extends DaffodilTunablesStaticMixin {

  def apply(tunables: Map[String, String]): DaffodilTunables = {
    apply().withTunables(tunables)
  }

  def apply(tunable: String, value: String): DaffodilTunables = {
    apply().withTunable(tunable, value)
  }

  def apply(): DaffodilTunables = {
    // override tunables from the global configuration file on the class path, if it exists
    val configPath = "/daffodil-config.xml"
    val (configOpt, _) = Misc.getResourceOption(configPath)
    val configTunables: Map[String, String] =
      if (configOpt.isDefined) {
        val loader = new DaffodilXMLLoader()
        val node = loader.load(URISchemaSource(Paths.get(configPath).toFile, configOpt.get), Some(XMLUtils.dafextURI))
        tunablesMap(node)
      } else {
        Map.empty
      }

    new DaffodilTunables().withTunables(configTunables)
  }
}

case class DaffodilTunables private (
  val allowBigIntegerBits: Boolean = true,
  val allowExpressionResultCoercion: Boolean = true,
  val allowExternalPathExpressions: Boolean = false,
  val allowSignedIntegerLength1Bit: Boolean = true,
  val blobChunkSizeInBytes: Int = 4096,
  val defaultEmptyElementParsePolicy: EmptyElementParsePolicy = EmptyElementParsePolicy.TreatAsEmpty,
  val defaultInitialRegexMatchLimitInChars: Int = 32,
  val errorOnUnsupportedJavaVersion: Boolean = true,
  val escalateWarningsToErrors: Boolean = false,
  val generatedNamespacePrefixStem: String = "tns",
  val infosetWalkerSkipMax: Int = 2048,
  val infosetWalkerSkipMin: Int = 32,
  val initialElementOccurrencesHint: Int = 10,
  val initialRegexMatchLimitInCharacters: Int = 64,
  val inputFileMemoryMapLowThreshold: Int = 33554432,
  val invalidRestrictionPolicy: InvalidRestrictionPolicy = InvalidRestrictionPolicy.Error,
  val maxBinaryDecimalVirtualPoint: Int = 200,
  val maxByteArrayOutputStreamBufferSizeInBytes: Int = 2097152000,
  val maxDataDumpSizeInBytes: Int = 256,
  val maxFieldContentLengthInBytes: Int = 1048576,
  val maxHexBinaryLengthInBytes: Int = 1073741823,
  val maxLengthForVariableLengthDelimiterDisplay: Int = 10,
  val maxLookaheadFunctionBits: Long = 512,
  val maxOccursBounds: Long = 2147483647,
  val maxSkipLengthInBytes: Int = 1024,
  val maxValidYear: Int = 9999,
  val maximumRegexMatchLengthInCharacters: Int = 1048576,
  val maximumSimpleElementSizeInCharacters: Int = 1048576,
  val minBinaryDecimalVirtualPoint: Int = -200,
  val minValidYear: Int = 0,
  val outputStreamChunkSizeInBytes: Int = 65536,
  val parseUnparsePolicy: ParseUnparsePolicyTunable = ParseUnparsePolicyTunable.FromRoot,
  val readerByteBufferSize: Int = 8192,
  val releaseUnneededInfoset: Boolean = true,
  val requireBitOrderProperty: Boolean = false,
  val requireEmptyElementParsePolicyProperty: Boolean = false,
  val requireEncodingErrorPolicyProperty: Boolean = false,
  val requireFloatingProperty: Boolean = false,
  val requireTextBidiProperty: Boolean = false,
  val requireTextStandardBaseProperty: Boolean = false,
  val saxUnparseEventBatchSize: Int = 100,
  val suppressSchemaDefinitionWarnings: Seq[WarnID] = Seq(WarnID.EmptyElementParsePolicyError),
  val tempFilePath: java.io.File = new java.io.File(System.getProperty("java.io.tmpdir")),
  val unparseSuspensionWaitOld: Int = 100,
  val unparseSuspensionWaitYoung: Int = 5,
  val unqualifiedPathStepPolicy: UnqualifiedPathStepPolicy = UnqualifiedPathStepPolicy.NoNamespace)
  extends Serializable {

  def withTunables(tunables: Map[String, String]): DaffodilTunables = {
    tunables.foldLeft(this) { case (dafTuns, (tunable, value)) => dafTuns.withTunable(tunable, value) }
  }

  def withTunable(tunable: String, value: String): DaffodilTunables = {
    tunable match {
      case "allowBigIntegerBits" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(allowBigIntegerBits = v)
      }
      case "allowExpressionResultCoercion" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(allowExpressionResultCoercion = v)
      }
      case "allowExternalPathExpressions" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(allowExternalPathExpressions = v)
      }
      case "allowSignedIntegerLength1Bit" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(allowSignedIntegerLength1Bit = v)
      }
      case "blobChunkSizeInBytes" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        if (!(v <= 268435455)) throwInvalidTunableValue(tunable, value)
        this.copy(blobChunkSizeInBytes = v)
      }
      case "defaultEmptyElementParsePolicy" => {
        val vOpt = EmptyElementParsePolicy.optionStringToEnum("EmptyElementParsePolicy", value)
        val v = vOpt.getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(defaultEmptyElementParsePolicy = v)
      }
      case "defaultInitialRegexMatchLimitInChars" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(defaultInitialRegexMatchLimitInChars = v)
      }
      case "errorOnUnsupportedJavaVersion" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(errorOnUnsupportedJavaVersion = v)
      }
      case "escalateWarningsToErrors" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(escalateWarningsToErrors = v)
      }
      case "generatedNamespacePrefixStem" => {
        val v = scala.util.Try(value.toString).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(generatedNamespacePrefixStem = v)
      }
      case "infosetWalkerSkipMax" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 0)) throwInvalidTunableValue(tunable, value)
        this.copy(infosetWalkerSkipMax = v)
      }
      case "infosetWalkerSkipMin" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 0)) throwInvalidTunableValue(tunable, value)
        this.copy(infosetWalkerSkipMin = v)
      }
      case "initialElementOccurrencesHint" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(initialElementOccurrencesHint = v)
      }
      case "initialRegexMatchLimitInCharacters" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(initialRegexMatchLimitInCharacters = v)
      }
      case "inputFileMemoryMapLowThreshold" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(inputFileMemoryMapLowThreshold = v)
      }
      case "invalidRestrictionPolicy" => {
        val vOpt = InvalidRestrictionPolicy.optionStringToEnum("InvalidRestrictionPolicy", value)
        val v = vOpt.getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(invalidRestrictionPolicy = v)
      }
      case "maxBinaryDecimalVirtualPoint" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(maxBinaryDecimalVirtualPoint = v)
      }
      case "maxByteArrayOutputStreamBufferSizeInBytes" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 0)) throwInvalidTunableValue(tunable, value)
        this.copy(maxByteArrayOutputStreamBufferSizeInBytes = v)
      }
      case "maxDataDumpSizeInBytes" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(maxDataDumpSizeInBytes = v)
      }
      case "maxFieldContentLengthInBytes" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(maxFieldContentLengthInBytes = v)
      }
      case "maxHexBinaryLengthInBytes" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        if (!(v <= 1073741823)) throwInvalidTunableValue(tunable, value)
        this.copy(maxHexBinaryLengthInBytes = v)
      }
      case "maxLengthForVariableLengthDelimiterDisplay" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(maxLengthForVariableLengthDelimiterDisplay = v)
      }
      case "maxLookaheadFunctionBits" => {
        val v = scala.util.Try(value.toLong).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(maxLookaheadFunctionBits = v)
      }
      case "maxOccursBounds" => {
        val v = scala.util.Try(value.toLong).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(maxOccursBounds = v)
      }
      case "maxSkipLengthInBytes" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(maxSkipLengthInBytes = v)
      }
      case "maxValidYear" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(maxValidYear = v)
      }
      case "maximumRegexMatchLengthInCharacters" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(maximumRegexMatchLengthInCharacters = v)
      }
      case "maximumSimpleElementSizeInCharacters" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(maximumSimpleElementSizeInCharacters = v)
      }
      case "minBinaryDecimalVirtualPoint" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v <= -1)) throwInvalidTunableValue(tunable, value)
        this.copy(minBinaryDecimalVirtualPoint = v)
      }
      case "minValidYear" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(minValidYear = v)
      }
      case "outputStreamChunkSizeInBytes" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(outputStreamChunkSizeInBytes = v)
      }
      case "parseUnparsePolicy" => {
        val vOpt = ParseUnparsePolicyTunable.optionStringToEnum("ParseUnparsePolicyTunable", value)
        val v = vOpt.getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(parseUnparsePolicy = v)
      }
      case "readerByteBufferSize" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(readerByteBufferSize = v)
      }
      case "releaseUnneededInfoset" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(releaseUnneededInfoset = v)
      }
      case "requireBitOrderProperty" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(requireBitOrderProperty = v)
      }
      case "requireEmptyElementParsePolicyProperty" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(requireEmptyElementParsePolicyProperty = v)
      }
      case "requireEncodingErrorPolicyProperty" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(requireEncodingErrorPolicyProperty = v)
      }
      case "requireFloatingProperty" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(requireFloatingProperty = v)
      }
      case "requireTextBidiProperty" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(requireTextBidiProperty = v)
      }
      case "requireTextStandardBaseProperty" => {
        val v = scala.util.Try(value.toBoolean).getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(requireTextStandardBaseProperty = v)
      }
      case "saxUnparseEventBatchSize" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(saxUnparseEventBatchSize = v)
      }
      case "suppressSchemaDefinitionWarnings" => {
        val values = value.split("\\s+").toSeq.map { v =>
          val vOpt = WarnID.optionStringToEnum("WarnID", v)
          vOpt.getOrElse { throwInvalidTunableValue(tunable, value) }
        }
        this.copy(suppressSchemaDefinitionWarnings = values)
      }
      case "tempFilePath" => {
        this.copy(tempFilePath = new java.io.File(value))
      }
      case "unparseSuspensionWaitOld" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(unparseSuspensionWaitOld = v)
      }
      case "unparseSuspensionWaitYoung" => {
        val v = scala.util.Try(value.toInt).getOrElse { throwInvalidTunableValue(tunable, value) }
        if (!(v >= 1)) throwInvalidTunableValue(tunable, value)
        this.copy(unparseSuspensionWaitYoung = v)
      }
      case "unqualifiedPathStepPolicy" => {
        val vOpt = UnqualifiedPathStepPolicy.optionStringToEnum("UnqualifiedPathStepPolicy", value)
        val v = vOpt.getOrElse { throwInvalidTunableValue(tunable, value) }
        this.copy(unqualifiedPathStepPolicy = v)
      }
      case _ => throw new IllegalArgumentException("Unknown tunable: " + tunable)
    }
  }

  private def throwInvalidTunableValue(tunable: String, value: String) = {
    throw new IllegalArgumentException("Invalid value for tunable " + tunable + ": " + value)
  }

}

sealed trait ParseUnparsePolicyTunable extends ParseUnparsePolicyTunable.Value
object ParseUnparsePolicyTunable extends Enum[ParseUnparsePolicyTunable] {
  case object Both extends ParseUnparsePolicyTunable
  case object ParseOnly extends ParseUnparsePolicyTunable
  case object UnparseOnly extends ParseUnparsePolicyTunable
  case object FromRoot extends ParseUnparsePolicyTunable
  override lazy val values = Array(Both, ParseOnly, UnparseOnly, FromRoot)

  override def apply(name: String, context: ThrowsSDE) = Assert.usageError("not to be called. Use optionStringToEnum")
}

sealed trait TDMLImplementation extends TDMLImplementation.Value
object TDMLImplementation extends Enum[TDMLImplementation] {
  case object Daffodil extends TDMLImplementation
  case object DaffodilC extends TDMLImplementation
  case object Ibm extends TDMLImplementation
  override lazy val values = Array(Daffodil, DaffodilC, Ibm)

  override def apply(name: String, context: ThrowsSDE) = Assert.usageError("not to be called. Use optionStringToEnum")
}

sealed trait InvalidRestrictionPolicy extends InvalidRestrictionPolicy.Value
object InvalidRestrictionPolicy extends Enum[InvalidRestrictionPolicy] {
  case object Error extends InvalidRestrictionPolicy
  case object Ignore extends InvalidRestrictionPolicy
  case object Validate extends InvalidRestrictionPolicy
  override lazy val values = Array(Error, Ignore, Validate)

  override def apply(name: String, context: ThrowsSDE) = Assert.usageError("not to be called. Use optionStringToEnum")
}

sealed trait UnqualifiedPathStepPolicy extends UnqualifiedPathStepPolicy.Value
object UnqualifiedPathStepPolicy extends Enum[UnqualifiedPathStepPolicy] {
  case object DefaultNamespace extends UnqualifiedPathStepPolicy
  case object NoNamespace extends UnqualifiedPathStepPolicy
  case object PreferDefaultNamespace extends UnqualifiedPathStepPolicy
  override lazy val values = Array(DefaultNamespace, NoNamespace, PreferDefaultNamespace)

  override def apply(name: String, context: ThrowsSDE) = Assert.usageError("not to be called. Use optionStringToEnum")
}
