package org.apache.daffodil.lib.schema.annotation.props.gen

////////////////////////////////////////////////////////////////////////////////////////////
//
// Generated Code - Do not hand modify!
//
// This file is entirely generated code created from the
// XML Schema files that describe DFDL Annotation syntax.
//
// Don't edit this. Go fix the generator to create what you need instead.
//
////////////////////////////////////////////////////////////////////////////////////////////

import org.apache.daffodil.lib.schema.annotation.props._
import org.apache.daffodil.lib.exceptions.ThrowsSDE

////////////////////////////////////
// <xsd:simpleType name="DFDLExpression" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:annotation>
//       <xsd:documentation>A subset of XPath 2.0 expressions for use in
//         properties</xsd:documentation>
//     </xsd:annotation>
//     <xsd:restriction base="xsd:token">
//       <xsd:pattern value="(\{[^\{].*\})|(\{\})"/>
//     </xsd:restriction>
//   </xsd:simpleType>


trait DFDLExpressionMixin { /* nothing */ }
object DFDLExpression {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="EmptyString" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:annotation>
//       <xsd:documentation>Matches the empty string only. No toleration of
//         whitespace.</xsd:documentation>
//     </xsd:annotation>
//     <xsd:restriction base="xsd:string">
//       <xsd:whiteSpace value="preserve"/>
//       <xsd:length value="0"/>
//     </xsd:restriction>
//   </xsd:simpleType>


trait EmptyStringMixin { /* nothing */ }
object EmptyString {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="DFDLExpressionOrNothing" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:annotation>
//       <xsd:documentation>An expression, or nothing at all.</xsd:documentation>
//     </xsd:annotation>
//     <xsd:union memberTypes="dfdl:EmptyString dfdl:DFDLExpression"/>
//     <!--
//       2012-01-04 mbeckerle - If you change the order of this union,
//       it stops enforcing the empty string aspect.
//       Reverse the order and then just empty whitespace will validate.
//     -->
//   </xsd:simpleType>


trait DFDLExpressionOrNothingMixin { /* nothing */ }
object DFDLExpressionOrNothing {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="DFDLExpressionOrPatternOrNothing" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:annotation>
//       <xsd:documentation>An expression, a regex, or nothing at all.
//       </xsd:documentation>
//     </xsd:annotation>
//     <xsd:union memberTypes="dfdl:EmptyString dfdl:DFDLExpression dfdl:DFDLRegularExpression"/>
//     <!--
//       2012-01-04 mbeckerle - If you change the order of this union,
//       it stops enforcing the empty string aspect.
//       Reverse the order and then just empty whitespace will validate.
//     -->
//   </xsd:simpleType>


trait DFDLExpressionOrPatternOrNothingMixin { /* nothing */ }
object DFDLExpressionOrPatternOrNothing {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="DFDLStringLiteral" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//     </xsd:restriction>
//   </xsd:simpleType>


trait DFDLStringLiteralMixin { /* nothing */ }
object DFDLStringLiteral {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="ListOfDFDLStringLiteral" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:list itemType="xsd:token"/>
//   </xsd:simpleType>


trait ListOfDFDLStringLiteralMixin { /* nothing */ }
object ListOfDFDLStringLiteral {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="NonEmptyStringLiteral" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:annotation>
//       <xsd:documentation>Matches a non-empty string only. No toleration of
//         whitespace in the string.</xsd:documentation>
//     </xsd:annotation>
//     <xsd:restriction base="xsd:string">
//       <xsd:pattern value="\S+"/>
//     </xsd:restriction>
//   </xsd:simpleType>


trait NonEmptyStringLiteralMixin { /* nothing */ }
object NonEmptyStringLiteral {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="NonEmptyListOfDFDLStringLiteral" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="dfdl:ListOfDFDLStringLiteral">
//       <xsd:minLength value="1"/>
//     </xsd:restriction>
//   </xsd:simpleType>


trait NonEmptyListOfDFDLStringLiteralMixin { /* nothing */ }
object NonEmptyListOfDFDLStringLiteral {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="NonEmptyListOfDFDLStringLiteral_nilValue" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="dfdl:ListOfDFDLStringLiteral">
//     <!-- used for dfdl:nilValue. We can give a much clearer diagnostic with a suggestion
//          on what the user should do instead, ie did they mean to use '%ES;'. So we don't
//          check this here. -->
//       <!-- <xsd:minLength value="1"/> --> 
//     </xsd:restriction>
//   </xsd:simpleType>


trait NonEmptyListOfDFDLStringLiteral_nilValueMixin { /* nothing */ }
object NonEmptyListOfDFDLStringLiteral_nilValue {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="ListOfInteger" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:list itemType="xsd:integer"/>
//   </xsd:simpleType>


trait ListOfIntegerMixin { /* nothing */ }
object ListOfInteger {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="NonEmptyListOfInteger" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="dfdl:ListOfInteger">
//        <xsd:minLength value="1"/> 
//     </xsd:restriction>
//   </xsd:simpleType>


trait NonEmptyListOfIntegerMixin { /* nothing */ }
object NonEmptyListOfInteger {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="NonEmptyListofDFDLStringLiteralOrNonEmptyListOfInteger" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:union memberTypes="dfdl:NonEmptyListOfDFDLStringLiteral dfdl:NonEmptyListOfInteger"/>
//   </xsd:simpleType>


trait NonEmptyListofDFDLStringLiteralOrNonEmptyListOfIntegerMixin { /* nothing */ }
object NonEmptyListofDFDLStringLiteralOrNonEmptyListOfInteger {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="DFDLNonNegativeInteger" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:int">
//       <xsd:minInclusive value="0"/>
//     </xsd:restriction>
//   </xsd:simpleType>


trait DFDLNonNegativeIntegerMixin { /* nothing */ }
object DFDLNonNegativeInteger {
    def apply(s : String, self : ThrowsSDE) = s.toInt
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="DFDLRegularExpression" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//     </xsd:restriction>
//   </xsd:simpleType>


trait DFDLRegularExpressionMixin { /* nothing */ }
object DFDLRegularExpression {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="DFDLQName" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:union>
//       <xsd:simpleType>
//         <xsd:restriction base="xsd:QName"/>
//       </xsd:simpleType>
//       <xsd:simpleType>
//         <xsd:restriction base="xsd:string">
//           <xsd:length value="0"/>
//         </xsd:restriction>
//       </xsd:simpleType>
//     </xsd:union>
//   </xsd:simpleType>


trait DFDLQNameMixin { /* nothing */ }
object DFDLQName {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="EncodingEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:token">
//       <!-- IANA charsets or CCIDSs -->
//       <xsd:pattern value=".{1,60}"/> <!-- at least one character -->
//     </xsd:restriction>
//   </xsd:simpleType>


trait EncodingMixin { /* nothing */ }
object Encoding {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextStringJustificationEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="left"/>
//       <xsd:enumeration value="right"/>
//       <xsd:enumeration value="center"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextStringJustification extends TextStringJustification.Value
object TextStringJustification extends Enum[TextStringJustification] {
  case object Left extends TextStringJustification
  case object Right extends TextStringJustification
  case object Center extends TextStringJustification
  override lazy val values = Array(Left, Right, Center)

  def apply(name: String, context : ThrowsSDE) : TextStringJustification = stringToEnum("textStringJustification", name, context)
}

trait TextStringJustificationMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextStringJustificationLookup = findPropertyOption("textStringJustification")
  final def optionTextStringJustification = if (optionTextStringJustificationLookup.isDefined) Some(textStringJustification) else None
  final def optionTextStringJustification_location = if (optionTextStringJustificationLookup.isDefined) Some(textStringJustification_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textStringJustificationLookup = requireProperty(optionTextStringJustificationLookup)
  final def textStringJustification = TextStringJustification(textStringJustificationLookup.value, this)
  final def textStringJustification_location = textStringJustificationLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textStringJustificationToString() = {
    optionTextStringJustification match {
      case None => "" // empty string if not present
      case Some(textStringJustification) =>  "textStringJustification='" + textStringJustification + "' "
    }
  }

  final def textStringJustificationInit() = {
    registerToStringFunction(() => textStringJustificationToString)
  }

  textStringJustificationInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextNumberJustificationEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="left"/>
//       <xsd:enumeration value="right"/>
//       <xsd:enumeration value="center"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextNumberJustification extends TextNumberJustification.Value
object TextNumberJustification extends Enum[TextNumberJustification] {
  case object Left extends TextNumberJustification
  case object Right extends TextNumberJustification
  case object Center extends TextNumberJustification
  override lazy val values = Array(Left, Right, Center)

  def apply(name: String, context : ThrowsSDE) : TextNumberJustification = stringToEnum("textNumberJustification", name, context)
}

trait TextNumberJustificationMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextNumberJustificationLookup = findPropertyOption("textNumberJustification")
  final def optionTextNumberJustification = if (optionTextNumberJustificationLookup.isDefined) Some(textNumberJustification) else None
  final def optionTextNumberJustification_location = if (optionTextNumberJustificationLookup.isDefined) Some(textNumberJustification_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textNumberJustificationLookup = requireProperty(optionTextNumberJustificationLookup)
  final def textNumberJustification = TextNumberJustification(textNumberJustificationLookup.value, this)
  final def textNumberJustification_location = textNumberJustificationLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textNumberJustificationToString() = {
    optionTextNumberJustification match {
      case None => "" // empty string if not present
      case Some(textNumberJustification) =>  "textNumberJustification='" + textNumberJustification + "' "
    }
  }

  final def textNumberJustificationInit() = {
    registerToStringFunction(() => textNumberJustificationToString)
  }

  textNumberJustificationInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextNumberRoundingEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="pattern"/>
//       <xsd:enumeration value="explicit"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextNumberRounding extends TextNumberRounding.Value
object TextNumberRounding extends Enum[TextNumberRounding] {
  case object Pattern extends TextNumberRounding
  case object Explicit extends TextNumberRounding
  override lazy val values = Array(Pattern, Explicit)

  def apply(name: String, context : ThrowsSDE) : TextNumberRounding = stringToEnum("textNumberRounding", name, context)
}

trait TextNumberRoundingMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextNumberRoundingLookup = findPropertyOption("textNumberRounding")
  final def optionTextNumberRounding = if (optionTextNumberRoundingLookup.isDefined) Some(textNumberRounding) else None
  final def optionTextNumberRounding_location = if (optionTextNumberRoundingLookup.isDefined) Some(textNumberRounding_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textNumberRoundingLookup = requireProperty(optionTextNumberRoundingLookup)
  final def textNumberRounding = TextNumberRounding(textNumberRoundingLookup.value, this)
  final def textNumberRounding_location = textNumberRoundingLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textNumberRoundingToString() = {
    optionTextNumberRounding match {
      case None => "" // empty string if not present
      case Some(textNumberRounding) =>  "textNumberRounding='" + textNumberRounding + "' "
    }
  }

  final def textNumberRoundingInit() = {
    registerToStringFunction(() => textNumberRoundingToString)
  }

  textNumberRoundingInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="SignCodingValue" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="twosComplement"/>
//       <xsd:enumeration value="onesComplement"/>
//       <xsd:enumeration value="signMagnitude"/>
//       <xsd:enumeration value="unsignedBinary"/>
//       <xsd:enumeration value="unsignedDecimal"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait SignCodingValue extends SignCodingValue.Value
object SignCodingValue extends Enum[SignCodingValue] {
  case object TwosComplement extends SignCodingValue
  case object OnesComplement extends SignCodingValue
  case object SignMagnitude extends SignCodingValue
  case object UnsignedBinary extends SignCodingValue
  case object UnsignedDecimal extends SignCodingValue
  override lazy val values = Array(TwosComplement, OnesComplement, SignMagnitude, UnsignedBinary, UnsignedDecimal)

  def apply(name: String, context : ThrowsSDE) : SignCodingValue = stringToEnum("signCodingValue", name, context)
}

trait SignCodingValueMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionSignCodingValueLookup = findPropertyOption("signCodingValue")
  final def optionSignCodingValue = if (optionSignCodingValueLookup.isDefined) Some(signCodingValue) else None
  final def optionSignCodingValue_location = if (optionSignCodingValueLookup.isDefined) Some(signCodingValue_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def signCodingValueLookup = requireProperty(optionSignCodingValueLookup)
  final def signCodingValue = SignCodingValue(signCodingValueLookup.value, this)
  final def signCodingValue_location = signCodingValueLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def signCodingValueToString() = {
    optionSignCodingValue match {
      case None => "" // empty string if not present
      case Some(signCodingValue) =>  "signCodingValue='" + signCodingValue + "' "
    }
  }

  final def signCodingValueInit() = {
    registerToStringFunction(() => signCodingValueToString)
  }

  signCodingValueInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="RepresentationEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="binary"/>
//       <xsd:enumeration value="text"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait Representation extends Representation.Value
object Representation extends Enum[Representation] {
  case object Binary extends Representation
  case object Text extends Representation
  override lazy val values = Array(Binary, Text)

  def apply(name: String, context : ThrowsSDE) : Representation = stringToEnum("representation", name, context)
}

trait RepresentationMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionRepresentationLookup = findPropertyOption("representation")
  final def optionRepresentation = if (optionRepresentationLookup.isDefined) Some(representation) else None
  final def optionRepresentation_location = if (optionRepresentationLookup.isDefined) Some(representation_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def representationLookup = requireProperty(optionRepresentationLookup)
  final def representation = Representation(representationLookup.value, this)
  final def representation_location = representationLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def representationToString() = {
    optionRepresentation match {
      case None => "" // empty string if not present
      case Some(representation) =>  "representation='" + representation + "' "
    }
  }

  final def representationInit() = {
    registerToStringFunction(() => representationToString)
  }

  representationInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextPadKindEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="none"/>
//       <xsd:enumeration value="padChar"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextPadKind extends TextPadKind.Value
object TextPadKind extends Enum[TextPadKind] {
  case object None extends TextPadKind
  case object PadChar extends TextPadKind
  override lazy val values = Array(None, PadChar)

  def apply(name: String, context : ThrowsSDE) : TextPadKind = stringToEnum("textPadKind", name, context)
}

trait TextPadKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextPadKindLookup = findPropertyOption("textPadKind")
  final def optionTextPadKind = if (optionTextPadKindLookup.isDefined) Some(textPadKind) else None
  final def optionTextPadKind_location = if (optionTextPadKindLookup.isDefined) Some(textPadKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textPadKindLookup = requireProperty(optionTextPadKindLookup)
  final def textPadKind = TextPadKind(textPadKindLookup.value, this)
  final def textPadKind_location = textPadKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textPadKindToString() = {
    optionTextPadKind match {
      case None => "" // empty string if not present
      case Some(textPadKind) =>  "textPadKind='" + textPadKind + "' "
    }
  }

  final def textPadKindInit() = {
    registerToStringFunction(() => textPadKindToString)
  }

  textPadKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextTrimKindEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="none"/>
//       <xsd:enumeration value="padChar"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextTrimKind extends TextTrimKind.Value
object TextTrimKind extends Enum[TextTrimKind] {
  case object None extends TextTrimKind
  case object PadChar extends TextTrimKind
  override lazy val values = Array(None, PadChar)

  def apply(name: String, context : ThrowsSDE) : TextTrimKind = stringToEnum("textTrimKind", name, context)
}

trait TextTrimKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextTrimKindLookup = findPropertyOption("textTrimKind")
  final def optionTextTrimKind = if (optionTextTrimKindLookup.isDefined) Some(textTrimKind) else None
  final def optionTextTrimKind_location = if (optionTextTrimKindLookup.isDefined) Some(textTrimKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textTrimKindLookup = requireProperty(optionTextTrimKindLookup)
  final def textTrimKind = TextTrimKind(textTrimKindLookup.value, this)
  final def textTrimKind_location = textTrimKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textTrimKindToString() = {
    optionTextTrimKind match {
      case None => "" // empty string if not present
      case Some(textTrimKind) =>  "textTrimKind='" + textTrimKind + "' "
    }
  }

  final def textTrimKindInit() = {
    registerToStringFunction(() => textTrimKindToString)
  }

  textTrimKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="EscapeKindEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="escapeCharacter"/>
//       <xsd:enumeration value="escapeBlock"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait EscapeKind extends EscapeKind.Value
object EscapeKind extends Enum[EscapeKind] {
  case object EscapeCharacter extends EscapeKind
  case object EscapeBlock extends EscapeKind
  override lazy val values = Array(EscapeCharacter, EscapeBlock)

  def apply(name: String, context : ThrowsSDE) : EscapeKind = stringToEnum("escapeKind", name, context)
}

trait EscapeKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionEscapeKindLookup = findPropertyOption("escapeKind")
  final def optionEscapeKind = if (optionEscapeKindLookup.isDefined) Some(escapeKind) else None
  final def optionEscapeKind_location = if (optionEscapeKindLookup.isDefined) Some(escapeKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def escapeKindLookup = requireProperty(optionEscapeKindLookup)
  final def escapeKind = EscapeKind(escapeKindLookup.value, this)
  final def escapeKind_location = escapeKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def escapeKindToString() = {
    optionEscapeKind match {
      case None => "" // empty string if not present
      case Some(escapeKind) =>  "escapeKind='" + escapeKind + "' "
    }
  }

  final def escapeKindInit() = {
    registerToStringFunction(() => escapeKindToString)
  }

  escapeKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="GenerateEscapeEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="always"/>
//       <xsd:enumeration value="whenNeeded"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait GenerateEscape extends GenerateEscape.Value
object GenerateEscape extends Enum[GenerateEscape] {
  case object Always extends GenerateEscape
  case object WhenNeeded extends GenerateEscape
  override lazy val values = Array(Always, WhenNeeded)

  def apply(name: String, context : ThrowsSDE) : GenerateEscape = stringToEnum("generateEscape", name, context)
}

trait GenerateEscapeMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionGenerateEscapeLookup = findPropertyOption("generateEscape")
  final def optionGenerateEscape = if (optionGenerateEscapeLookup.isDefined) Some(generateEscape) else None
  final def optionGenerateEscape_location = if (optionGenerateEscapeLookup.isDefined) Some(generateEscape_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def generateEscapeLookup = requireProperty(optionGenerateEscapeLookup)
  final def generateEscape = GenerateEscape(generateEscapeLookup.value, this)
  final def generateEscape_location = generateEscapeLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def generateEscapeToString() = {
    optionGenerateEscape match {
      case None => "" // empty string if not present
      case Some(generateEscape) =>  "generateEscape='" + generateEscape + "' "
    }
  }

  final def generateEscapeInit() = {
    registerToStringFunction(() => generateEscapeToString)
  }

  generateEscapeInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextBidiTextOrderingEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="implicit"/>
//       <xsd:enumeration value="visual"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextBidiTextOrdering extends TextBidiTextOrdering.Value
object TextBidiTextOrdering extends Enum[TextBidiTextOrdering] {
  case object Implicit extends TextBidiTextOrdering
  case object Visual extends TextBidiTextOrdering
  override lazy val values = Array(Implicit, Visual)

  def apply(name: String, context : ThrowsSDE) : TextBidiTextOrdering = stringToEnum("textBidiTextOrdering", name, context)
}

trait TextBidiTextOrderingMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextBidiTextOrderingLookup = findPropertyOption("textBidiTextOrdering")
  final def optionTextBidiTextOrdering = if (optionTextBidiTextOrderingLookup.isDefined) Some(textBidiTextOrdering) else None
  final def optionTextBidiTextOrdering_location = if (optionTextBidiTextOrderingLookup.isDefined) Some(textBidiTextOrdering_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textBidiTextOrderingLookup = requireProperty(optionTextBidiTextOrderingLookup)
  final def textBidiTextOrdering = TextBidiTextOrdering(textBidiTextOrderingLookup.value, this)
  final def textBidiTextOrdering_location = textBidiTextOrderingLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textBidiTextOrderingToString() = {
    optionTextBidiTextOrdering match {
      case None => "" // empty string if not present
      case Some(textBidiTextOrdering) =>  "textBidiTextOrdering='" + textBidiTextOrdering + "' "
    }
  }

  final def textBidiTextOrderingInit() = {
    registerToStringFunction(() => textBidiTextOrderingToString)
  }

  textBidiTextOrderingInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextBidiOrientationEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="LTR"/>
//       <xsd:enumeration value="RTL"/>
//       <xsd:enumeration value="contextual_LTR"/>
//       <xsd:enumeration value="contextual_RTL"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextBidiOrientation extends TextBidiOrientation.Value
object TextBidiOrientation extends Enum[TextBidiOrientation] {
  case object LTR extends TextBidiOrientation
  case object RTL extends TextBidiOrientation
  case object Contextual_LTR extends TextBidiOrientation
  case object Contextual_RTL extends TextBidiOrientation
  override lazy val values = Array(LTR, RTL, Contextual_LTR, Contextual_RTL)

  def apply(name: String, context : ThrowsSDE) : TextBidiOrientation = stringToEnum("textBidiOrientation", name, context)
}

trait TextBidiOrientationMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextBidiOrientationLookup = findPropertyOption("textBidiOrientation")
  final def optionTextBidiOrientation = if (optionTextBidiOrientationLookup.isDefined) Some(textBidiOrientation) else None
  final def optionTextBidiOrientation_location = if (optionTextBidiOrientationLookup.isDefined) Some(textBidiOrientation_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textBidiOrientationLookup = requireProperty(optionTextBidiOrientationLookup)
  final def textBidiOrientation = TextBidiOrientation(textBidiOrientationLookup.value, this)
  final def textBidiOrientation_location = textBidiOrientationLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textBidiOrientationToString() = {
    optionTextBidiOrientation match {
      case None => "" // empty string if not present
      case Some(textBidiOrientation) =>  "textBidiOrientation='" + textBidiOrientation + "' "
    }
  }

  final def textBidiOrientationInit() = {
    registerToStringFunction(() => textBidiOrientationToString)
  }

  textBidiOrientationInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextBidiNumeralShapesEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="nominal"/>
//       <xsd:enumeration value="national"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextBidiNumeralShapes extends TextBidiNumeralShapes.Value
object TextBidiNumeralShapes extends Enum[TextBidiNumeralShapes] {
  case object Nominal extends TextBidiNumeralShapes
  case object National extends TextBidiNumeralShapes
  override lazy val values = Array(Nominal, National)

  def apply(name: String, context : ThrowsSDE) : TextBidiNumeralShapes = stringToEnum("textBidiNumeralShapes", name, context)
}

trait TextBidiNumeralShapesMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextBidiNumeralShapesLookup = findPropertyOption("textBidiNumeralShapes")
  final def optionTextBidiNumeralShapes = if (optionTextBidiNumeralShapesLookup.isDefined) Some(textBidiNumeralShapes) else None
  final def optionTextBidiNumeralShapes_location = if (optionTextBidiNumeralShapesLookup.isDefined) Some(textBidiNumeralShapes_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textBidiNumeralShapesLookup = requireProperty(optionTextBidiNumeralShapesLookup)
  final def textBidiNumeralShapes = TextBidiNumeralShapes(textBidiNumeralShapesLookup.value, this)
  final def textBidiNumeralShapes_location = textBidiNumeralShapesLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textBidiNumeralShapesToString() = {
    optionTextBidiNumeralShapes match {
      case None => "" // empty string if not present
      case Some(textBidiNumeralShapes) =>  "textBidiNumeralShapes='" + textBidiNumeralShapes + "' "
    }
  }

  final def textBidiNumeralShapesInit() = {
    registerToStringFunction(() => textBidiNumeralShapesToString)
  }

  textBidiNumeralShapesInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextNumberRepEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="standard"/>
//       <xsd:enumeration value="zoned"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextNumberRep extends TextNumberRep.Value
object TextNumberRep extends Enum[TextNumberRep] {
  case object Standard extends TextNumberRep
  case object Zoned extends TextNumberRep
  override lazy val values = Array(Standard, Zoned)

  def apply(name: String, context : ThrowsSDE) : TextNumberRep = stringToEnum("textNumberRep", name, context)
}

trait TextNumberRepMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextNumberRepLookup = findPropertyOption("textNumberRep")
  final def optionTextNumberRep = if (optionTextNumberRepLookup.isDefined) Some(textNumberRep) else None
  final def optionTextNumberRep_location = if (optionTextNumberRepLookup.isDefined) Some(textNumberRep_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textNumberRepLookup = requireProperty(optionTextNumberRepLookup)
  final def textNumberRep = TextNumberRep(textNumberRepLookup.value, this)
  final def textNumberRep_location = textNumberRepLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textNumberRepToString() = {
    optionTextNumberRep match {
      case None => "" // empty string if not present
      case Some(textNumberRep) =>  "textNumberRep='" + textNumberRep + "' "
    }
  }

  final def textNumberRepInit() = {
    registerToStringFunction(() => textNumberRepToString)
  }

  textNumberRepInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextNumberCheckPolicyEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="strict"/>
//       <xsd:enumeration value="lax"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextNumberCheckPolicy extends TextNumberCheckPolicy.Value
object TextNumberCheckPolicy extends Enum[TextNumberCheckPolicy] {
  case object Strict extends TextNumberCheckPolicy
  case object Lax extends TextNumberCheckPolicy
  override lazy val values = Array(Strict, Lax)

  def apply(name: String, context : ThrowsSDE) : TextNumberCheckPolicy = stringToEnum("textNumberCheckPolicy", name, context)
}

trait TextNumberCheckPolicyMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextNumberCheckPolicyLookup = findPropertyOption("textNumberCheckPolicy")
  final def optionTextNumberCheckPolicy = if (optionTextNumberCheckPolicyLookup.isDefined) Some(textNumberCheckPolicy) else None
  final def optionTextNumberCheckPolicy_location = if (optionTextNumberCheckPolicyLookup.isDefined) Some(textNumberCheckPolicy_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textNumberCheckPolicyLookup = requireProperty(optionTextNumberCheckPolicyLookup)
  final def textNumberCheckPolicy = TextNumberCheckPolicy(textNumberCheckPolicyLookup.value, this)
  final def textNumberCheckPolicy_location = textNumberCheckPolicyLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textNumberCheckPolicyToString() = {
    optionTextNumberCheckPolicy match {
      case None => "" // empty string if not present
      case Some(textNumberCheckPolicy) =>  "textNumberCheckPolicy='" + textNumberCheckPolicy + "' "
    }
  }

  final def textNumberCheckPolicyInit() = {
    registerToStringFunction(() => textNumberCheckPolicyToString)
  }

  textNumberCheckPolicyInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="CalendarCheckPolicyEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="strict"/>
//       <xsd:enumeration value="lax"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait CalendarCheckPolicy extends CalendarCheckPolicy.Value
object CalendarCheckPolicy extends Enum[CalendarCheckPolicy] {
  case object Strict extends CalendarCheckPolicy
  case object Lax extends CalendarCheckPolicy
  override lazy val values = Array(Strict, Lax)

  def apply(name: String, context : ThrowsSDE) : CalendarCheckPolicy = stringToEnum("calendarCheckPolicy", name, context)
}

trait CalendarCheckPolicyMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionCalendarCheckPolicyLookup = findPropertyOption("calendarCheckPolicy")
  final def optionCalendarCheckPolicy = if (optionCalendarCheckPolicyLookup.isDefined) Some(calendarCheckPolicy) else None
  final def optionCalendarCheckPolicy_location = if (optionCalendarCheckPolicyLookup.isDefined) Some(calendarCheckPolicy_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def calendarCheckPolicyLookup = requireProperty(optionCalendarCheckPolicyLookup)
  final def calendarCheckPolicy = CalendarCheckPolicy(calendarCheckPolicyLookup.value, this)
  final def calendarCheckPolicy_location = calendarCheckPolicyLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def calendarCheckPolicyToString() = {
    optionCalendarCheckPolicy match {
      case None => "" // empty string if not present
      case Some(calendarCheckPolicy) =>  "calendarCheckPolicy='" + calendarCheckPolicy + "' "
    }
  }

  final def calendarCheckPolicyInit() = {
    registerToStringFunction(() => calendarCheckPolicyToString)
  }

  calendarCheckPolicyInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextNumberRoundingModeEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="roundCeiling"/>
//       <xsd:enumeration value="roundFloor"/>
//       <xsd:enumeration value="roundDown"/>
//       <xsd:enumeration value="roundUp"/>
//       <xsd:enumeration value="roundHalfEven"/>
//       <xsd:enumeration value="roundHalfDown"/>
//       <xsd:enumeration value="roundHalfUp"/>
//       <xsd:enumeration value="roundUnnecessary"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextNumberRoundingMode extends TextNumberRoundingMode.Value
object TextNumberRoundingMode extends Enum[TextNumberRoundingMode] {
  case object RoundCeiling extends TextNumberRoundingMode
  case object RoundFloor extends TextNumberRoundingMode
  case object RoundDown extends TextNumberRoundingMode
  case object RoundUp extends TextNumberRoundingMode
  case object RoundHalfEven extends TextNumberRoundingMode
  case object RoundHalfDown extends TextNumberRoundingMode
  case object RoundHalfUp extends TextNumberRoundingMode
  case object RoundUnnecessary extends TextNumberRoundingMode
  override lazy val values = Array(RoundCeiling, RoundFloor, RoundDown, RoundUp, RoundHalfEven, RoundHalfDown, RoundHalfUp, RoundUnnecessary)

  def apply(name: String, context : ThrowsSDE) : TextNumberRoundingMode = stringToEnum("textNumberRoundingMode", name, context)
}

trait TextNumberRoundingModeMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextNumberRoundingModeLookup = findPropertyOption("textNumberRoundingMode")
  final def optionTextNumberRoundingMode = if (optionTextNumberRoundingModeLookup.isDefined) Some(textNumberRoundingMode) else None
  final def optionTextNumberRoundingMode_location = if (optionTextNumberRoundingModeLookup.isDefined) Some(textNumberRoundingMode_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textNumberRoundingModeLookup = requireProperty(optionTextNumberRoundingModeLookup)
  final def textNumberRoundingMode = TextNumberRoundingMode(textNumberRoundingModeLookup.value, this)
  final def textNumberRoundingMode_location = textNumberRoundingModeLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textNumberRoundingModeToString() = {
    optionTextNumberRoundingMode match {
      case None => "" // empty string if not present
      case Some(textNumberRoundingMode) =>  "textNumberRoundingMode='" + textNumberRoundingMode + "' "
    }
  }

  final def textNumberRoundingModeInit() = {
    registerToStringFunction(() => textNumberRoundingModeToString)
  }

  textNumberRoundingModeInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextZonedSignStyleEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="asciiStandard"/>
//       <xsd:enumeration value="asciiTranslatedEBCDIC"/>
//       <xsd:enumeration value="asciiCARealiaModified"/>
//       <xsd:enumeration value="asciiTandemModified"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextZonedSignStyle extends TextZonedSignStyle.Value
object TextZonedSignStyle extends Enum[TextZonedSignStyle] {
  case object AsciiStandard extends TextZonedSignStyle
  case object AsciiTranslatedEBCDIC extends TextZonedSignStyle
  case object AsciiCARealiaModified extends TextZonedSignStyle
  case object AsciiTandemModified extends TextZonedSignStyle
  override lazy val values = Array(AsciiStandard, AsciiTranslatedEBCDIC, AsciiCARealiaModified, AsciiTandemModified)

  def apply(name: String, context : ThrowsSDE) : TextZonedSignStyle = stringToEnum("textZonedSignStyle", name, context)
}

trait TextZonedSignStyleMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextZonedSignStyleLookup = findPropertyOption("textZonedSignStyle")
  final def optionTextZonedSignStyle = if (optionTextZonedSignStyleLookup.isDefined) Some(textZonedSignStyle) else None
  final def optionTextZonedSignStyle_location = if (optionTextZonedSignStyleLookup.isDefined) Some(textZonedSignStyle_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textZonedSignStyleLookup = requireProperty(optionTextZonedSignStyleLookup)
  final def textZonedSignStyle = TextZonedSignStyle(textZonedSignStyleLookup.value, this)
  final def textZonedSignStyle_location = textZonedSignStyleLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textZonedSignStyleToString() = {
    optionTextZonedSignStyle match {
      case None => "" // empty string if not present
      case Some(textZonedSignStyle) =>  "textZonedSignStyle='" + textZonedSignStyle + "' "
    }
  }

  final def textZonedSignStyleInit() = {
    registerToStringFunction(() => textZonedSignStyleToString)
  }

  textZonedSignStyleInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="BinaryNumberRepEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="packed"/>
//       <xsd:enumeration value="bcd"/>
//       <xsd:enumeration value="binary"/>
//       <xsd:enumeration value="ibm4690Packed"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait BinaryNumberRep extends BinaryNumberRep.Value
object BinaryNumberRep extends Enum[BinaryNumberRep] {
  case object Packed extends BinaryNumberRep
  case object Bcd extends BinaryNumberRep
  case object Binary extends BinaryNumberRep
  case object Ibm4690Packed extends BinaryNumberRep
  override lazy val values = Array(Packed, Bcd, Binary, Ibm4690Packed)

  def apply(name: String, context : ThrowsSDE) : BinaryNumberRep = stringToEnum("binaryNumberRep", name, context)
}

trait BinaryNumberRepMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionBinaryNumberRepLookup = findPropertyOption("binaryNumberRep")
  final def optionBinaryNumberRep = if (optionBinaryNumberRepLookup.isDefined) Some(binaryNumberRep) else None
  final def optionBinaryNumberRep_location = if (optionBinaryNumberRepLookup.isDefined) Some(binaryNumberRep_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def binaryNumberRepLookup = requireProperty(optionBinaryNumberRepLookup)
  final def binaryNumberRep = BinaryNumberRep(binaryNumberRepLookup.value, this)
  final def binaryNumberRep_location = binaryNumberRepLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def binaryNumberRepToString() = {
    optionBinaryNumberRep match {
      case None => "" // empty string if not present
      case Some(binaryNumberRep) =>  "binaryNumberRep='" + binaryNumberRep + "' "
    }
  }

  final def binaryNumberRepInit() = {
    registerToStringFunction(() => binaryNumberRepToString)
  }

  binaryNumberRepInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="BinaryNumberCheckPolicyEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="strict"/>
//       <xsd:enumeration value="lax"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait BinaryNumberCheckPolicy extends BinaryNumberCheckPolicy.Value
object BinaryNumberCheckPolicy extends Enum[BinaryNumberCheckPolicy] {
  case object Strict extends BinaryNumberCheckPolicy
  case object Lax extends BinaryNumberCheckPolicy
  override lazy val values = Array(Strict, Lax)

  def apply(name: String, context : ThrowsSDE) : BinaryNumberCheckPolicy = stringToEnum("binaryNumberCheckPolicy", name, context)
}

trait BinaryNumberCheckPolicyMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionBinaryNumberCheckPolicyLookup = findPropertyOption("binaryNumberCheckPolicy")
  final def optionBinaryNumberCheckPolicy = if (optionBinaryNumberCheckPolicyLookup.isDefined) Some(binaryNumberCheckPolicy) else None
  final def optionBinaryNumberCheckPolicy_location = if (optionBinaryNumberCheckPolicyLookup.isDefined) Some(binaryNumberCheckPolicy_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def binaryNumberCheckPolicyLookup = requireProperty(optionBinaryNumberCheckPolicyLookup)
  final def binaryNumberCheckPolicy = BinaryNumberCheckPolicy(binaryNumberCheckPolicyLookup.value, this)
  final def binaryNumberCheckPolicy_location = binaryNumberCheckPolicyLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def binaryNumberCheckPolicyToString() = {
    optionBinaryNumberCheckPolicy match {
      case None => "" // empty string if not present
      case Some(binaryNumberCheckPolicy) =>  "binaryNumberCheckPolicy='" + binaryNumberCheckPolicy + "' "
    }
  }

  final def binaryNumberCheckPolicyInit() = {
    registerToStringFunction(() => binaryNumberCheckPolicyToString)
  }

  binaryNumberCheckPolicyInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="BinaryFloatRepEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="ieee"/>
//       <xsd:enumeration value="ibm390Hex"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait BinaryFloatRep extends BinaryFloatRep.Value
object BinaryFloatRep extends Enum[BinaryFloatRep] {
  case object Ieee extends BinaryFloatRep
  case object Ibm390Hex extends BinaryFloatRep
  override lazy val values = Array(Ieee, Ibm390Hex)

  def apply(name: String, context : ThrowsSDE) : BinaryFloatRep = stringToEnum("binaryFloatRep", name, context)
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextBooleanJustificationEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="left"/>
//       <xsd:enumeration value="right"/>
//       <xsd:enumeration value="center"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextBooleanJustification extends TextBooleanJustification.Value
object TextBooleanJustification extends Enum[TextBooleanJustification] {
  case object Left extends TextBooleanJustification
  case object Right extends TextBooleanJustification
  case object Center extends TextBooleanJustification
  override lazy val values = Array(Left, Right, Center)

  def apply(name: String, context : ThrowsSDE) : TextBooleanJustification = stringToEnum("textBooleanJustification", name, context)
}

trait TextBooleanJustificationMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextBooleanJustificationLookup = findPropertyOption("textBooleanJustification")
  final def optionTextBooleanJustification = if (optionTextBooleanJustificationLookup.isDefined) Some(textBooleanJustification) else None
  final def optionTextBooleanJustification_location = if (optionTextBooleanJustificationLookup.isDefined) Some(textBooleanJustification_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textBooleanJustificationLookup = requireProperty(optionTextBooleanJustificationLookup)
  final def textBooleanJustification = TextBooleanJustification(textBooleanJustificationLookup.value, this)
  final def textBooleanJustification_location = textBooleanJustificationLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textBooleanJustificationToString() = {
    optionTextBooleanJustification match {
      case None => "" // empty string if not present
      case Some(textBooleanJustification) =>  "textBooleanJustification='" + textBooleanJustification + "' "
    }
  }

  final def textBooleanJustificationInit() = {
    registerToStringFunction(() => textBooleanJustificationToString)
  }

  textBooleanJustificationInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TextCalendarJustificationEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="left"/>
//       <xsd:enumeration value="right"/>
//       <xsd:enumeration value="center"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TextCalendarJustification extends TextCalendarJustification.Value
object TextCalendarJustification extends Enum[TextCalendarJustification] {
  case object Left extends TextCalendarJustification
  case object Right extends TextCalendarJustification
  case object Center extends TextCalendarJustification
  override lazy val values = Array(Left, Right, Center)

  def apply(name: String, context : ThrowsSDE) : TextCalendarJustification = stringToEnum("textCalendarJustification", name, context)
}

trait TextCalendarJustificationMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTextCalendarJustificationLookup = findPropertyOption("textCalendarJustification")
  final def optionTextCalendarJustification = if (optionTextCalendarJustificationLookup.isDefined) Some(textCalendarJustification) else None
  final def optionTextCalendarJustification_location = if (optionTextCalendarJustificationLookup.isDefined) Some(textCalendarJustification_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def textCalendarJustificationLookup = requireProperty(optionTextCalendarJustificationLookup)
  final def textCalendarJustification = TextCalendarJustification(textCalendarJustificationLookup.value, this)
  final def textCalendarJustification_location = textCalendarJustificationLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def textCalendarJustificationToString() = {
    optionTextCalendarJustification match {
      case None => "" // empty string if not present
      case Some(textCalendarJustification) =>  "textCalendarJustification='" + textCalendarJustification + "' "
    }
  }

  final def textCalendarJustificationInit() = {
    registerToStringFunction(() => textCalendarJustificationToString)
  }

  textCalendarJustificationInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="CalendarPatternKindEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="explicit"/>
//       <xsd:enumeration value="implicit"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait CalendarPatternKind extends CalendarPatternKind.Value
object CalendarPatternKind extends Enum[CalendarPatternKind] {
  case object Explicit extends CalendarPatternKind
  case object Implicit extends CalendarPatternKind
  override lazy val values = Array(Explicit, Implicit)

  def apply(name: String, context : ThrowsSDE) : CalendarPatternKind = stringToEnum("calendarPatternKind", name, context)
}

trait CalendarPatternKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionCalendarPatternKindLookup = findPropertyOption("calendarPatternKind")
  final def optionCalendarPatternKind = if (optionCalendarPatternKindLookup.isDefined) Some(calendarPatternKind) else None
  final def optionCalendarPatternKind_location = if (optionCalendarPatternKindLookup.isDefined) Some(calendarPatternKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def calendarPatternKindLookup = requireProperty(optionCalendarPatternKindLookup)
  final def calendarPatternKind = CalendarPatternKind(calendarPatternKindLookup.value, this)
  final def calendarPatternKind_location = calendarPatternKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def calendarPatternKindToString() = {
    optionCalendarPatternKind match {
      case None => "" // empty string if not present
      case Some(calendarPatternKind) =>  "calendarPatternKind='" + calendarPatternKind + "' "
    }
  }

  final def calendarPatternKindInit() = {
    registerToStringFunction(() => calendarPatternKindToString)
  }

  calendarPatternKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="CalendarTimeZoneType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:union>
//       <xsd:simpleType>
//         <xsd:restriction base="xsd:string">
//           <xsd:pattern value="(UTC)([+\-]([01]\d|\d)((([:][0-5]\d){1,2})?))?"/>
//         </xsd:restriction>
//       </xsd:simpleType>
//       <xsd:simpleType>
//         <xsd:restriction base="xsd:string">
//           <xsd:length value="0"/>
//         </xsd:restriction>
//       </xsd:simpleType>
//     </xsd:union>
//     
//   </xsd:simpleType>


trait CalendarTimeZoneTypeMixin { /* nothing */ }
object CalendarTimeZoneType {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="CalendarLanguageType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:union>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:DFDLStringLiteral">
//         <!-- A pattern is used instead of an enumeration for compactness -->
//           <xsd:pattern value="([A-Za-z]{1,8}([-_][A-Za-z0-9]{1,8})*)"/>
//         </xsd:restriction>
//       </xsd:simpleType>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:DFDLExpression"/>
//       </xsd:simpleType>
//     </xsd:union>
//   </xsd:simpleType>


trait CalendarLanguageTypeMixin { /* nothing */ }
object CalendarLanguageType {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="CalendarFirstDayOfWeekEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="Monday"/>
//       <xsd:enumeration value="Tuesday"/>
//       <xsd:enumeration value="Wednesday"/>
//       <xsd:enumeration value="Thursday"/>
//       <xsd:enumeration value="Friday"/>
//       <xsd:enumeration value="Saturday"/>
//       <xsd:enumeration value="Sunday"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait CalendarFirstDayOfWeek extends CalendarFirstDayOfWeek.Value
object CalendarFirstDayOfWeek extends Enum[CalendarFirstDayOfWeek] {
  case object Monday extends CalendarFirstDayOfWeek
  case object Tuesday extends CalendarFirstDayOfWeek
  case object Wednesday extends CalendarFirstDayOfWeek
  case object Thursday extends CalendarFirstDayOfWeek
  case object Friday extends CalendarFirstDayOfWeek
  case object Saturday extends CalendarFirstDayOfWeek
  case object Sunday extends CalendarFirstDayOfWeek
  override lazy val values = Array(Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday)

  def apply(name: String, context : ThrowsSDE) : CalendarFirstDayOfWeek = stringToEnum("calendarFirstDayOfWeek", name, context)
}

trait CalendarFirstDayOfWeekMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionCalendarFirstDayOfWeekLookup = findPropertyOption("calendarFirstDayOfWeek")
  final def optionCalendarFirstDayOfWeek = if (optionCalendarFirstDayOfWeekLookup.isDefined) Some(calendarFirstDayOfWeek) else None
  final def optionCalendarFirstDayOfWeek_location = if (optionCalendarFirstDayOfWeekLookup.isDefined) Some(calendarFirstDayOfWeek_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def calendarFirstDayOfWeekLookup = requireProperty(optionCalendarFirstDayOfWeekLookup)
  final def calendarFirstDayOfWeek = CalendarFirstDayOfWeek(calendarFirstDayOfWeekLookup.value, this)
  final def calendarFirstDayOfWeek_location = calendarFirstDayOfWeekLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def calendarFirstDayOfWeekToString() = {
    optionCalendarFirstDayOfWeek match {
      case None => "" // empty string if not present
      case Some(calendarFirstDayOfWeek) =>  "calendarFirstDayOfWeek='" + calendarFirstDayOfWeek + "' "
    }
  }

  final def calendarFirstDayOfWeekInit() = {
    registerToStringFunction(() => calendarFirstDayOfWeekToString)
  }

  calendarFirstDayOfWeekInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="BinaryCalendarRepEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="packed"/>
//       <xsd:enumeration value="bcd"/>
//       <xsd:enumeration value="binarySeconds"/>
//       <xsd:enumeration value="binaryMilliseconds"/>
//       <xsd:enumeration value="ibm4690Packed"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait BinaryCalendarRep extends BinaryCalendarRep.Value
object BinaryCalendarRep extends Enum[BinaryCalendarRep] {
  case object Packed extends BinaryCalendarRep
  case object Bcd extends BinaryCalendarRep
  case object BinarySeconds extends BinaryCalendarRep
  case object BinaryMilliseconds extends BinaryCalendarRep
  case object Ibm4690Packed extends BinaryCalendarRep
  override lazy val values = Array(Packed, Bcd, BinarySeconds, BinaryMilliseconds, Ibm4690Packed)

  def apply(name: String, context : ThrowsSDE) : BinaryCalendarRep = stringToEnum("binaryCalendarRep", name, context)
}

trait BinaryCalendarRepMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionBinaryCalendarRepLookup = findPropertyOption("binaryCalendarRep")
  final def optionBinaryCalendarRep = if (optionBinaryCalendarRepLookup.isDefined) Some(binaryCalendarRep) else None
  final def optionBinaryCalendarRep_location = if (optionBinaryCalendarRepLookup.isDefined) Some(binaryCalendarRep_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def binaryCalendarRepLookup = requireProperty(optionBinaryCalendarRepLookup)
  final def binaryCalendarRep = BinaryCalendarRep(binaryCalendarRepLookup.value, this)
  final def binaryCalendarRep_location = binaryCalendarRepLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def binaryCalendarRepToString() = {
    optionBinaryCalendarRep match {
      case None => "" // empty string if not present
      case Some(binaryCalendarRep) =>  "binaryCalendarRep='" + binaryCalendarRep + "' "
    }
  }

  final def binaryCalendarRepInit() = {
    registerToStringFunction(() => binaryCalendarRepToString)
  }

  binaryCalendarRepInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="LengthKindEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="explicit"/>
//       <xsd:enumeration value="delimited"/>
//       <xsd:enumeration value="implicit"/>
//       <xsd:enumeration value="prefixed"/>
//       <xsd:enumeration value="endOfParent"/>
//       <xsd:enumeration value="pattern"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait LengthKind extends LengthKind.Value
object LengthKind extends Enum[LengthKind] {
  case object Explicit extends LengthKind
  case object Delimited extends LengthKind
  case object Implicit extends LengthKind
  case object Prefixed extends LengthKind
  case object EndOfParent extends LengthKind
  case object Pattern extends LengthKind
  override lazy val values = Array(Explicit, Delimited, Implicit, Prefixed, EndOfParent, Pattern)

  def apply(name: String, context : ThrowsSDE) : LengthKind = stringToEnum("lengthKind", name, context)
}

trait LengthKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionLengthKindLookup = findPropertyOption("lengthKind")
  final def optionLengthKind = if (optionLengthKindLookup.isDefined) Some(lengthKind) else None
  final def optionLengthKind_location = if (optionLengthKindLookup.isDefined) Some(lengthKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def lengthKindLookup = requireProperty(optionLengthKindLookup)
  final def lengthKind = LengthKind(lengthKindLookup.value, this)
  final def lengthKind_location = lengthKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def lengthKindToString() = {
    optionLengthKind match {
      case None => "" // empty string if not present
      case Some(lengthKind) =>  "lengthKind='" + lengthKind + "' "
    }
  }

  final def lengthKindInit() = {
    registerToStringFunction(() => lengthKindToString)
  }

  lengthKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="NilKindEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="literalValue"/>
//       <xsd:enumeration value="logicalValue"/>
//       <xsd:enumeration value="literalCharacter"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait NilKind extends NilKind.Value
object NilKind extends Enum[NilKind] {
  case object LiteralValue extends NilKind
  case object LogicalValue extends NilKind
  case object LiteralCharacter extends NilKind
  override lazy val values = Array(LiteralValue, LogicalValue, LiteralCharacter)

  def apply(name: String, context : ThrowsSDE) : NilKind = stringToEnum("nilKind", name, context)
}

trait NilKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionNilKindLookup = findPropertyOption("nilKind")
  final def optionNilKind = if (optionNilKindLookup.isDefined) Some(nilKind) else None
  final def optionNilKind_location = if (optionNilKindLookup.isDefined) Some(nilKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def nilKindLookup = requireProperty(optionNilKindLookup)
  final def nilKind = NilKind(nilKindLookup.value, this)
  final def nilKind_location = nilKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def nilKindToString() = {
    optionNilKind match {
      case None => "" // empty string if not present
      case Some(nilKind) =>  "nilKind='" + nilKind + "' "
    }
  }

  final def nilKindInit() = {
    registerToStringFunction(() => nilKindToString)
  }

  nilKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="NilValueDelimiterPolicyEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="none"/>
//       <xsd:enumeration value="initiator"/>
//       <xsd:enumeration value="terminator"/>
//       <xsd:enumeration value="both"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait NilValueDelimiterPolicy extends NilValueDelimiterPolicy.Value
object NilValueDelimiterPolicy extends Enum[NilValueDelimiterPolicy] {
  case object None extends NilValueDelimiterPolicy
  case object Initiator extends NilValueDelimiterPolicy
  case object Terminator extends NilValueDelimiterPolicy
  case object Both extends NilValueDelimiterPolicy
  override lazy val values = Array(None, Initiator, Terminator, Both)

  def apply(name: String, context : ThrowsSDE) : NilValueDelimiterPolicy = stringToEnum("nilValueDelimiterPolicy", name, context)
}

trait NilValueDelimiterPolicyMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionNilValueDelimiterPolicyLookup = findPropertyOption("nilValueDelimiterPolicy")
  final def optionNilValueDelimiterPolicy = if (optionNilValueDelimiterPolicyLookup.isDefined) Some(nilValueDelimiterPolicy) else None
  final def optionNilValueDelimiterPolicy_location = if (optionNilValueDelimiterPolicyLookup.isDefined) Some(nilValueDelimiterPolicy_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def nilValueDelimiterPolicyLookup = requireProperty(optionNilValueDelimiterPolicyLookup)
  final def nilValueDelimiterPolicy = NilValueDelimiterPolicy(nilValueDelimiterPolicyLookup.value, this)
  final def nilValueDelimiterPolicy_location = nilValueDelimiterPolicyLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def nilValueDelimiterPolicyToString() = {
    optionNilValueDelimiterPolicy match {
      case None => "" // empty string if not present
      case Some(nilValueDelimiterPolicy) =>  "nilValueDelimiterPolicy='" + nilValueDelimiterPolicy + "' "
    }
  }

  final def nilValueDelimiterPolicyInit() = {
    registerToStringFunction(() => nilValueDelimiterPolicyToString)
  }

  nilValueDelimiterPolicyInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="EmptyValueDelimiterPolicyEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="none"/>
//       <xsd:enumeration value="initiator"/>
//       <xsd:enumeration value="terminator"/>
//       <xsd:enumeration value="both"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait EmptyValueDelimiterPolicy extends EmptyValueDelimiterPolicy.Value
object EmptyValueDelimiterPolicy extends Enum[EmptyValueDelimiterPolicy] {
  case object None extends EmptyValueDelimiterPolicy
  case object Initiator extends EmptyValueDelimiterPolicy
  case object Terminator extends EmptyValueDelimiterPolicy
  case object Both extends EmptyValueDelimiterPolicy
  override lazy val values = Array(None, Initiator, Terminator, Both)

  def apply(name: String, context : ThrowsSDE) : EmptyValueDelimiterPolicy = stringToEnum("emptyValueDelimiterPolicy", name, context)
}

trait EmptyValueDelimiterPolicyMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionEmptyValueDelimiterPolicyLookup = findPropertyOption("emptyValueDelimiterPolicy")
  final def optionEmptyValueDelimiterPolicy = if (optionEmptyValueDelimiterPolicyLookup.isDefined) Some(emptyValueDelimiterPolicy) else None
  final def optionEmptyValueDelimiterPolicy_location = if (optionEmptyValueDelimiterPolicyLookup.isDefined) Some(emptyValueDelimiterPolicy_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def emptyValueDelimiterPolicyLookup = requireProperty(optionEmptyValueDelimiterPolicyLookup)
  final def emptyValueDelimiterPolicy = EmptyValueDelimiterPolicy(emptyValueDelimiterPolicyLookup.value, this)
  final def emptyValueDelimiterPolicy_location = emptyValueDelimiterPolicyLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def emptyValueDelimiterPolicyToString() = {
    optionEmptyValueDelimiterPolicy match {
      case None => "" // empty string if not present
      case Some(emptyValueDelimiterPolicy) =>  "emptyValueDelimiterPolicy='" + emptyValueDelimiterPolicy + "' "
    }
  }

  final def emptyValueDelimiterPolicyInit() = {
    registerToStringFunction(() => emptyValueDelimiterPolicyToString)
  }

  emptyValueDelimiterPolicyInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="SequenceKindEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="ordered"/>
//       <xsd:enumeration value="unordered"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait SequenceKind extends SequenceKind.Value
object SequenceKind extends Enum[SequenceKind] {
  case object Ordered extends SequenceKind
  case object Unordered extends SequenceKind
  override lazy val values = Array(Ordered, Unordered)

  def apply(name: String, context : ThrowsSDE) : SequenceKind = stringToEnum("sequenceKind", name, context)
}

trait SequenceKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionSequenceKindLookup = findPropertyOption("sequenceKind")
  final def optionSequenceKind = if (optionSequenceKindLookup.isDefined) Some(sequenceKind) else None
  final def optionSequenceKind_location = if (optionSequenceKindLookup.isDefined) Some(sequenceKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def sequenceKindLookup = requireProperty(optionSequenceKindLookup)
  final def sequenceKind = SequenceKind(sequenceKindLookup.value, this)
  final def sequenceKind_location = sequenceKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def sequenceKindToString() = {
    optionSequenceKind match {
      case None => "" // empty string if not present
      case Some(sequenceKind) =>  "sequenceKind='" + sequenceKind + "' "
    }
  }

  final def sequenceKindInit() = {
    registerToStringFunction(() => sequenceKindToString)
  }

  sequenceKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="LengthUnitsEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="bits"/>
//       <xsd:enumeration value="bytes"/>
//       <xsd:enumeration value="characters"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait LengthUnits extends LengthUnits.Value
object LengthUnits extends Enum[LengthUnits] {
  case object Bits extends LengthUnits
  case object Bytes extends LengthUnits
  case object Characters extends LengthUnits
  override lazy val values = Array(Bits, Bytes, Characters)

  def apply(name: String, context : ThrowsSDE) : LengthUnits = stringToEnum("lengthUnits", name, context)
}

trait LengthUnitsMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionLengthUnitsLookup = findPropertyOption("lengthUnits")
  final def optionLengthUnits = if (optionLengthUnitsLookup.isDefined) Some(lengthUnits) else None
  final def optionLengthUnits_location = if (optionLengthUnitsLookup.isDefined) Some(lengthUnits_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def lengthUnitsLookup = requireProperty(optionLengthUnitsLookup)
  final def lengthUnits = LengthUnits(lengthUnitsLookup.value, this)
  final def lengthUnits_location = lengthUnitsLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def lengthUnitsToString() = {
    optionLengthUnits match {
      case None => "" // empty string if not present
      case Some(lengthUnits) =>  "lengthUnits='" + lengthUnits + "' "
    }
  }

  final def lengthUnitsInit() = {
    registerToStringFunction(() => lengthUnitsToString)
  }

  lengthUnitsInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="AlignmentUnitsEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="bits"/>
//       <xsd:enumeration value="bytes"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait AlignmentUnits extends AlignmentUnits.Value
object AlignmentUnits extends Enum[AlignmentUnits] {
  case object Bits extends AlignmentUnits
  case object Bytes extends AlignmentUnits
  override lazy val values = Array(Bits, Bytes)

  def apply(name: String, context : ThrowsSDE) : AlignmentUnits = stringToEnum("alignmentUnits", name, context)
}

trait AlignmentUnitsMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionAlignmentUnitsLookup = findPropertyOption("alignmentUnits")
  final def optionAlignmentUnits = if (optionAlignmentUnitsLookup.isDefined) Some(alignmentUnits) else None
  final def optionAlignmentUnits_location = if (optionAlignmentUnitsLookup.isDefined) Some(alignmentUnits_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def alignmentUnitsLookup = requireProperty(optionAlignmentUnitsLookup)
  final def alignmentUnits = AlignmentUnits(alignmentUnitsLookup.value, this)
  final def alignmentUnits_location = alignmentUnitsLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def alignmentUnitsToString() = {
    optionAlignmentUnits match {
      case None => "" // empty string if not present
      case Some(alignmentUnits) =>  "alignmentUnits='" + alignmentUnits + "' "
    }
  }

  final def alignmentUnitsInit() = {
    registerToStringFunction(() => alignmentUnitsToString)
  }

  alignmentUnitsInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="GenerateQuotesEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="always"/>
//       <xsd:enumeration value="whenNeeded"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait GenerateQuotes extends GenerateQuotes.Value
object GenerateQuotes extends Enum[GenerateQuotes] {
  case object Always extends GenerateQuotes
  case object WhenNeeded extends GenerateQuotes
  override lazy val values = Array(Always, WhenNeeded)

  def apply(name: String, context : ThrowsSDE) : GenerateQuotes = stringToEnum("generateQuotes", name, context)
}

trait GenerateQuotesMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionGenerateQuotesLookup = findPropertyOption("generateQuotes")
  final def optionGenerateQuotes = if (optionGenerateQuotesLookup.isDefined) Some(generateQuotes) else None
  final def optionGenerateQuotes_location = if (optionGenerateQuotesLookup.isDefined) Some(generateQuotes_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def generateQuotesLookup = requireProperty(optionGenerateQuotesLookup)
  final def generateQuotes = GenerateQuotes(generateQuotesLookup.value, this)
  final def generateQuotes_location = generateQuotesLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def generateQuotesToString() = {
    optionGenerateQuotes match {
      case None => "" // empty string if not present
      case Some(generateQuotes) =>  "generateQuotes='" + generateQuotes + "' "
    }
  }

  final def generateQuotesInit() = {
    registerToStringFunction(() => generateQuotesToString)
  }

  generateQuotesInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="SeparatorPositionEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="infix"/>
//       <xsd:enumeration value="prefix"/>
//       <xsd:enumeration value="postfix"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait SeparatorPosition extends SeparatorPosition.Value
object SeparatorPosition extends Enum[SeparatorPosition] {
  case object Infix extends SeparatorPosition
  case object Prefix extends SeparatorPosition
  case object Postfix extends SeparatorPosition
  override lazy val values = Array(Infix, Prefix, Postfix)

  def apply(name: String, context : ThrowsSDE) : SeparatorPosition = stringToEnum("separatorPosition", name, context)
}

trait SeparatorPositionMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionSeparatorPositionLookup = findPropertyOption("separatorPosition")
  final def optionSeparatorPosition = if (optionSeparatorPositionLookup.isDefined) Some(separatorPosition) else None
  final def optionSeparatorPosition_location = if (optionSeparatorPositionLookup.isDefined) Some(separatorPosition_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def separatorPositionLookup = requireProperty(optionSeparatorPositionLookup)
  final def separatorPosition = SeparatorPosition(separatorPositionLookup.value, this)
  final def separatorPosition_location = separatorPositionLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def separatorPositionToString() = {
    optionSeparatorPosition match {
      case None => "" // empty string if not present
      case Some(separatorPosition) =>  "separatorPosition='" + separatorPosition + "' "
    }
  }

  final def separatorPositionInit() = {
    registerToStringFunction(() => separatorPositionToString)
  }

  separatorPositionInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="SeparatorPolicyEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="required"/>
//       <xsd:enumeration value="suppressed"/>
//       <xsd:enumeration value="suppressedAtEndStrict"/>
//       <xsd:enumeration value="suppressedAtEndLax"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait SeparatorPolicy extends SeparatorPolicy.Value
object SeparatorPolicy extends Enum[SeparatorPolicy] {
  case object Required extends SeparatorPolicy
  case object Suppressed extends SeparatorPolicy
  case object SuppressedAtEndStrict extends SeparatorPolicy
  case object SuppressedAtEndLax extends SeparatorPolicy
  override lazy val values = Array(Required, Suppressed, SuppressedAtEndStrict, SuppressedAtEndLax)

  def apply(name: String, context : ThrowsSDE) : SeparatorPolicy = stringToEnum("separatorPolicy", name, context)
}

trait SeparatorPolicyMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionSeparatorPolicyLookup = findPropertyOption("separatorPolicy")
  final def optionSeparatorPolicy = if (optionSeparatorPolicyLookup.isDefined) Some(separatorPolicy) else None
  final def optionSeparatorPolicy_location = if (optionSeparatorPolicyLookup.isDefined) Some(separatorPolicy_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def separatorPolicyLookup = requireProperty(optionSeparatorPolicyLookup)
  final def separatorPolicy = SeparatorPolicy(separatorPolicyLookup.value, this)
  final def separatorPolicy_location = separatorPolicyLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def separatorPolicyToString() = {
    optionSeparatorPolicy match {
      case None => "" // empty string if not present
      case Some(separatorPolicy) =>  "separatorPolicy='" + separatorPolicy + "' "
    }
  }

  final def separatorPolicyInit() = {
    registerToStringFunction(() => separatorPolicyToString)
  }

  separatorPolicyInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="ChoiceLengthKindEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="implicit"/>
//       <xsd:enumeration value="explicit"/>
//     </xsd:restriction>
// 
//   </xsd:simpleType>

sealed trait ChoiceLengthKind extends ChoiceLengthKind.Value
object ChoiceLengthKind extends Enum[ChoiceLengthKind] {
  case object Implicit extends ChoiceLengthKind
  case object Explicit extends ChoiceLengthKind
  override lazy val values = Array(Implicit, Explicit)

  def apply(name: String, context : ThrowsSDE) : ChoiceLengthKind = stringToEnum("choiceLengthKind", name, context)
}

trait ChoiceLengthKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionChoiceLengthKindLookup = findPropertyOption("choiceLengthKind")
  final def optionChoiceLengthKind = if (optionChoiceLengthKindLookup.isDefined) Some(choiceLengthKind) else None
  final def optionChoiceLengthKind_location = if (optionChoiceLengthKindLookup.isDefined) Some(choiceLengthKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def choiceLengthKindLookup = requireProperty(optionChoiceLengthKindLookup)
  final def choiceLengthKind = ChoiceLengthKind(choiceLengthKindLookup.value, this)
  final def choiceLengthKind_location = choiceLengthKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def choiceLengthKindToString() = {
    optionChoiceLengthKind match {
      case None => "" // empty string if not present
      case Some(choiceLengthKind) =>  "choiceLengthKind='" + choiceLengthKind + "' "
    }
  }

  final def choiceLengthKindInit() = {
    registerToStringFunction(() => choiceLengthKindToString)
  }

  choiceLengthKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="OccursCountKindEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="fixed"/>
//       <xsd:enumeration value="expression"/>
//       <xsd:enumeration value="parsed"/>
//       <xsd:enumeration value="stopValue"/>
//       <xsd:enumeration value="implicit"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait OccursCountKind extends OccursCountKind.Value
object OccursCountKind extends Enum[OccursCountKind] {
  case object Fixed extends OccursCountKind
  case object Expression extends OccursCountKind
  case object Parsed extends OccursCountKind
  case object StopValue extends OccursCountKind
  case object Implicit extends OccursCountKind
  override lazy val values = Array(Fixed, Expression, Parsed, StopValue, Implicit)

  def apply(name: String, context : ThrowsSDE) : OccursCountKind = stringToEnum("occursCountKind", name, context)
}

trait OccursCountKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionOccursCountKindLookup = findPropertyOption("occursCountKind")
  final def optionOccursCountKind = if (optionOccursCountKindLookup.isDefined) Some(occursCountKind) else None
  final def optionOccursCountKind_location = if (optionOccursCountKindLookup.isDefined) Some(occursCountKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def occursCountKindLookup = requireProperty(optionOccursCountKindLookup)
  final def occursCountKind = OccursCountKind(occursCountKindLookup.value, this)
  final def occursCountKind_location = occursCountKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def occursCountKindToString() = {
    optionOccursCountKind match {
      case None => "" // empty string if not present
      case Some(occursCountKind) =>  "occursCountKind='" + occursCountKind + "' "
    }
  }

  final def occursCountKindInit() = {
    registerToStringFunction(() => occursCountKindToString)
  }

  occursCountKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="ByteOrderEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="littleEndian"/>
//       <xsd:enumeration value="bigEndian"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait ByteOrder extends ByteOrder.Value
object ByteOrder extends Enum[ByteOrder] {
  case object LittleEndian extends ByteOrder
  case object BigEndian extends ByteOrder
  override lazy val values = Array(LittleEndian, BigEndian)

  def apply(name: String, context : ThrowsSDE) : ByteOrder = stringToEnum("byteOrder", name, context)
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="BitOrderEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="mostSignificantBitFirst"/>
//       <xsd:enumeration value="leastSignificantBitFirst"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait BitOrder extends BitOrder.Value
object BitOrder extends Enum[BitOrder] {
  case object MostSignificantBitFirst extends BitOrder
  case object LeastSignificantBitFirst extends BitOrder
  override lazy val values = Array(MostSignificantBitFirst, LeastSignificantBitFirst)

  def apply(name: String, context : ThrowsSDE) : BitOrder = stringToEnum("bitOrder", name, context)
}

trait BitOrderMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionBitOrderLookup = findPropertyOption("bitOrder")
  final def optionBitOrder = if (optionBitOrderLookup.isDefined) Some(bitOrder) else None
  final def optionBitOrder_location = if (optionBitOrderLookup.isDefined) Some(bitOrder_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def bitOrderLookup = requireProperty(optionBitOrderLookup)
  final def bitOrder = BitOrder(bitOrderLookup.value, this)
  final def bitOrder_location = bitOrderLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def bitOrderToString() = {
    optionBitOrder match {
      case None => "" // empty string if not present
      case Some(bitOrder) =>  "bitOrder='" + bitOrder + "' "
    }
  }

  final def bitOrderInit() = {
    registerToStringFunction(() => bitOrderToString)
  }

  bitOrderInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="YesNoEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="yes"/>
//       <xsd:enumeration value="no"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait YesNo extends YesNo.Value
object YesNo extends Enum[YesNo] {
  case object Yes extends YesNo
  case object No extends YesNo
  override lazy val values = Array(Yes, No)

  def apply(name: String, context : ThrowsSDE) : YesNo = stringToEnum("yesNo", name, context)
}

trait YesNoMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionYesNoLookup = findPropertyOption("yesNo")
  final def optionYesNo = if (optionYesNoLookup.isDefined) Some(yesNo) else None
  final def optionYesNo_location = if (optionYesNoLookup.isDefined) Some(yesNo_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def yesNoLookup = requireProperty(optionYesNoLookup)
  final def yesNo = YesNo(yesNoLookup.value, this)
  final def yesNo_location = yesNoLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def yesNoToString() = {
    optionYesNo match {
      case None => "" // empty string if not present
      case Some(yesNo) =>  "yesNo='" + yesNo + "' "
    }
  }

  final def yesNoInit() = {
    registerToStringFunction(() => yesNoToString)
  }

  yesNoInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="UTF16WidthEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="fixed"/>
//       <xsd:enumeration value="variable"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait UTF16Width extends UTF16Width.Value
object UTF16Width extends Enum[UTF16Width] {
  case object Fixed extends UTF16Width
  case object Variable extends UTF16Width
  override lazy val values = Array(Fixed, Variable)

  def apply(name: String, context : ThrowsSDE) : UTF16Width = stringToEnum("utf16Width", name, context)
}

trait UTF16WidthMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionUTF16WidthLookup = findPropertyOption("utf16Width")
  final def optionUTF16Width = if (optionUTF16WidthLookup.isDefined) Some(utf16Width) else None
  final def optionUTF16Width_location = if (optionUTF16WidthLookup.isDefined) Some(utf16Width_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def utf16WidthLookup = requireProperty(optionUTF16WidthLookup)
  final def utf16Width = UTF16Width(utf16WidthLookup.value, this)
  final def utf16Width_location = utf16WidthLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def utf16WidthToString() = {
    optionUTF16Width match {
      case None => "" // empty string if not present
      case Some(utf16Width) =>  "utf16Width='" + utf16Width + "' "
    }
  }

  final def utf16WidthInit() = {
    registerToStringFunction(() => utf16WidthToString)
  }

  utf16WidthInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="EncodingErrorPolicyEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="error"/>
//       <xsd:enumeration value="replace"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait EncodingErrorPolicy extends EncodingErrorPolicy.Value
object EncodingErrorPolicy extends Enum[EncodingErrorPolicy] {
  case object Error extends EncodingErrorPolicy
  case object Replace extends EncodingErrorPolicy
  override lazy val values = Array(Error, Replace)

  def apply(name: String, context : ThrowsSDE) : EncodingErrorPolicy = stringToEnum("encodingErrorPolicy", name, context)
}

trait EncodingErrorPolicyMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionEncodingErrorPolicyLookup = findPropertyOption("encodingErrorPolicy")
  final def optionEncodingErrorPolicy = if (optionEncodingErrorPolicyLookup.isDefined) Some(encodingErrorPolicy) else None
  final def optionEncodingErrorPolicy_location = if (optionEncodingErrorPolicyLookup.isDefined) Some(encodingErrorPolicy_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def encodingErrorPolicyLookup = requireProperty(optionEncodingErrorPolicyLookup)
  final def encodingErrorPolicy = EncodingErrorPolicy(encodingErrorPolicyLookup.value, this)
  final def encodingErrorPolicy_location = encodingErrorPolicyLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def encodingErrorPolicyToString() = {
    optionEncodingErrorPolicy match {
      case None => "" // empty string if not present
      case Some(encodingErrorPolicy) =>  "encodingErrorPolicy='" + encodingErrorPolicy + "' "
    }
  }

  final def encodingErrorPolicyInit() = {
    registerToStringFunction(() => encodingErrorPolicyToString)
  }

  encodingErrorPolicyInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="TestKindEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="expression"/>
//       <xsd:enumeration value="pattern"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait TestKind extends TestKind.Value
object TestKind extends Enum[TestKind] {
  case object Expression extends TestKind
  case object Pattern extends TestKind
  override lazy val values = Array(Expression, Pattern)

  def apply(name: String, context : ThrowsSDE) : TestKind = stringToEnum("testKind", name, context)
}

trait TestKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionTestKindLookup = findPropertyOption("testKind")
  final def optionTestKind = if (optionTestKindLookup.isDefined) Some(testKind) else None
  final def optionTestKind_location = if (optionTestKindLookup.isDefined) Some(testKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def testKindLookup = requireProperty(optionTestKindLookup)
  final def testKind = TestKind(testKindLookup.value, this)
  final def testKind_location = testKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def testKindToString() = {
    optionTestKind match {
      case None => "" // empty string if not present
      case Some(testKind) =>  "testKind='" + testKind + "' "
    }
  }

  final def testKindInit() = {
    registerToStringFunction(() => testKindToString)
  }

  testKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="FailureTypeEnum" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="xsd:string">
//       <xsd:enumeration value="processingError"/>
//       <xsd:enumeration value="recoverableError"/>
//     </xsd:restriction>
//   </xsd:simpleType>

sealed trait FailureType extends FailureType.Value
object FailureType extends Enum[FailureType] {
  case object ProcessingError extends FailureType
  case object RecoverableError extends FailureType
  override lazy val values = Array(ProcessingError, RecoverableError)

  def apply(name: String, context : ThrowsSDE) : FailureType = stringToEnum("failureType", name, context)
}

trait FailureTypeMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionFailureTypeLookup = findPropertyOption("failureType")
  final def optionFailureType = if (optionFailureTypeLookup.isDefined) Some(failureType) else None
  final def optionFailureType_location = if (optionFailureTypeLookup.isDefined) Some(failureType_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def failureTypeLookup = requireProperty(optionFailureTypeLookup)
  final def failureType = FailureType(failureTypeLookup.value, this)
  final def failureType_location = failureTypeLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def failureTypeToString() = {
    optionFailureType match {
      case None => "" // empty string if not present
      case Some(failureType) =>  "failureType='" + failureType + "' "
    }
  }

  final def failureTypeInit() = {
    registerToStringFunction(() => failureTypeToString)
  }

  failureTypeInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="BinaryPackedSignCodes" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="dfdl:DFDLStringLiteral">
//       <!--
//         A space separated string giving the hex sign nibbles to use for a 
//         positive
//         value, a negative value, an unsigned value, and zero.
//         Valid values for positive nibble: A, C, E, F
//         Valid values for negative nibble: B, D
//         Valid values for unsigned nibble: F
//         Valid values for zero sign: A C E F 0
//         Example: C D F C (typical S/390 usage)
//         Example: C D F 0 (handle special case for zero)
//       -->
//       <xsd:pattern value="(A|C|E|F) (B|D) (F) (A|C|E|F|0)"/>
//     </xsd:restriction>
//   </xsd:simpleType>


trait BinaryPackedSignCodesMixin { /* nothing */ }
object BinaryPackedSignCodes {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="CalendarDaysInFirstWeek" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="dfdl:DFDLNonNegativeInteger">
//       <xsd:minInclusive value="1"/>
//       <xsd:maxInclusive value="7"/>
//     </xsd:restriction>
//   </xsd:simpleType>


trait CalendarDaysInFirstWeekMixin { /* nothing */ }
object CalendarDaysInFirstWeek {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="CalendarCenturyStart" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:restriction base="dfdl:DFDLNonNegativeInteger">
//       <xsd:minInclusive value="0"/>
//       <xsd:maxInclusive value="99"/>
//     </xsd:restriction>
//   </xsd:simpleType>


trait CalendarCenturyStartMixin { /* nothing */ }
object CalendarCenturyStart {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="ByteOrderEnum_Or_DFDLExpression" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:union>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:DFDLExpression"/>
//       </xsd:simpleType>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:ByteOrderEnum"/>
//       </xsd:simpleType>
//     </xsd:union>
//   </xsd:simpleType>


trait ByteOrderEnum_Or_DFDLExpressionMixin { /* nothing */ }
object ByteOrderEnum_Or_DFDLExpression {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="EncodingEnum_Or_DFDLExpression" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:union>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:DFDLExpression"/>
//       </xsd:simpleType>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:EncodingEnum"/>
//       </xsd:simpleType>
//     </xsd:union>
//   </xsd:simpleType>


trait EncodingEnum_Or_DFDLExpressionMixin { /* nothing */ }
object EncodingEnum_Or_DFDLExpression {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="BinaryFloatRepEnum_Or_DFDLExpression" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:union>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:DFDLExpression"/>
//       </xsd:simpleType>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:BinaryFloatRepEnum"/>
//       </xsd:simpleType>
//     </xsd:union>
//   </xsd:simpleType>


trait BinaryFloatRepEnum_Or_DFDLExpressionMixin { /* nothing */ }
object BinaryFloatRepEnum_Or_DFDLExpression {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="DFDLStringLiteral_Or_DFDLExpression" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:union>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:DFDLExpression"/>
//       </xsd:simpleType>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:DFDLStringLiteral"/>
//       </xsd:simpleType>
//     </xsd:union>
//   </xsd:simpleType>


trait DFDLStringLiteral_Or_DFDLExpressionMixin { /* nothing */ }
object DFDLStringLiteral_Or_DFDLExpression {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="ListOfDFDLStringLiteral_Or_DFDLExpression" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:union>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:DFDLExpression"/>
//       </xsd:simpleType>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:ListOfDFDLStringLiteral"/>
//       </xsd:simpleType>
//     </xsd:union>
//   </xsd:simpleType>


trait ListOfDFDLStringLiteral_Or_DFDLExpressionMixin { /* nothing */ }
object ListOfDFDLStringLiteral_Or_DFDLExpression {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:simpleType name="DFDLNonNegativeInteger_Or_DFDLExpression" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/">
//     <xsd:union>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:DFDLExpression"/>
//       </xsd:simpleType>
//       <xsd:simpleType>
//         <xsd:restriction base="dfdl:DFDLNonNegativeInteger"/>
//       </xsd:simpleType>
//     </xsd:union>
//   </xsd:simpleType>


trait DFDLNonNegativeInteger_Or_DFDLExpressionMixin { /* nothing */ }
object DFDLNonNegativeInteger_Or_DFDLExpression {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="anyOther" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:anyAttribute namespace="##other" processContents="lax"/>
//   </xsd:attributeGroup>

trait AnyOtherMixin extends PropertyMixin {

  def anyOtherInit(): Unit = {
  }
  anyOtherInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="BaseAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="ref" type="xsd:QName"/>
//     <xsd:anyAttribute namespace="http://www.ibm.com/xmlns/dfdl/testData" processContents="lax"/> 
//   </xsd:attributeGroup>

trait BaseAGMixin extends PropertyMixin {

  def baseAGInit(): Unit = {
  }
  baseAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="CommonAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="byteOrder" type="dfdl:ByteOrderEnum_Or_DFDLExpression"/>
//       
//     <xsd:attribute name="bitOrder" type="dfdl:BitOrderEnum"/>
//     <xsd:attribute ref="daf:parseUnparsePolicy"/> <!-- backwards compatibility -->
//     <xsd:attribute ref="dfdlx:parseUnparsePolicy"/>
//     <xsd:attribute name="emptyElementParsePolicy" type="dfdl:EmptyElementParsePolicyEnum"/>
// 
//     <!-- deprecated -->
//     <xsd:attribute ref="dfdlx:emptyElementParsePolicy"/>
// 
//     <xsd:attribute name="encoding" type="dfdl:EncodingEnum_Or_DFDLExpression"/>
//     <xsd:attribute name="utf16Width" type="dfdl:UTF16WidthEnum"/>
//     <xsd:attribute name="encodingErrorPolicy" type="dfdl:EncodingErrorPolicyEnum"/>
//     <xsd:attribute name="ignoreCase" type="dfdl:YesNoEnum"/>
//     <xsd:attribute name="choiceBranchKey" type="dfdl:ListOfDFDLStringLiteral"/>
//     <xsd:attribute ref="dfdlx:choiceBranchKeyRanges"/>
//     <xsd:attribute name="textBidi" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait CommonAGMixin extends PropertyMixin
  with BitOrderMixin
  with ParseUnparsePolicyMixin
  with UTF16WidthMixin
  with EncodingErrorPolicyMixin {

      final def ignoreCase = YesNo(findProperty("ignoreCase").value, this)
      final def ignoreCase_location = findProperty("ignoreCase").location

      final def choiceBranchKey = ListOfDFDLStringLiteral(findProperty("choiceBranchKey").value, this)
      final def choiceBranchKey_location = findProperty("choiceBranchKey").location

      final def choiceBranchKeyRanges = NonEmptyListOfInteger(findProperty("choiceBranchKeyRanges").value, this)
      final def choiceBranchKeyRanges_location = findProperty("choiceBranchKeyRanges").location

      final def textBidi = YesNo(findProperty("textBidi").value, this)
      final def textBidi_location = findProperty("textBidi").location

  def commonAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("byteOrder", true) match {
        case None => ""
        case Some(value) => "byteOrder='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("encoding", true) match {
        case None => ""
        case Some(value) => "encoding='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("ignoreCase", false) match {
        case None => ""
        case Some(value) => "ignoreCase='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("choiceBranchKey", false) match {
        case None => ""
        case Some(value) => "choiceBranchKey='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("choiceBranchKeyRanges", false) match {
        case None => ""
        case Some(value) => "choiceBranchKeyRanges='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textBidi", false) match {
        case None => ""
        case Some(value) => "textBidi='" + value.toString + "'"
      }
    })
  }
  commonAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="AlignmentAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="alignment" type="dfdl:AlignmentType"/>
//     <xsd:attribute name="alignmentUnits" type="dfdl:AlignmentUnitsEnum"/>
//     <xsd:attribute name="fillByte" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute name="leadingSkip" type="dfdl:DFDLNonNegativeInteger"/>
//     <xsd:attribute name="trailingSkip" type="dfdl:DFDLNonNegativeInteger"/>
//     <xsd:attribute ref="dfdlx:alignmentKind"/>
//   </xsd:attributeGroup>

trait AlignmentAGMixin extends PropertyMixin
  with AlignmentUnitsMixin
  with AlignmentKindMixin {

      final def alignment = AlignmentType(findProperty("alignment").value, this)
      final def alignment_location = findProperty("alignment").location

      final def fillByte = DFDLStringLiteral(findProperty("fillByte").value, this)
      final def fillByte_location = findProperty("fillByte").location

      final def leadingSkip = DFDLNonNegativeInteger(findProperty("leadingSkip").value, this)
      final def leadingSkip_location = findProperty("leadingSkip").location

      final def trailingSkip = DFDLNonNegativeInteger(findProperty("trailingSkip").value, this)
      final def trailingSkip_location = findProperty("trailingSkip").location

  def alignmentAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("alignment", false) match {
        case None => ""
        case Some(value) => "alignment='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("fillByte", false) match {
        case None => ""
        case Some(value) => "fillByte='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("leadingSkip", false) match {
        case None => ""
        case Some(value) => "leadingSkip='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("trailingSkip", false) match {
        case None => ""
        case Some(value) => "trailingSkip='" + value.toString + "'"
      }
    })
  }
  alignmentAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="MarkupAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="initiator" type="dfdl:ListOfDFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute name="terminator" type="dfdl:ListOfDFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute name="outputNewLine" type="dfdl:DFDLStringLiteral"/>
//   </xsd:attributeGroup>

trait MarkupAGMixin extends PropertyMixin {

  def markupAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("initiator", true) match {
        case None => ""
        case Some(value) => "initiator='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("terminator", true) match {
        case None => ""
        case Some(value) => "terminator='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("outputNewLine", true) match {
        case None => ""
        case Some(value) => "outputNewLine='" + value.toString + "'"
      }
    })
  }
  markupAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NonGroupMarkupAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="emptyValueDelimiterPolicy" type="dfdl:EmptyValueDelimiterPolicyEnum"/>
//   </xsd:attributeGroup>

trait NonGroupMarkupAGMixin extends PropertyMixin
  with EmptyValueDelimiterPolicyMixin {

  def nonGroupMarkupAGInit(): Unit = {
  }
  nonGroupMarkupAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="LengthAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="lengthKind" type="dfdl:LengthKindEnum"/>
//     <xsd:attribute name="length" type="dfdl:DFDLNonNegativeInteger_Or_DFDLExpression"/>
//     <xsd:attribute name="lengthPattern" type="dfdl:DFDLRegularExpression"/>
//     <xsd:attribute name="lengthUnits" type="dfdl:LengthUnitsEnum"/>
//     <xsd:attribute name="prefixIncludesPrefixLength" type="dfdl:YesNoEnum"/>
//     <xsd:attribute name="prefixLengthType" type="xsd:QName"/>
//   </xsd:attributeGroup>

trait LengthAGMixin extends PropertyMixin
  with LengthKindMixin
  with LengthUnitsMixin {

  def prefixLengthType = {
    val cp = findProperty("prefixLengthType")
    convertToQName(cp.value, cp.location)
  }
  def prefixLengthTypeOption = findPropertyOption("prefixLengthType") match {
    case Found(s, ll, _, _) => Some(convertToQName(s, ll))
    case _ => None
  }

      final def lengthPattern = DFDLRegularExpression(findProperty("lengthPattern").value, this)
      final def lengthPattern_location = findProperty("lengthPattern").location

      final def prefixIncludesPrefixLength = YesNo(findProperty("prefixIncludesPrefixLength").value, this)
      final def prefixIncludesPrefixLength_location = findProperty("prefixIncludesPrefixLength").location

  def lengthAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("length", true) match {
        case None => ""
        case Some(value) => "length='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("lengthPattern", false) match {
        case None => ""
        case Some(value) => "lengthPattern='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("prefixIncludesPrefixLength", false) match {
        case None => ""
        case Some(value) => "prefixIncludesPrefixLength='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("prefixLengthType", false) match {
        case None => ""
        case Some(value) => "prefixLengthType='" + value.toString + "'"
      }
    })
  }
  lengthAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="RepresentationAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="representation" type="dfdl:RepresentationEnum"/>
//   </xsd:attributeGroup>

trait RepresentationAGMixin extends PropertyMixin
  with RepresentationMixin {

  def representationAGInit(): Unit = {
  }
  representationAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="FloatingAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="floating" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait FloatingAGMixin extends PropertyMixin {

      final def floating = YesNo(findProperty("floating").value, this)
      final def floating_location = findProperty("floating").location

  def floatingAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("floating", false) match {
        case None => ""
        case Some(value) => "floating='" + value.toString + "'"
      }
    })
  }
  floatingAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="SimpleTypesTextAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="textPadKind" type="dfdl:TextPadKindEnum"/>
//     <xsd:attribute name="textTrimKind" type="dfdl:TextTrimKindEnum"/>
//     <xsd:attribute name="textOutputMinLength" type="dfdl:DFDLNonNegativeInteger"/>
//     <xsd:attribute name="escapeSchemeRef" type="dfdl:DFDLQName"/>
//   </xsd:attributeGroup>

trait SimpleTypesTextAGMixin extends PropertyMixin
  with TextPadKindMixin
  with TextTrimKindMixin {

      final def escapeSchemeRef = DFDLQName(findProperty("escapeSchemeRef").value, this)
      final def escapeSchemeRef_location = findProperty("escapeSchemeRef").location

  def simpleTypesTextAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("escapeSchemeRef", false) match {
        case None => ""
        case Some(value) => "escapeSchemeRef='" + value.toString + "'"
      }
    })
  }
  simpleTypesTextAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="EscapeSchemeAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="escapeKind" type="dfdl:EscapeKindEnum"/>
//     <xsd:attribute name="escapeCharacter" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute name="escapeBlockStart" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute name="escapeBlockEnd" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute name="escapeEscapeCharacter" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute name="extraEscapedCharacters" type="dfdl:ListOfDFDLStringLiteral"/>
//     <xsd:attribute name="generateEscapeBlock" type="dfdl:GenerateEscapeEnum"/>
//   </xsd:attributeGroup>

trait EscapeSchemeAGMixin extends PropertyMixin
  with EscapeKindMixin {

      final def escapeBlockStart = DFDLStringLiteral(findProperty("escapeBlockStart").value, this)
      final def escapeBlockStart_location = findProperty("escapeBlockStart").location

      final def escapeBlockEnd = DFDLStringLiteral(findProperty("escapeBlockEnd").value, this)
      final def escapeBlockEnd_location = findProperty("escapeBlockEnd").location

      final def extraEscapedCharacters = ListOfDFDLStringLiteral(findProperty("extraEscapedCharacters").value, this)
      final def extraEscapedCharacters_location = findProperty("extraEscapedCharacters").location

      final def generateEscapeBlock = GenerateEscape(findProperty("generateEscapeBlock").value, this)
      final def generateEscapeBlock_location = findProperty("generateEscapeBlock").location

  def escapeSchemeAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("escapeCharacter", true) match {
        case None => ""
        case Some(value) => "escapeCharacter='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("escapeBlockStart", false) match {
        case None => ""
        case Some(value) => "escapeBlockStart='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("escapeBlockEnd", false) match {
        case None => ""
        case Some(value) => "escapeBlockEnd='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("escapeEscapeCharacter", true) match {
        case None => ""
        case Some(value) => "escapeEscapeCharacter='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("extraEscapedCharacters", false) match {
        case None => ""
        case Some(value) => "extraEscapedCharacters='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("generateEscapeBlock", false) match {
        case None => ""
        case Some(value) => "generateEscapeBlock='" + value.toString + "'"
      }
    })
  }
  escapeSchemeAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="TextBidiSchemeAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="textBidiTextOrdering" type="dfdl:TextBidiTextOrderingEnum"/>
//     <xsd:attribute name="textBidiOrientation" type="dfdl:TextBidiOrientationEnum"/>
//     <xsd:attribute name="textBidiSymmetric" type="dfdl:YesNoEnum"/>
//     <xsd:attribute name="textBidiTextShaped" type="dfdl:YesNoEnum"/>
//     <xsd:attribute name="textBidiNumeralShapes" type="dfdl:TextBidiNumeralShapesEnum"/>
//   </xsd:attributeGroup>

trait TextBidiSchemeAGMixin extends PropertyMixin
  with TextBidiTextOrderingMixin
  with TextBidiOrientationMixin
  with TextBidiNumeralShapesMixin {

      final def textBidiSymmetric = YesNo(findProperty("textBidiSymmetric").value, this)
      final def textBidiSymmetric_location = findProperty("textBidiSymmetric").location

      final def textBidiTextShaped = YesNo(findProperty("textBidiTextShaped").value, this)
      final def textBidiTextShaped_location = findProperty("textBidiTextShaped").location

  def textBidiSchemeAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("textBidiSymmetric", false) match {
        case None => ""
        case Some(value) => "textBidiSymmetric='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textBidiTextShaped", false) match {
        case None => ""
        case Some(value) => "textBidiTextShaped='" + value.toString + "'"
      }
    })
  }
  textBidiSchemeAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="StringTextAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="textStringJustification" type="dfdl:TextStringJustificationEnum"/>
//     <xsd:attribute name="textStringPadCharacter" type="dfdl:NonEmptyStringLiteral"/>
//     <xsd:attribute name="truncateSpecifiedLengthString" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait StringTextAGMixin extends PropertyMixin
  with TextStringJustificationMixin {

      final def truncateSpecifiedLengthString = YesNo(findProperty("truncateSpecifiedLengthString").value, this)
      final def truncateSpecifiedLengthString_location = findProperty("truncateSpecifiedLengthString").location

  def stringTextAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("truncateSpecifiedLengthString", false) match {
        case None => ""
        case Some(value) => "truncateSpecifiedLengthString='" + value.toString + "'"
      }
    })
  }
  stringTextAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NumberAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="decimalSigned" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait NumberAGMixin extends PropertyMixin {

      final def decimalSigned = YesNo(findProperty("decimalSigned").value, this)
      final def decimalSigned_location = findProperty("decimalSigned").location

  def numberAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("decimalSigned", false) match {
        case None => ""
        case Some(value) => "decimalSigned='" + value.toString + "'"
      }
    })
  }
  numberAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NumberTextAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="textNumberRep" type="dfdl:TextNumberRepEnum"/>
//     <xsd:attribute name="textNumberJustification" type="dfdl:TextNumberJustificationEnum"/>
//     <xsd:attribute name="textNumberPadCharacter" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute name="textStandardBase" type="dfdl:TextNumberBaseEnum"/>
//   </xsd:attributeGroup>

trait NumberTextAGMixin extends PropertyMixin
  with TextNumberRepMixin
  with TextNumberJustificationMixin {

      final def textStandardBase = TextNumberBase(findProperty("textStandardBase").value, this)
      final def textStandardBase_location = findProperty("textStandardBase").location

  def numberTextAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("textStandardBase", false) match {
        case None => ""
        case Some(value) => "textStandardBase='" + value.toString + "'"
      }
    })
  }
  numberTextAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="TextNumberFormatAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="textNumberPattern" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute name="textStandardGroupingSeparator" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute name="textStandardDecimalSeparator" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute name="textStandardExponentRep" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <!-- deprecated form accepted by IBM DFDL as of 2018-10-30 -->
//     <xsd:attribute name="textStandardExponentCharacter" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute name="textNumberCheckPolicy" type="dfdl:TextNumberCheckPolicyEnum"/>
//     <xsd:attribute name="textStandardInfinityRep" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute name="textStandardNaNRep" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute name="textNumberRoundingMode" type="dfdl:TextNumberRoundingModeEnum"/>
//     <xsd:attribute name="textNumberRounding" type="dfdl:TextNumberRoundingEnum"/>
//     <xsd:attribute name="textNumberRoundingIncrement" type="xsd:double"/>
//     <xsd:attribute name="textZonedSignStyle" type="dfdl:TextZonedSignStyleEnum"/>
//     <xsd:attribute name="textStandardZeroRep" type="dfdl:ListOfDFDLStringLiteral"/>
//   </xsd:attributeGroup>

trait TextNumberFormatAGMixin extends PropertyMixin
  with TextNumberCheckPolicyMixin
  with TextNumberRoundingModeMixin
  with TextNumberRoundingMixin
  with TextZonedSignStyleMixin {
  def textNumberRoundingIncrement = convertToDouble(findProperty("textNumberRoundingIncrement").value)

      final def textNumberPattern = DFDLStringLiteral(findProperty("textNumberPattern").value, this)
      final def textNumberPattern_location = findProperty("textNumberPattern").location

  def textNumberFormatAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("textNumberPattern", false) match {
        case None => ""
        case Some(value) => "textNumberPattern='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textStandardGroupingSeparator", true) match {
        case None => ""
        case Some(value) => "textStandardGroupingSeparator='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textStandardDecimalSeparator", true) match {
        case None => ""
        case Some(value) => "textStandardDecimalSeparator='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textNumberRoundingIncrement", false) match {
        case None => ""
        case Some(value) => "textNumberRoundingIncrement='" + value.toString + "'"
      }
    })
  }
  textNumberFormatAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NumberBinaryAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="binaryNumberRep" type="dfdl:BinaryNumberRepEnum"/>
//     <xsd:attribute name="binaryDecimalVirtualPoint" type="xsd:int"/>
//     <xsd:attribute name="binaryPackedSignCodes" type="dfdl:BinaryPackedSignCodes"/>
//     <xsd:attribute name="binaryNumberCheckPolicy" type="dfdl:BinaryNumberCheckPolicyEnum"/>
//   </xsd:attributeGroup>

trait NumberBinaryAGMixin extends PropertyMixin
  with BinaryNumberRepMixin
  with BinaryNumberCheckPolicyMixin {
  def binaryDecimalVirtualPoint = convertToInt(findProperty("binaryDecimalVirtualPoint").value)

      final def binaryPackedSignCodes = BinaryPackedSignCodes(findProperty("binaryPackedSignCodes").value, this)
      final def binaryPackedSignCodes_location = findProperty("binaryPackedSignCodes").location

  def numberBinaryAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("binaryDecimalVirtualPoint", false) match {
        case None => ""
        case Some(value) => "binaryDecimalVirtualPoint='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("binaryPackedSignCodes", false) match {
        case None => ""
        case Some(value) => "binaryPackedSignCodes='" + value.toString + "'"
      }
    })
  }
  numberBinaryAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="FloatBinaryAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="binaryFloatRep" type="dfdl:BinaryFloatRepEnum_Or_DFDLExpression"/>
//   </xsd:attributeGroup>

trait FloatBinaryAGMixin extends PropertyMixin {

  def floatBinaryAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("binaryFloatRep", true) match {
        case None => ""
        case Some(value) => "binaryFloatRep='" + value.toString + "'"
      }
    })
  }
  floatBinaryAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="BooleanTextAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="textBooleanTrueRep" type="dfdl:ListOfDFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute name="textBooleanFalseRep" type="dfdl:ListOfDFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute name="textBooleanJustification" type="dfdl:TextBooleanJustificationEnum"/>
//     <xsd:attribute name="textBooleanPadCharacter" type="dfdl:DFDLStringLiteral"/>
//   </xsd:attributeGroup>

trait BooleanTextAGMixin extends PropertyMixin
  with TextBooleanJustificationMixin {

  def booleanTextAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("textBooleanTrueRep", true) match {
        case None => ""
        case Some(value) => "textBooleanTrueRep='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textBooleanFalseRep", true) match {
        case None => ""
        case Some(value) => "textBooleanFalseRep='" + value.toString + "'"
      }
    })
  }
  booleanTextAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="BooleanBinaryAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="binaryBooleanTrueRep" type="dfdl:BinaryBooleanTrueRepType"/>
//     <xsd:attribute name="binaryBooleanFalseRep" type="dfdl:BinaryBooleanFalseRepType"/>
//   </xsd:attributeGroup>

trait BooleanBinaryAGMixin extends PropertyMixin {

      final def binaryBooleanTrueRep = BinaryBooleanTrueRepType(findProperty("binaryBooleanTrueRep").value, this)
      final def binaryBooleanTrueRep_location = findProperty("binaryBooleanTrueRep").location

      final def binaryBooleanFalseRep = BinaryBooleanFalseRepType(findProperty("binaryBooleanFalseRep").value, this)
      final def binaryBooleanFalseRep_location = findProperty("binaryBooleanFalseRep").location

  def booleanBinaryAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("binaryBooleanTrueRep", false) match {
        case None => ""
        case Some(value) => "binaryBooleanTrueRep='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("binaryBooleanFalseRep", false) match {
        case None => ""
        case Some(value) => "binaryBooleanFalseRep='" + value.toString + "'"
      }
    })
  }
  booleanBinaryAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="CalendarFormatAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="calendarPattern" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute name="calendarPatternKind" type="dfdl:CalendarPatternKindEnum"/>
//     <xsd:attribute name="calendarCheckPolicy" type="dfdl:CalendarCheckPolicyEnum"/>
//     <xsd:attribute name="calendarTimeZone" type="dfdl:CalendarTimeZoneType"/>
//     <xsd:attribute name="calendarObserveDST" type="dfdl:YesNoEnum"/>
//     <xsd:attribute name="calendarFirstDayOfWeek" type="dfdl:CalendarFirstDayOfWeekEnum"/>
//     <xsd:attribute name="calendarDaysInFirstWeek" type="dfdl:CalendarDaysInFirstWeek"/>
//     <xsd:attribute name="calendarCenturyStart" type="dfdl:CalendarCenturyStart"/>
//     <xsd:attribute name="calendarLanguage" type="dfdl:CalendarLanguageType"/>
//   </xsd:attributeGroup>

trait CalendarFormatAGMixin extends PropertyMixin
  with CalendarPatternKindMixin
  with CalendarCheckPolicyMixin
  with CalendarFirstDayOfWeekMixin {

      final def calendarPattern = DFDLStringLiteral(findProperty("calendarPattern").value, this)
      final def calendarPattern_location = findProperty("calendarPattern").location

      final def calendarTimeZone = CalendarTimeZoneType(findProperty("calendarTimeZone").value, this)
      final def calendarTimeZone_location = findProperty("calendarTimeZone").location

      final def calendarObserveDST = YesNo(findProperty("calendarObserveDST").value, this)
      final def calendarObserveDST_location = findProperty("calendarObserveDST").location

      final def calendarDaysInFirstWeek = CalendarDaysInFirstWeek(findProperty("calendarDaysInFirstWeek").value, this)
      final def calendarDaysInFirstWeek_location = findProperty("calendarDaysInFirstWeek").location

      final def calendarCenturyStart = CalendarCenturyStart(findProperty("calendarCenturyStart").value, this)
      final def calendarCenturyStart_location = findProperty("calendarCenturyStart").location

  def calendarFormatAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("calendarPattern", false) match {
        case None => ""
        case Some(value) => "calendarPattern='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("calendarTimeZone", false) match {
        case None => ""
        case Some(value) => "calendarTimeZone='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("calendarObserveDST", false) match {
        case None => ""
        case Some(value) => "calendarObserveDST='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("calendarDaysInFirstWeek", false) match {
        case None => ""
        case Some(value) => "calendarDaysInFirstWeek='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("calendarCenturyStart", false) match {
        case None => ""
        case Some(value) => "calendarCenturyStart='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("calendarLanguage", true) match {
        case None => ""
        case Some(value) => "calendarLanguage='" + value.toString + "'"
      }
    })
  }
  calendarFormatAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="CalendarTextAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="textCalendarJustification" type="dfdl:TextCalendarJustificationEnum"/>
//     <xsd:attribute name="textCalendarPadCharacter" type="dfdl:DFDLStringLiteral"/>
//   </xsd:attributeGroup>

trait CalendarTextAGMixin extends PropertyMixin
  with TextCalendarJustificationMixin {

  def calendarTextAGInit(): Unit = {
  }
  calendarTextAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="CalendarBinaryAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="binaryCalendarRep" type="dfdl:BinaryCalendarRepEnum"/>
//     <xsd:attribute name="binaryCalendarEpoch" type="xsd:string"/>
//   </xsd:attributeGroup>

trait CalendarBinaryAGMixin extends PropertyMixin
  with BinaryCalendarRepMixin {
  def binaryCalendarEpoch = convertToString(findProperty("binaryCalendarEpoch").value)

  def calendarBinaryAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("binaryCalendarEpoch", false) match {
        case None => ""
        case Some(value) => "binaryCalendarEpoch='" + value.toString + "'"
      }
    })
  }
  calendarBinaryAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="OpaqueAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//   </xsd:attributeGroup>

trait OpaqueAGMixin extends PropertyMixin {

  def opaqueAGInit(): Unit = {
  }
  opaqueAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NillableAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="nilKind" type="dfdl:NilKindEnum"/>
//     <xsd:attribute name="nilValue" type="dfdl:NonEmptyListOfDFDLStringLiteral_nilValue"/>
//     <xsd:attribute name="nilValueDelimiterPolicy" type="dfdl:NilValueDelimiterPolicyEnum"/>
//   </xsd:attributeGroup>

trait NillableAGMixin extends PropertyMixin
  with NilKindMixin
  with NilValueDelimiterPolicyMixin {

  def nillableAGInit(): Unit = {
  }
  nillableAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="DefaultValueControlAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="useNilForDefault" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait DefaultValueControlAGMixin extends PropertyMixin {

      final def useNilForDefault = YesNo(findProperty("useNilForDefault").value, this)
      final def useNilForDefault_location = findProperty("useNilForDefault").location

  def defaultValueControlAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("useNilForDefault", false) match {
        case None => ""
        case Some(value) => "useNilForDefault='" + value.toString + "'"
      }
    })
  }
  defaultValueControlAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="SequenceAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="sequenceKind" type="dfdl:SequenceKindEnum"/>
//     <xsd:attribute name="hiddenGroupRef" type="xsd:QName"/>
//   </xsd:attributeGroup>

trait SequenceAGMixin extends PropertyMixin
  with SequenceKindMixin {

  def sequenceAGInit(): Unit = {
  }
  sequenceAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="SeparatorAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="separator" type="dfdl:ListOfDFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute name="separatorPosition" type="dfdl:SeparatorPositionEnum"/>
//     <xsd:attribute name="separatorPolicy" type="dfdl:SeparatorPolicyEnum"/>
//     <xsd:attribute name="separatorSuppressionPolicy" type="dfdl:SeparatorSuppressionPolicyEnum"/>  
//   </xsd:attributeGroup>

trait SeparatorAGMixin extends PropertyMixin
  with SeparatorPositionMixin
  with SeparatorPolicyMixin {

  def separatorAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("separator", true) match {
        case None => ""
        case Some(value) => "separator='" + value.toString + "'"
      }
    })
  }
  separatorAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="GroupCommonAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="initiatedContent" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait GroupCommonAGMixin extends PropertyMixin {

      final def initiatedContent = YesNo(findProperty("initiatedContent").value, this)
      final def initiatedContent_location = findProperty("initiatedContent").location

  def groupCommonAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("initiatedContent", false) match {
        case None => ""
        case Some(value) => "initiatedContent='" + value.toString + "'"
      }
    })
  }
  groupCommonAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="ChoiceAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="choiceLengthKind" type="dfdl:ChoiceLengthKindEnum"/>
//     <xsd:attribute name="choiceLength" type="dfdl:DFDLNonNegativeInteger"/>
//     <xsd:attribute name="choiceDispatchKey" type="dfdl:DFDLExpression"/>
//   </xsd:attributeGroup>

trait ChoiceAGMixin extends PropertyMixin
  with ChoiceLengthKindMixin {

      final def choiceLength = DFDLNonNegativeInteger(findProperty("choiceLength").value, this)
      final def choiceLength_location = findProperty("choiceLength").location

  def choiceAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("choiceLength", false) match {
        case None => ""
        case Some(value) => "choiceLength='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("choiceDispatchKey", true) match {
        case None => ""
        case Some(value) => "choiceDispatchKey='" + value.toString + "'"
      }
    })
  }
  choiceAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="OccursAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="occursCountKind" type="dfdl:OccursCountKindEnum"/>
//     <xsd:attribute name="occursCount" type="dfdl:DFDLExpression"/>
//     <xsd:attribute name="occursStopValue" type="dfdl:ListOfDFDLStringLiteral"/>
//   </xsd:attributeGroup>

trait OccursAGMixin extends PropertyMixin
  with OccursCountKindMixin {

      final def occursStopValue = ListOfDFDLStringLiteral(findProperty("occursStopValue").value, this)
      final def occursStopValue_location = findProperty("occursStopValue").location

  def occursAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("occursCount", true) match {
        case None => ""
        case Some(value) => "occursCount='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("occursStopValue", false) match {
        case None => ""
        case Some(value) => "occursStopValue='" + value.toString + "'"
      }
    })
  }
  occursAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="CalculatedValueAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="inputValueCalc" type="dfdl:DFDLExpression"/>
//     <xsd:attribute name="outputValueCalc" type="dfdl:DFDLExpression"/>
//   </xsd:attributeGroup>

trait CalculatedValueAGMixin extends PropertyMixin {

  def calculatedValueAGInit(): Unit = {
  }
  calculatedValueAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="DocumentPropertiesAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute name="documentFinalTerminatorCanBeMissing" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait DocumentPropertiesAGMixin extends PropertyMixin {

      final def documentFinalTerminatorCanBeMissing = YesNo(findProperty("documentFinalTerminatorCanBeMissing").value, this)
      final def documentFinalTerminatorCanBeMissing_location = findProperty("documentFinalTerminatorCanBeMissing").location

  def documentPropertiesAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("documentFinalTerminatorCanBeMissing", false) match {
        case None => ""
        case Some(value) => "documentFinalTerminatorCanBeMissing='" + value.toString + "'"
      }
    })
  }
  documentPropertiesAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="BaseAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="ref" type="xsd:QName"/>
//   </xsd:attributeGroup>

trait BaseAGQualifiedMixin extends PropertyMixin {

  def baseAGQualifiedInit(): Unit = {
  }
  baseAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="CommonAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="bitOrder" type="dfdl:BitOrderEnum"/>
//     <xsd:attribute form="qualified" name="byteOrder" type="dfdl:ByteOrderEnum_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="encoding" type="dfdl:EncodingEnum_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="encodingErrorPolicy" type="dfdl:EncodingErrorPolicyEnum"/>
//     <xsd:attribute form="qualified" name="emptyElementParsePolicy" type="dfdl:EmptyElementParsePolicyEnum"/>
//     <xsd:attribute form="qualified" name="utf16Width" type="dfdl:UTF16WidthEnum"/>
//     <xsd:attribute form="qualified" name="ignoreCase" type="dfdl:YesNoEnum"/>
//     <xsd:attribute form="qualified" name="choiceBranchKey" type="dfdl:ListOfDFDLStringLiteral"/>
//     <xsd:attribute ref="dfdlx:choiceBranchKeyRanges"/>
//   </xsd:attributeGroup>

trait CommonAGQualifiedMixin extends PropertyMixin
  with BitOrderMixin
  with EncodingErrorPolicyMixin
  with UTF16WidthMixin {

      final def ignoreCase = YesNo(findProperty("ignoreCase").value, this)
      final def ignoreCase_location = findProperty("ignoreCase").location

      final def choiceBranchKey = ListOfDFDLStringLiteral(findProperty("choiceBranchKey").value, this)
      final def choiceBranchKey_location = findProperty("choiceBranchKey").location

      final def choiceBranchKeyRanges = NonEmptyListOfInteger(findProperty("choiceBranchKeyRanges").value, this)
      final def choiceBranchKeyRanges_location = findProperty("choiceBranchKeyRanges").location

  def commonAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("byteOrder", true) match {
        case None => ""
        case Some(value) => "byteOrder='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("encoding", true) match {
        case None => ""
        case Some(value) => "encoding='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("ignoreCase", false) match {
        case None => ""
        case Some(value) => "ignoreCase='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("choiceBranchKey", false) match {
        case None => ""
        case Some(value) => "choiceBranchKey='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("choiceBranchKeyRanges", false) match {
        case None => ""
        case Some(value) => "choiceBranchKeyRanges='" + value.toString + "'"
      }
    })
  }
  commonAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="AlignmentAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="alignment" type="dfdl:AlignmentType"/>
//     <xsd:attribute form="qualified" name="alignmentUnits" type="dfdl:AlignmentUnitsEnum"/>
//     <xsd:attribute form="qualified" name="fillByte" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute form="qualified" name="leadingSkip" type="dfdl:DFDLNonNegativeInteger"/>
//     <xsd:attribute form="qualified" name="trailingSkip" type="dfdl:DFDLNonNegativeInteger"/>
//   </xsd:attributeGroup>

trait AlignmentAGQualifiedMixin extends PropertyMixin
  with AlignmentUnitsMixin {

      final def alignment = AlignmentType(findProperty("alignment").value, this)
      final def alignment_location = findProperty("alignment").location

      final def fillByte = DFDLStringLiteral(findProperty("fillByte").value, this)
      final def fillByte_location = findProperty("fillByte").location

      final def leadingSkip = DFDLNonNegativeInteger(findProperty("leadingSkip").value, this)
      final def leadingSkip_location = findProperty("leadingSkip").location

      final def trailingSkip = DFDLNonNegativeInteger(findProperty("trailingSkip").value, this)
      final def trailingSkip_location = findProperty("trailingSkip").location

  def alignmentAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("alignment", false) match {
        case None => ""
        case Some(value) => "alignment='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("fillByte", false) match {
        case None => ""
        case Some(value) => "fillByte='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("leadingSkip", false) match {
        case None => ""
        case Some(value) => "leadingSkip='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("trailingSkip", false) match {
        case None => ""
        case Some(value) => "trailingSkip='" + value.toString + "'"
      }
    })
  }
  alignmentAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="MarkupAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="initiator" type="dfdl:ListOfDFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="terminator" type="dfdl:ListOfDFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="outputNewLine" type="dfdl:DFDLStringLiteral"/>
//   </xsd:attributeGroup>

trait MarkupAGQualifiedMixin extends PropertyMixin {

  def markupAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("initiator", true) match {
        case None => ""
        case Some(value) => "initiator='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("terminator", true) match {
        case None => ""
        case Some(value) => "terminator='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("outputNewLine", true) match {
        case None => ""
        case Some(value) => "outputNewLine='" + value.toString + "'"
      }
    })
  }
  markupAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NonGroupMarkupAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="emptyValueDelimiterPolicy" type="dfdl:EmptyValueDelimiterPolicyEnum"/>
//   </xsd:attributeGroup>

trait NonGroupMarkupAGQualifiedMixin extends PropertyMixin
  with EmptyValueDelimiterPolicyMixin {

  def nonGroupMarkupAGQualifiedInit(): Unit = {
  }
  nonGroupMarkupAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="LengthAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="lengthKind" type="dfdl:LengthKindEnum"/>
//     <xsd:attribute form="qualified" name="length" type="dfdl:DFDLNonNegativeInteger_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="lengthPattern" type="dfdl:DFDLRegularExpression"/>
//     <xsd:attribute form="qualified" name="lengthUnits" type="dfdl:LengthUnitsEnum"/>
//     <xsd:attribute form="qualified" name="prefixIncludesPrefixLength" type="dfdl:YesNoEnum"/>
//     <xsd:attribute form="qualified" name="prefixLengthType" type="xsd:QName"/>
//   </xsd:attributeGroup>

trait LengthAGQualifiedMixin extends PropertyMixin
  with LengthKindMixin
  with LengthUnitsMixin {

  def prefixLengthType = {
    val cp = findProperty("prefixLengthType")
    convertToQName(cp.value, cp.location)
  }
  def prefixLengthTypeOption = findPropertyOption("prefixLengthType") match {
    case Found(s, ll, _, _) => Some(convertToQName(s, ll))
    case _ => None
  }

      final def lengthPattern = DFDLRegularExpression(findProperty("lengthPattern").value, this)
      final def lengthPattern_location = findProperty("lengthPattern").location

      final def prefixIncludesPrefixLength = YesNo(findProperty("prefixIncludesPrefixLength").value, this)
      final def prefixIncludesPrefixLength_location = findProperty("prefixIncludesPrefixLength").location

  def lengthAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("length", true) match {
        case None => ""
        case Some(value) => "length='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("lengthPattern", false) match {
        case None => ""
        case Some(value) => "lengthPattern='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("prefixIncludesPrefixLength", false) match {
        case None => ""
        case Some(value) => "prefixIncludesPrefixLength='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("prefixLengthType", false) match {
        case None => ""
        case Some(value) => "prefixLengthType='" + value.toString + "'"
      }
    })
  }
  lengthAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="RepresentationAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="representation" type="dfdl:RepresentationEnum"/>
//   </xsd:attributeGroup>

trait RepresentationAGQualifiedMixin extends PropertyMixin
  with RepresentationMixin {

  def representationAGQualifiedInit(): Unit = {
  }
  representationAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="FloatingAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="floating" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait FloatingAGQualifiedMixin extends PropertyMixin {

      final def floating = YesNo(findProperty("floating").value, this)
      final def floating_location = findProperty("floating").location

  def floatingAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("floating", false) match {
        case None => ""
        case Some(value) => "floating='" + value.toString + "'"
      }
    })
  }
  floatingAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="SimpleTypesTextAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="textPadKind" type="dfdl:TextPadKindEnum"/>
//     <xsd:attribute form="qualified" name="textTrimKind" type="dfdl:TextTrimKindEnum"/>
//     <xsd:attribute form="qualified" name="textOutputMinLength" type="dfdl:DFDLNonNegativeInteger"/>
//     <xsd:attribute form="qualified" name="escapeSchemeRef" type="dfdl:DFDLQName"/>
//   </xsd:attributeGroup>

trait SimpleTypesTextAGQualifiedMixin extends PropertyMixin
  with TextPadKindMixin
  with TextTrimKindMixin {

      final def escapeSchemeRef = DFDLQName(findProperty("escapeSchemeRef").value, this)
      final def escapeSchemeRef_location = findProperty("escapeSchemeRef").location

  def simpleTypesTextAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("escapeSchemeRef", false) match {
        case None => ""
        case Some(value) => "escapeSchemeRef='" + value.toString + "'"
      }
    })
  }
  simpleTypesTextAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="EscapeSchemeAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="escapeKind" type="dfdl:EscapeKindEnum"/>
//     <xsd:attribute form="qualified" name="escapeCharacter" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="escapeBlockStart" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute form="qualified" name="escapeBlockEnd" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute form="qualified" name="escapeEscapeCharacter" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="extraEscapedCharacters" type="dfdl:ListOfDFDLStringLiteral"/>
//     <xsd:attribute form="qualified" name="generateEscapeBlock" type="dfdl:GenerateEscapeEnum"/>
//   </xsd:attributeGroup>

trait EscapeSchemeAGQualifiedMixin extends PropertyMixin
  with EscapeKindMixin {

      final def escapeBlockStart = DFDLStringLiteral(findProperty("escapeBlockStart").value, this)
      final def escapeBlockStart_location = findProperty("escapeBlockStart").location

      final def escapeBlockEnd = DFDLStringLiteral(findProperty("escapeBlockEnd").value, this)
      final def escapeBlockEnd_location = findProperty("escapeBlockEnd").location

      final def extraEscapedCharacters = ListOfDFDLStringLiteral(findProperty("extraEscapedCharacters").value, this)
      final def extraEscapedCharacters_location = findProperty("extraEscapedCharacters").location

      final def generateEscapeBlock = GenerateEscape(findProperty("generateEscapeBlock").value, this)
      final def generateEscapeBlock_location = findProperty("generateEscapeBlock").location

  def escapeSchemeAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("escapeCharacter", true) match {
        case None => ""
        case Some(value) => "escapeCharacter='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("escapeBlockStart", false) match {
        case None => ""
        case Some(value) => "escapeBlockStart='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("escapeBlockEnd", false) match {
        case None => ""
        case Some(value) => "escapeBlockEnd='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("escapeEscapeCharacter", true) match {
        case None => ""
        case Some(value) => "escapeEscapeCharacter='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("extraEscapedCharacters", false) match {
        case None => ""
        case Some(value) => "extraEscapedCharacters='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("generateEscapeBlock", false) match {
        case None => ""
        case Some(value) => "generateEscapeBlock='" + value.toString + "'"
      }
    })
  }
  escapeSchemeAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="TextBidiSchemeAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="textBidiTextOrdering" type="dfdl:TextBidiTextOrderingEnum"/>
//     <xsd:attribute form="qualified" name="textBidiOrientation" type="dfdl:TextBidiOrientationEnum"/>
//     <xsd:attribute form="qualified" name="textBidiSymmetric" type="dfdl:YesNoEnum"/>
//     <xsd:attribute form="qualified" name="textBidiTextShaped" type="dfdl:YesNoEnum"/>
//     <xsd:attribute form="qualified" name="textBidiNumeralShapes" type="dfdl:TextBidiNumeralShapesEnum"/>
//     <xsd:attribute form="qualified" name="textBidi" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait TextBidiSchemeAGQualifiedMixin extends PropertyMixin
  with TextBidiTextOrderingMixin
  with TextBidiOrientationMixin
  with TextBidiNumeralShapesMixin {

      final def textBidiSymmetric = YesNo(findProperty("textBidiSymmetric").value, this)
      final def textBidiSymmetric_location = findProperty("textBidiSymmetric").location

      final def textBidiTextShaped = YesNo(findProperty("textBidiTextShaped").value, this)
      final def textBidiTextShaped_location = findProperty("textBidiTextShaped").location

      final def textBidi = YesNo(findProperty("textBidi").value, this)
      final def textBidi_location = findProperty("textBidi").location

  def textBidiSchemeAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("textBidiSymmetric", false) match {
        case None => ""
        case Some(value) => "textBidiSymmetric='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textBidiTextShaped", false) match {
        case None => ""
        case Some(value) => "textBidiTextShaped='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textBidi", false) match {
        case None => ""
        case Some(value) => "textBidi='" + value.toString + "'"
      }
    })
  }
  textBidiSchemeAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="StringTextAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="textStringJustification" type="dfdl:TextStringJustificationEnum"/>
//     <xsd:attribute form="qualified" name="textStringPadCharacter" type="dfdl:NonEmptyStringLiteral"/>
//     <xsd:attribute form="qualified" name="truncateSpecifiedLengthString" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait StringTextAGQualifiedMixin extends PropertyMixin
  with TextStringJustificationMixin {

      final def truncateSpecifiedLengthString = YesNo(findProperty("truncateSpecifiedLengthString").value, this)
      final def truncateSpecifiedLengthString_location = findProperty("truncateSpecifiedLengthString").location

  def stringTextAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("truncateSpecifiedLengthString", false) match {
        case None => ""
        case Some(value) => "truncateSpecifiedLengthString='" + value.toString + "'"
      }
    })
  }
  stringTextAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NumberAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="decimalSigned" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait NumberAGQualifiedMixin extends PropertyMixin {

      final def decimalSigned = YesNo(findProperty("decimalSigned").value, this)
      final def decimalSigned_location = findProperty("decimalSigned").location

  def numberAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("decimalSigned", false) match {
        case None => ""
        case Some(value) => "decimalSigned='" + value.toString + "'"
      }
    })
  }
  numberAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NumberTextAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="textNumberRep" type="dfdl:TextNumberRepEnum"/>
//     <xsd:attribute form="qualified" name="textNumberJustification" type="dfdl:TextNumberJustificationEnum"/>
//     <xsd:attribute form="qualified" name="textNumberPadCharacter" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute form="qualified" name="textStandardBase" type="dfdl:TextNumberBaseEnum"/>
//   </xsd:attributeGroup>

trait NumberTextAGQualifiedMixin extends PropertyMixin
  with TextNumberRepMixin
  with TextNumberJustificationMixin {

      final def textStandardBase = TextNumberBase(findProperty("textStandardBase").value, this)
      final def textStandardBase_location = findProperty("textStandardBase").location

  def numberTextAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("textStandardBase", false) match {
        case None => ""
        case Some(value) => "textStandardBase='" + value.toString + "'"
      }
    })
  }
  numberTextAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="TextNumberFormatAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="textNumberPattern" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute form="qualified" name="textStandardGroupingSeparator" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="textStandardDecimalSeparator" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="textStandardExponentRep" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <!-- deprecated form still accepted by IBM DFDL as of 2018-10-30 -->
//     <xsd:attribute form="qualified" name="textStandardExponentCharacter" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="textNumberCheckPolicy" type="dfdl:TextNumberCheckPolicyEnum"/>
//     <xsd:attribute form="qualified" name="textStandardInfinityRep" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute form="qualified" name="textStandardNaNRep" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute form="qualified" name="textNumberRoundingMode" type="dfdl:TextNumberRoundingModeEnum"/>
//     <xsd:attribute form="qualified" name="textNumberRounding" type="dfdl:TextNumberRoundingEnum"/>
//     <xsd:attribute form="qualified" name="textNumberRoundingIncrement" type="xsd:double"/>
//     <xsd:attribute form="qualified" name="textZonedSignStyle" type="dfdl:TextZonedSignStyleEnum"/>
//     <xsd:attribute form="qualified" name="textStandardZeroRep" type="dfdl:ListOfDFDLStringLiteral"/>
//   </xsd:attributeGroup>

trait TextNumberFormatAGQualifiedMixin extends PropertyMixin
  with TextNumberCheckPolicyMixin
  with TextNumberRoundingModeMixin
  with TextNumberRoundingMixin
  with TextZonedSignStyleMixin {
  def textNumberRoundingIncrement = convertToDouble(findProperty("textNumberRoundingIncrement").value)

      final def textNumberPattern = DFDLStringLiteral(findProperty("textNumberPattern").value, this)
      final def textNumberPattern_location = findProperty("textNumberPattern").location

  def textNumberFormatAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("textNumberPattern", false) match {
        case None => ""
        case Some(value) => "textNumberPattern='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textStandardGroupingSeparator", true) match {
        case None => ""
        case Some(value) => "textStandardGroupingSeparator='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textStandardDecimalSeparator", true) match {
        case None => ""
        case Some(value) => "textStandardDecimalSeparator='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textNumberRoundingIncrement", false) match {
        case None => ""
        case Some(value) => "textNumberRoundingIncrement='" + value.toString + "'"
      }
    })
  }
  textNumberFormatAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NumberBinaryAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="binaryNumberRep" type="dfdl:BinaryNumberRepEnum"/>
//     <xsd:attribute form="qualified" name="binaryDecimalVirtualPoint" type="xsd:int"/>
//     <xsd:attribute form="qualified" name="binaryPackedSignCodes" type="dfdl:BinaryPackedSignCodes"/>
//     <xsd:attribute form="qualified" name="binaryNumberCheckPolicy" type="dfdl:BinaryNumberCheckPolicyEnum"/>
//   </xsd:attributeGroup>

trait NumberBinaryAGQualifiedMixin extends PropertyMixin
  with BinaryNumberRepMixin
  with BinaryNumberCheckPolicyMixin {
  def binaryDecimalVirtualPoint = convertToInt(findProperty("binaryDecimalVirtualPoint").value)

      final def binaryPackedSignCodes = BinaryPackedSignCodes(findProperty("binaryPackedSignCodes").value, this)
      final def binaryPackedSignCodes_location = findProperty("binaryPackedSignCodes").location

  def numberBinaryAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("binaryDecimalVirtualPoint", false) match {
        case None => ""
        case Some(value) => "binaryDecimalVirtualPoint='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("binaryPackedSignCodes", false) match {
        case None => ""
        case Some(value) => "binaryPackedSignCodes='" + value.toString + "'"
      }
    })
  }
  numberBinaryAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="FloatBinaryAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="binaryFloatRep" type="dfdl:BinaryFloatRepEnum_Or_DFDLExpression"/>
//   </xsd:attributeGroup>

trait FloatBinaryAGQualifiedMixin extends PropertyMixin {

  def floatBinaryAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("binaryFloatRep", true) match {
        case None => ""
        case Some(value) => "binaryFloatRep='" + value.toString + "'"
      }
    })
  }
  floatBinaryAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="BooleanTextAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="textBooleanTrueRep" type="dfdl:ListOfDFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="textBooleanFalseRep" type="dfdl:ListOfDFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="textBooleanJustification" type="dfdl:TextBooleanJustificationEnum"/>
//     <xsd:attribute form="qualified" name="textBooleanPadCharacter" type="dfdl:DFDLStringLiteral"/>
//   </xsd:attributeGroup>

trait BooleanTextAGQualifiedMixin extends PropertyMixin
  with TextBooleanJustificationMixin {

  def booleanTextAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("textBooleanTrueRep", true) match {
        case None => ""
        case Some(value) => "textBooleanTrueRep='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("textBooleanFalseRep", true) match {
        case None => ""
        case Some(value) => "textBooleanFalseRep='" + value.toString + "'"
      }
    })
  }
  booleanTextAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="BooleanBinaryAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="binaryBooleanTrueRep" type="dfdl:BinaryBooleanTrueRepType"/>
//     <xsd:attribute form="qualified" name="binaryBooleanFalseRep" type="dfdl:BinaryBooleanFalseRepType"/>
//   </xsd:attributeGroup>

trait BooleanBinaryAGQualifiedMixin extends PropertyMixin {

      final def binaryBooleanTrueRep = BinaryBooleanTrueRepType(findProperty("binaryBooleanTrueRep").value, this)
      final def binaryBooleanTrueRep_location = findProperty("binaryBooleanTrueRep").location

      final def binaryBooleanFalseRep = BinaryBooleanFalseRepType(findProperty("binaryBooleanFalseRep").value, this)
      final def binaryBooleanFalseRep_location = findProperty("binaryBooleanFalseRep").location

  def booleanBinaryAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("binaryBooleanTrueRep", false) match {
        case None => ""
        case Some(value) => "binaryBooleanTrueRep='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("binaryBooleanFalseRep", false) match {
        case None => ""
        case Some(value) => "binaryBooleanFalseRep='" + value.toString + "'"
      }
    })
  }
  booleanBinaryAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="CalendarFormatAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="calendarPattern" type="dfdl:DFDLStringLiteral"/>
//     <xsd:attribute form="qualified" name="calendarPatternKind" type="dfdl:CalendarPatternKindEnum"/>
//     <xsd:attribute form="qualified" name="calendarCheckPolicy" type="dfdl:CalendarCheckPolicyEnum"/>
//     <xsd:attribute form="qualified" name="calendarTimeZone" type="dfdl:CalendarTimeZoneType"/>
//     <xsd:attribute form="qualified" name="calendarObserveDST" type="dfdl:YesNoEnum"/>
//     <xsd:attribute form="qualified" name="calendarFirstDayOfWeek" type="dfdl:CalendarFirstDayOfWeekEnum"/>
//     <xsd:attribute form="qualified" name="calendarDaysInFirstWeek" type="dfdl:CalendarDaysInFirstWeek"/>
//     <xsd:attribute form="qualified" name="calendarCenturyStart" type="dfdl:CalendarCenturyStart"/>
//     <xsd:attribute form="qualified" name="calendarLanguage" type="dfdl:CalendarLanguageType"/>
//   </xsd:attributeGroup>

trait CalendarFormatAGQualifiedMixin extends PropertyMixin
  with CalendarPatternKindMixin
  with CalendarCheckPolicyMixin
  with CalendarFirstDayOfWeekMixin {

      final def calendarPattern = DFDLStringLiteral(findProperty("calendarPattern").value, this)
      final def calendarPattern_location = findProperty("calendarPattern").location

      final def calendarTimeZone = CalendarTimeZoneType(findProperty("calendarTimeZone").value, this)
      final def calendarTimeZone_location = findProperty("calendarTimeZone").location

      final def calendarObserveDST = YesNo(findProperty("calendarObserveDST").value, this)
      final def calendarObserveDST_location = findProperty("calendarObserveDST").location

      final def calendarDaysInFirstWeek = CalendarDaysInFirstWeek(findProperty("calendarDaysInFirstWeek").value, this)
      final def calendarDaysInFirstWeek_location = findProperty("calendarDaysInFirstWeek").location

      final def calendarCenturyStart = CalendarCenturyStart(findProperty("calendarCenturyStart").value, this)
      final def calendarCenturyStart_location = findProperty("calendarCenturyStart").location

  def calendarFormatAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("calendarPattern", false) match {
        case None => ""
        case Some(value) => "calendarPattern='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("calendarTimeZone", false) match {
        case None => ""
        case Some(value) => "calendarTimeZone='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("calendarObserveDST", false) match {
        case None => ""
        case Some(value) => "calendarObserveDST='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("calendarDaysInFirstWeek", false) match {
        case None => ""
        case Some(value) => "calendarDaysInFirstWeek='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("calendarCenturyStart", false) match {
        case None => ""
        case Some(value) => "calendarCenturyStart='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("calendarLanguage", true) match {
        case None => ""
        case Some(value) => "calendarLanguage='" + value.toString + "'"
      }
    })
  }
  calendarFormatAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="CalendarTextAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="textCalendarJustification" type="dfdl:TextCalendarJustificationEnum"/>
//     <xsd:attribute form="qualified" name="textCalendarPadCharacter" type="dfdl:DFDLStringLiteral"/>
//   </xsd:attributeGroup>

trait CalendarTextAGQualifiedMixin extends PropertyMixin
  with TextCalendarJustificationMixin {

  def calendarTextAGQualifiedInit(): Unit = {
  }
  calendarTextAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="CalendarBinaryAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="binaryCalendarRep" type="dfdl:BinaryCalendarRepEnum"/>
//     <xsd:attribute form="qualified" name="binaryCalendarEpoch" type="xsd:string"/>
//   </xsd:attributeGroup>

trait CalendarBinaryAGQualifiedMixin extends PropertyMixin
  with BinaryCalendarRepMixin {
  def binaryCalendarEpoch = convertToString(findProperty("binaryCalendarEpoch").value)

  def calendarBinaryAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("binaryCalendarEpoch", false) match {
        case None => ""
        case Some(value) => "binaryCalendarEpoch='" + value.toString + "'"
      }
    })
  }
  calendarBinaryAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="OpaqueAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//   </xsd:attributeGroup>

trait OpaqueAGQualifiedMixin extends PropertyMixin {

  def opaqueAGQualifiedInit(): Unit = {
  }
  opaqueAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NillableAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="nilKind" type="dfdl:NilKindEnum"/>
//     <xsd:attribute form="qualified" name="nilValue" type="dfdl:NonEmptyListOfDFDLStringLiteral_nilValue"/>
//     <xsd:attribute form="qualified" name="nilValueDelimiterPolicy" type="dfdl:NilValueDelimiterPolicyEnum"/>
//   </xsd:attributeGroup>

trait NillableAGQualifiedMixin extends PropertyMixin
  with NilKindMixin
  with NilValueDelimiterPolicyMixin {

  def nillableAGQualifiedInit(): Unit = {
  }
  nillableAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="DefaultValueControlAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="useNilForDefault" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait DefaultValueControlAGQualifiedMixin extends PropertyMixin {

      final def useNilForDefault = YesNo(findProperty("useNilForDefault").value, this)
      final def useNilForDefault_location = findProperty("useNilForDefault").location

  def defaultValueControlAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("useNilForDefault", false) match {
        case None => ""
        case Some(value) => "useNilForDefault='" + value.toString + "'"
      }
    })
  }
  defaultValueControlAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="SequenceAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="sequenceKind" type="dfdl:SequenceKindEnum"/>
//     <xsd:attribute form="qualified" name="hiddenGroupRef" type="xsd:QName"/>
//   </xsd:attributeGroup>

trait SequenceAGQualifiedMixin extends PropertyMixin
  with SequenceKindMixin {

  def sequenceAGQualifiedInit(): Unit = {
  }
  sequenceAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="SeparatorAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="separator" type="dfdl:ListOfDFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute form="qualified" name="separatorPosition" type="dfdl:SeparatorPositionEnum"/>
//     <xsd:attribute form="qualified" name="separatorPolicy" type="dfdl:SeparatorPolicyEnum"/>
//     <xsd:attribute form="qualified" name="separatorSuppressionPolicy" type="dfdl:SeparatorSuppressionPolicyEnum"/>      
//   </xsd:attributeGroup>

trait SeparatorAGQualifiedMixin extends PropertyMixin
  with SeparatorPositionMixin
  with SeparatorPolicyMixin {

  def separatorAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("separator", true) match {
        case None => ""
        case Some(value) => "separator='" + value.toString + "'"
      }
    })
  }
  separatorAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="GroupCommonAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="initiatedContent" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait GroupCommonAGQualifiedMixin extends PropertyMixin {

      final def initiatedContent = YesNo(findProperty("initiatedContent").value, this)
      final def initiatedContent_location = findProperty("initiatedContent").location

  def groupCommonAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("initiatedContent", false) match {
        case None => ""
        case Some(value) => "initiatedContent='" + value.toString + "'"
      }
    })
  }
  groupCommonAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="ChoiceAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="choiceLengthKind" type="dfdl:ChoiceLengthKindEnum"/>
//     <xsd:attribute form="qualified" name="choiceLength" type="dfdl:DFDLNonNegativeInteger"/>
//     <xsd:attribute form="qualified" name="choiceDispatchKey" type="dfdl:DFDLExpression"/>
//   </xsd:attributeGroup>

trait ChoiceAGQualifiedMixin extends PropertyMixin
  with ChoiceLengthKindMixin {

      final def choiceLength = DFDLNonNegativeInteger(findProperty("choiceLength").value, this)
      final def choiceLength_location = findProperty("choiceLength").location

  def choiceAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("choiceLength", false) match {
        case None => ""
        case Some(value) => "choiceLength='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("choiceDispatchKey", true) match {
        case None => ""
        case Some(value) => "choiceDispatchKey='" + value.toString + "'"
      }
    })
  }
  choiceAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="OccursAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="occursCountKind" type="dfdl:OccursCountKindEnum"/>
//     <xsd:attribute form="qualified" name="occursCount" type="dfdl:DFDLExpression"/>
//     <xsd:attribute form="qualified" name="occursStopValue" type="dfdl:ListOfDFDLStringLiteral"/>
//   </xsd:attributeGroup>

trait OccursAGQualifiedMixin extends PropertyMixin
  with OccursCountKindMixin {

      final def occursStopValue = ListOfDFDLStringLiteral(findProperty("occursStopValue").value, this)
      final def occursStopValue_location = findProperty("occursStopValue").location

  def occursAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("occursCount", true) match {
        case None => ""
        case Some(value) => "occursCount='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("occursStopValue", false) match {
        case None => ""
        case Some(value) => "occursStopValue='" + value.toString + "'"
      }
    })
  }
  occursAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="CalculatedValueAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="inputValueCalc" type="dfdl:DFDLExpression"/>
//     <xsd:attribute form="qualified" name="outputValueCalc" type="dfdl:DFDLExpression"/>
//   </xsd:attributeGroup>

trait CalculatedValueAGQualifiedMixin extends PropertyMixin {

  def calculatedValueAGQualifiedInit(): Unit = {
  }
  calculatedValueAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="DocumentPropertiesAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attribute form="qualified" name="documentFinalTerminatorCanBeMissing" type="dfdl:YesNoEnum"/>
//   </xsd:attributeGroup>

trait DocumentPropertiesAGQualifiedMixin extends PropertyMixin {

      final def documentFinalTerminatorCanBeMissing = YesNo(findProperty("documentFinalTerminatorCanBeMissing").value, this)
      final def documentFinalTerminatorCanBeMissing_location = findProperty("documentFinalTerminatorCanBeMissing").location

  def documentPropertiesAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("documentFinalTerminatorCanBeMissing", false) match {
        case None => ""
        case Some(value) => "documentFinalTerminatorCanBeMissing='" + value.toString + "'"
      }
    })
  }
  documentPropertiesAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="ElementAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attributeGroup ref="dfdl:SimpleTypeAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:FloatingAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:NillableAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:DefaultValueControlAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:OccursAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:CalculatedValueAGQualified"/>
//     <xsd:attributeGroup ref="dfdlx:RuntimePropertiesAGQualified"/>
//   </xsd:attributeGroup>

trait ElementAGQualifiedMixin extends PropertyMixin
  with SimpleTypeAGQualifiedMixin
  with FloatingAGQualifiedMixin
  with NillableAGQualifiedMixin
  with DefaultValueControlAGQualifiedMixin
  with OccursAGQualifiedMixin
  with CalculatedValueAGQualifiedMixin
  with RuntimePropertiesAGQualifiedMixin {

  def elementAGQualifiedInit(): Unit = {
  }
  elementAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="GroupAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attributeGroup ref="dfdl:GroupCommonAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:SequenceAGQualified"/>
//     <xsd:attributeGroup ref="dfdlx:ExtLayeringAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:ChoiceAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:SeparatorAGQualified"/>
//   </xsd:attributeGroup>

trait GroupAGQualifiedMixin extends PropertyMixin
  with GroupCommonAGQualifiedMixin
  with SequenceAGQualifiedMixin
  with ExtLayeringAGQualifiedMixin
  with ChoiceAGQualifiedMixin
  with SeparatorAGQualifiedMixin {

  def groupAGQualifiedInit(): Unit = {
  }
  groupAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="SimpleTypeAGQualified" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext">
//     <xsd:attributeGroup ref="dfdl:RepresentationAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:NonGroupMarkupAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:LengthAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:SimpleTypesTextAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:StringTextAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:NumberAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:NumberTextAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:TextNumberFormatAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:NumberBinaryAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:FloatBinaryAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:TextBidiSchemeAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:CalendarTextAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:CalendarBinaryAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:CalendarFormatAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:BooleanTextAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:BooleanBinaryAGQualified"/>
//     <xsd:attributeGroup ref="dfdlx:ObjectKindAGQualified"/>
//     <xsd:attributeGroup ref="dfdlx:RepTypeAGQualified"/>
//   </xsd:attributeGroup>

trait SimpleTypeAGQualifiedMixin extends PropertyMixin
  with RepresentationAGQualifiedMixin
  with NonGroupMarkupAGQualifiedMixin
  with LengthAGQualifiedMixin
  with SimpleTypesTextAGQualifiedMixin
  with StringTextAGQualifiedMixin
  with NumberAGQualifiedMixin
  with NumberTextAGQualifiedMixin
  with TextNumberFormatAGQualifiedMixin
  with NumberBinaryAGQualifiedMixin
  with FloatBinaryAGQualifiedMixin
  with TextBidiSchemeAGQualifiedMixin
  with CalendarTextAGQualifiedMixin
  with CalendarBinaryAGQualifiedMixin
  with CalendarFormatAGQualifiedMixin
  with BooleanTextAGQualifiedMixin
  with BooleanBinaryAGQualifiedMixin
  with ObjectKindAGQualifiedMixin
  with RepTypeAGQualifiedMixin {

  def simpleTypeAGQualifiedInit(): Unit = {
  }
  simpleTypeAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:element name="defineFormat" type="dfdl:DFDLDefineFormat" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int"/>

trait DefineFormat_AnnotationMixin extends PropertyMixin
  with DFDLDefineFormatMixin {

  def defineFormat_AnnotationInit(): Unit = {
  }
  defineFormat_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLDefineFormat" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:sequence>
//       <xsd:element maxOccurs="unbounded" minOccurs="0" ref="dfdl:format"/>
//     </xsd:sequence>
//     <xsd:attribute name="name" type="xsd:NCName" use="required"/>
//     <xsd:attributeGroup ref="dafint:daffodilAG"/>
//   </xsd:complexType>

trait DFDLDefineFormatMixin extends PropertyMixin {
  def name = convertToNCName(findProperty("name").value)

  def dFDLDefineFormatInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("name", false) match {
        case None => ""
        case Some(value) => "name='" + value.toString + "'"
      }
    })
  }
  dFDLDefineFormatInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:element name="format" type="dfdl:DFDLFormat" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int"/>

trait Format_AnnotationMixin extends PropertyMixin
  with DFDLFormatMixin {

  def format_AnnotationInit(): Unit = {
  }
  format_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLFormat" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexContent>
//       <xsd:extension base="dfdl:DFDLBaseType">
//         <xsd:sequence/>
//         <xsd:attributeGroup ref="dfdl:FormatAG"/>
//       </xsd:extension>
//     </xsd:complexContent>
//   </xsd:complexType>

trait DFDLFormatMixin extends PropertyMixin
  with DFDLBaseTypeMixin
  with FormatAGMixin {

  def dFDLFormatInit(): Unit = {
  }
  dFDLFormatInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:element name="defineEscapeScheme" type="dfdl:DFDLDefineEscapeScheme" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int"/>

trait DefineEscapeScheme_AnnotationMixin extends PropertyMixin
  with DFDLDefineEscapeSchemeMixin {

  def defineEscapeScheme_AnnotationInit(): Unit = {
  }
  defineEscapeScheme_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLDefineEscapeScheme" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:sequence>
//       <xsd:element ref="dfdl:escapeScheme"/>
//     </xsd:sequence>
//     <xsd:attribute name="name" type="xsd:NCName" use="required"/>
//     <xsd:attributeGroup ref="dafint:daffodilAG"/>
//   </xsd:complexType>

trait DFDLDefineEscapeSchemeMixin extends PropertyMixin {
  def name = convertToNCName(findProperty("name").value)

  def dFDLDefineEscapeSchemeInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("name", false) match {
        case None => ""
        case Some(value) => "name='" + value.toString + "'"
      }
    })
  }
  dFDLDefineEscapeSchemeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:element name="escapeScheme" type="dfdl:DFDLEscapeScheme" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int"/>

trait EscapeScheme_AnnotationMixin extends PropertyMixin
  with DFDLEscapeSchemeMixin {

  def escapeScheme_AnnotationInit(): Unit = {
  }
  escapeScheme_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLEscapeScheme" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexContent>
//       <xsd:extension base="dfdl:DFDLType">
//         <xsd:sequence/>
//         <xsd:attributeGroup ref="dfdl:EscapeSchemeAG"/>
//       </xsd:extension>
//     </xsd:complexContent>
//   </xsd:complexType>

trait DFDLEscapeSchemeMixin extends PropertyMixin
  with DFDLTypeMixin
  with EscapeSchemeAGMixin {

  def dFDLEscapeSchemeInit(): Unit = {
  }
  dFDLEscapeSchemeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLVariableType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:simpleContent>
//       <xsd:extension base="dfdl:DFDLStringLiteral_Or_DFDLExpression">
//         <xsd:attributeGroup ref="dafint:daffodilAG"/>
//       </xsd:extension>
//     </xsd:simpleContent>
//   </xsd:complexType>

trait DFDLVariableTypeMixin extends PropertyMixin
  with DFDLStringLiteral_Or_DFDLExpressionMixin {

  def dFDLVariableTypeInit(): Unit = {
  }
  dFDLVariableTypeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="DefineVariableAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:attribute name="name" type="xsd:NCName" use="required"/>
//     <xsd:attribute name="predefined" type="xsd:boolean"/>
//     <xsd:attribute name="type" type="xsd:QName"/>
//     <xsd:attribute name="external" type="xsd:boolean"/>
//     <xsd:attribute name="defaultValue" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//     <xsd:attribute ref="dfdlx:direction"/>
//   </xsd:attributeGroup>

trait DefineVariableAGMixin extends PropertyMixin
  with VariableDirectionMixin {
  def predefined = convertToBoolean(findProperty("predefined").value)
  def external = convertToBoolean(findProperty("external").value)

  def defineVariableAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("predefined", false) match {
        case None => ""
        case Some(value) => "predefined='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("external", false) match {
        case None => ""
        case Some(value) => "external='" + value.toString + "'"
      }
    })
  }
  defineVariableAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="SetVariableAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:attribute name="ref" type="xsd:QName" use="required"/>
//     <xsd:attribute name="value" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//   </xsd:attributeGroup>

trait SetVariableAGMixin extends PropertyMixin {

      final def value = DFDLStringLiteral_Or_DFDLExpression(findProperty("value").value, this)
      final def value_location = findProperty("value").location

  def setVariableAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("value", false) match {
        case None => ""
        case Some(value) => "value='" + value.toString + "'"
      }
    })
  }
  setVariableAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="NewVariableInstanceAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:attribute name="ref" type="xsd:QName" use="required"/>
//     <xsd:attribute name="defaultValue" type="dfdl:DFDLStringLiteral_Or_DFDLExpression"/>
//   </xsd:attributeGroup>

trait NewVariableInstanceAGMixin extends PropertyMixin {

  def newVariableInstanceAGInit(): Unit = {
  }
  newVariableInstanceAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//       <xsd:simpleContent>
//         <xsd:extension base="dfdl:DFDLVariableType">
//           <xsd:attributeGroup ref="dfdl:DefineVariableAG"/>
//         </xsd:extension>
//       </xsd:simpleContent>
//     </xsd:complexType>

trait DFDLDefineVariableTypeMixin extends PropertyMixin
  with DFDLVariableTypeMixin
  with DefineVariableAGMixin {

  def dFDLDefineVariableTypeInit(): Unit = {
  }
  dFDLDefineVariableTypeInit()
}

////////////////////////////////////
////////////////////////////////////
// <xsd:element name="defineVariable" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexType>
//       <xsd:simpleContent>
//         <xsd:extension base="dfdl:DFDLVariableType">
//           <xsd:attributeGroup ref="dfdl:DefineVariableAG"/>
//         </xsd:extension>
//       </xsd:simpleContent>
//     </xsd:complexType>
//   </xsd:element>

trait DefineVariable_AnnotationMixin extends PropertyMixin
  with DFDLDefineVariableTypeMixin
  with DefineVariableAGMixin {

  def defineVariable_AnnotationInit(): Unit = {
  }
  defineVariable_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//       <xsd:simpleContent>
//         <xsd:extension base="dfdl:DFDLVariableType">
//           <xsd:attributeGroup ref="dfdl:NewVariableInstanceAG"/>
//         </xsd:extension>
//       </xsd:simpleContent>
//     </xsd:complexType>

trait DFDLNewVariableInstanceTypeMixin extends PropertyMixin
  with DFDLVariableTypeMixin
  with NewVariableInstanceAGMixin {

  def dFDLNewVariableInstanceTypeInit(): Unit = {
  }
  dFDLNewVariableInstanceTypeInit()
}

////////////////////////////////////
////////////////////////////////////
// <xsd:element name="newVariableInstance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexType>
//       <xsd:simpleContent>
//         <xsd:extension base="dfdl:DFDLVariableType">
//           <xsd:attributeGroup ref="dfdl:NewVariableInstanceAG"/>
//         </xsd:extension>
//       </xsd:simpleContent>
//     </xsd:complexType>
//   </xsd:element>

trait NewVariableInstance_AnnotationMixin extends PropertyMixin
  with DFDLNewVariableInstanceTypeMixin
  with NewVariableInstanceAGMixin {

  def newVariableInstance_AnnotationInit(): Unit = {
  }
  newVariableInstance_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//       <xsd:simpleContent>
//         <xsd:extension base="dfdl:DFDLVariableType">
//           <xsd:attributeGroup ref="dfdl:SetVariableAG"/>
//         </xsd:extension>
//       </xsd:simpleContent>
//     </xsd:complexType>

trait DFDLSetVariableTypeMixin extends PropertyMixin
  with DFDLVariableTypeMixin
  with SetVariableAGMixin {

  def dFDLSetVariableTypeInit(): Unit = {
  }
  dFDLSetVariableTypeInit()
}

////////////////////////////////////
////////////////////////////////////
// <xsd:element name="setVariable" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexType>
//       <xsd:simpleContent>
//         <xsd:extension base="dfdl:DFDLVariableType">
//           <xsd:attributeGroup ref="dfdl:SetVariableAG"/>
//         </xsd:extension>
//       </xsd:simpleContent>
//     </xsd:complexType>
//   </xsd:element>

trait SetVariable_AnnotationMixin extends PropertyMixin
  with DFDLSetVariableTypeMixin
  with SetVariableAGMixin {

  def setVariable_AnnotationInit(): Unit = {
  }
  setVariable_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="TestConditionAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:attribute name="test" type="dfdl:DFDLExpression"/>
//     <xsd:attribute name="testKind" type="dfdl:TestKindEnum"/>
//     <xsd:attribute name="testPattern" type="dfdl:DFDLRegularExpression"/>
//     <xsd:attribute name="message" type="xsd:string"/>
//     <xsd:attribute name="failureType" type="dfdl:FailureTypeEnum"/>
//   </xsd:attributeGroup>

trait TestConditionAGMixin extends PropertyMixin
  with TestKindMixin
  with FailureTypeMixin {

      final def testPattern = DFDLRegularExpression(findProperty("testPattern").value, this)
      final def testPattern_location = findProperty("testPattern").location

  def testConditionAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("testPattern", false) match {
        case None => ""
        case Some(value) => "testPattern='" + value.toString + "'"
      }
    })
  }
  testConditionAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="TestCondition" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:simpleContent>
//       <xsd:extension base="dfdl:DFDLExpressionOrPatternOrNothing"> <!-- changed to accept regex -->
//         <xsd:attributeGroup ref="dfdl:TestConditionAG"/>
//         <xsd:attributeGroup ref="dafint:daffodilAG"/>
//       </xsd:extension>
//     </xsd:simpleContent>
//   </xsd:complexType>

trait TestConditionMixin extends PropertyMixin
  with DFDLExpressionOrPatternOrNothingMixin
  with TestConditionAGMixin {

  def testConditionInit(): Unit = {
  }
  testConditionInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//       <xsd:simpleContent>
//         <xsd:extension base="dfdl:TestCondition">
//         </xsd:extension>
//       </xsd:simpleContent>
//     </xsd:complexType>

trait DFDLAssertTypeMixin extends PropertyMixin
  with TestConditionMixin {

  def dFDLAssertTypeInit(): Unit = {
  }
  dFDLAssertTypeInit()
}

////////////////////////////////////
////////////////////////////////////
// <xsd:element name="assert" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexType>
//       <xsd:simpleContent>
//         <xsd:extension base="dfdl:TestCondition">
//         </xsd:extension>
//       </xsd:simpleContent>
//     </xsd:complexType>
//   </xsd:element>

trait Assert_AnnotationMixin extends PropertyMixin
  with DFDLAssertTypeMixin {

  def assert_AnnotationInit(): Unit = {
  }
  assert_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//       <xsd:simpleContent>
//         <xsd:extension base="dfdl:TestCondition">
//         </xsd:extension>
//       </xsd:simpleContent>
//     </xsd:complexType>

trait DFDLDiscriminatorTypeMixin extends PropertyMixin
  with TestConditionMixin {

  def dFDLDiscriminatorTypeInit(): Unit = {
  }
  dFDLDiscriminatorTypeInit()
}

////////////////////////////////////
////////////////////////////////////
// <xsd:element name="discriminator" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexType>
//       <xsd:simpleContent>
//         <xsd:extension base="dfdl:TestCondition">
//         </xsd:extension>
//       </xsd:simpleContent>
//     </xsd:complexType>
//   </xsd:element>

trait Discriminator_AnnotationMixin extends PropertyMixin
  with DFDLDiscriminatorTypeMixin {

  def discriminator_AnnotationInit(): Unit = {
  }
  discriminator_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:element name="element" type="dfdl:DFDLElementType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int"/>

trait Element_AnnotationMixin extends PropertyMixin
  with DFDLElementTypeMixin {

  def element_AnnotationInit(): Unit = {
  }
  element_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:element name="sequence" type="dfdl:DFDLSequenceType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int"/>

trait Sequence_AnnotationMixin extends PropertyMixin
  with DFDLSequenceTypeMixin {

  def sequence_AnnotationInit(): Unit = {
  }
  sequence_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:element name="choice" type="dfdl:DFDLChoiceType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int"/>

trait Choice_AnnotationMixin extends PropertyMixin
  with DFDLChoiceTypeMixin {

  def choice_AnnotationInit(): Unit = {
  }
  choice_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:element name="group" type="dfdl:DFDLGroupType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int"/>

trait Group_AnnotationMixin extends PropertyMixin
  with DFDLGroupTypeMixin {

  def group_AnnotationInit(): Unit = {
  }
  group_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:element name="simpleType" type="dfdl:DFDLSimpleType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int"/>

trait SimpleType_AnnotationMixin extends PropertyMixin
  with DFDLSimpleTypeMixin {

  def simpleType_AnnotationInit(): Unit = {
  }
  simpleType_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:element name="enumeration" type="dfdl:DFDLEnumerationType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int"/>

trait Enumeration_AnnotationMixin extends PropertyMixin
  with DFDLEnumerationTypeMixin {

  def enumeration_AnnotationInit(): Unit = {
  }
  enumeration_AnnotationInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType abstract="true" name="DFDLType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:sequence>
//       <xsd:element maxOccurs="unbounded" minOccurs="0" ref="dfdl:property"/>
//       <xsd:element maxOccurs="unbounded" minOccurs="0" ref="daf:property"/>
//     </xsd:sequence>
//     <xsd:attributeGroup ref="dafint:daffodilAG"/> 
//   </xsd:complexType>

trait DFDLTypeMixin extends PropertyMixin {

  def dFDLTypeInit(): Unit = {
  }
  dFDLTypeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType abstract="true" name="DFDLBaseType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexContent>
//       <xsd:extension base="dfdl:DFDLType">
//         <xsd:sequence/>
//         <xsd:attributeGroup ref="dfdl:BaseAG"/>
//         <xsd:attributeGroup ref="dfdl:CommonAG"/>
//         <xsd:attributeGroup ref="dfdl:AlignmentAG"/>
//         <xsd:attributeGroup ref="dfdl:MarkupAG"/>
//       </xsd:extension>
//     </xsd:complexContent>
//   </xsd:complexType>

trait DFDLBaseTypeMixin extends PropertyMixin
  with DFDLTypeMixin
  with BaseAGMixin
  with CommonAGMixin
  with AlignmentAGMixin
  with MarkupAGMixin {

  def dFDLBaseTypeInit(): Unit = {
  }
  dFDLBaseTypeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLElementType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexContent>
//       <xsd:extension base="dfdl:DFDLBaseType">
//         <xsd:sequence/>
//         <xsd:attributeGroup ref="dfdl:ElementAG"/>
//       </xsd:extension>
//     </xsd:complexContent>
//   </xsd:complexType>

trait DFDLElementTypeMixin extends PropertyMixin
  with DFDLBaseTypeMixin
  with ElementAGMixin {

  def dFDLElementTypeInit(): Unit = {
  }
  dFDLElementTypeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLSequenceType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexContent>
//       <xsd:extension base="dfdl:DFDLBaseType">
//         <xsd:sequence/>
//         <xsd:attributeGroup ref="dfdl:GroupCommonAG"/>
//         <xsd:attributeGroup ref="dfdl:SequenceAG"/>
//         <xsd:attributeGroup ref="dfdlx:ExtLayeringAGQualified"/>
//         <xsd:attributeGroup ref="dfdl:SeparatorAG"/>
//       </xsd:extension>
//     </xsd:complexContent>
//   </xsd:complexType>

trait DFDLSequenceTypeMixin extends PropertyMixin
  with DFDLBaseTypeMixin
  with GroupCommonAGMixin
  with SequenceAGMixin
  with ExtLayeringAGQualifiedMixin
  with SeparatorAGMixin {

  def dFDLSequenceTypeInit(): Unit = {
  }
  dFDLSequenceTypeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLChoiceType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexContent>
//       <xsd:extension base="dfdl:DFDLBaseType">
//         <xsd:sequence/>
//         <xsd:attributeGroup ref="dfdl:GroupCommonAG"/>
//         <xsd:attributeGroup ref="dfdl:ChoiceAG"/>
//       </xsd:extension>
//     </xsd:complexContent>
//   </xsd:complexType>

trait DFDLChoiceTypeMixin extends PropertyMixin
  with DFDLBaseTypeMixin
  with GroupCommonAGMixin
  with ChoiceAGMixin {

  def dFDLChoiceTypeInit(): Unit = {
  }
  dFDLChoiceTypeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLSimpleType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexContent>
//       <xsd:extension base="dfdl:DFDLBaseType">
//         <xsd:sequence/>
//         <xsd:attributeGroup ref="dfdl:SimpleTypeAG"/>
//       </xsd:extension>
//     </xsd:complexContent>
//   </xsd:complexType>

trait DFDLSimpleTypeMixin extends PropertyMixin
  with DFDLBaseTypeMixin
  with SimpleTypeAGMixin {

  def dFDLSimpleTypeInit(): Unit = {
  }
  dFDLSimpleTypeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLEnumerationType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:attributeGroup ref="dfdlx:RepValuesAG"/>
//   </xsd:complexType>

trait DFDLEnumerationTypeMixin extends PropertyMixin
  with RepValuesAGMixin {

  def dFDLEnumerationTypeInit(): Unit = {
  }
  dFDLEnumerationTypeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:complexType name="DFDLGroupType" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:complexContent>
//       <xsd:extension base="dfdl:DFDLBaseType">
//         <xsd:sequence/>
//         <xsd:attributeGroup ref="dfdl:GroupAG"/>
//       </xsd:extension>
//     </xsd:complexContent>
//   </xsd:complexType>

trait DFDLGroupTypeMixin extends PropertyMixin
  with DFDLBaseTypeMixin
  with GroupAGMixin {

  def dFDLGroupTypeInit(): Unit = {
  }
  dFDLGroupTypeInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="FormatAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:attributeGroup ref="dfdl:ElementFormatSubsetAG"/>
//     <xsd:attributeGroup ref="dfdl:GroupAG"/>
//     <xsd:attributeGroup ref="dfdl:DocumentPropertiesAG"/>
//   </xsd:attributeGroup>

trait FormatAGMixin extends PropertyMixin
  with ElementFormatSubsetAGMixin
  with GroupAGMixin
  with DocumentPropertiesAGMixin {

  def formatAGInit(): Unit = {
  }
  formatAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="ElementFormatSubsetAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:attributeGroup ref="dfdl:SimpleTypeAG"/>
//     <xsd:attributeGroup ref="dfdl:FloatingAG"/>
//     <xsd:attributeGroup ref="dfdl:NillableAG"/>
//     <xsd:attributeGroup ref="dfdl:DefaultValueControlAG"/>
//     <xsd:attributeGroup ref="dfdl:OccursAG"/>
//     <xsd:attributeGroup ref="dfdlx:RuntimePropertiesAG"/>
//   </xsd:attributeGroup>

trait ElementFormatSubsetAGMixin extends PropertyMixin
  with SimpleTypeAGMixin
  with FloatingAGMixin
  with NillableAGMixin
  with DefaultValueControlAGMixin
  with OccursAGMixin
  with RuntimePropertiesAGMixin {

  def elementFormatSubsetAGInit(): Unit = {
  }
  elementFormatSubsetAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="ElementAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:attributeGroup ref="dfdl:ElementFormatSubsetAG"/>
//     <xsd:attributeGroup ref="dfdl:CalculatedValueAG"/>
//   </xsd:attributeGroup>

trait ElementAGMixin extends PropertyMixin
  with ElementFormatSubsetAGMixin
  with CalculatedValueAGMixin {

  def elementAGInit(): Unit = {
  }
  elementAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="GroupAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:attributeGroup ref="dfdl:GroupCommonAG"/>
//     <xsd:attributeGroup ref="dfdl:SequenceAG"/>
//     <xsd:attributeGroup ref="dfdlx:ExtLayeringAGQualified"/>
//     <xsd:attributeGroup ref="dfdl:ChoiceAG"/>
//     <xsd:attributeGroup ref="dfdl:SeparatorAG"/>
//   </xsd:attributeGroup>

trait GroupAGMixin extends PropertyMixin
  with GroupCommonAGMixin
  with SequenceAGMixin
  with ExtLayeringAGQualifiedMixin
  with ChoiceAGMixin
  with SeparatorAGMixin {

  def groupAGInit(): Unit = {
  }
  groupAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xsd:attributeGroup name="SimpleTypeAG" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xsd:attributeGroup ref="dfdl:RepresentationAG"/>
//     <xsd:attributeGroup ref="dfdl:NonGroupMarkupAG"/>
//     <xsd:attributeGroup ref="dfdl:LengthAG"/>
//     <xsd:attributeGroup ref="dfdl:SimpleTypesTextAG"/>
//     <xsd:attributeGroup ref="dfdl:StringTextAG"/>
//     <xsd:attributeGroup ref="dfdl:NumberAG"/>
//     <xsd:attributeGroup ref="dfdl:NumberTextAG"/>
//     <xsd:attributeGroup ref="dfdl:TextNumberFormatAG"/>
//     <xsd:attributeGroup ref="dfdl:NumberBinaryAG"/>
//     <xsd:attributeGroup ref="dfdl:FloatBinaryAG"/>
//     <xsd:attributeGroup ref="dfdl:TextBidiSchemeAG"/>
//     <xsd:attributeGroup ref="dfdl:CalendarTextAG"/>
//     <xsd:attributeGroup ref="dfdl:CalendarBinaryAG"/>
//     <xsd:attributeGroup ref="dfdl:CalendarFormatAG"/>
//     <xsd:attributeGroup ref="dfdl:BooleanTextAG"/>
//     <xsd:attributeGroup ref="dfdl:BooleanBinaryAG"/>
//     <xsd:attributeGroup ref="dfdlx:ObjectKindAG"/>
//     <xsd:attributeGroup ref="dfdlx:RepTypeAG"/>
//   </xsd:attributeGroup>

trait SimpleTypeAGMixin extends PropertyMixin
  with RepresentationAGMixin
  with NonGroupMarkupAGMixin
  with LengthAGMixin
  with SimpleTypesTextAGMixin
  with StringTextAGMixin
  with NumberAGMixin
  with NumberTextAGMixin
  with TextNumberFormatAGMixin
  with NumberBinaryAGMixin
  with FloatBinaryAGMixin
  with TextBidiSchemeAGMixin
  with CalendarTextAGMixin
  with CalendarBinaryAGMixin
  with CalendarFormatAGMixin
  with BooleanTextAGMixin
  with BooleanBinaryAGMixin
  with ObjectKindAGMixin
  with RepTypeAGMixin {

  def simpleTypeAGInit(): Unit = {
  }
  simpleTypeAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xs:simpleType name="AlignmentKindEnum" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:restriction base="xs:string">
//       <xs:enumeration value="automatic"/>
//       <xs:enumeration value="manual"/>
//     </xs:restriction>
//   </xs:simpleType>

sealed trait AlignmentKind extends AlignmentKind.Value
object AlignmentKind extends Enum[AlignmentKind] {
  case object Automatic extends AlignmentKind
  case object Manual extends AlignmentKind
  override lazy val values = Array(Automatic, Manual)

  def apply(name: String, context : ThrowsSDE) : AlignmentKind = stringToEnum("alignmentKind", name, context)
}

trait AlignmentKindMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionAlignmentKindLookup = findPropertyOption("alignmentKind")
  final def optionAlignmentKind = if (optionAlignmentKindLookup.isDefined) Some(alignmentKind) else None
  final def optionAlignmentKind_location = if (optionAlignmentKindLookup.isDefined) Some(alignmentKind_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def alignmentKindLookup = requireProperty(optionAlignmentKindLookup)
  final def alignmentKind = AlignmentKind(alignmentKindLookup.value, this)
  final def alignmentKind_location = alignmentKindLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def alignmentKindToString() = {
    optionAlignmentKind match {
      case None => "" // empty string if not present
      case Some(alignmentKind) =>  "alignmentKind='" + alignmentKind + "' "
    }
  }

  final def alignmentKindInit() = {
    registerToStringFunction(() => alignmentKindToString)
  }

  alignmentKindInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xs:simpleType name="ParseUnparsePolicyEnum" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:restriction base="xs:string">
//       <xs:enumeration value="both"/>
//       <xs:enumeration value="parseOnly"/>
//       <xs:enumeration value="unparseOnly"/>
//     </xs:restriction>
//   </xs:simpleType>

sealed trait ParseUnparsePolicy extends ParseUnparsePolicy.Value
object ParseUnparsePolicy extends Enum[ParseUnparsePolicy] {
  case object Both extends ParseUnparsePolicy
  case object ParseOnly extends ParseUnparsePolicy
  case object UnparseOnly extends ParseUnparsePolicy
  override lazy val values = Array(Both, ParseOnly, UnparseOnly)

  def apply(name: String, context : ThrowsSDE) : ParseUnparsePolicy = stringToEnum("parseUnparsePolicy", name, context)
}

trait ParseUnparsePolicyMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionParseUnparsePolicyLookup = findPropertyOption("parseUnparsePolicy")
  final def optionParseUnparsePolicy = if (optionParseUnparsePolicyLookup.isDefined) Some(parseUnparsePolicy) else None
  final def optionParseUnparsePolicy_location = if (optionParseUnparsePolicyLookup.isDefined) Some(parseUnparsePolicy_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def parseUnparsePolicyLookup = requireProperty(optionParseUnparsePolicyLookup)
  final def parseUnparsePolicy = ParseUnparsePolicy(parseUnparsePolicyLookup.value, this)
  final def parseUnparsePolicy_location = parseUnparsePolicyLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def parseUnparsePolicyToString() = {
    optionParseUnparsePolicy match {
      case None => "" // empty string if not present
      case Some(parseUnparsePolicy) =>  "parseUnparsePolicy='" + parseUnparsePolicy + "' "
    }
  }

  final def parseUnparsePolicyInit() = {
    registerToStringFunction(() => parseUnparsePolicyToString)
  }

  parseUnparsePolicyInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xs:simpleType name="VariableDirectionEnum" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:restriction base="xs:string">
//       <xs:enumeration value="both"/>
//       <xs:enumeration value="parseOnly"/>
//       <xs:enumeration value="unparseOnly"/>
//     </xs:restriction>
//   </xs:simpleType>

sealed trait VariableDirection extends VariableDirection.Value
object VariableDirection extends Enum[VariableDirection] {
  case object Both extends VariableDirection
  case object ParseOnly extends VariableDirection
  case object UnparseOnly extends VariableDirection
  override lazy val values = Array(Both, ParseOnly, UnparseOnly)

  def apply(name: String, context : ThrowsSDE) : VariableDirection = stringToEnum("variableDirection", name, context)
}

trait VariableDirectionMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionVariableDirectionLookup = findPropertyOption("variableDirection")
  final def optionVariableDirection = if (optionVariableDirectionLookup.isDefined) Some(variableDirection) else None
  final def optionVariableDirection_location = if (optionVariableDirectionLookup.isDefined) Some(variableDirection_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def variableDirectionLookup = requireProperty(optionVariableDirectionLookup)
  final def variableDirection = VariableDirection(variableDirectionLookup.value, this)
  final def variableDirection_location = variableDirectionLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def variableDirectionToString() = {
    optionVariableDirection match {
      case None => "" // empty string if not present
      case Some(variableDirection) =>  "variableDirection='" + variableDirection + "' "
    }
  }

  final def variableDirectionInit() = {
    registerToStringFunction(() => variableDirectionToString)
  }

  variableDirectionInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xs:attributeGroup name="RepValuesAG" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:attribute form="qualified" name="repValues" type="dfdl:NonEmptyListofDFDLStringLiteralOrNonEmptyListOfInteger"/>
//     <xs:attribute form="qualified" name="repValueRanges" type="dfdl:NonEmptyListOfInteger"/>
//   </xs:attributeGroup>

trait RepValuesAGMixin extends PropertyMixin {

      final def repValues = NonEmptyListofDFDLStringLiteralOrNonEmptyListOfInteger(findProperty("repValues").value, this)
      final def repValues_location = findProperty("repValues").location

      final def repValueRanges = NonEmptyListOfInteger(findProperty("repValueRanges").value, this)
      final def repValueRanges_location = findProperty("repValueRanges").location

  def repValuesAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("repValues", false) match {
        case None => ""
        case Some(value) => "repValues='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("repValueRanges", false) match {
        case None => ""
        case Some(value) => "repValueRanges='" + value.toString + "'"
      }
    })
  }
  repValuesAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xs:attributeGroup name="RepValuesAGQualified" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:attribute form="qualified" name="repValues" type="dfdl:NonEmptyListofDFDLStringLiteralOrNonEmptyListOfInteger"/>
//     <xs:attribute form="qualified" name="repValueRanges" type="dfdl:NonEmptyListOfInteger"/>
//   </xs:attributeGroup>

trait RepValuesAGQualifiedMixin extends PropertyMixin {

      final def repValues = NonEmptyListofDFDLStringLiteralOrNonEmptyListOfInteger(findProperty("repValues").value, this)
      final def repValues_location = findProperty("repValues").location

      final def repValueRanges = NonEmptyListOfInteger(findProperty("repValueRanges").value, this)
      final def repValueRanges_location = findProperty("repValueRanges").location

  def repValuesAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("repValues", false) match {
        case None => ""
        case Some(value) => "repValues='" + value.toString + "'"
      }
    })
    registerToStringFunction(()=>{getPropertyOption("repValueRanges", false) match {
        case None => ""
        case Some(value) => "repValueRanges='" + value.toString + "'"
      }
    })
  }
  repValuesAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xs:attributeGroup name="RepTypeAG" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:attribute form="qualified" name="repType" type="xsd:QName"/>
//   </xs:attributeGroup>

trait RepTypeAGMixin extends PropertyMixin {

  def repType = {
    val cp = findProperty("repType")
    convertToQName(cp.value, cp.location)
  }
  def repTypeOption = findPropertyOption("repType") match {
    case Found(s, ll, _, _) => Some(convertToQName(s, ll))
    case _ => None
  }

  def repTypeAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("repType", false) match {
        case None => ""
        case Some(value) => "repType='" + value.toString + "'"
      }
    })
  }
  repTypeAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xs:attributeGroup name="RepTypeAGQualified" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:attribute form="qualified" name="repType" type="xsd:QName"/>
//   </xs:attributeGroup>

trait RepTypeAGQualifiedMixin extends PropertyMixin {

  def repType = {
    val cp = findProperty("repType")
    convertToQName(cp.value, cp.location)
  }
  def repTypeOption = findPropertyOption("repType") match {
    case Found(s, ll, _, _) => Some(convertToQName(s, ll))
    case _ => None
  }

  def repTypeAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("repType", false) match {
        case None => ""
        case Some(value) => "repType='" + value.toString + "'"
      }
    })
  }
  repTypeAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xs:attributeGroup name="ExtLayeringAGQualified" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:attribute form="qualified" name="layer" type="xsd:QName" use="optional"/>
//   </xs:attributeGroup>

trait ExtLayeringAGQualifiedMixin extends PropertyMixin {

  def layer = {
    val cp = findProperty("layer")
    convertToQName(cp.value, cp.location)
  }
  def layerOption = findPropertyOption("layer") match {
    case Found(s, ll, _, _) => Some(convertToQName(s, ll))
    case _ => None
  }

  def extLayeringAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("layer", false) match {
        case None => ""
        case Some(value) => "layer='" + value.toString + "'"
      }
    })
  }
  extLayeringAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xs:attributeGroup name="ObjectKindAG" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:attribute form="qualified" name="objectKind" type="dfdlx:ObjectKindType"/>
//   </xs:attributeGroup>

trait ObjectKindAGMixin extends PropertyMixin {

      final def objectKind = ObjectKindType(findProperty("objectKind").value, this)
      final def objectKind_location = findProperty("objectKind").location

  def objectKindAGInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("objectKind", false) match {
        case None => ""
        case Some(value) => "objectKind='" + value.toString + "'"
      }
    })
  }
  objectKindAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xs:attributeGroup name="ObjectKindAGQualified" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:attribute form="qualified" name="objectKind" type="dfdlx:ObjectKindType"/>
//   </xs:attributeGroup>

trait ObjectKindAGQualifiedMixin extends PropertyMixin {

      final def objectKind = ObjectKindType(findProperty("objectKind").value, this)
      final def objectKind_location = findProperty("objectKind").location

  def objectKindAGQualifiedInit(): Unit = {
    registerToStringFunction(()=>{getPropertyOption("objectKind", false) match {
        case None => ""
        case Some(value) => "objectKind='" + value.toString + "'"
      }
    })
  }
  objectKindAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xs:simpleType name="ObjectKindType" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:restriction base="xs:string">
//       <xs:enumeration value="bytes"/>
//       <xs:enumeration value="chars"/>
//     </xs:restriction>
//   </xs:simpleType>

sealed trait ObjectKindType extends ObjectKindType.Value
object ObjectKindType extends Enum[ObjectKindType] {
  case object Bytes extends ObjectKindType
  case object Chars extends ObjectKindType
  override lazy val values = Array(Bytes, Chars)

  def apply(name: String, context : ThrowsSDE) : ObjectKindType = stringToEnum("objectKindType", name, context)
}

trait ObjectKindTypeMixin extends PropertyMixin {

  /**
   * get Some(property value) or None if not defined in scope.
   *
   * Mostly do not use this. Most code shouldn't need to test for
   * property existence. Just insist on the property you need by
   * using its name. E.g., if you need calendarTimeZone, just use
   * a.calendarTimeZone (where a is an AnnotatedSchemaComponent)
   */
  private def optionObjectKindTypeLookup = findPropertyOption("objectKindType")
  final def optionObjectKindType = if (optionObjectKindTypeLookup.isDefined) Some(objectKindType) else None
  final def optionObjectKindType_location = if (optionObjectKindTypeLookup.isDefined) Some(objectKindType_location) else None

  /**
   * get property value, or fail trying. Use this if you need
   * the property value.
   *
   * Also gets the schema component where the property was found
   * so that one can report errors/diagnostics relative to that
   * location, not the point of use of the property.
   */
  private def objectKindTypeLookup = requireProperty(optionObjectKindTypeLookup)
  final def objectKindType = ObjectKindType(objectKindTypeLookup.value, this)
  final def objectKindType_location = objectKindTypeLookup.location

  /**
   * This will print the property value if the property has any value
   * in scope. This is mostly for debugging purposes.
   */
  final def objectKindTypeToString() = {
    optionObjectKindType match {
      case None => "" // empty string if not present
      case Some(objectKindType) =>  "objectKindType='" + objectKindType + "' "
    }
  }

  final def objectKindTypeInit() = {
    registerToStringFunction(() => objectKindTypeToString)
  }

  objectKindTypeInit() // call at object creation to initialize
}

////////////////////////////////////////////////////////////////////////
// <xs:attributeGroup name="RuntimePropertiesAG" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:attribute form="qualified" name="runtimeProperties" type="dfdlx:RuntimePropertiesType"/>
//   </xs:attributeGroup>

trait RuntimePropertiesAGMixin extends PropertyMixin {

  def runtimePropertiesAGInit(): Unit = {
  }
  runtimePropertiesAGInit()
}

////////////////////////////////////////////////////////////////////////
// <xs:attributeGroup name="RuntimePropertiesAGQualified" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:attribute form="qualified" name="runtimeProperties" type="dfdlx:RuntimePropertiesType"/>
//   </xs:attributeGroup>

trait RuntimePropertiesAGQualifiedMixin extends PropertyMixin {

  def runtimePropertiesAGQualifiedInit(): Unit = {
  }
  runtimePropertiesAGQualifiedInit()
}

////////////////////////////////////////////////////////////////////////
// <xs:simpleType name="RuntimePropertiesType" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:restriction base="dfdlx:KVList"/>
//   </xs:simpleType>


trait RuntimePropertiesTypeMixin { /* nothing */ }
object RuntimePropertiesType {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////////////////////////////////////////
// <xs:simpleType name="KVList" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/" xmlns:dfdlx="http://www.ogf.org/dfdl/dfdl-1.0/extensions" xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext" xmlns:dafint="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:int">
//     <xs:list>
//       <xs:simpleType>
//         <xs:restriction base="xs:token">
//           <xs:pattern value="[a-zA-Z_][a-zA-Z0-9_]*=\S*"/>
//         </xs:restriction>
//       </xs:simpleType>
//     </xs:list>
//   </xs:simpleType>


trait KVListMixin { /* nothing */ }
object KVList {
    def apply(s : String, self : ThrowsSDE) = s
}
////////////////////////////////////