/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.schema.annotation.props.gen.TextZonedSignStyle;
import org.apache.daffodil.schema.annotation.props.gen.TextZonedSignStyle$AsciiCARealiaModified$;
import org.apache.daffodil.schema.annotation.props.gen.TextZonedSignStyle$AsciiStandard$;
import org.apache.daffodil.schema.annotation.props.gen.TextZonedSignStyle$AsciiTandemModified$;
import org.apache.daffodil.schema.annotation.props.gen.TextZonedSignStyle$AsciiTranslatedEBCDIC$;
import org.apache.daffodil.util.DecimalUtils$OverpunchLocation$;
import org.apache.daffodil.util.PackedSignCodes;
import scala.Enumeration;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class DecimalUtils$ {
    public static DecimalUtils$ MODULE$;

    static {
        new DecimalUtils$();
    }

    public BigInteger packedToBigInteger(byte[] num, PackedSignCodes signCodes) {
        int numDigits = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(num)).size() * 2;
        char[] outputData = new char[numDigits - 1];
        int outputPos = 0;
        int offset = 0;
        int signNibble = num[offset + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(num)).size() - 1] & 0xF;
        boolean negative = signCodes.negative().contains((Object)BoxesRunTime.boxToInteger((int)signNibble));
        if (!(negative || signCodes.positive().contains((Object)BoxesRunTime.boxToInteger((int)signNibble)) || signCodes.unsigned().contains((Object)BoxesRunTime.boxToInteger((int)signNibble)) || signCodes.zero_sign().contains((Object)BoxesRunTime.boxToInteger((int)signNibble)))) {
            throw new NumberFormatException(new StringBuilder(21).append("Invalid sign nibble: ").append(signNibble).toString());
        }
        while (outputPos < new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(outputData)).size() - 1) {
            int highNibble = (num[offset] & 0xFF) >>> 4;
            if (highNibble > 9) {
                throw new NumberFormatException(new StringBuilder(21).append("Invalid high nibble: ").append(highNibble).toString());
            }
            outputData[outputPos] = (char)(highNibble | 0x30);
            ++outputPos;
            int lowNibble = num[offset] & 0xF;
            if (lowNibble > 9) {
                throw new NumberFormatException(new StringBuilder(20).append("Invalid low nibble: ").append(lowNibble).toString());
            }
            outputData[outputPos] = (char)(lowNibble | 0x30);
            ++outputPos;
            ++offset;
        }
        int lastNibble = (num[offset] & 0xFF) >>> 4;
        if (lastNibble > 9) {
            throw new NumberFormatException(new StringBuilder(21).append("Invalid high nibble: ").append(lastNibble).toString());
        }
        outputData[outputPos] = (char)(lastNibble | 0x30);
        BigInteger jbi = new BigInteger(new String(outputData));
        return negative ? jbi.negate() : jbi;
    }

    public BigDecimal packedToBigDecimal(byte[] num, int scale, PackedSignCodes signCodes) {
        return new BigDecimal(this.packedToBigInteger(num, signCodes), scale);
    }

    public Tuple2<Object, Object> packedFromBigIntegerLength(String absBigIntAsString, int minLengthInBits) {
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(absBigIntAsString), 0) == '-') {
            throw Assert$.MODULE$.abort("Invariant broken: scala.Predef.augmentString(absBigIntAsString).apply(0).!=('-')");
        }
        int numDigits = absBigIntAsString.length();
        int requiredBitLen = numDigits % 2 == 0 ? (numDigits + 2) * 4 : (numDigits + 1) * 4;
        int bitLen = package$.MODULE$.max(minLengthInBits, requiredBitLen);
        int numBytes = bitLen / 8;
        int leadingZeros = numDigits % 2 == 0 ? bitLen / 4 - numDigits - 1 : bitLen / 4 - numDigits;
        return new Tuple2.mcII.sp(numBytes, leadingZeros);
    }

    public byte[] packedFromBigInteger(BigInteger bigInt, int minLengthInBits, PackedSignCodes signCodes) {
        boolean negative = bigInt.signum() != 1;
        String inChars = bigInt.abs().toString();
        int numDigits = inChars.length();
        Tuple2<Object, Object> tuple2 = this.packedFromBigIntegerLength(inChars, minLengthInBits);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numBytes = tuple2._1$mcI$sp();
        int leadingZeros = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(numBytes, leadingZeros);
        Tuple2.mcII.sp sp3 = sp2;
        int numBytes2 = sp3._1$mcI$sp();
        int leadingZeros2 = sp3._2$mcI$sp();
        byte[] outArray = new byte[numBytes2];
        int offset = 0;
        int inPos = 0;
        while (offset * 2 < leadingZeros2 - 1) {
            outArray[offset] = (byte)0;
            ++offset;
        }
        if (numDigits % 2 == 0) {
            outArray[offset] = (byte)(0 + (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF));
            ++inPos;
            ++offset;
        }
        while (inPos < numDigits - 1) {
            int firstNibble = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF) << 4;
            int secondNibble = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos) & 0xF;
            ++inPos;
            outArray[offset] = (byte)(firstNibble + secondNibble);
            ++offset;
        }
        int lastNibble = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF) << 4;
        int signNibble = negative ? BoxesRunTime.unboxToInt((Object)signCodes.negative().apply(0)) & 0xF : BoxesRunTime.unboxToInt((Object)signCodes.positive().apply(0)) & 0xF;
        outArray[offset] = (byte)(lastNibble + signNibble);
        return outArray;
    }

    public BigInteger bcdToBigInteger(byte[] bcdNum) {
        int numDigits = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bcdNum)).size() * 2;
        char[] outputData = new char[numDigits];
        int outputPos = 0;
        for (int offset = 0; offset < new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bcdNum)).size(); ++offset) {
            int highNibble = (bcdNum[offset] & 0xFF) >>> 4;
            if (highNibble > 9) {
                throw new NumberFormatException(new StringBuilder(21).append("Invalid high nibble: ").append(highNibble).toString());
            }
            outputData[outputPos] = (char)(highNibble | 0x30);
            ++outputPos;
            int lowNibble = bcdNum[offset] & 0xF;
            if (lowNibble > 9) {
                throw new NumberFormatException(new StringBuilder(20).append("Invalid low nibble: ").append(lowNibble).toString());
            }
            outputData[outputPos] = (char)(lowNibble | 0x30);
            ++outputPos;
        }
        return new BigInteger(new String(outputData));
    }

    public BigDecimal bcdToBigDecimal(byte[] bcdNum, int scale) {
        return new BigDecimal(this.bcdToBigInteger(bcdNum), scale);
    }

    public Tuple2<Object, Object> bcdFromBigIntegerLength(String absBigIntAsString, int minLengthInBits) {
        int numDigits = absBigIntAsString.length();
        int requiredBitLen = numDigits % 2 == 0 ? numDigits * 4 : (numDigits + 1) * 4;
        int bitLen = package$.MODULE$.max(minLengthInBits, requiredBitLen);
        int numBytes = bitLen / 8;
        int leadingZeros = bitLen / 4 - numDigits;
        return new Tuple2.mcII.sp(numBytes, leadingZeros);
    }

    public byte[] bcdFromBigInteger(BigInteger bigInt, int minLengthInBits) {
        String inChars = bigInt.toString();
        int numDigits = inChars.length();
        Tuple2<Object, Object> tuple2 = this.bcdFromBigIntegerLength(inChars, minLengthInBits);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numBytes = tuple2._1$mcI$sp();
        int leadingZeros = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(numBytes, leadingZeros);
        Tuple2.mcII.sp sp3 = sp2;
        int numBytes2 = sp3._1$mcI$sp();
        int leadingZeros2 = sp3._2$mcI$sp();
        byte[] outArray = new byte[numBytes2];
        int offset = 0;
        int inPos = 0;
        while (offset * 2 < leadingZeros2 - 1) {
            outArray[offset] = (byte)0;
            ++offset;
        }
        if (inChars.length() % 2 != 0) {
            outArray[offset] = (byte)(0 + (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF));
            ++offset;
            ++inPos;
        }
        while (inPos < inChars.length()) {
            int firstNibble = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF) << 4;
            int secondNibble = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos) & 0xF;
            ++inPos;
            outArray[offset] = (byte)(firstNibble + secondNibble);
            ++offset;
        }
        return outArray;
    }

    public BigInteger ibm4690ToBigInteger(byte[] num) {
        int numDigits = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(num)).size() * 2;
        char[] outputData = new char[numDigits];
        int outputPos = 0;
        boolean negative = false;
        boolean inDigits = false;
        for (int offset = 0; offset < new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(num)).size(); ++offset) {
            int lowNibble;
            int highNibble = (num[offset] & 0xFF) >>> 4;
            if (highNibble > 9) {
                outputData[outputPos] = 48;
                if (highNibble == 13 && !inDigits) {
                    negative = true;
                    inDigits = true;
                } else if (highNibble != 15 || inDigits) {
                    throw new NumberFormatException(new StringBuilder(21).append("Invalid high nibble: ").append(highNibble).toString());
                }
                ++outputPos;
            }
            if (highNibble <= 9) {
                inDigits = true;
                outputData[outputPos] = (char)(highNibble | 0x30);
                ++outputPos;
            }
            if ((lowNibble = num[offset] & 0xF) > 9) {
                outputData[outputPos] = 48;
                ++outputPos;
                if (lowNibble == 13 && !inDigits) {
                    negative = true;
                    inDigits = true;
                } else if (lowNibble != 15 || inDigits) {
                    throw new NumberFormatException(new StringBuilder(20).append("Invalid low nibble: ").append(lowNibble).toString());
                }
            }
            if (lowNibble > 9) continue;
            inDigits = true;
            outputData[outputPos] = (char)(lowNibble | 0x30);
            ++outputPos;
        }
        BigInteger jbi = new BigInteger(new String(outputData));
        return negative ? jbi.negate() : jbi;
    }

    public BigDecimal ibm4690ToBigDecimal(byte[] num, int scale) {
        return new BigDecimal(this.ibm4690ToBigInteger(num), scale);
    }

    public Tuple2<Object, Object> ibm4690FromBigIntegerLength(String absBigIntAsString, int minLengthInBits, boolean negative) {
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(absBigIntAsString), 0) == '-') {
            throw Assert$.MODULE$.abort("Invariant broken: scala.Predef.augmentString(absBigIntAsString).apply(0).!=('-')");
        }
        int numDigits = negative ? absBigIntAsString.length() + 1 : absBigIntAsString.length();
        int requiredBitLen = numDigits % 2 == 0 ? numDigits * 4 : (numDigits + 1) * 4;
        int bitLen = package$.MODULE$.max(minLengthInBits, requiredBitLen);
        int numBytes = bitLen / 8;
        int leadingZeros = numDigits % 2 == 0 ? bitLen / 4 - numDigits : bitLen / 4 - (numDigits + 1);
        return new Tuple2.mcII.sp(numBytes, leadingZeros);
    }

    public byte[] ibm4690FromBigInteger(BigInteger bigInt, int minLengthInBits) {
        boolean negative = bigInt.signum() != 1;
        String inChars = bigInt.abs().toString();
        int numDigits = negative ? inChars.length() + 1 : inChars.length();
        Tuple2<Object, Object> tuple2 = this.ibm4690FromBigIntegerLength(inChars, minLengthInBits, negative);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numBytes = tuple2._1$mcI$sp();
        int leadingZeros = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(numBytes, leadingZeros);
        Tuple2.mcII.sp sp3 = sp2;
        int numBytes2 = sp3._1$mcI$sp();
        int leadingZeros2 = sp3._2$mcI$sp();
        byte[] outArray = new byte[numBytes2];
        boolean wrote_negative = false;
        int offset = 0;
        int inPos = 0;
        while (offset * 2 < leadingZeros2 - 1) {
            outArray[offset] = (byte)255;
            ++offset;
        }
        if (numDigits % 2 != 0) {
            int n;
            int padNibble = 240;
            if (negative) {
                wrote_negative = true;
                n = 13;
            } else {
                n = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos - 1) & 0xF;
            }
            int signNibble = n;
            outArray[offset] = (byte)(padNibble + signNibble);
            ++offset;
        }
        while (inPos < numDigits - 1) {
            int n;
            if (negative && !wrote_negative) {
                wrote_negative = true;
                n = 208;
            } else {
                n = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos - 1) & 0xF) << 4;
            }
            int firstNibble = n;
            int secondNibble = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF;
            ++inPos;
            outArray[offset] = (byte)(firstNibble + secondNibble);
            ++offset;
        }
        return outArray;
    }

    public Tuple2<Object, Object> convertFromAsciiStandard(char digit) {
        Tuple2.mcIZ.sp sp2;
        if (digit >= '0' && digit <= '9') {
            sp2 = new Tuple2.mcIZ.sp(digit - 48, false);
        } else if (digit >= 'p' && digit <= 'y') {
            sp2 = new Tuple2.mcIZ.sp(digit - 112, true);
        } else {
            throw new NumberFormatException(new StringBuilder(21).append("Invalid zoned digit: ").append(digit).toString());
        }
        return sp2;
    }

    public char convertToAsciiStandard(char digit, boolean positive) {
        return positive ? digit : (char)(digit + 64);
    }

    public Tuple2<Object, Object> convertFromAsciiTranslatedEBCDIC(char digit) {
        Tuple2.mcIZ.sp sp2;
        if (digit == '{') {
            sp2 = new Tuple2.mcIZ.sp(0, false);
        } else if (digit == '}') {
            sp2 = new Tuple2.mcIZ.sp(0, true);
        } else if (digit >= 'A' && digit <= 'I') {
            sp2 = new Tuple2.mcIZ.sp(digit - 64, false);
        } else if (digit >= 'J' && digit <= 'R') {
            sp2 = new Tuple2.mcIZ.sp(digit - 73, true);
        } else if (digit >= '0' && digit <= '9') {
            sp2 = new Tuple2.mcIZ.sp(digit - 48, false);
        } else {
            throw new NumberFormatException(new StringBuilder(21).append("Invalid zoned digit: ").append(digit).toString());
        }
        return sp2;
    }

    public char convertToAsciiTranslatedEBCDIC(char digit, boolean positive) {
        return positive ? (digit == '0' ? (char)'{' : (char)(digit + 16)) : (digit == '0' ? (char)'}' : (char)(digit + 25));
    }

    public Tuple2<Object, Object> convertFromAsciiCARealiaModified(char digit) {
        Tuple2.mcIZ.sp sp2;
        if (digit >= '0' && digit <= '9') {
            sp2 = new Tuple2.mcIZ.sp(digit - 48, false);
        } else if (digit >= ' ' && digit <= ')') {
            sp2 = new Tuple2.mcIZ.sp(digit - 32, true);
        } else {
            throw new NumberFormatException(new StringBuilder(21).append("Invalid zoned digit: ").append(digit).toString());
        }
        return sp2;
    }

    public char convertToAsciiCARealiaModified(char digit, boolean positive) {
        return positive ? digit : (char)(digit - 16);
    }

    public Tuple2<Object, Object> convertFromAsciiTandemModified(char digit) {
        Tuple2.mcIZ.sp sp2;
        if (digit >= '0' && digit <= '9') {
            sp2 = new Tuple2.mcIZ.sp(digit - 48, false);
        } else if (digit >= '\u0080' && digit <= '\u0089') {
            sp2 = new Tuple2.mcIZ.sp(digit - 128, true);
        } else {
            throw new NumberFormatException(new StringBuilder(21).append("Invalid zoned digit: ").append(digit).toString());
        }
        return sp2;
    }

    public char convertToAsciiTandemModified(char digit, boolean positive) {
        return positive ? digit : (char)(digit + 80);
    }

    /*
     * Unable to fully structure code
     */
    public String zonedToNumber(String num, TextZonedSignStyle zonedStyle, Enumeration.Value opl) {
        block14: {
            block16: {
                block18: {
                    block17: {
                        block15: {
                            block13: {
                                var9_4 = opl;
                                v0 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
                                var10_5 = var9_4;
                                if (!(v0 != null ? v0.equals(var10_5) == false : var10_5 != null)) {
                                    var7_6 = 0;
                                } else {
                                    v1 = DecimalUtils$OverpunchLocation$.MODULE$.End();
                                    var11_7 = var9_4;
                                    var7_6 = !(v1 != null ? v1.equals(var11_7) == false : var11_7 != null) ? num.length() - 1 : -1;
                                }
                                opindex = var7_6;
                                v2 = opl;
                                var13_9 = DecimalUtils$OverpunchLocation$.MODULE$.None();
                                if (v2 != null ? v2.equals(var13_9) == false : var13_9 != null) break block13;
                                v3 = num;
                                break block14;
                            }
                            var16_10 = zonedStyle;
                            if (TextZonedSignStyle$AsciiStandard$.MODULE$.equals(var16_10)) {
                                var6_11 = this.convertFromAsciiStandard(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
                            } else if (TextZonedSignStyle$AsciiTranslatedEBCDIC$.MODULE$.equals(var16_10)) {
                                var6_11 = this.convertFromAsciiTranslatedEBCDIC(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
                            } else if (TextZonedSignStyle$AsciiCARealiaModified$.MODULE$.equals(var16_10)) {
                                var6_11 = this.convertFromAsciiCARealiaModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
                            } else if (TextZonedSignStyle$AsciiTandemModified$.MODULE$.equals(var16_10)) {
                                var6_11 = this.convertFromAsciiTandemModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
                            } else {
                                throw new MatchError((Object)var16_10);
                            }
                            var15_12 = var6_11;
                            if (var15_12 == null) {
                                throw new MatchError(var15_12);
                            }
                            digit = var15_12._1$mcI$sp();
                            opneg = var15_12._2$mcZ$sp();
                            var5_15 = new Tuple2.mcIZ.sp(digit, opneg);
                            var14_16 = var5_15;
                            digit = var14_16._1$mcI$sp();
                            opneg = var14_16._2$mcZ$sp();
                            var22_19 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)opneg), (Object)opl);
                            if (var22_19 == null) break block15;
                            var23_20 = var22_19._1$mcZ$sp();
                            var24_21 = (Enumeration.Value)var22_19._2();
                            if (!var23_20) break block15;
                            v4 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
                            var25_22 = var24_21;
                            if (v4 != null ? v4.equals(var25_22) == false : var25_22 != null) break block15;
                            var4_23 = new StringBuilder(1).append("-").append(digit).append(num.substring(1)).toString();
                            break block16;
                        }
                        if (var22_19 == null) break block17;
                        var26_24 = var22_19._1$mcZ$sp();
                        var27_25 = (Enumeration.Value)var22_19._2();
                        if (var26_24) break block17;
                        v5 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
                        var28_26 = var27_25;
                        if (v5 != null ? v5.equals(var28_26) == false : var28_26 != null) break block17;
                        var4_23 = new StringBuilder(0).append(digit).append(num.substring(1)).toString();
                        break block16;
                    }
                    if (var22_19 == null) break block18;
                    var29_27 = var22_19._1$mcZ$sp();
                    var30_28 = (Enumeration.Value)var22_19._2();
                    if (!var29_27) break block18;
                    v6 = DecimalUtils$OverpunchLocation$.MODULE$.End();
                    var31_29 = var30_28;
                    if (v6 != null ? v6.equals(var31_29) == false : var31_29 != null) break block18;
                    var4_23 = new StringBuilder(1).append("-").append(num.substring(0, opindex)).append(digit).toString();
                    break block16;
                }
                if (var22_19 == null) ** GOTO lbl-1000
                var32_30 = var22_19._1$mcZ$sp();
                var33_31 = (Enumeration.Value)var22_19._2();
                if (var32_30) ** GOTO lbl-1000
                v7 = DecimalUtils$OverpunchLocation$.MODULE$.End();
                var34_32 = var33_31;
                if (!(v7 != null ? v7.equals(var34_32) == false : var34_32 != null)) {
                    var4_23 = new StringBuilder(0).append(num.substring(0, opindex)).append(digit).toString();
                } else lbl-1000:
                // 3 sources

                {
                    throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                }
            }
            v3 = convertedNum = var4_23;
        }
        decodedValue = v3;
        return decodedValue;
    }

    public String zonedFromNumber(String num, TextZonedSignStyle zonedStyle, Enumeration.Value opl) {
        String string;
        int n;
        String string2;
        boolean positive = num.charAt(0) != '-';
        boolean bl = positive;
        if (bl) {
            string2 = num;
        } else if (!bl) {
            string2 = num.substring(1);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        String inStr = string2;
        Enumeration.Value value = opl;
        Enumeration.Value value2 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = 0;
        } else {
            Enumeration.Value value4 = DecimalUtils$OverpunchLocation$.MODULE$.End();
            Enumeration.Value value5 = value;
            n = !(value4 != null ? !value4.equals(value5) : value5 != null) ? inStr.length() - 1 : -1;
        }
        int opindex = n;
        Enumeration.Value value6 = opl;
        Enumeration.Value value7 = DecimalUtils$OverpunchLocation$.MODULE$.None();
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            if (!positive) {
                throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
            }
            string = inStr;
        } else {
            String convertedNum;
            String string3;
            char c;
            TextZonedSignStyle textZonedSignStyle = zonedStyle;
            if (TextZonedSignStyle$AsciiStandard$.MODULE$.equals(textZonedSignStyle)) {
                c = this.convertToAsciiStandard(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
            } else if (TextZonedSignStyle$AsciiTranslatedEBCDIC$.MODULE$.equals(textZonedSignStyle)) {
                c = this.convertToAsciiTranslatedEBCDIC(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
            } else if (TextZonedSignStyle$AsciiCARealiaModified$.MODULE$.equals(textZonedSignStyle)) {
                c = this.convertToAsciiCARealiaModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
            } else if (TextZonedSignStyle$AsciiTandemModified$.MODULE$.equals(textZonedSignStyle)) {
                c = this.convertToAsciiTandemModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
            } else {
                throw new MatchError((Object)textZonedSignStyle);
            }
            char digit = c;
            Enumeration.Value value8 = opl;
            Enumeration.Value value9 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
            Enumeration.Value value10 = value8;
            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                string3 = new StringBuilder(0).append(digit).append(inStr.substring(1)).toString();
            } else {
                Enumeration.Value value11 = DecimalUtils$OverpunchLocation$.MODULE$.End();
                Enumeration.Value value12 = value8;
                if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                    string3 = new StringBuilder(0).append(inStr.substring(0, opindex)).append(digit).toString();
                } else {
                    throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                }
            }
            string = convertedNum = string3;
        }
        String encodedValue = string;
        return encodedValue;
    }

    private DecimalUtils$() {
        MODULE$ = this;
    }
}

