/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.calendar;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import org.apache.daffodil.calendar.DFDLCalendar;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class DFDLCalendarConversion$ {
    public static DFDLCalendarConversion$ MODULE$;

    static {
        new DFDLCalendarConversion$();
    }

    private String pad2(int i) {
        String istr = Integer.toString(i);
        if (i >= 10) {
            return istr;
        }
        return new StringBuilder(1).append("0").append(istr).toString();
    }

    private String pad3(int i) {
        String istr = Integer.toString(i);
        if (i >= 100) {
            return istr;
        }
        if (i >= 10) {
            return new StringBuilder(1).append("0").append(istr).toString();
        }
        return new StringBuilder(2).append("00").append(istr).toString();
    }

    private String pad4(int i) {
        String istr = Integer.toString(i);
        if (i >= 1000) {
            return istr;
        }
        if (i >= 100) {
            return new StringBuilder(1).append("0").append(istr).toString();
        }
        if (i >= 10) {
            return new StringBuilder(2).append("00").append(istr).toString();
        }
        return new StringBuilder(3).append("000").append(istr).toString();
    }

    public String datePartToXMLString(DFDLCalendar dfdlcal) {
        Calendar calendar = dfdlcal.calendar();
        int y = calendar.get(19);
        int m = calendar.get(2) + 1;
        int d = calendar.get(5);
        String ysign = y >= 0 ? "" : "-";
        return new StringBuilder(2).append(ysign).append(this.pad4(Math.abs(y))).append("-").append(this.pad2(m)).append("-").append(this.pad2(d)).toString();
    }

    public String datePartFromXMLString(String string, Calendar calendar) {
        int endYear;
        if (string.length() == 0) {
            throw DFDLCalendarConversion$.invalidValue$1(string);
        }
        int n = endYear = string.charAt(0) == '-' ? string.indexOf(45, 1) : string.indexOf(45);
        if (endYear == -1) {
            throw DFDLCalendarConversion$.invalidValue$1(string);
        }
        if (string.length() < endYear + 6) {
            throw DFDLCalendarConversion$.invalidValue$1(string);
        }
        if (string.charAt(endYear + 3) != '-') {
            throw DFDLCalendarConversion$.invalidValue$1(string);
        }
        String y = string.substring(0, endYear);
        String m = string.substring(endYear + 1, endYear + 3);
        String d = string.substring(endYear + 4, endYear + 6);
        try {
            calendar.set(19, Integer.parseInt(y));
            calendar.set(2, Integer.parseInt(m) - 1);
            calendar.set(5, Integer.parseInt(d));
        }
        catch (NumberFormatException numberFormatException) {
            throw DFDLCalendarConversion$.invalidValue$1(string);
        }
        return string.substring(endYear + 6);
    }

    public String timePartToXMLString(DFDLCalendar dfdlcal) {
        Calendar calendar = dfdlcal.calendar();
        int h = calendar.get(11);
        int m = calendar.get(12);
        int s = calendar.get(13);
        int u = calendar.get(14);
        return new StringBuilder(2).append(this.pad2(h)).append(":").append(this.pad2(m)).append(":").append(this.pad2(s)).append((Object)(u != 0 ? new StringBuilder(4).append(".").append(this.pad3(u)).append("000").toString() : "")).toString();
    }

    public String timePartFromXMLString(String string, Calendar calendar) {
        Tuple2 tuple2;
        int tzStart;
        if (string.length() < 8) {
            throw DFDLCalendarConversion$.invalidValue$2(string);
        }
        if (string.charAt(2) != ':') {
            throw DFDLCalendarConversion$.invalidValue$2(string);
        }
        if (string.charAt(5) != ':') {
            throw DFDLCalendarConversion$.invalidValue$2(string);
        }
        String h = string.substring(0, 2);
        String m = string.substring(3, 5);
        String s = string.substring(6, 8);
        Tuple2 tuple22 = string.length() > 8 ? (string.charAt(8) != '.' ? new Tuple2((Object)"0", (Object)BoxesRunTime.boxToInteger((int)8)) : ((tzStart = new StringOps(Predef$.MODULE$.augmentString(string)).indexWhere((Function1 & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DFDLCalendarConversion$.$anonfun$timePartFromXMLString$1(BoxesRunTime.unboxToChar((Object)c))), 9)) == -1 ? new Tuple2((Object)string.substring(9), (Object)BoxesRunTime.boxToInteger((int)string.length())) : new Tuple2((Object)string.substring(9, tzStart), (Object)BoxesRunTime.boxToInteger((int)tzStart)))) : (tuple2 = new Tuple2((Object)"0", (Object)BoxesRunTime.boxToInteger((int)8)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String ms = (String)tuple2._1();
        int endTime = tuple2._2$mcI$sp();
        Tuple2 tuple23 = new Tuple2((Object)ms, (Object)BoxesRunTime.boxToInteger((int)endTime));
        String ms2 = (String)tuple23._1();
        int endTime2 = tuple23._2$mcI$sp();
        try {
            calendar.set(11, Integer.parseInt(h));
            calendar.set(12, Integer.parseInt(m));
            calendar.set(13, Integer.parseInt(s));
            int msDigits = Math.min(ms2.length(), 3);
            int msUnscaled = Integer.parseInt(ms2.substring(0, msDigits));
            int msScaled = msDigits == 1 ? msUnscaled * 100 : (msDigits == 2 ? msUnscaled * 10 : msUnscaled);
            calendar.set(14, msScaled);
        }
        catch (NumberFormatException numberFormatException) {
            throw DFDLCalendarConversion$.invalidValue$2(string);
        }
        return string.substring(endTime2);
    }

    public String timeZonePartToXMLString(DFDLCalendar dfdlcal) {
        if (!dfdlcal.hasTimeZone()) {
            return "";
        }
        TimeZone tz = dfdlcal.calendar().getTimeZone();
        int offsetInMils = tz.getRawOffset();
        int offsetInMins = Math.abs(offsetInMils / 60000);
        int h = offsetInMins / 60;
        int m = offsetInMins % 60;
        String s = offsetInMils >= 0 ? "+" : "-";
        return new StringBuilder(1).append(s).append(this.pad2(h)).append(":").append(this.pad2(m)).toString();
    }

    public String timeZonePartFromXMLString(String string, Calendar calendar) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        String string2 = string;
        String string3 = "";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return string;
        }
        char firstChar = string.charAt(0);
        if (firstChar == 'Z') {
            tuple22 = new Tuple2((Object)TimeZone.GMT_ZONE, (Object)BoxesRunTime.boxToInteger((int)1));
        } else {
            String string4;
            int n;
            if (firstChar == '+') {
                n = 1;
            } else if (firstChar == '-') {
                n = -1;
            } else {
                throw DFDLCalendarConversion$.invalidValue$3(string);
            }
            int sign = n;
            if (string.length() < 6) {
                throw DFDLCalendarConversion$.invalidValue$3(string);
            }
            if (string.charAt(3) != ':') {
                throw DFDLCalendarConversion$.invalidValue$3(string);
            }
            String h = string.substring(1, 3);
            String m = string.substring(4, 6);
            if (string.length() > 6) {
                if (string.charAt(6) != ':') {
                    throw DFDLCalendarConversion$.invalidValue$3(string);
                }
                string4 = string.substring(7, 9);
            } else {
                string4 = "00";
            }
            String s = string4;
            int offsetInMillis = DFDLCalendarConversion$.liftedTree1$1(h, m, s, sign, string);
            TimeZone tz = offsetInMillis == 0 ? TimeZone.GMT_ZONE : new SimpleTimeZone(offsetInMillis, string);
            int consumed = string.length() > 6 ? 9 : 6;
            tuple22 = tuple2 = new Tuple2((Object)tz, (Object)BoxesRunTime.boxToInteger((int)consumed));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TimeZone timezone = (TimeZone)tuple2._1();
        int endTimeZone = tuple2._2$mcI$sp();
        Tuple2 tuple23 = new Tuple2((Object)timezone, (Object)BoxesRunTime.boxToInteger((int)endTimeZone));
        TimeZone timezone2 = (TimeZone)tuple23._1();
        int endTimeZone2 = tuple23._2$mcI$sp();
        calendar.setTimeZone(timezone2);
        return string.substring(endTimeZone2);
    }

    private static final Nothing$ invalidValue$1(String string$1) {
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid date string: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string$1})));
    }

    private static final Nothing$ invalidValue$2(String string$2) {
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid time string: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string$2})));
    }

    public static final /* synthetic */ boolean $anonfun$timePartFromXMLString$1(char c) {
        return c == '-' || c == '+' || c == 'Z';
    }

    private static final Nothing$ invalidValue$3(String string$3) {
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid time zone string: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string$3})));
    }

    private static final /* synthetic */ int liftedTree1$1(String h$1, String m$1, String s$1, int sign$1, String string$3) {
        int n;
        try {
            int hi = Integer.parseInt(h$1);
            int mi = Integer.parseInt(m$1);
            int si = Integer.parseInt(s$1);
            if (hi < 0 || hi >= 24) {
                throw DFDLCalendarConversion$.invalidValue$3(string$3);
            }
            if (mi < 0 || mi >= 60) {
                throw DFDLCalendarConversion$.invalidValue$3(string$3);
            }
            if (si < 0 || si >= 60) {
                throw DFDLCalendarConversion$.invalidValue$3(string$3);
            }
            n = sign$1 * (hi * 60 * 60 + mi * 60 + si) * 1000;
        }
        catch (NumberFormatException numberFormatException) {
            throw DFDLCalendarConversion$.invalidValue$3(string$3);
        }
        return n;
    }

    private DFDLCalendarConversion$() {
        MODULE$ = this;
    }
}

