/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.externalvars;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.exceptions.ThrowsSDE;
import org.apache.daffodil.externalvars.Binding;
import org.apache.daffodil.externalvars.Binding$;
import org.apache.daffodil.externalvars.ExternalVariablesValidator$;
import org.apache.daffodil.processors.VariableMap;
import org.apache.daffodil.processors.VariableUtils$;
import org.apache.daffodil.util.Misc$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.xml.Node;
import scala.xml.parsing.ConstructingParser$;

public final class ExternalVariablesLoader$ {
    public static ExternalVariablesLoader$ MODULE$;

    static {
        new ExternalVariablesLoader$();
    }

    public VariableMap loadVariables(Seq<Binding> bindings, ThrowsSDE referringContext, VariableMap vmap) {
        if (referringContext == null) {
            throw Assert$.MODULE$.abort2("Usage error: loadVariables expects 'referringContext' to not be null!", "referringContext.!=(null)");
        }
        VariableMap finalVMap = VariableUtils$.MODULE$.setExternalVariables(vmap, bindings, referringContext);
        return finalVMap;
    }

    public Queue<Binding> mapToBindings(Map<String, String> vars) {
        Iterable varsKVP = (Iterable)vars.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            Binding binding = Binding$.MODULE$.apply(name, value);
            return binding;
        }, Iterable$.MODULE$.canBuildFrom());
        return Queue$.MODULE$.empty().enqueue(varsKVP);
    }

    public Queue<Binding> uriToBindings(URI uri) {
        if (uri == null) {
            throw Assert$.MODULE$.abort("Usage error: uri.ne(null)");
        }
        File file = new File(uri);
        return this.fileToBindings(file);
    }

    public Queue<Binding> fileToBindings(File file) {
        if (file == null) {
            throw Assert$.MODULE$.abort("Usage error: file.ne(null)");
        }
        Either either = ExternalVariablesValidator$.MODULE$.validate(file);
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable ex = (Throwable)left.value();
            throw Assert$.MODULE$.abort(ex);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        String enc = Misc$.MODULE$.determineEncoding(file);
        BufferedSource input = Source$.MODULE$.fromURI(file.toURI(), Codec$.MODULE$.string2codec(enc));
        Node node = ConstructingParser$.MODULE$.fromSource((Source)input, true).document().docElem();
        return this.nodeToBindings(node);
    }

    public Queue<Binding> nodeToBindings(Node node) {
        if (node == null) {
            throw Assert$.MODULE$.abort("Usage error: node.ne(null)");
        }
        Seq newBindings = Binding$.MODULE$.getBindings(node);
        ObjectRef res = ObjectRef.create((Object)Queue$.MODULE$.empty());
        newBindings.foreach((Function1 & Serializable & scala.Serializable)b -> {
            res.elem = ((Queue)res.elem).enqueue((Object)b);
            return BoxedUnit.UNIT;
        });
        return (Queue)res.elem;
    }

    private ExternalVariablesLoader$() {
        MODULE$ = this;
    }
}

