/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors;

import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.processors.Suspension;
import org.apache.daffodil.processors.SuspensionDeadlockException;
import org.apache.daffodil.util.LogLevel;
import org.apache.daffodil.util.LogWriter;
import org.apache.daffodil.util.Logging;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4AAF\f\u0001A!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u0003/\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u001dA\u0004A1A\u0005\neBa!\u0012\u0001!\u0002\u0013Q\u0004b\u0002$\u0001\u0005\u0004%I!\u000f\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002\u001e\t\u000b!\u0003A\u0011A%\t\u000fY\u0003\u0001\u0019!C\u0005/\"9\u0001\f\u0001a\u0001\n\u0013I\u0006BB0\u0001A\u0003&a\u0006C\u0004a\u0001\u0001\u0007I\u0011B,\t\u000f\u0005\u0004\u0001\u0019!C\u0005E\"1A\r\u0001Q!\n9Bq!\u001a\u0001A\u0002\u0013%q\u000bC\u0004g\u0001\u0001\u0007I\u0011B4\t\r%\u0004\u0001\u0015)\u0003/\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015\u0001\b\u0001\"\u0001p\u0011\u0015\t\b\u0001\"\u0003s\u0005E\u0019Vo\u001d9f]NLwN\u001c+sC\u000e\\WM\u001d\u0006\u00031e\t!\u0002\u001d:pG\u0016\u001c8o\u001c:t\u0015\tQ2$\u0001\u0005eC\u001a4w\u000eZ5m\u0015\taR$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tA3&D\u0001*\u0015\tQ\u0013$\u0001\u0003vi&d\u0017B\u0001\u0017*\u0005\u001daunZ4j]\u001e\f1c];ta\u0016t7/[8o/\u0006LG/W8v]\u001e\u0004\"AI\u0018\n\u0005A\u001a#aA%oi\u0006\t2/^:qK:\u001c\u0018n\u001c8XC&$x\n\u001c3\u0002\rqJg.\u001b;?)\r!dg\u000e\t\u0003k\u0001i\u0011a\u0006\u0005\u0006[\r\u0001\rA\f\u0005\u0006c\r\u0001\rAL\u0001\u0011gV\u001c\b/\u001a8tS>t7/W8v]\u001e,\u0012A\u000f\t\u0004w\u0001\u0013U\"\u0001\u001f\u000b\u0005ur\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003\u007f\r\n!bY8mY\u0016\u001cG/[8o\u0013\t\tEHA\u0003Rk\u0016,X\r\u0005\u00026\u0007&\u0011Ai\u0006\u0002\u000b'V\u001c\b/\u001a8tS>t\u0017!E:vgB,gn]5p]NLv.\u001e8hA\u0005q1/^:qK:\u001c\u0018n\u001c8t\u001f2$\u0017aD:vgB,gn]5p]N|E\u000e\u001a\u0011\u0002\u0017M,8\u000f]3og&|gn]\u000b\u0002\u0015B\u00191j\u0015\"\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA( \u0003\u0019a$o\\8u}%\tA%\u0003\u0002SG\u00059\u0001/Y2lC\u001e,\u0017B\u0001+V\u0005\r\u0019V-\u001d\u0006\u0003%\u000e\nQaY8v]R,\u0012AL\u0001\nG>,h\u000e^0%KF$\"AW/\u0011\u0005\tZ\u0016B\u0001/$\u0005\u0011)f.\u001b;\t\u000fyS\u0011\u0011!a\u0001]\u0005\u0019\u0001\u0010J\u0019\u0002\r\r|WO\u001c;!\u0003U\u0019Xo\u001d9f]NLwN\\*uCR$&/Y2lK\u0012\f\u0011d];ta\u0016t7/[8o'R\fG\u000f\u0016:bG.,Gm\u0018\u0013fcR\u0011!l\u0019\u0005\b=6\t\t\u00111\u0001/\u0003Y\u0019Xo\u001d9f]NLwN\\*uCR$&/Y2lK\u0012\u0004\u0013AE:vgB,gn]5p]N#\u0018\r\u001e*v]N\fac];ta\u0016t7/[8o'R\fGOU;og~#S-\u001d\u000b\u00035\"DqA\u0018\t\u0002\u0002\u0003\u0007a&A\ntkN\u0004XM\\:j_:\u001cF/\u0019;Sk:\u001c\b%A\bue\u0006\u001c7nU;ta\u0016t7/[8o)\tQF\u000eC\u0003n%\u0001\u0007!)A\u0001t\u0003=)g/\u00197TkN\u0004XM\\:j_:\u001cH#\u0001.\u0002\u0019I,\u0017/^5sK\u001aKg.\u00197\u0002'\u00154\u0018\r\\*vgB,gn]5p]F+X-^3\u0015\u0005i\u001b\b\"\u0002;\u0016\u0001\u0004Q\u0014!B9vKV,\u0007")
public class SuspensionTracker
implements Logging {
    private final int suspensionWaitYoung;
    private final int suspensionWaitOld;
    private final Queue<Suspension> suspensionsYoung;
    private final Queue<Suspension> suspensionsOld;
    private int count;
    private int suspensionStatTracked;
    private int suspensionStatRuns;
    private String logID;
    private Object logWriter;
    private Object logLevel;
    private volatile boolean bitmap$0;

    public void setLoggingLevel(LogLevel.Type level) {
        Logging.setLoggingLevel$((Logging)this, (LogLevel.Type)level);
    }

    public final LogLevel.Type getLoggingLevel() {
        return Logging.getLoggingLevel$((Logging)this);
    }

    public void setLogWriter(LogWriter lw) {
        Logging.setLogWriter$((Logging)this, (LogWriter)lw);
    }

    public LogWriter getLogWriter() {
        return Logging.getLogWriter$((Logging)this);
    }

    public final boolean areLogging(LogLevel.Type lvl) {
        return Logging.areLogging$((Logging)this, (LogLevel.Type)lvl);
    }

    public void doLogging(LogLevel.Type lvl, String msg, Seq<Object> args) {
        Logging.doLogging$((Logging)this, (LogLevel.Type)lvl, (String)msg, args);
    }

    public <S> LogLevel.Type withLoggingLevel$default$1() {
        return Logging.withLoggingLevel$default$1$((Logging)this);
    }

    private String logID$lzycompute() {
        SuspensionTracker suspensionTracker = this;
        synchronized (suspensionTracker) {
            if (!this.bitmap$0) {
                this.logID = Logging.logID$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logID;
    }

    public String logID() {
        return !this.bitmap$0 ? this.logID$lzycompute() : this.logID;
    }

    public Object logWriter() {
        return this.logWriter;
    }

    public void logWriter_$eq(Object x$1) {
        this.logWriter = x$1;
    }

    public Object logLevel() {
        return this.logLevel;
    }

    public void logLevel_$eq(Object x$1) {
        this.logLevel = x$1;
    }

    private Queue<Suspension> suspensionsYoung() {
        return this.suspensionsYoung;
    }

    private Queue<Suspension> suspensionsOld() {
        return this.suspensionsOld;
    }

    public Seq<Suspension> suspensions() {
        return (Seq)this.suspensionsYoung().toSeq().$plus$plus((GenTraversableOnce)this.suspensionsOld().toSeq(), Seq$.MODULE$.canBuildFrom());
    }

    private int count() {
        return this.count;
    }

    private void count_$eq(int x$1) {
        this.count = x$1;
    }

    private int suspensionStatTracked() {
        return this.suspensionStatTracked;
    }

    private void suspensionStatTracked_$eq(int x$1) {
        this.suspensionStatTracked = x$1;
    }

    private int suspensionStatRuns() {
        return this.suspensionStatRuns;
    }

    private void suspensionStatRuns_$eq(int x$1) {
        this.suspensionStatRuns = x$1;
    }

    public void trackSuspension(Suspension s) {
        this.suspensionsYoung().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{s}));
        this.suspensionStatTracked_$eq(this.suspensionStatTracked() + 1);
    }

    public void evalSuspensions() {
        if (this.count() % this.suspensionWaitOld == 0) {
            this.evalSuspensionQueue(this.suspensionsOld());
        }
        if (this.count() % this.suspensionWaitYoung == 0) {
            this.evalSuspensionQueue(this.suspensionsYoung());
            while (this.suspensionsYoung().nonEmpty()) {
                this.suspensionsOld().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{(Suspension)this.suspensionsYoung().dequeue()}));
            }
        }
        if (this.count() == this.suspensionWaitOld) {
            this.count_$eq(0);
        } else {
            this.count_$eq(this.count() + 1);
        }
    }

    public void requireFinal() {
        BoxedUnit boxedUnit;
        while (this.suspensionsYoung().nonEmpty()) {
            this.suspensionsOld().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{(Suspension)this.suspensionsYoung().dequeue()}));
        }
        this.evalSuspensionQueue(this.suspensionsOld());
        if (this.suspensionsOld().length() == 1) {
            throw Assert$.MODULE$.abort(new StringBuilder(74).append("Invariant broken. ").append("Single suspended expression making no forward progress. ").append(this.suspensionsOld().apply(0)).toString());
        }
        if (this.suspensionsOld().nonEmpty()) {
            throw new SuspensionDeadlockException((Seq<Suspension>)this.suspensionsOld().seq());
        }
        LogLevel.Debug$ fresh$macro$1 = LogLevel.Debug$.MODULE$;
        int fresh$macro$2 = fresh$macro$1.lvl();
        if (this.getLoggingLevel().lvl() >= fresh$macro$2) {
            this.doLogging((LogLevel.Type)fresh$macro$1, "Suspension runs/tracked: %d/%d (%.2f%%)", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.suspensionStatRuns()), BoxesRunTime.boxToInteger((int)this.suspensionStatTracked()), BoxesRunTime.boxToFloat((float)((float)this.suspensionStatRuns() / (float)this.suspensionStatTracked() * (float)100))}))));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void evalSuspensionQueue(Queue<Suspension> queue) {
        int countOfNotMakingProgress = 0;
        while (!queue.isEmpty() && countOfNotMakingProgress < queue.length()) {
            Suspension s = (Suspension)queue.dequeue();
            this.suspensionStatRuns_$eq(this.suspensionStatRuns() + 1);
            s.runSuspension();
            if (!s.isDone()) {
                queue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{s}));
            }
            if (s.isDone() || s.isMakingProgress()) {
                countOfNotMakingProgress = 0;
                continue;
            }
            ++countOfNotMakingProgress;
        }
    }

    public SuspensionTracker(int suspensionWaitYoung, int suspensionWaitOld) {
        this.suspensionWaitYoung = suspensionWaitYoung;
        this.suspensionWaitOld = suspensionWaitOld;
        Logging.$init$((Logging)this);
        this.suspensionsYoung = new Queue();
        this.suspensionsOld = new Queue();
        this.count = 0;
        this.suspensionStatTracked = 0;
        this.suspensionStatRuns = 0;
    }
}

