/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.layers;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.layers.ChecksumLayerBase;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Q3A!\u0004\b\u00013!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003\u001b\u0011\u0015A\u0003\u0001\"\u0001*\u0011!i\u0003\u0001#b\u0001\n\u0013q\u0003b\u0002\u001a\u0001\u0001\u0004%Ia\r\u0005\bu\u0001\u0001\r\u0011\"\u0003<\u0011\u0019\t\u0005\u0001)Q\u0005i!)!\t\u0001C!\u0007\"9\u0011\n\u0001a\u0001\n\u0013Q\u0005b\u0002(\u0001\u0001\u0004%Ia\u0014\u0005\u0007#\u0002\u0001\u000b\u0015B&\t\u000bI\u0003A\u0011I*\u00037\rCWmY6tk6,enY8eKJ|U\u000f\u001e9viN#(/Z1n\u0015\ty\u0001#\u0001\u0004mCf,'o\u001d\u0006\u0003#I\t\u0001B];oi&lW-\r\u0006\u0003'Q\t\u0001\u0002Z1gM>$\u0017\u000e\u001c\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\tIwNC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"\u0001D(viB,Ho\u0015;sK\u0006l\u0017!\u00027bs\u0016\u0014\bC\u0001\u0013&\u001b\u0005q\u0011B\u0001\u0014\u000f\u0005E\u0019\u0005.Z2lgVlG*Y=fe\n\u000b7/Z\u0001\u0004U>\u001c\u0018A\u0002\u001fj]&$h\bF\u0002+W1\u0002\"\u0001\n\u0001\t\u000b\t\u001a\u0001\u0019A\u0012\t\u000b\u001d\u001a\u0001\u0019\u0001\u000e\u0002\t\t\fwn]\u000b\u0002_A\u00111\u0004M\u0005\u0003cq\u0011QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.A\u0003d_VtG/F\u00015!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0011auN\\4\u0002\u0013\r|WO\u001c;`I\u0015\fHC\u0001\u001f@!\t)T(\u0003\u0002?m\t!QK\\5u\u0011\u001d\u0001e!!AA\u0002Q\n1\u0001\u001f\u00132\u0003\u0019\u0019w.\u001e8uA\u0005)qO]5uKR\u0011A\b\u0012\u0005\u0006\u000b\"\u0001\rAR\u0001\u0002EB\u0011QgR\u0005\u0003\u0011Z\u00121!\u00138u\u0003\u0019I7o\u00149f]V\t1\n\u0005\u00026\u0019&\u0011QJ\u000e\u0002\b\u0005>|G.Z1o\u0003)I7o\u00149f]~#S-\u001d\u000b\u0003yACq\u0001\u0011\u0006\u0002\u0002\u0003\u00071*A\u0004jg>\u0003XM\u001c\u0011\u0002\u000b\rdwn]3\u0015\u0003q\u0002")
public class ChecksumEncoderOutputStream
extends OutputStream {
    private ByteArrayOutputStream baos;
    private final ChecksumLayerBase layer;
    private final OutputStream jos;
    private long count;
    private boolean isOpen;
    private volatile boolean bitmap$0;

    private ByteArrayOutputStream baos$lzycompute() {
        ChecksumEncoderOutputStream checksumEncoderOutputStream = this;
        synchronized (checksumEncoderOutputStream) {
            if (!this.bitmap$0) {
                this.baos = new ByteArrayOutputStream(this.layer.getLength());
                this.bitmap$0 = true;
            }
        }
        return this.baos;
    }

    private ByteArrayOutputStream baos() {
        if (!this.bitmap$0) {
            return this.baos$lzycompute();
        }
        return this.baos;
    }

    private long count() {
        return this.count;
    }

    private void count_$eq(long x$1) {
        this.count = x$1;
    }

    @Override
    public void write(int b) {
        this.baos().write(b);
        this.count_$eq(this.count() + 1L);
        if (this.count() > (long)this.layer.getLength()) {
            this.layer.processingError(new IndexOutOfBoundsException(new StringBuilder(52).append("Written data amount exceeded fixed layer length of ").append(this.layer.getLength()).append(".").toString()));
            return;
        }
    }

    private boolean isOpen() {
        return this.isOpen;
    }

    private void isOpen_$eq(boolean x$1) {
        this.isOpen = x$1;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.isOpen_$eq(false);
            byte[] ba = this.baos().toByteArray();
            int baLen = ba.length;
            if (baLen > this.layer.getLength()) {
                throw Assert$.MODULE$.abort("Invariant broken: baLen.<=(ChecksumEncoderOutputStream.this.layer.getLength)");
            }
            ByteBuffer buf = ByteBuffer.wrap(ba);
            this.layer.setChecksum(this.layer.compute(true, buf));
            this.jos.write(ba);
            this.jos.flush();
            return;
        }
    }

    public ChecksumEncoderOutputStream(ChecksumLayerBase layer, OutputStream jos) {
        this.layer = layer;
        this.jos = jos;
        this.count = 0L;
        this.isOpen = true;
    }
}

