/*
 * Decompiled with CFR 0.152.
 */
package datafu.com.google.common.collect;

import com.google.j2objc.annotations.Weak;
import datafu.com.google.common.annotations.GwtCompatible;
import datafu.com.google.common.annotations.GwtIncompatible;
import datafu.com.google.common.collect.ImmutableAsList;
import datafu.com.google.common.collect.ImmutableCollection;
import datafu.com.google.common.collect.ImmutableList;
import datafu.com.google.common.collect.UnmodifiableListIterator;

@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    @Weak
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }
}

