/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.maxent;

import datafu.opennlp.maxent.io.SuffixSensitiveGISModelReader;
import datafu.opennlp.model.AbstractModel;
import datafu.opennlp.model.Context;
import datafu.opennlp.model.EvalParameters;
import datafu.opennlp.model.Prior;
import datafu.opennlp.model.UniformPrior;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;

public final class GISModel
extends AbstractModel {
    public GISModel(Context[] params, String[] predLabels, String[] outcomeNames, int correctionConstant, double correctionParam) {
        this(params, predLabels, outcomeNames, correctionConstant, correctionParam, new UniformPrior());
    }

    public GISModel(Context[] params, String[] predLabels, String[] outcomeNames, int correctionConstant, double correctionParam, Prior prior) {
        super(params, predLabels, outcomeNames, correctionConstant, correctionParam);
        this.prior = prior;
        prior.setLabels(outcomeNames, predLabels);
        this.modelType = AbstractModel.ModelType.Maxent;
    }

    public final double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    public final double[] eval(String[] context, float[] values) {
        return this.eval(context, values, new double[this.evalParams.getNumOutcomes()]);
    }

    public final double[] eval(String[] context, double[] outsums) {
        return this.eval(context, null, outsums);
    }

    public final double[] eval(String[] context, float[] values, double[] outsums) {
        int[] scontexts = new int[context.length];
        for (int i = 0; i < context.length; ++i) {
            Integer ci = this.pmap.get(context[i]);
            scontexts[i] = ci == null ? -1 : ci;
        }
        this.prior.logPrior(outsums, scontexts, values);
        return GISModel.eval(scontexts, values, outsums, this.evalParams);
    }

    public static double[] eval(int[] context, double[] prior, EvalParameters model) {
        return GISModel.eval(context, null, prior, model);
    }

    public static double[] eval(int[] context, float[] values, double[] prior, EvalParameters model) {
        int oid;
        Context[] params = model.getParams();
        int[] numfeats = new int[model.getNumOutcomes()];
        double value = 1.0;
        for (int ci = 0; ci < context.length; ++ci) {
            if (context[ci] < 0) continue;
            Context predParams = params[context[ci]];
            int[] activeOutcomes = predParams.getOutcomes();
            double[] activeParameters = predParams.getParameters();
            if (values != null) {
                value = values[ci];
            }
            for (int ai = 0; ai < activeOutcomes.length; ++ai) {
                int oid2;
                int n = oid2 = activeOutcomes[ai];
                numfeats[n] = numfeats[n] + 1;
                int n2 = oid2;
                prior[n2] = prior[n2] + activeParameters[ai] * value;
            }
        }
        double normal = 0.0;
        for (oid = 0; oid < model.getNumOutcomes(); ++oid) {
            prior[oid] = model.getCorrectionParam() != 0.0 ? Math.exp(prior[oid] * model.getConstantInverse() + (1.0 - (double)numfeats[oid] / model.getCorrectionConstant()) * model.getCorrectionParam()) : Math.exp(prior[oid] * model.getConstantInverse());
            normal += prior[oid];
        }
        oid = 0;
        while (oid < model.getNumOutcomes()) {
            int n = oid++;
            prior[n] = prior[n] / normal;
        }
        return prior;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: GISModel modelname < contexts");
            System.exit(1);
        }
        AbstractModel m = new SuffixSensitiveGISModelReader(new File(args[0])).getModel();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        DecimalFormat df = new DecimalFormat(".###");
        String line = in.readLine();
        while (line != null) {
            String[] context = line.split(" ");
            double[] dist = m.eval(context);
            for (int oi = 0; oi < dist.length; ++oi) {
                System.out.print("[" + m.getOutcome(oi) + " " + df.format(dist[oi]) + "] ");
            }
            System.out.println();
            line = in.readLine();
        }
    }
}

