/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.maxent.io;

import datafu.opennlp.maxent.quasinewton.QNModel;
import datafu.opennlp.model.AbstractModel;
import datafu.opennlp.model.AbstractModelReader;
import datafu.opennlp.model.Context;
import datafu.opennlp.model.DataReader;
import java.io.File;
import java.io.IOException;

public class QNModelReader
extends AbstractModelReader {
    public QNModelReader(DataReader dataReader) {
        super(dataReader);
    }

    public QNModelReader(File file) throws IOException {
        super(file);
    }

    public void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (!modelType.equals("QN")) {
            System.out.println("Error: attempting to load a " + modelType + " model as a MAXENT_QN model." + " You should expect problems.");
        }
    }

    public AbstractModel constructModel() throws IOException {
        String[] predNames = this.getPredicates();
        String[] outcomeNames = this.getOutcomes();
        Context[] params = this.getParameters();
        double[] parameters = this.getDoubleArrayParams();
        return new QNModel(predNames, outcomeNames, params, parameters);
    }

    private double[] getDoubleArrayParams() throws IOException {
        int numDouble = this.readInt();
        double[] doubleArray = new double[numDouble];
        for (int i = 0; i < numDouble; ++i) {
            doubleArray[i] = this.readDouble();
        }
        return doubleArray;
    }

    private int[] getIntArrayParams() throws IOException {
        int numInt = this.readInt();
        int[] intArray = new int[numInt];
        for (int i = 0; i < numInt; ++i) {
            intArray[i] = this.readInt();
        }
        return intArray;
    }

    protected Context[] getParameters() throws IOException {
        int numContext = this.readInt();
        Context[] params = new Context[numContext];
        for (int i = 0; i < numContext; ++i) {
            int[] outcomePattern = this.getIntArrayParams();
            double[] parameters = this.getDoubleArrayParams();
            params[i] = new Context(outcomePattern, parameters);
        }
        return params;
    }
}

