/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.model;

import datafu.opennlp.model.Context;

public class EvalParameters {
    private Context[] params;
    private final int numOutcomes;
    private double correctionConstant;
    private final double constantInverse;
    private double correctionParam;

    public EvalParameters(Context[] params, double correctionParam, double correctionConstant, int numOutcomes) {
        this.params = params;
        this.correctionParam = correctionParam;
        this.numOutcomes = numOutcomes;
        this.correctionConstant = correctionConstant;
        this.constantInverse = 1.0 / correctionConstant;
    }

    public EvalParameters(Context[] params, int numOutcomes) {
        this(params, 0.0, 0.0, numOutcomes);
    }

    public Context[] getParams() {
        return this.params;
    }

    public int getNumOutcomes() {
        return this.numOutcomes;
    }

    public double getCorrectionConstant() {
        return this.correctionConstant;
    }

    public double getConstantInverse() {
        return this.constantInverse;
    }

    public double getCorrectionParam() {
        return this.correctionParam;
    }

    public void setCorrectionParam(double correctionParam) {
        this.correctionParam = correctionParam;
    }
}

