/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.model;

import datafu.opennlp.maxent.io.GISModelReader;
import datafu.opennlp.maxent.io.QNModelReader;
import datafu.opennlp.model.AbstractModel;
import datafu.opennlp.model.AbstractModelReader;
import datafu.opennlp.model.DataReader;
import datafu.opennlp.model.GenericModelWriter;
import datafu.opennlp.perceptron.PerceptronModelReader;
import java.io.File;
import java.io.IOException;

public class GenericModelReader
extends AbstractModelReader {
    private AbstractModelReader delegateModelReader;

    public GenericModelReader(File f) throws IOException {
        super(f);
    }

    public GenericModelReader(DataReader dataReader) {
        super(dataReader);
    }

    public void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (modelType.equals("Perceptron")) {
            this.delegateModelReader = new PerceptronModelReader(this.dataReader);
        } else if (modelType.equals("GIS")) {
            this.delegateModelReader = new GISModelReader(this.dataReader);
        } else if (modelType.equals("QN")) {
            this.delegateModelReader = new QNModelReader(this.dataReader);
        } else {
            throw new IOException("Unknown model format: " + modelType);
        }
    }

    public AbstractModel constructModel() throws IOException {
        return this.delegateModelReader.constructModel();
    }

    public static void main(String[] args) throws IOException {
        AbstractModel m = new GenericModelReader(new File(args[0])).getModel();
        new GenericModelWriter(m, new File(args[1])).persist();
    }
}

