/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexHashTable<T> {
    private final Object[] keys;
    private final int[] values;
    private final int size;

    public IndexHashTable(T[] mapping, double loadfactor) {
        if (loadfactor <= 0.0 || loadfactor > 1.0) {
            throw new IllegalArgumentException("loadfactor must be larger than 0 and equal to or smaller than 1 but is " + loadfactor + "!");
        }
        int arraySize = (int)((double)mapping.length / loadfactor) + 1;
        this.keys = new Object[arraySize];
        this.values = new int[arraySize];
        this.size = mapping.length;
        int i = 0;
        while (i < mapping.length) {
            int startIndex = IndexHashTable.indexForHash(mapping[i].hashCode(), this.keys.length);
            int index = this.searchKey(startIndex, null, true);
            if (index == -1) {
                throw new IllegalArgumentException("Array must contain only unique keys!");
            }
            this.keys[index] = mapping[i];
            this.values[index] = i++;
        }
    }

    private static int indexForHash(int h, int length) {
        return (h & Integer.MAX_VALUE) % length;
    }

    private int searchKey(int startIndex, Object key, boolean insert) {
        int index = startIndex;
        while (true) {
            if (this.keys[index] == null) {
                if (insert) {
                    return index;
                }
                return -1;
            }
            if (this.keys[index].equals(key)) {
                if (!insert) {
                    return index;
                }
                return -1;
            }
            index = (index + 1) % this.keys.length;
        }
    }

    public int get(T key) {
        int startIndex = IndexHashTable.indexForHash(key.hashCode(), this.keys.length);
        int index = this.searchKey(startIndex, key, false);
        if (index != -1) {
            return this.values[index];
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public T[] toArray(T[] array) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            array[this.values[i]] = this.keys[i];
        }
        return array;
    }
}

