/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.model;

import datafu.opennlp.model.AbstractDataIndexer;
import datafu.opennlp.model.ComparableEvent;
import datafu.opennlp.model.Event;
import datafu.opennlp.model.EventStream;
import datafu.opennlp.model.FileEventStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoPassDataIndexer
extends AbstractDataIndexer {
    public TwoPassDataIndexer(EventStream eventStream) throws IOException {
        this(eventStream, 0);
    }

    public TwoPassDataIndexer(EventStream eventStream, int cutoff) throws IOException {
        this(eventStream, cutoff, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TwoPassDataIndexer(EventStream eventStream, int cutoff, boolean sort) throws IOException {
        HashMap<String, Integer> predicateIndex = new HashMap<String, Integer>();
        System.out.println("Indexing events using cutoff of " + cutoff + "\n");
        System.out.print("\tComputing event counts...  ");
        try {
            List<ComparableEvent> eventsToCompare;
            File tmp = File.createTempFile("events", null);
            tmp.deleteOnExit();
            BufferedWriter osw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), "UTF8"));
            int numEvents = this.computeEventCounts(eventStream, osw, predicateIndex, cutoff);
            System.out.println("done. " + numEvents + " events");
            System.out.print("\tIndexing...  ");
            FileEventStream fes = new FileEventStream(tmp);
            try {
                eventsToCompare = this.index(numEvents, fes, predicateIndex);
            }
            finally {
                fes.close();
            }
            predicateIndex = null;
            tmp.delete();
            System.out.println("done.");
            if (sort) {
                System.out.print("Sorting and merging events... ");
            } else {
                System.out.print("Collecting events... ");
            }
            this.sortAndMerge(eventsToCompare, sort);
            System.out.println("Done indexing.");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private int computeEventCounts(EventStream eventStream, Writer eventStore, Map<String, Integer> predicatesInOut, int cutoff) throws IOException {
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        int eventCount = 0;
        HashSet<String> predicateSet = new HashSet<String>();
        while (eventStream.hasNext()) {
            Event ev = eventStream.next();
            ++eventCount;
            eventStore.write(FileEventStream.toLine(ev));
            String[] ec = ev.getContext();
            TwoPassDataIndexer.update(ec, predicateSet, counter, cutoff);
        }
        this.predCounts = new int[predicateSet.size()];
        int index = 0;
        for (String predicate : predicateSet) {
            this.predCounts[index] = (Integer)counter.get(predicate);
            predicatesInOut.put(predicate, index);
            ++index;
        }
        eventStore.close();
        return eventCount;
    }

    private List<ComparableEvent> index(int numEvents, EventStream es, Map<String, Integer> predicateIndex) throws IOException {
        HashMap<String, Integer> omap = new HashMap<String, Integer>();
        int outcomeCount = 0;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        ArrayList<Integer> indexedContext = new ArrayList<Integer>();
        while (es.hasNext()) {
            int ocID;
            Event ev = es.next();
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey(oc)) {
                ocID = (Integer)omap.get(oc);
            } else {
                ocID = outcomeCount++;
                omap.put(oc, ocID);
            }
            for (String pred : econtext) {
                if (!predicateIndex.containsKey(pred)) continue;
                indexedContext.add(predicateIndex.get(pred));
            }
            if (indexedContext.size() > 0) {
                int[] cons = new int[indexedContext.size()];
                for (int ci = 0; ci < cons.length; ++ci) {
                    cons[ci] = (Integer)indexedContext.get(ci);
                }
                ComparableEvent ce = new ComparableEvent(ocID, cons);
                eventsToCompare.add(ce);
            } else {
                System.err.println("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()));
            }
            indexedContext.clear();
        }
        this.outcomeLabels = TwoPassDataIndexer.toIndexedStringArray(omap);
        this.predLabels = TwoPassDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }
}

