/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.perceptron;

import datafu.opennlp.model.AbstractModel;
import datafu.opennlp.model.Context;
import datafu.opennlp.model.EvalParameters;
import datafu.opennlp.model.IndexHashTable;
import datafu.opennlp.perceptron.PerceptronModelReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerceptronModel
extends AbstractModel {
    public PerceptronModel(Context[] params, String[] predLabels, IndexHashTable<String> pmap, String[] outcomeNames) {
        super(params, predLabels, pmap, outcomeNames);
        this.modelType = AbstractModel.ModelType.Perceptron;
    }

    @Deprecated
    public PerceptronModel(Context[] params, String[] predLabels, Map<String, Integer> pmap, String[] outcomeNames) {
        super(params, predLabels, outcomeNames);
        this.modelType = AbstractModel.ModelType.Perceptron;
    }

    public PerceptronModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        super(params, predLabels, outcomeNames);
        this.modelType = AbstractModel.ModelType.Perceptron;
    }

    @Override
    public double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, float[] values) {
        return this.eval(context, values, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, double[] probs) {
        return this.eval(context, null, probs);
    }

    public double[] eval(String[] context, float[] values, double[] outsums) {
        int[] scontexts = new int[context.length];
        Arrays.fill(outsums, 0.0);
        for (int i = 0; i < context.length; ++i) {
            Integer ci = this.pmap.get(context[i]);
            scontexts[i] = ci == null ? -1 : ci;
        }
        return PerceptronModel.eval(scontexts, values, outsums, this.evalParams, true);
    }

    public static double[] eval(int[] context, double[] prior, EvalParameters model) {
        return PerceptronModel.eval(context, null, prior, model, true);
    }

    public static double[] eval(int[] context, float[] values, double[] prior, EvalParameters model, boolean normalize) {
        int oid;
        Context[] params = model.getParams();
        double value = 1.0;
        for (int ci = 0; ci < context.length; ++ci) {
            if (context[ci] < 0) continue;
            Context predParams = params[context[ci]];
            int[] activeOutcomes = predParams.getOutcomes();
            double[] activeParameters = predParams.getParameters();
            if (values != null) {
                value = values[ci];
            }
            for (int ai = 0; ai < activeOutcomes.length; ++ai) {
                int n = oid = activeOutcomes[ai];
                prior[n] = prior[n] + activeParameters[ai] * value;
            }
        }
        if (normalize) {
            int oid2;
            int numOutcomes = model.getNumOutcomes();
            double maxPrior = 1.0;
            for (oid = 0; oid < numOutcomes; ++oid) {
                if (!(maxPrior < Math.abs(prior[oid]))) continue;
                maxPrior = Math.abs(prior[oid]);
            }
            double normal = 0.0;
            for (oid2 = 0; oid2 < numOutcomes; ++oid2) {
                prior[oid2] = Math.exp(prior[oid2] / maxPrior);
                normal += prior[oid2];
            }
            oid2 = 0;
            while (oid2 < numOutcomes) {
                int n = oid2++;
                prior[n] = prior[n] / normal;
            }
        }
        return prior;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: PerceptronModel modelname < contexts");
            System.exit(1);
        }
        AbstractModel m = new PerceptronModelReader(new File(args[0])).getModel();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        DecimalFormat df = new DecimalFormat(".###");
        String line = in.readLine();
        while (line != null) {
            String[] context = line.split(" ");
            double[] dist = m.eval(context);
            for (int oi = 0; oi < dist.length; ++oi) {
                System.out.print("[" + m.getOutcome(oi) + " " + df.format(dist[oi]) + "] ");
            }
            System.out.println();
            line = in.readLine();
        }
    }
}

