/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.dictionary.serializer;

import datafu.opennlp.tools.dictionary.serializer.Attributes;
import datafu.opennlp.tools.dictionary.serializer.Entry;
import datafu.opennlp.tools.dictionary.serializer.EntryInserter;
import datafu.opennlp.tools.util.InvalidFormatException;
import datafu.opennlp.tools.util.StringList;
import datafu.opennlp.tools.util.model.UncloseableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionarySerializer {
    private static final String CHARSET = "UTF-8";
    private static final String DICTIONARY_ELEMENT = "dictionary";
    private static final String ENTRY_ELEMENT = "entry";
    private static final String TOKEN_ELEMENT = "token";
    private static final String ATTRIBUTE_CASE_SENSITIVE = "case_sensitive";

    public static boolean create(InputStream in, EntryInserter inserter) throws IOException, InvalidFormatException {
        DictionaryContenthandler profileContentHandler = new DictionaryContenthandler(inserter);
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(profileContentHandler);
            xmlReader.parse(new InputSource(new UncloseableInputStream(in)));
        }
        catch (SAXException e) {
            throw new InvalidFormatException("The profile data stream has an invalid format!", e);
        }
        return profileContentHandler.mIsCaseSensitiveDictionary;
    }

    @Deprecated
    public static void serialize(OutputStream out, Iterator<Entry> entries) throws IOException {
        DictionarySerializer.serialize(out, entries, true);
    }

    public static void serialize(OutputStream out, Iterator<Entry> entries, boolean casesensitive) throws IOException {
        TransformerHandler hd;
        StreamResult streamResult = new StreamResult(out);
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            hd = tf.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new AssertionError((Object)"The Transformer configuration must be valid!");
        }
        Transformer serializer = hd.getTransformer();
        serializer.setOutputProperty("encoding", CHARSET);
        serializer.setOutputProperty("indent", "yes");
        hd.setResult(streamResult);
        try {
            hd.startDocument();
            AttributesImpl dictionaryAttributes = new AttributesImpl();
            dictionaryAttributes.addAttribute("", "", ATTRIBUTE_CASE_SENSITIVE, "", String.valueOf(casesensitive));
            hd.startElement("", "", DICTIONARY_ELEMENT, dictionaryAttributes);
            while (entries.hasNext()) {
                Entry entry = entries.next();
                DictionarySerializer.serializeEntry(hd, entry);
            }
            hd.endElement("", "", DICTIONARY_ELEMENT);
            hd.endDocument();
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Error during serialization: " + e.getMessage()).initCause(e);
        }
    }

    private static void serializeEntry(TransformerHandler hd, Entry entry) throws SAXException {
        AttributesImpl entryAttributes = new AttributesImpl();
        Iterator<String> it = entry.getAttributes().iterator();
        while (it.hasNext()) {
            String key = it.next();
            entryAttributes.addAttribute("", "", key, "", entry.getAttributes().getValue(key));
        }
        hd.startElement("", "", ENTRY_ELEMENT, entryAttributes);
        StringList tokens = entry.getTokens();
        Iterator<String> it2 = tokens.iterator();
        while (it2.hasNext()) {
            hd.startElement("", "", TOKEN_ELEMENT, new AttributesImpl());
            String token = it2.next();
            hd.characters(token.toCharArray(), 0, token.length());
            hd.endElement("", "", TOKEN_ELEMENT);
        }
        hd.endElement("", "", ENTRY_ELEMENT);
    }

    private static class DictionaryContenthandler
    implements ContentHandler {
        private EntryInserter mInserter;
        private boolean mIsInsideTokenElement;
        private boolean mIsCaseSensitiveDictionary;
        private List<String> mTokenList = new LinkedList<String>();
        private StringBuilder token = new StringBuilder();
        private Attributes mAttributes;

        private DictionaryContenthandler(EntryInserter inserter) {
            this.mInserter = inserter;
            this.mIsCaseSensitiveDictionary = true;
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes atts) throws SAXException {
            if (DictionarySerializer.DICTIONARY_ELEMENT.equals(localName)) {
                this.mAttributes = new Attributes();
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.mAttributes.setValue(atts.getLocalName(i), atts.getValue(i));
                }
                if (this.mAttributes.getValue(DictionarySerializer.ATTRIBUTE_CASE_SENSITIVE) != null) {
                    this.mIsCaseSensitiveDictionary = Boolean.valueOf(this.mAttributes.getValue(DictionarySerializer.ATTRIBUTE_CASE_SENSITIVE));
                }
                this.mAttributes = null;
            } else if (DictionarySerializer.ENTRY_ELEMENT.equals(localName)) {
                this.mAttributes = new Attributes();
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.mAttributes.setValue(atts.getLocalName(i), atts.getValue(i));
                }
            } else if (DictionarySerializer.TOKEN_ELEMENT.equals(localName)) {
                this.mIsInsideTokenElement = true;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mIsInsideTokenElement) {
                this.token.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (DictionarySerializer.TOKEN_ELEMENT.equals(localName)) {
                this.mTokenList.add(this.token.toString().trim());
                this.token.setLength(0);
                this.mIsInsideTokenElement = false;
            } else if (DictionarySerializer.ENTRY_ELEMENT.equals(localName)) {
                String[] tokens = this.mTokenList.toArray(new String[this.mTokenList.size()]);
                Entry entry = new Entry(new StringList(tokens), this.mAttributes);
                try {
                    this.mInserter.insert(entry);
                }
                catch (InvalidFormatException e) {
                    throw new SAXException("Invalid dictionary format!", e);
                }
                this.mTokenList.clear();
                this.mAttributes = null;
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

