/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.ngram;

import datafu.opennlp.tools.dictionary.Dictionary;
import datafu.opennlp.tools.dictionary.serializer.Attributes;
import datafu.opennlp.tools.dictionary.serializer.DictionarySerializer;
import datafu.opennlp.tools.dictionary.serializer.Entry;
import datafu.opennlp.tools.dictionary.serializer.EntryInserter;
import datafu.opennlp.tools.util.InvalidFormatException;
import datafu.opennlp.tools.util.StringList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NGramModel
implements Iterable<StringList> {
    protected static final String COUNT = "count";
    private Map<StringList, Integer> mNGrams = new HashMap<StringList, Integer>();

    public NGramModel() {
    }

    public NGramModel(InputStream in) throws IOException, InvalidFormatException {
        DictionarySerializer.create(in, new EntryInserter(){

            public void insert(Entry entry) throws InvalidFormatException {
                int count;
                String countValueString = null;
                try {
                    countValueString = entry.getAttributes().getValue(NGramModel.COUNT);
                    if (countValueString == null) {
                        throw new InvalidFormatException("The count attribute must be set!");
                    }
                    count = Integer.parseInt(countValueString);
                }
                catch (NumberFormatException e) {
                    throw new InvalidFormatException("The count attribute '" + countValueString + "' must be a number!", e);
                }
                NGramModel.this.add(entry.getTokens());
                NGramModel.this.setCount(entry.getTokens(), count);
            }
        });
    }

    public int getCount(StringList ngram) {
        Integer count = this.mNGrams.get(ngram);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public void setCount(StringList ngram, int count) {
        Integer oldCount = this.mNGrams.put(ngram, count);
        if (oldCount == null) {
            this.mNGrams.remove(ngram);
            throw new NoSuchElementException();
        }
    }

    public void add(StringList ngram) {
        if (this.contains(ngram)) {
            this.setCount(ngram, this.getCount(ngram) + 1);
        } else {
            this.mNGrams.put(ngram, 1);
        }
    }

    public void add(StringList ngram, int minLength, int maxLength) {
        if (minLength < 1 || maxLength < 1) {
            throw new IllegalArgumentException("minLength and maxLength param must be at least 1. minLength=" + minLength + ", maxLength= " + maxLength);
        }
        if (minLength > maxLength) {
            throw new IllegalArgumentException("minLength param must not be larger than maxLength param. minLength=" + minLength + ", maxLength= " + maxLength);
        }
        for (int lengthIndex = minLength; lengthIndex < maxLength + 1; ++lengthIndex) {
            int textIndex = 0;
            while (textIndex + lengthIndex - 1 < ngram.size()) {
                String[] grams = new String[lengthIndex];
                for (int i = textIndex; i < textIndex + lengthIndex; ++i) {
                    grams[i - textIndex] = ngram.getToken(i);
                }
                this.add(new StringList(grams));
                ++textIndex;
            }
        }
    }

    public void add(String chars, int minLength, int maxLength) {
        for (int lengthIndex = minLength; lengthIndex < maxLength + 1; ++lengthIndex) {
            int textIndex = 0;
            while (textIndex + lengthIndex - 1 < chars.length()) {
                String gram = chars.substring(textIndex, textIndex + lengthIndex).toLowerCase();
                this.add(new StringList(new String[]{gram}));
                ++textIndex;
            }
        }
    }

    public void remove(StringList tokens) {
        this.mNGrams.remove(tokens);
    }

    public boolean contains(StringList tokens) {
        return this.mNGrams.containsKey(tokens);
    }

    public int size() {
        return this.mNGrams.size();
    }

    @Override
    public Iterator<StringList> iterator() {
        return this.mNGrams.keySet().iterator();
    }

    public int numberOfGrams() {
        int counter = 0;
        for (StringList ngram : this) {
            counter += this.getCount(ngram);
        }
        return counter;
    }

    public void cutoff(int cutoffUnder, int cutoffOver) {
        if (cutoffUnder > 0 || cutoffOver < Integer.MAX_VALUE) {
            Iterator<StringList> it = this.iterator();
            while (it.hasNext()) {
                StringList ngram = it.next();
                int count = this.getCount(ngram);
                if (count >= cutoffUnder && count <= cutoffOver) continue;
                it.remove();
            }
        }
    }

    public Dictionary toDictionary() {
        return this.toDictionary(false);
    }

    public Dictionary toDictionary(boolean caseSensitive) {
        Dictionary dict = new Dictionary(caseSensitive);
        for (StringList stringList : this) {
            dict.put(stringList);
        }
        return dict;
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator<Entry> entryIterator = new Iterator<Entry>(){
            private Iterator<StringList> mDictionaryIterator;
            {
                this.mDictionaryIterator = NGramModel.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mDictionaryIterator.hasNext();
            }

            @Override
            public Entry next() {
                StringList tokens = this.mDictionaryIterator.next();
                Attributes attributes = new Attributes();
                attributes.setValue(NGramModel.COUNT, Integer.toString(NGramModel.this.getCount(tokens)));
                return new Entry(tokens, attributes);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(out, entryIterator, false);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj == this) {
            result = true;
        } else if (obj instanceof NGramModel) {
            NGramModel model = (NGramModel)obj;
            result = ((Object)this.mNGrams).equals(model.mNGrams);
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        return "Size: " + this.size();
    }

    public int hashCode() {
        return ((Object)this.mNGrams).hashCode();
    }
}

