/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.postag;

import datafu.opennlp.model.AbstractModel;
import datafu.opennlp.tools.dictionary.Dictionary;
import datafu.opennlp.tools.postag.POSDictionary;
import datafu.opennlp.tools.postag.POSTaggerFactory;
import datafu.opennlp.tools.postag.TagDictionary;
import datafu.opennlp.tools.util.BaseToolFactory;
import datafu.opennlp.tools.util.InvalidFormatException;
import datafu.opennlp.tools.util.model.ArtifactSerializer;
import datafu.opennlp.tools.util.model.BaseModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class POSModel
extends BaseModel {
    private static final String COMPONENT_NAME = "POSTaggerME";
    public static final String POS_MODEL_ENTRY_NAME = "pos.model";

    public POSModel(String languageCode, AbstractModel posModel, POSDictionary tagDictionary, Dictionary ngramDict, Map<String, String> manifestInfoEntries) {
        this(languageCode, posModel, manifestInfoEntries, new POSTaggerFactory(ngramDict, tagDictionary));
    }

    public POSModel(String languageCode, AbstractModel posModel, POSDictionary tagDictionary, Dictionary ngramDict) {
        this(languageCode, posModel, null, new POSTaggerFactory(ngramDict, tagDictionary));
    }

    public POSModel(String languageCode, AbstractModel posModel, Map<String, String> manifestInfoEntries, POSTaggerFactory posFactory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, posFactory);
        if (posModel == null) {
            throw new IllegalArgumentException("The maxentPosModel param must not be null!");
        }
        this.artifactMap.put(POS_MODEL_ENTRY_NAME, posModel);
        this.checkArtifactMap();
    }

    public POSModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    public POSModel(File modelFile) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelFile);
    }

    public POSModel(URL modelURL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return POSTaggerFactory.class;
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("POS model is incomplete!");
        }
    }

    public AbstractModel getPosModel() {
        return (AbstractModel)this.artifactMap.get(POS_MODEL_ENTRY_NAME);
    }

    public POSDictionary getTagDictionary() {
        TagDictionary dict;
        if (this.getFactory() != null && (dict = this.getFactory().getTagDictionary()) != null) {
            if (dict instanceof POSDictionary) {
                return (POSDictionary)dict;
            }
            String clazz = dict.getClass().getCanonicalName();
            throw new IllegalStateException("Can not get a dictionary of type " + clazz + " using the deprecated method POSModel.getTagDictionary() " + "because it can only return dictionaries of type POSDictionary. " + "Use POSModel.getFactory().getTagDictionary() instead.");
        }
        return null;
    }

    public POSTaggerFactory getFactory() {
        return (POSTaggerFactory)this.toolFactory;
    }

    public Dictionary getNgramDictionary() {
        if (this.getFactory() != null) {
            return this.getFactory().getDictionary();
        }
        return null;
    }
}

