/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.postag;

import datafu.opennlp.model.Event;
import datafu.opennlp.tools.postag.DefaultPOSContextGenerator;
import datafu.opennlp.tools.postag.POSContextGenerator;
import datafu.opennlp.tools.postag.POSSample;
import datafu.opennlp.tools.util.AbstractEventStream;
import datafu.opennlp.tools.util.ObjectStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSSampleEventStream
extends AbstractEventStream<POSSample> {
    private POSContextGenerator cg;

    public POSSampleEventStream(ObjectStream<POSSample> samples, POSContextGenerator cg) {
        super(samples);
        this.cg = cg;
    }

    public POSSampleEventStream(ObjectStream<POSSample> samples) {
        this(samples, new DefaultPOSContextGenerator(null));
    }

    @Override
    protected Iterator<Event> createEvents(POSSample sample) {
        String[] sentence = sample.getSentence();
        String[] tags = sample.getTags();
        String[][] ac = sample.getAddictionalContext();
        List<Event> events = POSSampleEventStream.generateEvents(sentence, tags, (Object[])ac, this.cg);
        return events.iterator();
    }

    public static List<Event> generateEvents(String[] sentence, String[] tags, Object[] additionalContext, POSContextGenerator cg) {
        ArrayList<Event> events = new ArrayList<Event>(sentence.length);
        for (int i = 0; i < sentence.length; ++i) {
            String[] context = cg.getContext(i, sentence, tags, additionalContext);
            events.add(new Event(tags[i], context));
        }
        return events;
    }

    public static List<Event> generateEvents(String[] sentence, String[] tags, POSContextGenerator cg) {
        return POSSampleEventStream.generateEvents(sentence, tags, null, cg);
    }
}

