/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.postag;

import datafu.opennlp.model.Event;
import datafu.opennlp.model.Sequence;
import datafu.opennlp.tools.postag.DefaultPOSContextGenerator;
import datafu.opennlp.tools.postag.POSContextGenerator;
import datafu.opennlp.tools.postag.POSSample;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class POSSampleSequenceIterator
implements Iterator<Sequence> {
    private Iterator<POSSample> psi;
    private POSContextGenerator cg;

    public POSSampleSequenceIterator(Iterator<POSSample> psi) {
        this.psi = psi;
        this.cg = new DefaultPOSContextGenerator(null);
    }

    @Override
    public boolean hasNext() {
        return this.psi.hasNext();
    }

    @Override
    public Sequence<POSSample> next() {
        POSSample sample = this.psi.next();
        String[] sentence = sample.getSentence();
        String[] tags = sample.getTags();
        Event[] events = new Event[sentence.length];
        for (int i = 0; i < sentence.length; ++i) {
            String[] context = this.cg.getContext(i, sentence, tags, (Object[])null);
            events[i] = new Event(tags[i], context);
        }
        Sequence<POSSample> sequence = new Sequence<POSSample>(events, sample);
        return sequence;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

