/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.postag;

import datafu.opennlp.model.AbstractModel;
import datafu.opennlp.model.Event;
import datafu.opennlp.model.Sequence;
import datafu.opennlp.model.SequenceStream;
import datafu.opennlp.tools.postag.DefaultPOSContextGenerator;
import datafu.opennlp.tools.postag.POSContextGenerator;
import datafu.opennlp.tools.postag.POSModel;
import datafu.opennlp.tools.postag.POSSample;
import datafu.opennlp.tools.postag.POSSampleEventStream;
import datafu.opennlp.tools.postag.POSSampleSequenceIterator;
import datafu.opennlp.tools.postag.POSTaggerFactory;
import datafu.opennlp.tools.postag.POSTaggerME;
import datafu.opennlp.tools.util.ObjectStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSSampleSequenceStream
implements SequenceStream {
    private POSContextGenerator pcg;
    private List<POSSample> samples = new ArrayList<POSSample>();

    public POSSampleSequenceStream(ObjectStream<POSSample> psi) throws IOException {
        this(psi, new DefaultPOSContextGenerator(null));
    }

    public POSSampleSequenceStream(ObjectStream<POSSample> psi, POSContextGenerator pcg) throws IOException {
        POSSample sample;
        while ((sample = psi.read()) != null) {
            this.samples.add(sample);
        }
        System.err.println("Got " + this.samples.size() + " sequences");
        this.pcg = pcg;
    }

    @Override
    public Event[] updateContext(Sequence sequence, AbstractModel model) {
        Sequence pss = sequence;
        POSTaggerME tagger = new POSTaggerME(new POSModel("x-unspecified", model, null, new POSTaggerFactory()));
        String[] sentence = ((POSSample)pss.getSource()).getSentence();
        String[][] ac = ((POSSample)pss.getSource()).getAddictionalContext();
        String[] tags = tagger.tag(((POSSample)pss.getSource()).getSentence());
        Event[] events = new Event[sentence.length];
        POSSampleEventStream.generateEvents(sentence, tags, (Object[])ac, this.pcg).toArray(events);
        return events;
    }

    @Override
    public Iterator<Sequence> iterator() {
        return new POSSampleSequenceIterator(this.samples.iterator());
    }
}

