/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.postag;

import datafu.opennlp.model.AbstractModel;
import datafu.opennlp.model.TrainUtil;
import datafu.opennlp.tools.dictionary.Dictionary;
import datafu.opennlp.tools.ngram.NGramModel;
import datafu.opennlp.tools.postag.DefaultPOSContextGenerator;
import datafu.opennlp.tools.postag.MutableTagDictionary;
import datafu.opennlp.tools.postag.POSContextGenerator;
import datafu.opennlp.tools.postag.POSDictionary;
import datafu.opennlp.tools.postag.POSModel;
import datafu.opennlp.tools.postag.POSSample;
import datafu.opennlp.tools.postag.POSSampleEventStream;
import datafu.opennlp.tools.postag.POSSampleSequenceStream;
import datafu.opennlp.tools.postag.POSTagger;
import datafu.opennlp.tools.postag.POSTaggerFactory;
import datafu.opennlp.tools.postag.TagDictionary;
import datafu.opennlp.tools.util.BeamSearch;
import datafu.opennlp.tools.util.ObjectStream;
import datafu.opennlp.tools.util.Sequence;
import datafu.opennlp.tools.util.SequenceValidator;
import datafu.opennlp.tools.util.StringList;
import datafu.opennlp.tools.util.TrainingParameters;
import datafu.opennlp.tools.util.featuregen.StringPattern;
import datafu.opennlp.tools.util.model.ModelType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSTaggerME
implements POSTagger {
    protected AbstractModel posModel;
    protected POSContextGenerator contextGen;
    protected TagDictionary tagDictionary;
    protected Dictionary ngramDictionary;
    protected boolean useClosedClassTagsFilter = false;
    public static final int DEFAULT_BEAM_SIZE = 3;
    protected int size;
    private Sequence bestSequence;
    protected BeamSearch<String> beam;

    public POSTaggerME(POSModel model, int beamSize, int cacheSize, SequenceValidator<String> sequenceValidator) {
        POSTaggerFactory factory = model.getFactory();
        this.posModel = model.getPosModel();
        model.getTagDictionary();
        this.contextGen = factory.getPOSContextGenerator(beamSize);
        this.tagDictionary = factory.getTagDictionary();
        this.size = beamSize;
        this.beam = new BeamSearch<String>(this.size, this.contextGen, this.posModel, sequenceValidator, cacheSize);
    }

    public POSTaggerME(POSModel model, int beamSize, int cacheSize) {
        POSTaggerFactory factory = model.getFactory();
        this.posModel = model.getPosModel();
        this.contextGen = factory.getPOSContextGenerator(beamSize);
        this.tagDictionary = factory.getTagDictionary();
        this.size = beamSize;
        this.beam = new BeamSearch<String>(this.size, this.contextGen, this.posModel, factory.getSequenceValidator(), cacheSize);
    }

    public POSTaggerME(POSModel model) {
        this(model, 3, 0);
    }

    @Deprecated
    public POSTaggerME(AbstractModel model, TagDictionary tagdict) {
        this(model, new DefaultPOSContextGenerator(null), tagdict);
    }

    @Deprecated
    public POSTaggerME(AbstractModel model, Dictionary dict) {
        this(model, new DefaultPOSContextGenerator(dict));
    }

    @Deprecated
    public POSTaggerME(AbstractModel model, Dictionary dict, TagDictionary tagdict) {
        this(3, model, new DefaultPOSContextGenerator(dict), tagdict);
    }

    @Deprecated
    public POSTaggerME(AbstractModel model, POSContextGenerator cg) {
        this(3, model, cg, null);
    }

    @Deprecated
    public POSTaggerME(AbstractModel model, POSContextGenerator cg, TagDictionary tagdict) {
        this(3, model, cg, tagdict);
    }

    @Deprecated
    public POSTaggerME(int beamSize, AbstractModel model, POSContextGenerator cg, TagDictionary tagdict) {
        this.size = beamSize;
        this.posModel = model;
        this.contextGen = cg;
        this.beam = new BeamSearch<String>(this.size, cg, model);
        this.tagDictionary = tagdict;
    }

    public int getNumTags() {
        return this.posModel.getNumOutcomes();
    }

    @Override
    @Deprecated
    public List<String> tag(List<String> sentence) {
        this.bestSequence = this.beam.bestSequence((String[])sentence.toArray(new String[sentence.size()]), null);
        return this.bestSequence.getOutcomes();
    }

    @Override
    public String[] tag(String[] sentence) {
        return this.tag(sentence, null);
    }

    @Override
    public String[] tag(String[] sentence, Object[] additionaContext) {
        this.bestSequence = this.beam.bestSequence((String[])sentence, additionaContext);
        List<String> t = this.bestSequence.getOutcomes();
        return t.toArray(new String[t.size()]);
    }

    public String[][] tag(int numTaggings, String[] sentence) {
        Sequence[] bestSequences = this.beam.bestSequences(numTaggings, (String[])sentence, null);
        String[][] tags = new String[bestSequences.length][];
        for (int si = 0; si < tags.length; ++si) {
            List<String> t = bestSequences[si].getOutcomes();
            tags[si] = t.toArray(new String[t.size()]);
        }
        return tags;
    }

    @Override
    @Deprecated
    public Sequence[] topKSequences(List<String> sentence) {
        return this.beam.bestSequences(this.size, (String[])sentence.toArray(new String[sentence.size()]), null);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence) {
        return this.topKSequences(sentence, null);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, Object[] additionaContext) {
        return this.beam.bestSequences(this.size, (String[])sentence, additionaContext);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    @Override
    @Deprecated
    public String tag(String sentence) {
        ArrayList<String> toks = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(sentence);
        while (st.hasMoreTokens()) {
            toks.add(st.nextToken());
        }
        List<String> tags = this.tag(toks);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tags.size(); ++i) {
            sb.append((String)toks.get(i) + "/" + tags.get(i) + " ");
        }
        return sb.toString().trim();
    }

    public String[] getOrderedTags(List<String> words, List<String> tags, int index) {
        return this.getOrderedTags(words, tags, index, null);
    }

    public String[] getOrderedTags(List<String> words, List<String> tags, int index, double[] tprobs) {
        double[] probs = this.posModel.eval(this.contextGen.getContext(index, words.toArray(new String[words.size()]), tags.toArray(new String[tags.size()]), (Object[])null));
        String[] orderedTags = new String[probs.length];
        for (int i = 0; i < probs.length; ++i) {
            int max = 0;
            for (int ti = 1; ti < probs.length; ++ti) {
                if (!(probs[ti] > probs[max])) continue;
                max = ti;
            }
            orderedTags[i] = this.posModel.getOutcome(max);
            if (tprobs != null) {
                tprobs[i] = probs[max];
            }
            probs[max] = 0.0;
        }
        return orderedTags;
    }

    public static POSModel train(String languageCode, ObjectStream<POSSample> samples, TrainingParameters trainParams, POSTaggerFactory posFactory) throws IOException {
        AbstractModel posModel;
        POSContextGenerator contextGenerator = posFactory.getPOSContextGenerator();
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        if (!TrainUtil.isSequenceTraining(trainParams.getSettings())) {
            POSSampleEventStream es = new POSSampleEventStream(samples, contextGenerator);
            posModel = TrainUtil.train(es, trainParams.getSettings(), manifestInfoEntries);
        } else {
            POSSampleSequenceStream ss = new POSSampleSequenceStream(samples, contextGenerator);
            posModel = TrainUtil.train(ss, trainParams.getSettings(), manifestInfoEntries);
        }
        return new POSModel(languageCode, posModel, manifestInfoEntries, posFactory);
    }

    public static POSModel train(String languageCode, ObjectStream<POSSample> samples, TrainingParameters trainParams, POSDictionary tagDictionary, Dictionary ngramDictionary) throws IOException {
        return POSTaggerME.train(languageCode, samples, trainParams, new POSTaggerFactory(ngramDictionary, tagDictionary));
    }

    @Deprecated
    public static POSModel train(String languageCode, ObjectStream<POSSample> samples, ModelType modelType, POSDictionary tagDictionary, Dictionary ngramDictionary, int cutoff, int iterations) throws IOException {
        TrainingParameters params = new TrainingParameters();
        params.put("Algorithm", modelType.toString());
        params.put("Iterations", Integer.toString(iterations));
        params.put("Cutoff", Integer.toString(cutoff));
        return POSTaggerME.train(languageCode, samples, params, tagDictionary, ngramDictionary);
    }

    public static Dictionary buildNGramDictionary(ObjectStream<POSSample> samples, int cutoff) throws IOException {
        POSSample sample;
        NGramModel ngramModel = new NGramModel();
        while ((sample = samples.read()) != null) {
            String[] words = sample.getSentence();
            if (words.length <= 0) continue;
            ngramModel.add(new StringList(words), 1, 1);
        }
        ngramModel.cutoff(cutoff, Integer.MAX_VALUE);
        return ngramModel.toDictionary(true);
    }

    public static void populatePOSDictionary(ObjectStream<POSSample> samples, MutableTagDictionary dict, int cutoff) throws IOException {
        POSSample sample;
        System.out.println("Expanding POS Dictionary ...");
        long start = System.nanoTime();
        HashMap newEntries = new HashMap();
        while ((sample = samples.read()) != null) {
            String[] words = sample.getSentence();
            String[] tags = sample.getTags();
            for (int i = 0; i < words.length; ++i) {
                String[] dictTags;
                if (StringPattern.recognize(words[i]).containsDigit()) continue;
                String word = dict.isCaseSensitive() ? words[i] : words[i].toLowerCase();
                if (!newEntries.containsKey(word)) {
                    newEntries.put(word, new HashMap());
                }
                if ((dictTags = dict.getTags(word)) != null) {
                    for (String tag : dictTags) {
                        Map value = (Map)newEntries.get(word);
                        if (value.containsKey(tag)) continue;
                        value.put(tag, new AtomicInteger(cutoff));
                    }
                }
                if (!((Map)newEntries.get(word)).containsKey(tags[i])) {
                    ((Map)newEntries.get(word)).put(tags[i], new AtomicInteger(1));
                    continue;
                }
                ((AtomicInteger)((Map)newEntries.get(word)).get(tags[i])).incrementAndGet();
            }
        }
        for (Map.Entry wordEntry : newEntries.entrySet()) {
            ArrayList tagsForWord = new ArrayList();
            for (Map.Entry entry : ((Map)wordEntry.getValue()).entrySet()) {
                if (((AtomicInteger)entry.getValue()).get() < cutoff) continue;
                tagsForWord.add(entry.getKey());
            }
            if (tagsForWord.size() <= 0) continue;
            dict.put((String)wordEntry.getKey(), tagsForWord.toArray(new String[tagsForWord.size()]));
        }
        System.out.println("... finished expanding POS Dictionary. [" + (System.nanoTime() - start) / 1000000L + "ms]");
    }
}

