/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.sentdetect;

import datafu.opennlp.maxent.IntegerPool;
import datafu.opennlp.tools.sentdetect.EndOfSentenceScanner;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEndOfSentenceScanner
implements EndOfSentenceScanner {
    protected static final IntegerPool INT_POOL = new IntegerPool(500);
    private char[] eosCharacters;

    public DefaultEndOfSentenceScanner(char[] eosCharacters) {
        this.eosCharacters = eosCharacters;
    }

    @Override
    public List<Integer> getPositions(String s) {
        return this.getPositions(s.toCharArray());
    }

    @Override
    public List<Integer> getPositions(StringBuffer buf) {
        return this.getPositions(buf.toString().toCharArray());
    }

    @Override
    public List<Integer> getPositions(char[] cbuf) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        char[] eosCharacters = this.getEndOfSentenceCharacters();
        block0: for (int i = 0; i < cbuf.length; ++i) {
            for (char eosCharacter : eosCharacters) {
                if (cbuf[i] != eosCharacter) continue;
                l.add(INT_POOL.get(i));
                continue block0;
            }
        }
        return l;
    }

    @Override
    public char[] getEndOfSentenceCharacters() {
        return this.eosCharacters;
    }
}

