/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.sentdetect;

import datafu.opennlp.tools.sentdetect.SDContextGenerator;
import datafu.opennlp.tools.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSDContextGenerator
implements SDContextGenerator {
    protected StringBuffer buf;
    protected List<String> collectFeats;
    private Set<String> inducedAbbreviations;
    private char[] eosCharacters;

    public DefaultSDContextGenerator(char[] eosCharacters) {
        this(Collections.emptySet(), eosCharacters);
    }

    public DefaultSDContextGenerator(Set<String> inducedAbbreviations, char[] eosCharacters) {
        this.inducedAbbreviations = inducedAbbreviations;
        this.eosCharacters = eosCharacters;
        this.buf = new StringBuffer();
        this.collectFeats = new ArrayList<String>();
    }

    @Override
    public String[] getContext(CharSequence sb, int position) {
        String next;
        String suffix;
        int lastIndex = sb.length() - 1;
        if (position > 0 && StringUtil.isWhitespace(sb.charAt(position - 1))) {
            this.collectFeats.add("sp");
        }
        if (position < lastIndex && StringUtil.isWhitespace(sb.charAt(position + 1))) {
            this.collectFeats.add("sn");
        }
        this.collectFeats.add("eos=" + sb.charAt(position));
        int prefixStart = DefaultSDContextGenerator.previousSpaceIndex(sb, position);
        int c = position;
        block0: while (--c > prefixStart) {
            int ecl = this.eosCharacters.length;
            for (int eci = 0; eci < ecl; ++eci) {
                if (sb.charAt(c) != this.eosCharacters[eci]) continue;
                prefixStart = c++;
                continue block0;
            }
        }
        String prefix = new StringBuffer(sb.subSequence(prefixStart, position)).toString().trim();
        int prevStart = DefaultSDContextGenerator.previousSpaceIndex(sb, prefixStart);
        String previous = new StringBuffer(sb.subSequence(prevStart, prefixStart)).toString().trim();
        int suffixEnd = DefaultSDContextGenerator.nextSpaceIndex(sb, position, lastIndex);
        c = position;
        block2: while (++c < suffixEnd) {
            int ecl = this.eosCharacters.length;
            for (int eci = 0; eci < ecl; ++eci) {
                if (sb.charAt(c) != this.eosCharacters[eci]) continue;
                suffixEnd = c--;
                continue block2;
            }
        }
        int nextEnd = DefaultSDContextGenerator.nextSpaceIndex(sb, suffixEnd + 1, lastIndex + 1);
        if (position == lastIndex) {
            suffix = "";
            next = "";
        } else {
            suffix = new StringBuilder(sb.subSequence(position + 1, suffixEnd)).toString().trim();
            next = new StringBuilder(sb.subSequence(suffixEnd + 1, nextEnd)).toString().trim();
        }
        this.collectFeatures(prefix, suffix, previous, next, Character.valueOf(sb.charAt(position)));
        String[] context = new String[this.collectFeats.size()];
        context = this.collectFeats.toArray(context);
        this.collectFeats.clear();
        return context;
    }

    protected void collectFeatures(String prefix, String suffix, String previous, String next) {
        this.collectFeatures(prefix, suffix, previous, next, null);
    }

    protected void collectFeatures(String prefix, String suffix, String previous, String next, Character eosChar) {
        this.buf.append("x=");
        this.buf.append(prefix);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!prefix.equals("")) {
            this.collectFeats.add(Integer.toString(prefix.length()));
            if (DefaultSDContextGenerator.isFirstUpper(prefix)) {
                this.collectFeats.add("xcap");
            }
            if (eosChar != null && this.inducedAbbreviations.contains(prefix + eosChar)) {
                this.collectFeats.add("xabbrev");
            }
        }
        this.buf.append("v=");
        this.buf.append(previous);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!previous.equals("")) {
            if (DefaultSDContextGenerator.isFirstUpper(previous)) {
                this.collectFeats.add("vcap");
            }
            if (this.inducedAbbreviations.contains(previous)) {
                this.collectFeats.add("vabbrev");
            }
        }
        this.buf.append("s=");
        this.buf.append(suffix);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!suffix.equals("")) {
            if (DefaultSDContextGenerator.isFirstUpper(suffix)) {
                this.collectFeats.add("scap");
            }
            if (this.inducedAbbreviations.contains(suffix)) {
                this.collectFeats.add("sabbrev");
            }
        }
        this.buf.append("n=");
        this.buf.append(next);
        this.collectFeats.add(this.buf.toString());
        this.buf.setLength(0);
        if (!next.equals("")) {
            if (DefaultSDContextGenerator.isFirstUpper(next)) {
                this.collectFeats.add("ncap");
            }
            if (this.inducedAbbreviations.contains(next)) {
                this.collectFeats.add("nabbrev");
            }
        }
    }

    private static final boolean isFirstUpper(String s) {
        return Character.isUpperCase(s.charAt(0));
    }

    private static final int previousSpaceIndex(CharSequence sb, int seek) {
        --seek;
        while (seek > 0 && !StringUtil.isWhitespace(sb.charAt(seek))) {
            --seek;
        }
        if (seek > 0 && StringUtil.isWhitespace(sb.charAt(seek))) {
            while (seek > 0 && StringUtil.isWhitespace(sb.charAt(seek - 1))) {
                --seek;
            }
            return seek;
        }
        return 0;
    }

    private static final int nextSpaceIndex(CharSequence sb, int seek, int lastIndex) {
        ++seek;
        while (seek < lastIndex) {
            char c = sb.charAt(seek);
            if (StringUtil.isWhitespace(c)) {
                while (sb.length() > seek + 1 && StringUtil.isWhitespace(sb.charAt(seek + 1))) {
                    ++seek;
                }
                return seek;
            }
            ++seek;
        }
        return lastIndex;
    }
}

