/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.sentdetect;

import datafu.opennlp.model.Event;
import datafu.opennlp.tools.sentdetect.EndOfSentenceScanner;
import datafu.opennlp.tools.sentdetect.SDContextGenerator;
import datafu.opennlp.tools.sentdetect.SentenceSample;
import datafu.opennlp.tools.util.AbstractEventStream;
import datafu.opennlp.tools.util.ObjectStream;
import datafu.opennlp.tools.util.Span;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDEventStream
extends AbstractEventStream<SentenceSample> {
    private SDContextGenerator cg;
    private EndOfSentenceScanner scanner;

    public SDEventStream(ObjectStream<SentenceSample> samples, SDContextGenerator cg, EndOfSentenceScanner scanner) {
        super(samples);
        this.cg = cg;
        this.scanner = scanner;
    }

    @Override
    protected Iterator<Event> createEvents(SentenceSample sample) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Span sentenceSpan : sample.getSentences()) {
            String sentenceString = ((Object)sentenceSpan.getCoveredText(sample.getDocument())).toString();
            Iterator<Integer> it = this.scanner.getPositions(sentenceString).iterator();
            while (it.hasNext()) {
                int candidate = it.next();
                String type = "n";
                if (!it.hasNext()) {
                    type = "s";
                }
                events.add(new Event(type, this.cg.getContext(sample.getDocument(), sentenceSpan.getStart() + candidate)));
            }
        }
        return events.iterator();
    }
}

