/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.sentdetect;

import datafu.opennlp.tools.tokenize.Detokenizer;
import datafu.opennlp.tools.util.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SentenceSample {
    private final String document;
    private final List<Span> sentences;

    public SentenceSample(String document, Span ... sentences) {
        this.document = document;
        this.sentences = Collections.unmodifiableList(new ArrayList<Span>(Arrays.asList(sentences)));
    }

    public SentenceSample(Detokenizer detokenizer, String[][] sentences) {
        ArrayList<Span> spans = new ArrayList<Span>(sentences.length);
        StringBuilder documentBuilder = new StringBuilder();
        for (String[] sentenceTokens : sentences) {
            String sampleSentence = detokenizer.detokenize(sentenceTokens, null);
            int beginIndex = documentBuilder.length();
            documentBuilder.append(sampleSentence);
            spans.add(new Span(beginIndex, documentBuilder.length()));
        }
        this.document = documentBuilder.toString();
        this.sentences = Collections.unmodifiableList(spans);
    }

    public String getDocument() {
        return this.document;
    }

    public Span[] getSentences() {
        return this.sentences.toArray(new Span[this.sentences.size()]);
    }

    public String toString() {
        StringBuilder documentBuilder = new StringBuilder();
        for (Span sentSpan : this.sentences) {
            documentBuilder.append(sentSpan.getCoveredText(this.document));
            documentBuilder.append("\n");
        }
        return documentBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SentenceSample) {
            SentenceSample a = (SentenceSample)obj;
            return this.getDocument().equals(a.getDocument()) && Arrays.equals(this.getSentences(), a.getSentences());
        }
        return false;
    }
}

