/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.sentdetect.lang;

import datafu.opennlp.tools.sentdetect.DefaultEndOfSentenceScanner;
import datafu.opennlp.tools.sentdetect.DefaultSDContextGenerator;
import datafu.opennlp.tools.sentdetect.EndOfSentenceScanner;
import datafu.opennlp.tools.sentdetect.SDContextGenerator;
import datafu.opennlp.tools.sentdetect.lang.th.SentenceContextGenerator;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory {
    public static final char[] ptEosCharacters = new char[]{'.', '?', '!', ';', ':', '(', ')', '\u00ab', '\u00bb', '\'', '\"'};
    public static final char[] defaultEosCharacters = new char[]{'.', '!', '?'};
    public static final char[] thEosCharacters = new char[]{' ', '\n'};

    public EndOfSentenceScanner createEndOfSentenceScanner(String languageCode) {
        if ("th".equals(languageCode)) {
            return new DefaultEndOfSentenceScanner(new char[]{' ', '\n'});
        }
        if ("pt".equals(languageCode)) {
            return new DefaultEndOfSentenceScanner(ptEosCharacters);
        }
        return new DefaultEndOfSentenceScanner(defaultEosCharacters);
    }

    public EndOfSentenceScanner createEndOfSentenceScanner(char[] customEOSCharacters) {
        return new DefaultEndOfSentenceScanner(customEOSCharacters);
    }

    public SDContextGenerator createSentenceContextGenerator(String languageCode, Set<String> abbreviations) {
        if ("th".equals(languageCode)) {
            return new SentenceContextGenerator();
        }
        if ("pt".equals(languageCode)) {
            return new DefaultSDContextGenerator(abbreviations, ptEosCharacters);
        }
        return new DefaultSDContextGenerator(abbreviations, defaultEosCharacters);
    }

    public SDContextGenerator createSentenceContextGenerator(Set<String> abbreviations, char[] customEOSCharacters) {
        return new DefaultSDContextGenerator(abbreviations, customEOSCharacters);
    }

    public SDContextGenerator createSentenceContextGenerator(String languageCode) {
        return this.createSentenceContextGenerator(languageCode, Collections.<String>emptySet());
    }

    public char[] getEOSCharacters(String languageCode) {
        if ("th".equals(languageCode)) {
            return thEosCharacters;
        }
        if ("pt".equals(languageCode)) {
            return ptEosCharacters;
        }
        return defaultEosCharacters;
    }
}

