/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.tokenize;

import datafu.opennlp.maxent.io.BinaryGISModelReader;
import datafu.opennlp.model.AbstractModel;
import datafu.opennlp.model.MaxentModel;
import datafu.opennlp.tools.dictionary.Dictionary;
import datafu.opennlp.tools.tokenize.TokenizerFactory;
import datafu.opennlp.tools.util.BaseToolFactory;
import datafu.opennlp.tools.util.InvalidFormatException;
import datafu.opennlp.tools.util.model.BaseModel;
import datafu.opennlp.tools.util.model.ModelUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenizerModel
extends BaseModel {
    private static final String COMPONENT_NAME = "TokenizerME";
    private static final String TOKENIZER_MODEL_ENTRY = "token.model";

    public TokenizerModel(AbstractModel tokenizerModel, Map<String, String> manifestInfoEntries, TokenizerFactory tokenizerFactory) {
        super(COMPONENT_NAME, tokenizerFactory.getLanguageCode(), manifestInfoEntries, tokenizerFactory);
        this.artifactMap.put(TOKENIZER_MODEL_ENTRY, tokenizerModel);
        this.checkArtifactMap();
    }

    public TokenizerModel(String language, AbstractModel tokenizerMaxentModel, Dictionary abbreviations, boolean useAlphaNumericOptimization, Map<String, String> manifestInfoEntries) {
        this(tokenizerMaxentModel, manifestInfoEntries, new TokenizerFactory(language, abbreviations, useAlphaNumericOptimization, null));
    }

    public TokenizerModel(String language, AbstractModel tokenizerMaxentModel, boolean useAlphaNumericOptimization, Map<String, String> manifestInfoEntries) {
        this(language, tokenizerMaxentModel, null, useAlphaNumericOptimization, manifestInfoEntries);
    }

    public TokenizerModel(String language, AbstractModel tokenizerMaxentModel, boolean useAlphaNumericOptimization) {
        this(language, tokenizerMaxentModel, useAlphaNumericOptimization, null);
    }

    public TokenizerModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    public TokenizerModel(File modelFile) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelFile);
    }

    public TokenizerModel(URL modelURL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelURL);
    }

    private static boolean isModelCompatible(MaxentModel model) {
        return ModelUtil.validateOutcomes(model, "T", "F");
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(TOKENIZER_MODEL_ENTRY) instanceof AbstractModel)) {
            throw new InvalidFormatException("Token model is incomplete!");
        }
        if (!TokenizerModel.isModelCompatible(this.getMaxentModel())) {
            throw new InvalidFormatException("The maxent model is not compatible with the tokenizer!");
        }
    }

    public TokenizerFactory getFactory() {
        return (TokenizerFactory)this.toolFactory;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return TokenizerFactory.class;
    }

    public AbstractModel getMaxentModel() {
        return (AbstractModel)this.artifactMap.get(TOKENIZER_MODEL_ENTRY);
    }

    public Dictionary getAbbreviations() {
        if (this.getFactory() != null) {
            return this.getFactory().getAbbreviationDictionary();
        }
        return null;
    }

    public boolean useAlphaNumericOptimization() {
        if (this.getFactory() != null) {
            return this.getFactory().isUseAlphaNumericOptmization();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("TokenizerModel [-alphaNumericOptimization] languageCode packageName modelName");
            System.exit(1);
        }
        int ai = 0;
        boolean alphaNumericOptimization = false;
        if ("-alphaNumericOptimization".equals(args[ai])) {
            alphaNumericOptimization = true;
        }
        int n = ++ai;
        String languageCode = args[n];
        int n2 = ++ai;
        String packageName = args[n2];
        String modelName = args[++ai];
        AbstractModel model = new BinaryGISModelReader(new DataInputStream(new FileInputStream(modelName))).getModel();
        TokenizerModel packageModel = new TokenizerModel(languageCode, model, alphaNumericOptimization);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(packageName);
            packageModel.serialize(out);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }
}

