/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.tokenize;

import datafu.opennlp.tools.tokenize.AbstractTokenizer;
import datafu.opennlp.tools.util.Span;
import datafu.opennlp.tools.util.StringUtil;
import java.util.ArrayList;

public class WhitespaceTokenizer
extends AbstractTokenizer {
    public static final WhitespaceTokenizer INSTANCE = new WhitespaceTokenizer();

    private WhitespaceTokenizer() {
    }

    public Span[] tokenizePos(String d) {
        int tokStart = -1;
        ArrayList<Span> tokens = new ArrayList<Span>();
        boolean inTok = false;
        int end = d.length();
        for (int i = 0; i < end; ++i) {
            if (StringUtil.isWhitespace(d.charAt(i))) {
                if (!inTok) continue;
                tokens.add(new Span(tokStart, i));
                inTok = false;
                tokStart = -1;
                continue;
            }
            if (inTok) continue;
            tokStart = i;
            inTok = true;
        }
        if (inTok) {
            tokens.add(new Span(tokStart, end));
        }
        return tokens.toArray(new Span[tokens.size()]);
    }
}

