/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.util;

import datafu.opennlp.tools.util.InvalidFormatException;
import datafu.opennlp.tools.util.ext.ExtensionLoader;
import datafu.opennlp.tools.util.model.ArtifactProvider;
import datafu.opennlp.tools.util.model.ArtifactSerializer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseToolFactory {
    protected ArtifactProvider artifactProvider;

    protected void init(ArtifactProvider artifactProvider) {
        this.artifactProvider = artifactProvider;
    }

    public Map<String, ArtifactSerializer> createArtifactSerializersMap() {
        return new HashMap<String, ArtifactSerializer>();
    }

    public Map<String, Object> createArtifactMap() {
        return new HashMap<String, Object>();
    }

    public Map<String, String> createManifestEntries() {
        return new HashMap<String, String>();
    }

    public abstract void validateArtifactMap() throws InvalidFormatException;

    public static BaseToolFactory create(String subclassName, ArtifactProvider artifactProvider) throws InvalidFormatException {
        BaseToolFactory theFactory = null;
        try {
            theFactory = ExtensionLoader.instantiateExtension(BaseToolFactory.class, subclassName);
            if (theFactory != null) {
                theFactory.init(artifactProvider);
            }
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, e);
        }
        return theFactory;
    }

    public static BaseToolFactory create(Class<? extends BaseToolFactory> factoryClass, ArtifactProvider artifactProvider) throws InvalidFormatException {
        BaseToolFactory theFactory = null;
        if (factoryClass != null) {
            try {
                theFactory = factoryClass.newInstance();
                theFactory.init(artifactProvider);
            }
            catch (Exception e) {
                String msg = "Could not instantiate the " + factoryClass.getCanonicalName() + ". The initialization throw an exception.";
                System.err.println(msg);
                e.printStackTrace();
                throw new InvalidFormatException(msg, e);
            }
        }
        return theFactory;
    }
}

