/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.util;

import datafu.opennlp.model.MaxentModel;
import datafu.opennlp.tools.util.BeamSearchContextGenerator;
import datafu.opennlp.tools.util.Cache;
import datafu.opennlp.tools.util.ListHeap;
import datafu.opennlp.tools.util.Sequence;
import datafu.opennlp.tools.util.SequenceValidator;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeamSearch<T> {
    private static final Object[] EMPTY_ADDITIONAL_CONTEXT = new Object[0];
    protected int size;
    protected BeamSearchContextGenerator<T> cg;
    protected MaxentModel model;
    private SequenceValidator<T> validator;
    private double[] probs;
    private Cache contextsCache;
    private static final int zeroLog = -100000;

    public BeamSearch(int size, BeamSearchContextGenerator<T> cg, MaxentModel model) {
        this(size, cg, model, null, 0);
    }

    public BeamSearch(int size, BeamSearchContextGenerator<T> cg, MaxentModel model, int cacheSize) {
        this(size, cg, model, null, cacheSize);
    }

    public BeamSearch(int size, BeamSearchContextGenerator<T> cg, MaxentModel model, SequenceValidator<T> validator, int cacheSize) {
        this.size = size;
        this.cg = cg;
        this.model = model;
        this.validator = validator;
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
        this.probs = new double[model.getNumOutcomes()];
    }

    private boolean validSequence(int i, T[] inputSequence, String[] outcomesSequence, String outcome) {
        if (this.validator != null) {
            return this.validator.validSequence(i, inputSequence, outcomesSequence, outcome);
        }
        return true;
    }

    public Sequence[] bestSequences(int numSequences, T[] sequence, Object[] additionalContext) {
        return this.bestSequences(numSequences, sequence, additionalContext, -100000.0);
    }

    public Sequence[] bestSequences(int numSequences, T[] sequence, Object[] additionalContext, double minSequenceScore) {
        ListHeap<Sequence> prev = new ListHeap<Sequence>(this.size);
        ListHeap<Sequence> next = new ListHeap<Sequence>(this.size);
        prev.add(new Sequence());
        if (additionalContext == null) {
            additionalContext = EMPTY_ADDITIONAL_CONTEXT;
        }
        for (int i = 0; i < sequence.length; ++i) {
            int sz = Math.min(this.size, prev.size());
            for (int sc = 0; prev.size() > 0 && sc < sz; ++sc) {
                Sequence ns;
                String out;
                int p;
                double[] scores;
                Sequence top = (Sequence)prev.extract();
                List<String> tmpOutcomes = top.getOutcomes();
                String[] outcomes = tmpOutcomes.toArray(new String[tmpOutcomes.size()]);
                String[] contexts = this.cg.getContext(i, sequence, outcomes, additionalContext);
                if (this.contextsCache != null) {
                    scores = (double[])this.contextsCache.get(contexts);
                    if (scores == null) {
                        scores = this.model.eval(contexts, this.probs);
                        this.contextsCache.put(contexts, scores);
                    }
                } else {
                    scores = this.model.eval(contexts, this.probs);
                }
                double[] temp_scores = new double[scores.length];
                for (int c = 0; c < scores.length; ++c) {
                    temp_scores[c] = scores[c];
                }
                Arrays.sort(temp_scores);
                double min = temp_scores[Math.max(0, scores.length - this.size)];
                for (p = 0; p < scores.length; ++p) {
                    if (scores[p] < min || !this.validSequence(i, sequence, outcomes, out = this.model.getOutcome(p)) || !((ns = new Sequence(top, out, scores[p])).getScore() > minSequenceScore)) continue;
                    next.add(ns);
                }
                if (next.size() != 0) continue;
                for (p = 0; p < scores.length; ++p) {
                    out = this.model.getOutcome(p);
                    if (!this.validSequence(i, sequence, outcomes, out) || !((ns = new Sequence(top, out, scores[p])).getScore() > minSequenceScore)) continue;
                    next.add(ns);
                }
            }
            prev.clear();
            ListHeap<Sequence> tmp = prev;
            prev = next;
            next = tmp;
        }
        int numSeq = Math.min(numSequences, prev.size());
        Sequence[] topSequences = new Sequence[numSeq];
        for (int seqIndex = 0; seqIndex < numSeq; ++seqIndex) {
            topSequences[seqIndex] = (Sequence)prev.extract();
        }
        return topSequences;
    }

    public Sequence bestSequence(T[] sequence, Object[] additionalContext) {
        Sequence[] sequences = this.bestSequences(1, sequence, additionalContext, -100000.0);
        if (sequences.length > 0) {
            return sequences[0];
        }
        return null;
    }
}

