/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringList
implements Iterable<String> {
    private String[] tokens;

    public StringList(String singleToken) {
        this.tokens = new String[]{singleToken.intern()};
    }

    public StringList(String ... tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException("tokens must not be null");
        }
        if (tokens.length == 0) {
            throw new IllegalArgumentException("tokens must not be empty");
        }
        this.tokens = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            this.tokens[i] = tokens[i].intern();
        }
    }

    public String getToken(int index) {
        return this.tokens[index];
    }

    public int size() {
        return this.tokens.length;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < StringList.this.size();
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    return StringList.this.getToken(this.index++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean compareToIgnoreCase(StringList tokens) {
        if (this.size() == tokens.size()) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.getToken(i).compareToIgnoreCase(tokens.getToken(i)) == 0) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj instanceof StringList) {
            StringList tokenList = (StringList)obj;
            result = Arrays.equals(this.tokens, tokenList.tokens);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int numBitsRegular = 32 / this.size();
        int numExtra = 32 % this.size();
        int maskExtra = -1 >>> 32 - numBitsRegular + 1;
        int maskRegular = -1 >>> 32 - numBitsRegular;
        int code = 0;
        int leftMostBit = 0;
        for (int wi = 0; wi < this.size(); ++wi) {
            int numBits;
            int mask;
            if (wi < numExtra) {
                mask = maskExtra;
                numBits = numBitsRegular + 1;
            } else {
                mask = maskRegular;
                numBits = numBitsRegular;
            }
            int word = this.getToken(wi).hashCode() & mask;
            code |= (word <<= 32 - (leftMostBit += numBits) - numBits);
        }
        return code;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append('[');
        for (int i = 0; i < this.size(); ++i) {
            string.append(this.getToken(i));
            if (i >= this.size() - 1) continue;
            string.append(',');
        }
        string.append(']');
        return string.toString();
    }
}

