/*
 * Decompiled with CFR 0.152.
 */
package datafu.opennlp.tools.util.model;

import datafu.opennlp.model.AbstractModel;
import datafu.opennlp.model.GenericModelWriter;
import datafu.opennlp.model.MaxentModel;
import datafu.opennlp.tools.util.TrainingParameters;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelUtil {
    private ModelUtil() {
    }

    public static void writeModel(AbstractModel model, final OutputStream out) throws IOException {
        if (model == null) {
            throw new IllegalArgumentException("model parameter must not be null!");
        }
        if (out == null) {
            throw new IllegalArgumentException("out parameter must not be null!");
        }
        GenericModelWriter modelWriter = new GenericModelWriter(model, new DataOutputStream(new OutputStream(){

            public void write(int b) throws IOException {
                out.write(b);
            }
        }));
        modelWriter.persist();
    }

    public static boolean validateOutcomes(MaxentModel model, String ... expectedOutcomes) {
        boolean result = true;
        if (expectedOutcomes.length == model.getNumOutcomes()) {
            HashSet<String> expectedOutcomesSet = new HashSet<String>();
            expectedOutcomesSet.addAll(Arrays.asList(expectedOutcomes));
            for (int i = 0; i < model.getNumOutcomes(); ++i) {
                if (expectedOutcomesSet.contains(model.getOutcome(i))) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static byte[] read(InputStream in) throws IOException {
        int length;
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) > 0) {
            byteArrayOut.write(buffer, 0, length);
        }
        byteArrayOut.close();
        return byteArrayOut.toByteArray();
    }

    public static void addCutoffAndIterations(Map<String, String> manifestInfoEntries, int cutoff, int iterations) {
        manifestInfoEntries.put("Training-Cutoff", Integer.toString(cutoff));
        manifestInfoEntries.put("Training-Iterations", Integer.toString(iterations));
    }

    public static TrainingParameters createTrainingParameters(int iterations, int cutoff) {
        TrainingParameters mlParams = new TrainingParameters();
        mlParams.put("Algorithm", "MAXENT");
        mlParams.put("Iterations", Integer.toString(iterations));
        mlParams.put("Cutoff", Integer.toString(cutoff));
        return mlParams;
    }
}

